/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.geracaonfterceiros;

import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.IntegracaoNotaTerceirosNotas;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.LancCtoItemNota;
import com.touchcomp.basementor.model.vo.LancamentoCentroCusto;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalIpi;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesImpostos;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.SituacaoDocumento;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.UnidadeFederativaOrigDest;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementor.model.vo.ValoresNfTerceiros;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacao.ExceptionParametrizacao;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.calculovalores.BaseCalculoValores;
import com.touchcomp.basementorservice.components.contabil.CompParametrizacaoContabilNF;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.entradassaidasfiscais.CompLancamentosEntradaSaidaFiscais;
import com.touchcomp.basementorservice.helpers.impl.centroestoque.HelperCentroEstoque;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.exceptions.ExceptionCFOPNotFound;
import mentorcore.exceptions.ExceptionCalculoICMS;
import mentorcore.exceptions.ExceptionCalculoIPI;
import mentorcore.exceptions.ExceptionCalculoPisCofins;
import mentorcore.exceptions.ExceptionParametrizacaoCtbModFiscalNotFound;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.calculoimpostos.CalculosImpFiscaisNotaTerceiros;
import mentorcore.utilities.impl.obsfaturamento.ObsFaturamentoUtilities;

public class AuxStandardMethodsNF {
    public static void createTitulos(NotaFiscalTerceiros n, OpcoesFinanceiras opFin, EmpresaContabilidade empCont, OpcoesContabeis opcoesContabeis) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        CoreUtilityFactory.getUtilityTitulos().criarTitulos(n, empCont, opFin, opcoesContabeis);
    }

    private static void findAndSetPcContabilGerencial(ItemNotaTerceiros vo, UnidadeFatFornecedor unidadeFatFornecedor, OpcoesContabeis opcoesContabeis) throws ExceptionService, ExceptionParametrizacaoCtbModFiscalNotFound {
        try {
            CompParametrizacaoContabilNF comp = (CompParametrizacaoContabilNF)Context.get(CompParametrizacaoContabilNF.class);
            CompParametrizacaoContabilNF.DadosContas dados = comp.getPlanoContasNfTerceiros(vo.getModeloFiscal(), vo.getProduto(), unidadeFatFornecedor, vo.getNaturezaOperacao(), vo.getNotaFiscalTerceiros().getEmpresa(), unidadeFatFornecedor.getCategoriaPessoa(), opcoesContabeis);
            vo.setPlanoContaCred(dados.getPlanoContaCred());
            vo.setPlanoContaDeb(dados.getPlanoContaDeb());
            vo.setPlanoContaGerencial(dados.getPcGerencial());
        }
        catch (ExceptionInvalidData | ExceptionParametrizacao ex) {
            TLogger.get(ex.getClass()).error(ex);
            throw new ExceptionService(ex.getFormattedMessage());
        }
    }

    private static Double getAliquotaICMS(UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino) throws ExceptionService {
        CoreRequestContext h = new CoreRequestContext();
        h.setAttribute("ufOrigem", ufOrigem);
        h.setAttribute("ufDestino", ufDestino);
        UnidadeFederativaOrigDest found = (UnidadeFederativaOrigDest)CoreServiceFactory.getServiceUF().execute(h, "findAliquotaIcmsInterUF");
        if (found != null) {
            return found.getAliquotaICMS();
        }
        return 0.0;
    }

    private static Double getAliquotaICMS(UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino, Produto prod) throws ExceptionService {
        if (prod == null) {
            return 0.0;
        }
        if (ufDestino.equals((Object)ufOrigem)) {
            return prod.getAliquotaIcms();
        }
        return AuxStandardMethodsNF.getAliquotaICMS(ufOrigem, ufDestino);
    }

    public static void calcImpostos(NotaFiscalTerceiros n, EmpresaContabilidade empCont, OpcoesCompraSuprimentos op, OpcoesImpostos opImpostos) throws ExceptionService, ExceptionCalculoICMS, ExceptionCalculoIPI, ExceptionCalculoPisCofins, ExceptionAvaliadorExpressoes {
        AuxStandardMethodsNF.updateQtdTotalitens(n);
        CalculosImpFiscaisNotaTerceiros.calcularImpostosFiscaisItNotaTerceiros(n.getDataEntrada(), n.getItemNotaTerceiros(), n.getUnidadeFatFornecedor(), n.getUfPrestacao(), n.getEmpresa().getPessoa().getEndereco().getCidade().getUf(), n.getValoresNfTerceiros().getValorFreteInf(), n.getValoresNfTerceiros().getValorFreteCtrc(), n.getValoresNfTerceiros().getValorSeguroInf(), n.getValoresNfTerceiros().getValorDescontoInf(), n.getValoresNfTerceiros().getValorDespAcessoriaInf(), n.getValoresNfTerceiros().getValorAgregadoInf(), n.getValoresNfTerceiros().getValorIcmsInf(), n.getValoresNfTerceiros().getValorIpiInf(), n.getValoresNfTerceiros().getValorTotalInf(), n.getNaoRatearVlrAcess() == 1 && n.getNaoRatearVlrAcess() != null, n.getNaoRatearVlrFrete() != null && n.getNaoRatearVlrFrete() == 1, n.getNaoRatearVlrSeguro() != null && n.getNaoRatearVlrSeguro() == 1, n.getNaoRatearVlrDesconto() != null && n.getNaoRatearVlrDesconto() == 1, n.getNaoRatearVlrAgregado() != null && n.getNaoRatearVlrAgregado() == 1, empCont, op, opImpostos);
        AuxStandardMethodsNF.calculaTotalizadores(n);
        AuxStandardMethodsNF.gerarLivrosFiscais(n);
        AuxStandardMethodsNF.getObservacoesNotaPropria(n);
    }

    static void gerarLivrosFiscais(NotaFiscalTerceiros n) throws ExceptionAvaliadorExpressoes {
        n.setLivrosFiscais(CoreUtilityFactory.getUtilityNotaFiscalTerceiros().getLivrosFiscaisResumo(n.getItemNotaTerceiros(), n.getLivrosFiscais(), n.getModeloDocFiscal(), n.getSituacaoDocumento(), n.getUfPrestacao(), n.getCidadePrestacao()));
    }

    static void findAndSetAliquotasCont(ItemNotaTerceiros i, NaturezaOperacao nat, Empresa emp, UnidadeFatFornecedor unid, UnidadeFederativa ufDestino, UnidadeFederativa ufOrigem, OpcoesContabeis opcoesContabeis) throws ExceptionService, ExceptionCFOPNotFound, ExceptionParametrizacaoCtbModFiscalNotFound {
        ItemNotaLivroFiscal il = i.getItemNotaLivroFiscal();
        if (il == null) {
            il = new ItemNotaLivroFiscal();
            il.setItemNotaTerceiros(i);
            i.setItemNotaLivroFiscal(il);
        }
        Cfop cfop = CoreUtilityFactory.getUtilityCFOP().findCfopEntrada(ufDestino, ufOrigem, i.getModeloFiscal());
        il.setCfop(cfop);
        i.setIncidenciaIcms(i.getModeloFiscal().getModeloFiscalIcms().getIncidenciaIcms());
        i.setIncidenciaIpi(i.getModeloFiscal().getModeloFiscalIpi().getIncidenciaIpi());
        i.setModalidadeIcms(i.getModeloFiscal().getModeloFiscalIcms().getModalidadeIcms());
        i.setModalidadeIcmsSt(i.getModeloFiscal().getModeloFiscalIcms().getModalidadeIcmsSt());
        i.setIncidenciaPisCofins(i.getModeloFiscal().getModeloFiscalPisCofins().getIncidenciaPisCofins());
        il.setAliquotaCofins(i.getProduto().getAliquotaCofins());
        il.setAliquotaPis(i.getProduto().getAliquotaPis());
        il.setAliquotaContSoc(i.getProduto().getAliquotaContSoc());
        il.setAliquotaFunrural(i.getProduto().getAliquotaFunrural());
        il.setAliquotaRat(i.getProduto().getAliquotaRat());
        il.setAliquotaSenar(i.getProduto().getAliquotaSenar());
        il.setTaxaSanidadeAnimal(i.getProduto().getTaxaSanidadeAnimal());
        il.setFatorTaxaSanidadeAnimal(i.getProduto().getFatorTaxaSanidadeAnimal());
        il.setAliquotaInss(i.getProduto().getAliquotaInss());
        il.setAliquotaIrrf(i.getProduto().getAliquotaIrrf());
        il.setAliquotaIss(i.getProduto().getAliquotaIss());
        il.setAliquotaLei10833(i.getProduto().getAliquotaLei10833());
        il.setAliquotaOutros(i.getProduto().getAliquotaOutros());
        il.setAliquotaSestSenat(i.getProduto().getPercSestSenat());
        il.setPercRedBcInss(i.getProduto().getPercRedBCINSS());
        il.setPercRedContSoc(i.getProduto().getPercRedContSoc());
        il.setPercRedFunrural(i.getProduto().getPercRedFunrural());
        il.setPercRedIrrf(i.getProduto().getPercRedIrrf());
        il.setPercRedLei10833(i.getProduto().getPercRedLei10833());
        il.setPercRedOutros(i.getProduto().getPercRedOutros());
        il.setPercRedSestSenat(i.getProduto().getPercSestSenat());
        if (ToolMethods.isEquals((Object)i.getModeloFiscal().getModeloFiscalIcms().getTipoPercReducaoBaseCalcIcms(), (Object)2)) {
            il.setPercReducaoBCIcms(i.getModeloFiscal().getModeloFiscalIcms().getReducaoBaseCalcIcms());
        } else {
            il.setPercReducaoBCIcms(i.getProduto().getReducaoBaseCalcIcms());
        }
        il.setAliquotaICMSSimples(emp.getEmpresaDados().getAliquotaICMSSimples());
        Double aliquotaIpi = BaseCalculoValores.getAliquotaIpi((Produto)i.getProduto(), (ModeloFiscalIpi)i.getModeloFiscal().getModeloFiscalIpi());
        il.setAliquotaIpi(aliquotaIpi);
        if (i.getModeloFiscal() != null) {
            double alICMS = 0.0;
            alICMS = i.getModeloFiscal().getModeloFiscalIcms().getTipoAliquotaIcms() == 2 ? i.getModeloFiscal().getModeloFiscalIcms().getAliquotaIcms().doubleValue() : AuxStandardMethodsNF.getAliquotaICMS(emp.getPessoa().getEndereco().getCidade().getUf(), unid.getFornecedor().getPessoa().getEndereco().getCidade().getUf(), i.getProduto()).doubleValue();
            il.setAliquotaIcms(Double.valueOf(alICMS));
        }
        if (i.getModeloFiscal() != null && i.getModeloFiscal().getModeloFiscalPisCofins() != null) {
            i.setNaturezaBCCredito(i.getModeloFiscal().getModeloFiscalPisCofins().getNaturezaBCCredito());
        }
        AuxStandardMethodsNF.findAndSetPcContabilGerencial(i, unid, opcoesContabeis);
    }

    static NotaFiscalTerceiros newNotaFiscalTerceiros(NotaFiscalTerceiros n, UnidadeFatFornecedor unidadeFatFornecedor, Empresa empresa, Date dataCompetencia, Date dataEntrada, Date dataEmissao, ModeloDocFiscal modeloDocFiscal, String serie, Integer numeroNF, CondicoesPagamento condPag, String parcelas, SituacaoDocumento sitDoc, OpcoesFinanceiras op) throws ExceptionService {
        if (n == null) {
            n = new NotaFiscalTerceiros();
            n.setDataCadastro(new Date());
        }
        n.setEmpresa(empresa);
        n.setUnidadeFatFornecedor(unidadeFatFornecedor);
        n.setCategoriaPessoa(unidadeFatFornecedor.getCategoriaPessoa());
        n.setClassificacaoPessoas(unidadeFatFornecedor.getFornecedor().getClassificacaoPessoa());
        n.setUfPrestacao(unidadeFatFornecedor.getPessoa().getEndereco().getCidade().getUf());
        n.setCidadePrestacao(unidadeFatFornecedor.getPessoa().getEndereco().getCidade());
        n.setNumeroNota(numeroNF);
        n.setSerie(serie);
        n.setCondicoesPagamento(condPag);
        n.setParcelas(parcelas);
        n.setSituacaoDocumento(sitDoc);
        n.setDataEntrada(dataEntrada);
        n.setDataCompetencia(dataCompetencia);
        n.setDataEmissao(dataEmissao);
        n.setModeloDocFiscal(modeloDocFiscal);
        if (n.getCondicoesPagamento() != null && n.getCondicoesPagamento().getMeioPagamento() != null) {
            n.setMeioPagamento(n.getCondicoesPagamento().getMeioPagamento());
        } else if (op != null) {
            n.setMeioPagamento(op.getMeioPagamento());
        }
        return n;
    }

    private static void getObservacoesNotaPropria(NotaFiscalTerceiros vo) {
        ObsFaturamentoUtilities.buildObs(vo, true);
    }

    static CentroEstoque getCentroEstoquePadrao(Empresa empresa, OpcoesEstoque opcoes, ItemNotaTerceiros item, Usuario usuario) throws ExceptionService {
        return ((HelperCentroEstoque)ConfApplicationContext.getBean(HelperCentroEstoque.class)).getCentroEstoque(empresa, opcoes, item, usuario);
    }

    static GradeCor getFirstGradeCor(Produto produto) throws ExceptionService {
        GradeCor gc = (GradeCor)CoreServiceFactory.getServiceGradeCor().execute(CoreRequestContext.newInstance().setAttribute("produto", produto), "findPrimeiraGradeCor");
        return gc;
    }

    static LoteFabricacao getLoteUnico(Produto produto) throws ExceptionService {
        LoteFabricacao gc = ((ServiceLoteFabricacaoImpl)Context.get(ServiceLoteFabricacaoImpl.class)).findOrCreateLoteUnico(produto);
        return gc;
    }

    static void gerarLancCentroCusto(NotaFiscalTerceiros nf, CentroCusto centro) {
        for (ItemNotaTerceiros i : nf.getItemNotaTerceiros()) {
            for (GradeItemNotaTerceiros grade : i.getGrade()) {
                LancCtoItemNota l1 = new LancCtoItemNota();
                l1.setGerarRequisicao(Short.valueOf((short)0));
                l1.setItemNotaTerceiros(i);
                LancamentoCentroCusto lc = new LancamentoCentroCusto();
                lc.setEmpresa(nf.getEmpresa());
                lc.setDataCadastro(new Date());
                lc.setCentroCusto(centro);
                lc.setDataLancamento(nf.getDataEntrada());
                lc.setEntSaida(Short.valueOf((short)0));
                lc.setGradeCor(grade.getGradeCor());
                lc.setProvisao(Short.valueOf((short)1));
                lc.setQuantidade(i.getQuantidadeTotal());
                lc.setValor(Double.valueOf(lc.getQuantidade() * grade.getValorCusto()));
                l1.setLancCtoCusto(lc);
                ArrayList<LancCtoItemNota> aux = new ArrayList<LancCtoItemNota>();
                aux.add(l1);
                i.setLancCtoEntrada(aux);
            }
        }
    }

    static void contabilizarNF(NotaFiscalTerceiros nf, EmpresaContabilidade empCont, OpcoesContabeis opcoes) throws ExceptionService, ExceptionInvalidData {
        if (empCont != null && empCont.getLancNotaTerceiros() == 0) {
            CompLancamentosEntradaSaidaFiscais comp = (CompLancamentosEntradaSaidaFiscais)ConfApplicationContext.getBean(CompLancamentosEntradaSaidaFiscais.class);
            LoteContabil lote = comp.contabilizar(nf, opcoes);
            IntegracaoNotaTerceirosNotas i = nf.getIntegracaoNotaTerceiros();
            if (i == null) {
                i = new IntegracaoNotaTerceirosNotas();
                i.setNotaFiscalTerceiros(nf);
            }
            i.setLoteContabil(lote);
            nf.setIntegracaoNotaTerceiros(i);
        }
    }

    static void calculaTotalizadores(NotaFiscalTerceiros n) {
        ValoresNfTerceiros vr = CoreUtilityFactory.getUtilityNotaFiscalTerceiros().calcularTotalizadores(n.getValoresNfTerceiros(), n.getItemNotaTerceiros(), n.getNotaTerceirosFreteCtrc());
        vr.setNotaFiscalTerceiros(n);
        n.setValoresNfTerceiros(vr);
    }

    static void updateQtdTotalitens(NotaFiscalTerceiros n) {
        AuxStandardMethodsNF.updateQtdTotalitens(n.getItemNotaTerceiros());
    }

    static void updateQtdTotalitens(List<ItemNotaTerceiros> itens) {
        for (ItemNotaTerceiros item : itens) {
            double qtd = item.getGrade().stream().mapToDouble(i -> i.getQuantidade()).sum();
            item.setQuantidadeTotal(Double.valueOf(qtd));
        }
    }
}

