/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.impchequeagenciavalores;

import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import mentorcore.tools.DateUtil;

public class UtilityImpChequeAgenciaValores {
    private String getValue(String token, HashMap vo) {
        if (token == null || vo == null) {
            return "";
        }
        TextBuilderParam param = this.getSize(token);
        if ((token = token.replaceAll("\n", "")).startsWith("valor")) {
            return this.build(ContatoFormatUtil.formataNumero((Number)((Number)vo.get("valor")), (int)2), param, false);
        }
        if (token.startsWith("extenso")) {
            return this.build(ContatoFormatUtil.numeroPorExtensoReais((Number)((Number)vo.get("valor"))), param, false);
        }
        if (token.startsWith("favorecido")) {
            return this.build((String)vo.get("favorecido"), param, false);
        }
        if (token.startsWith("local")) {
            return this.build((String)vo.get("cidade"), param, true);
        }
        if (token.startsWith("dia")) {
            GregorianCalendar g = new GregorianCalendar();
            g.setTime((Date)vo.get("dataEmissao"));
            return this.build(String.valueOf(g.get(5)), param, false);
        }
        if (token.startsWith("mes")) {
            return ToolString.clearSpecialCharacXML((String)this.build(DateUtil.dateToStr((Date)vo.get("dataEmissao"), "MMMM"), param, false));
        }
        if (token.startsWith("ano")) {
            GregorianCalendar g = new GregorianCalendar();
            g.setTime((Date)vo.get("dataEmissao"));
            return this.build(String.valueOf(g.get(1)), param, false);
        }
        return "";
    }

    public String getTextoCheque(String modelo, HashMap h) {
        List tokens = ToolString.getReplaceTokens((String)modelo);
        HashMap<String, String> values = new HashMap<String, String>();
        for (Object o : tokens) {
            StringToken tk = (StringToken)o;
            String value = this.getValue(tk.getChaveCompleta(), h);
            values.put(tk.getChave(), ToolString.clearSpecialCharacXMLFile((String)value));
        }
        String found = ToolString.build((String)modelo, values);
        return found;
    }

    private TextBuilderParam getSize(String token) {
        int indexStart = token.indexOf("(");
        int indexEnd = token.indexOf(")");
        if (indexStart > 0 && indexEnd > 0) {
            token = token.substring(indexStart + 1, indexEnd);
            StringTokenizer sk = new StringTokenizer(token, ",");
            int auxCount = 1;
            TextBuilderParam param = new TextBuilderParam(this);
            sk.countTokens();
            while (sk.hasMoreTokens()) {
                String aux = sk.nextToken();
                if (auxCount == 1) {
                    param.minSize = Integer.valueOf(aux);
                } else if (auxCount == 2) {
                    param.maxSize = Integer.valueOf(aux);
                } else if (auxCount == 3) {
                    param.caracterBefore = aux;
                } else if (auxCount == 4) {
                    param.caracterAfter = aux;
                } else if (auxCount == 5) {
                    param.sizeBefore = Integer.valueOf(aux);
                } else if (auxCount == 6) {
                    param.sizeAfter = Integer.valueOf(aux);
                } else if (auxCount == 7) {
                    param.quebraLinha = Integer.valueOf(aux);
                }
                ++auxCount;
            }
            return param;
        }
        return null;
    }

    private String build(String text, TextBuilderParam param, boolean completaEsquerda) {
        if (text == null) {
            return "";
        }
        text = ((String)text).toUpperCase();
        Object prefixo = "";
        Object sufixo = "";
        if (param.caracterBefore != null && param.caracterBefore.trim().length() > 0 && param.sizeBefore > 0) {
            prefixo = ToolString.completaCaracter((String)"", (String)param.caracterBefore, (int)param.sizeBefore, (boolean)true) + " ";
        }
        if (param.caracterAfter != null && param.caracterAfter.trim().length() > 0 && param.sizeAfter > 0) {
            sufixo = " " + ToolString.completaCaracter((String)"", (String)param.caracterAfter, (int)param.sizeAfter, (boolean)true);
        }
        text = (String)prefixo + (String)text + (String)sufixo;
        if (param.minSize > 0 && ((String)text).length() < param.minSize) {
            text = ToolString.completaEspacos((String)text, (int)param.minSize, (boolean)completaEsquerda);
        }
        if (param.quebraLinha > 0) {
            StringBuilder aux = new StringBuilder();
            char[] caract = ((String)text).toCharArray();
            int lastSpace = 0;
            for (int i = 0; i < caract.length; ++i) {
                char ch = caract[i];
                if (ch == ' ' || ch == '*') {
                    lastSpace = i;
                }
                if (i > 0 && i < param.maxSize && i % param.quebraLinha == 0) {
                    aux.insert(lastSpace, "\n");
                }
                aux.append(ch);
            }
            if (aux.length() > 0) {
                text = aux.toString();
            }
        }
        if (param.maxSize > 0 && ((String)text).length() > param.maxSize) {
            text = ((String)text).substring(0, param.maxSize);
        }
        return text;
    }

    private class TextBuilderParam {
        private String caracterBefore;
        private String caracterAfter;
        private int sizeAfter;
        private int sizeBefore;
        private int maxSize;
        private int minSize;
        private int quebraLinha;

        private TextBuilderParam(UtilityImpChequeAgenciaValores utilityImpChequeAgenciaValores) {
        }
    }
}

