/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.importexportbi;

import com.touchcomp.basementor.model.vo.BusinessIntConsSQL;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceDados;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceFiles;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceFormGer;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceInf;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceNodo;
import com.touchcomp.basementor.model.vo.BusinessJavaClassCode;
import com.touchcomp.basementor.model.vo.CheckNodeBI;
import com.touchcomp.basementor.model.vo.ClasseModeloBI;
import com.touchcomp.basementor.model.vo.DadoAdicionalBI;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FormatoGeracaoBI;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.OrderNodeBI;
import com.touchcomp.basementor.model.vo.ValorFixoDadoAdicional;
import com.touchcomp.basementor.model.vo.WhereNodeBI;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.components.entityxml.CompExpImpEntityXML;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.clone.ToolClone;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import com.touchcomp.touchvomodel.vo.importacaobi.repositorio.DTOVersaoBICompleto;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.properties.LocalProperties;
import mentorcore.service.CoreService;

class AuxImportBi {
    public BusinessIntelligence importarDataBI(DTOVersaoBICompleto h, Empresa emp) throws ExceptionService {
        try {
            String serial = h.getSerialBI();
            Long numeroVersao = h.getNumeroVersao();
            Long numeroBI = h.getNumeroBI();
            Short tipoClassificacaoBI = Short.valueOf(h.getTipoClassificacaoBI());
            String numeroControle = h.getNumeroControle();
            Long numeroVersaoRep = h.getNumeroVersaoRep();
            String conteudo = h.getArquivoBI();
            String content = ToolHexString.decodeToStr((String)conteudo);
            BusinessIntelligence b = this.importarDataBI(content);
            b.setTipoClassificacaoBI(tipoClassificacaoBI);
            b.setNumeroBI(numeroBI);
            b.setAtivo(Short.valueOf((short)1));
            b.setNumeroVersao(numeroVersao);
            b.setNumeroVersaoRep(numeroVersaoRep);
            b.setSerialLocalBI(serial);
            b.setNumeroControle(numeroControle);
            this.setNodos(b, h);
            if (b.getBusinessIntelligenceObjetos() != null && b.getBusinessIntelligenceObjetos().getClasseModeloBI() != null) {
                String oldClass = b.getBusinessIntelligenceObjetos().getClasseModeloBI().getClasse();
                b.getBusinessIntelligenceObjetos().getClasseModeloBI().setClasse(ToolReflections.toModelVOClass((String)oldClass).getCanonicalName());
                Iterator iterator = b.getDadosAdicionalBI().iterator();
                while (iterator.hasNext()) {
                    DadoAdicionalBI d;
                    oldClass = (d = (DadoAdicionalBI)iterator.next()).getClassePesquisa();
                    d.setClassePesquisa(oldClass != null ? ToolReflections.toModelVOClass((String)oldClass).getCanonicalName() : null);
                }
            }
            ToolClone.nullIds((Object)b);
            return this.doAfterImport(b, emp, true);
        }
        catch (Exception ex) {
            throw new ExceptionService("Erro ao importar o BI", ex);
        }
    }

    public BusinessIntelligence importarDataBI(byte[] data) throws ExceptionIO, ExceptionService {
        String conteudoBI;
        try {
            conteudoBI = ToolHexString.decodeToStr((String)new String(data));
        }
        catch (ExceptionDecodeHexString ex) {
            throw new ExceptionService(ex);
        }
        return this.importarDataBI(conteudoBI);
    }

    public BusinessIntelligence importarDataBI(String conteudoBI) throws ExceptionIO {
        String versao = LocalProperties.getInstance().getCodigoVersao();
        if (versao == null) {
            versao = "0";
        }
        return (BusinessIntelligence)((CompExpImpEntityXML)Context.get(CompExpImpEntityXML.class)).fileToEntity((InputStream)new ByteArrayInputStream(conteudoBI.getBytes(Charset.forName("UTF-8"))), Long.valueOf(versao), false, "com.touchcomp.basementor.model.vo");
    }

    public BusinessIntelligence importarDataBI(File file, Empresa emp, boolean save) throws ExceptionService {
        try {
            return this.importarDataBI(ToolFile.getConteudoArquivo((InputStream)new FileInputStream(file), (String)"UTF-8"), emp, save);
        }
        catch (ExceptionIO ex) {
            throw new ExceptionService(ex);
        }
        catch (FileNotFoundException ex) {
            throw new ExceptionService(ex);
        }
    }

    public BusinessIntelligence importarDataBI(byte[] data, Empresa emp, boolean save) throws ExceptionService, ExceptionIO {
        String conteudoBI;
        try {
            conteudoBI = ToolHexString.decodeToStr((String)new String(data));
        }
        catch (ExceptionDecodeHexString ex) {
            throw new ExceptionService(ex);
        }
        return this.importarDataBI(conteudoBI, emp, save);
    }

    public BusinessIntelligence importarDataBI(String content, Empresa emp, boolean save) throws ExceptionService, ExceptionIO {
        String nrVersao = LocalProperties.getInstance().getCodigoVersao();
        if (nrVersao == null) {
            nrVersao = "0";
        }
        BusinessIntelligence b = (BusinessIntelligence)((CompExpImpEntityXML)Context.get(CompExpImpEntityXML.class)).fileToEntity(content, new Long(nrVersao), false, "com.touchcomp.basementor.model.vo");
        return this.doAfterImport(b, emp, save);
    }

    private BusinessIntelligence doAfterImport(BusinessIntelligence b, Empresa emp, boolean save) throws ExceptionService {
        try {
            ToolClone.nullIds((Object)b);
        }
        catch (ExceptionReflection ex) {
            throw new ExceptionService(ex);
        }
        if (b.getBusinessIntelligenceInf() == null) {
            b.setBusinessIntelligenceInf(new BusinessIntelligenceInf());
        }
        b.setEmpresa(emp);
        b.getBusinessIntelligenceInf().setGrupos(new ArrayList());
        b.setFormatosGeracao(this.getAllFormatos());
        b.setAtivo(Short.valueOf((short)1));
        this.atualizarValorFixoBi(b.getDadosAdicionalBI());
        if (b.getNrVersaoEstruturaBI() == null) {
            b.setNrVersaoEstruturaBI(Integer.valueOf(1));
        }
        for (DadoAdicionalBI dadosAdicionalBI : b.getDadosAdicionalBI()) {
            dadosAdicionalBI.setBusinessInteligence(b);
        }
        for (BusinessIntelligenceFiles businessIntelligenceFile : b.getBusinessIntelligenceFiles()) {
            businessIntelligenceFile.setBusinessIntelligence(b);
        }
        for (BusinessIntelligenceDados dadosImagen : b.getDadosImagens()) {
            dadosImagen.setBusinessIntelligence(b);
        }
        for (BusinessIntelligenceFormGer formatosGeracao : b.getFormatosGeracao()) {
            formatosGeracao.setBusinessIntelligence(b);
        }
        if (b.getBusinessIntelligenceObjetos() != null && b.getBusinessIntelligenceObjetos().getClasseModeloBI() != null) {
            ClasseModeloBI cl = b.getBusinessIntelligenceObjetos().getClasseModeloBI();
            for (WhereNodeBI nodosCondicao : cl.getNodosCondicao()) {
                nodosCondicao.setClasseModelo(cl);
            }
            for (OrderNodeBI order : cl.getNodosOrdenacao()) {
                order.setClasseModelo(cl);
            }
            for (CheckNodeBI check : cl.getNodosSelecao()) {
                check.setClasseModelo(cl);
            }
            cl.setBusinessIntelligenceObjetos(b.getBusinessIntelligenceObjetos());
        }
        if (b.getBusinessIntConsSQL() != null) {
            BusinessIntConsSQL bs = b.getBusinessIntConsSQL();
            for (BusinessIntConsSQL consultasSQL : bs.getConsultasSQL()) {
                consultasSQL.setBusinessIntConsSQL(bs);
            }
        }
        if (b.getBusinessJavaClassCode() != null) {
            BusinessJavaClassCode bo = b.getBusinessJavaClassCode();
            bo.setBusinessIntelligence(b);
        }
        if (save) {
            b = (BusinessIntelligence)CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOBusinessIntelligence(), b);
        }
        return b;
    }

    private void atualizarValorFixoBi(List<DadoAdicionalBI> dados) {
        for (DadoAdicionalBI dadosAdicionais : dados) {
            for (ValorFixoDadoAdicional valorFixo : dadosAdicionais.getValorFixo()) {
                valorFixo.setDadoAdicional(dadosAdicionais);
            }
            this.atualizarValorFixoBi(dadosAdicionais.getDadoAdicionalBIFilhos());
        }
    }

    private List<BusinessIntelligenceFormGer> getAllFormatos() throws ExceptionService {
        List formatosDisp = (List)CoreService.simpleFindAll(CoreDAOFactory.getInstance().getDAOFormatoGeracaoBI(), "indice");
        LinkedList<BusinessIntelligenceFormGer> toAdd = new LinkedList<BusinessIntelligenceFormGer>();
        for (FormatoGeracaoBI formatoGeracaoBI : formatosDisp) {
            BusinessIntelligenceFormGer baux = new BusinessIntelligenceFormGer();
            baux.setFormatoGeracaoBI(formatoGeracaoBI);
            baux.setLiberar(Short.valueOf((short)1));
            toAdd.add(baux);
        }
        return toAdd;
    }

    private void setNodos(BusinessIntelligence b, DTOVersaoBICompleto h) throws ExceptionService {
        if (h.getNodos() == null) {
            return;
        }
        for (Long nd : h.getNodos()) {
            Nodo nodo = (Nodo)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAONodo(), nd);
            if (nodo == null) continue;
            BusinessIntelligenceNodo bn = new BusinessIntelligenceNodo();
            bn.setBusinessIntelligenceInf(b.getBusinessIntelligenceInf());
            bn.setNodo(nodo);
            b.getBusinessIntelligenceInf().getNodos().add(bn);
        }
    }
}

