/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.jasperreports;

import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import java.io.File;
import java.util.List;
import mentorcore.exceptions.ExceptionExportRelatorio;
import mentorcore.utilities.impl.jasperreports.FormatoImpressaoBase;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.fill.JRTemplatePrintText;

public class UtilityJasperReports {
    private static final TLogger logger = TLogger.get(UtilityJasperReports.class);

    public String getPathReports() {
        return System.getProperty("mentor.pathreports") + File.separator + "reports" + File.separator;
    }

    public Object export(String factoryClass, DataOutputBI out, File output) throws ExceptionExportRelatorio {
        try {
            Class<?> cl = Class.forName(factoryClass);
            FormatoImpressaoBase factory = (FormatoImpressaoBase)cl.newInstance();
            return this.export(factory, out, output);
        }
        catch (Exception ex) {
            throw new ExceptionExportRelatorio(ex);
        }
    }

    public Object export(FormatoImpressaoBase formato, DataOutputBI out, File output) throws ExceptionExportRelatorio {
        UtilityJasperReports.correctPageNumbers(out.getJasperPrint());
        return formato.buildOutputReport(out, output);
    }

    protected static void correctPageNumbers(JasperPrint jasperPrint) {
        List listPages = jasperPrint.getPages();
        int numberOfPages = listPages.size();
        int currentPageIndex = 1;
        for (JRPrintPage currentPage : listPages) {
            List listElements = currentPage.getElements();
            for (Object element : listElements) {
                if (!(element instanceof JRTemplatePrintText)) continue;
                JRTemplatePrintText templatePrintText = (JRTemplatePrintText)element;
                if (templatePrintText.getKey() != null && templatePrintText.getKey().equalsIgnoreCase("textFieldCurrentPage")) {
                    templatePrintText.setText(String.valueOf(currentPageIndex));
                }
                if (templatePrintText.getKey() == null || !templatePrintText.getKey().equalsIgnoreCase("textFieldNumberOfPages")) continue;
                templatePrintText.setText(String.valueOf(numberOfPages));
            }
            ++currentPageIndex;
        }
    }
}

