/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.jasperreports.auxiliar;

import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import java.io.File;
import java.io.IOException;
import mentorcore.exceptions.ExceptionExportRelatorio;
import mentorcore.utilities.impl.jasperreports.FormatoImpressaoBase;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleRtfReportConfiguration;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;

public class FormImpressaoExporterRtf
extends FormatoImpressaoBase {
    @Override
    public File buildOutputReport(DataOutputBI out) throws ExceptionExportRelatorio {
        try {
            File f = this.createTempFile("mentor_doc", ".rtf");
            out.setFile(f);
            return this.buildOutputReport(out, f);
        }
        catch (IOException ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionExportRelatorio(ex);
        }
    }

    @Override
    public File buildOutputReport(DataOutputBI out, File output) throws ExceptionExportRelatorio {
        try {
            JRRtfExporter exporter = new JRRtfExporter();
            exporter.setExporterInput((ExporterInput)new SimpleExporterInput(out.getJasperPrint()));
            exporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput(output));
            SimpleRtfReportConfiguration config = new SimpleRtfReportConfiguration();
            exporter.setConfiguration((ReportExportConfiguration)config);
            exporter.exportReport();
            return output;
        }
        catch (JRException ex) {
            logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionExportRelatorio(ex);
        }
    }
}

