/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.jasperreports.auxiliar;

import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import java.io.File;
import java.io.IOException;
import mentorcore.exceptions.ExceptionExportRelatorio;
import mentorcore.utilities.impl.jasperreports.FormatoImpressaoBase;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.export.JRTextExporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleTextExporterConfiguration;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;

public class FormImpressaoExporterTxt
extends FormatoImpressaoBase {
    @Override
    public File buildOutputReport(DataOutputBI out) throws ExceptionExportRelatorio {
        try {
            File f = this.createTempFile("mentor_doc", ".xlsx");
            out.setFile(f);
            return this.buildOutputReport(out, f);
        }
        catch (IOException ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionExportRelatorio(ex);
        }
    }

    @Override
    public File buildOutputReport(DataOutputBI out, File output) throws ExceptionExportRelatorio {
        try {
            if (output == null) {
                output = this.createTempFile("mentor_doc", ".xlsx");
            }
            JRTextExporter exporter = new JRTextExporter();
            exporter.setExporterInput((ExporterInput)new SimpleExporterInput(out.getJasperPrint()));
            exporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput(output));
            SimpleTextExporterConfiguration config = new SimpleTextExporterConfiguration();
            exporter.setConfiguration((ExporterConfiguration)config);
            exporter.exportReport();
            return output;
        }
        catch (IOException ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionExportRelatorio(ex);
        }
        catch (JRException ex) {
            logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionExportRelatorio(ex);
        }
    }
}

