/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.lancamentogerencial;

import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.situacaocobranca.EnumConstSituacaoCobranca;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorspringcontext.Context;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Date;

class AuxBaixaTitulo {
    AuxBaixaTitulo() {
    }

    void criarLancamentosCTBGerencialLiquidacao(GrupoDeBaixaFormas vo) {
        for (BaixaTitulo b : vo.getBaixaTitulo()) {
            this.criarLancamentos(b, vo.getGrupoDeBaixa().getDataLiquidacao());
        }
    }

    private void criarLancamentos(BaixaTitulo b, Date dataLiquidacao) {
        if (b.getTitulo().getCarteiraCobranca().getSituacaoCobranca().getTipoCobranca().equals(EnumConstSituacaoCobranca.DESCONTADA.getEnumId())) {
            return;
        }
        ArrayList<LancamentoCtbGerencial> lanc = new ArrayList<LancamentoCtbGerencial>();
        double perc = b.getValor() / b.getTitulo().getValor();
        double valorTotal = 0.0;
        double valorDebito = 0.0;
        double valorCredito = 0.0;
        LancamentoCtbGerencial last = null;
        for (LancamentoCtbGerencial l : b.getTitulo().getLancCtbGerencial()) {
            double valorAux = ContatoFormatUtil.arrredondarNumero((Double)(l.getValor() * perc), (int)2);
            LancamentoCtbGerencial laux = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, dataLiquidacao, dataLiquidacao, l.getDebCred(), l.getEmpresa(), l.getGerado(), l.getHistorico(), l.getPlanoContaGerencial(), l.getProvRealizado(), Short.valueOf(EnumTipoLancamentoCTBGerencial.LIQUIDACAO.getValue()), l.getCentroCusto(), Double.valueOf(valorAux), null);
            lanc.add(laux);
            last = laux;
            if (l.getDebCred() == 1) {
                valorCredito += valorAux;
                continue;
            }
            valorDebito += valorAux;
        }
        valorTotal = valorCredito - valorDebito;
        valorTotal = Math.abs(valorTotal);
        if (last != null && valorTotal != b.getTotalOperacao()) {
            last.setValor(Double.valueOf(last.getValor() + (b.getValor() - valorTotal)));
        }
        b.setLancCTbGerencialLiquidacao(lanc);
    }
}

