/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.lancamentogerencial;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.model.vo.AdiantamentoViagem;
import com.touchcomp.basementor.model.vo.ApuracaoLocacaoContrato;
import com.touchcomp.basementor.model.vo.ApuracaoLocacaoContratoBem;
import com.touchcomp.basementor.model.vo.Bem;
import com.touchcomp.basementor.model.vo.CancAntecTitulos;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.DepreciacaoBem;
import com.touchcomp.basementor.model.vo.DevolucaoPedComercio;
import com.touchcomp.basementor.model.vo.DuplicataTransporte;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Executante;
import com.touchcomp.basementor.model.vo.FechamAdiantamentoViagem;
import com.touchcomp.basementor.model.vo.GradeItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.IntegCustoProdVendidoData;
import com.touchcomp.basementor.model.vo.IntegCustoProdVendidoItem;
import com.touchcomp.basementor.model.vo.IntegracaoCustoProdVendidoLancCtbGerencial;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.ItemOrdemCompra;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.ItemPedidoComercio;
import com.touchcomp.basementor.model.vo.LancCtoItemNota;
import com.touchcomp.basementor.model.vo.LancCtoSaidaItemNota;
import com.touchcomp.basementor.model.vo.LancamentoCentroCusto;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.LancamentoEventoCooperado;
import com.touchcomp.basementor.model.vo.LoteLancamentoEventoCooperado;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementor.model.vo.NotaContratoLocacao;
import com.touchcomp.basementor.model.vo.OpcoesContabeisBaixaTitulos;
import com.touchcomp.basementor.model.vo.PedidoComercio;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoContaBemDepreciacao;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.RenegociacaoTitulos;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementor.model.vo.TipoBem;
import com.touchcomp.basementor.model.vo.TipoDepreciacao;
import com.touchcomp.basementor.model.vo.TipoOperacaoGeracaoFaturamento;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorservice.service.impl.opcoescontabeisbaixatitulos.ServiceOpcoesContabeisBaixaTitulosImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import mentorcore.exceptions.ExceptionService;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.impl.lancamentogerencial.AuxBaixaTitulo;
import mentorcore.utilities.impl.lancamentogerencial.AuxMovimentoFinanceiro;

public class UtilityLancamentosGerenciais {
    private final ServiceOpcoesContabeisBaixaTitulosImpl serviceOpcoesContabeisBaixaTitulosImpl = (ServiceOpcoesContabeisBaixaTitulosImpl)Context.get(ServiceOpcoesContabeisBaixaTitulosImpl.class);

    public void criarLancamentosCTBGerencial(List itensNota, List titulos, Empresa emp) {
        HashMap pc = this.getPlanoContas(itensNota);
        Double valorTotalTitulos = this.getValorTotalTitulos(titulos);
        for (Object ob : titulos) {
            Titulo t = (Titulo)ob;
            Set keys = pc.keySet();
            ArrayList<LancamentoCtbGerencial> lanc = t.getLancCtbGerencial();
            if (lanc == null) {
                lanc = new ArrayList<LancamentoCtbGerencial>();
            } else {
                lanc.clear();
            }
            int count = 0;
            double valorAcumulado = 0.0;
            for (Object o : keys) {
                if (o == null) continue;
                HashMap m = (HashMap)o;
                Set keys2 = m.keySet();
                PlanoContaGerencial planoContaGerencial = null;
                CentroCusto centroCusto = null;
                for (Object o2 : keys2) {
                    if (o2 instanceof PlanoContaGerencial) {
                        planoContaGerencial = (PlanoContaGerencial)o2;
                        continue;
                    }
                    if (!(o2 instanceof CentroCusto)) continue;
                    centroCusto = (CentroCusto)o2;
                }
                Double valorConta = (Double)pc.get(m);
                String historico = "Titulo/Parcela: " + t.getNumParcTituloEstnota() + ". Pessoa: " + t.getPessoa().getNome();
                Double valorLanc = 0.0;
                Double valorLancGer = 0.0;
                if (t.getValor() > 0.0 && valorTotalTitulos > 0.0) {
                    valorLanc = ContatoFormatUtil.arrredondarNumero((Double)(t.getValor() / valorTotalTitulos * valorConta), (int)2);
                }
                valorLancGer = count == pc.size() - 1 ? Double.valueOf(Math.abs(t.getValor() - valorAcumulado)) : valorLanc;
                valorAcumulado += valorLanc.doubleValue();
                LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, t.getDataCompetencia(), t.getDataVencimento(), Short.valueOf(ToolMethods.isEquals((Object)t.getPagRec(), (Object)0) ? EnumLancamentoCTBGerencial.DEBITO.getValue() : EnumLancamentoCTBGerencial.CREDITO.getValue()), emp, Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()), (String)(historico.length() > 500 ? historico.substring(0, 500) : historico), planoContaGerencial, t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), centroCusto, valorLancGer, null);
                ++count;
                lanc.add(l);
            }
            if (lanc.isEmpty()) continue;
            t.setLancCtbGerencial(lanc);
        }
    }

    public void criarLancamentosCTBGerencialNotaPropria(List<ItemNotaFiscalPropria> itensNota, List titulos, Empresa emp, PlanoContaGerencial planoGerencialDescontosNaoDest, PlanoContaGerencial planoGerencialFreteNaoDest, PlanoContaGerencial planoGerencialSeguroNaoDest, PlanoContaGerencial planoGerencialDespAcesNaoDest, CentroCusto centroCusto) {
        HashMap pc = this.getPlanoContasNotaPropria(itensNota, planoGerencialDescontosNaoDest, planoGerencialFreteNaoDest, planoGerencialSeguroNaoDest, planoGerencialDespAcesNaoDest);
        Double valorTotalTitulos = this.getValorTotalTitulos(titulos);
        this.setLancamentosValoresNaoDestacadosNotaPropria(titulos, itensNota, emp, planoGerencialDescontosNaoDest, planoGerencialFreteNaoDest, planoGerencialSeguroNaoDest, planoGerencialDespAcesNaoDest, centroCusto);
        for (Object ob : titulos) {
            Titulo t = (Titulo)ob;
            Set keys = pc.keySet();
            List lanc = t.getLancCtbGerencial();
            int count = 0;
            double valorAcumulado = 0.0;
            for (Object o : keys) {
                if (o == null) continue;
                HashMap h = (HashMap)pc.get(o);
                Double valorTotal = (Double)h.get("valorTotal");
                Double valorDescontoNaoDest = (Double)h.get("valorDescontoNaoDest");
                Double valorFreteNaoDest = (Double)h.get("valorFreteNaoDest");
                Double valorSeguroNaoDest = (Double)h.get("valorSeguroNaoDest");
                Double valorDespNaoAcesNaoDest = (Double)h.get("valorDespAcesNaoDest");
                Double naoDestacadoFreteSegDesp = ContatoFormatUtil.arrredondarNumero((Double)(Math.abs(valorFreteNaoDest + valorSeguroNaoDest + valorDespNaoAcesNaoDest) / (double)titulos.size()), (int)2);
                Double naoDestacadoDesc = ContatoFormatUtil.arrredondarNumero((Double)(Math.abs(valorDescontoNaoDest) / (double)titulos.size()), (int)2);
                Double valorConta = ContatoFormatUtil.arrredondarNumero((Double)(valorTotal - naoDestacadoFreteSegDesp + naoDestacadoDesc), (int)2);
                String historico = "Titulo/Parcela: " + t.getNumParcTituloEstnota() + ". Pessoa: " + t.getPessoa().getNome();
                Double valorLanc = ContatoFormatUtil.arrredondarNumero((Double)(t.getValor() / valorTotalTitulos * valorConta), (int)2);
                Double valorLancGer = 0.0;
                valorLancGer = count == pc.size() - 1 ? ContatoFormatUtil.arrredondarNumero((Double)Math.abs(t.getValor() - valorAcumulado - naoDestacadoFreteSegDesp + naoDestacadoDesc), (int)2) : valorLanc;
                valorAcumulado += valorLanc.doubleValue();
                LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, t.getDataCompetencia(), t.getDataVencimento(), Short.valueOf(ToolMethods.isEquals((Object)t.getPagRec(), (Object)0) ? EnumLancamentoCTBGerencial.DEBITO.getValue() : EnumLancamentoCTBGerencial.CREDITO.getValue()), emp, Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()), (String)(historico.length() > 500 ? historico.substring(0, 500) : historico), (PlanoContaGerencial)o, t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), null, valorLancGer, null);
                ++count;
                lanc.add(l);
            }
        }
    }

    private HashMap getPlanoContas(List itensNota) {
        HashMap s = new HashMap();
        Boolean notPlanoConta = false;
        for (Object o : itensNota) {
            HashMap<Object, Object> h;
            if (o instanceof ItemNotaFiscalPropria) {
                ItemNotaFiscalPropria itemNotaPropria = (ItemNotaFiscalPropria)o;
                h = new HashMap<Object, Object>();
                h.put(itemNotaPropria.getPlanoContaGerencial(), itemNotaPropria.getPlanoContaGerencial());
                Double valor = itemNotaPropria.getItemNotaLivroFiscal().getValorTotal();
                if (s.get(h) != null) {
                    s.put(h, (Double)s.get(h) + valor);
                    continue;
                }
                s.put(h, valor);
                continue;
            }
            if (o instanceof ItemNotaTerceiros) {
                ItemNotaTerceiros itemNotaTerceiros = (ItemNotaTerceiros)o;
                h = new HashMap();
                h.put(itemNotaTerceiros.getPlanoContaGerencial(), itemNotaTerceiros.getPlanoContaGerencial());
                h.put(itemNotaTerceiros.getCentroCusto(), itemNotaTerceiros.getCentroCusto());
                if (s.get(h) != null) {
                    s.put(h, (Double)s.get(h) + itemNotaTerceiros.getItemNotaLivroFiscal().getValorTotal());
                    continue;
                }
                s.put(h, itemNotaTerceiros.getItemNotaLivroFiscal().getValorTotal());
                continue;
            }
            if (o instanceof ApuracaoLocacaoContratoBem) {
                ApuracaoLocacaoContratoBem apuracaoLocacaoContratoBem = (ApuracaoLocacaoContratoBem)o;
                h = new HashMap();
                h.put(apuracaoLocacaoContratoBem.getContaGerencial(), apuracaoLocacaoContratoBem.getContaGerencial());
                if (s.get(h) != null) {
                    s.put(h, (Double)s.get(h) + apuracaoLocacaoContratoBem.getValorTotal());
                    continue;
                }
                s.put(h, apuracaoLocacaoContratoBem.getValorTotal());
                continue;
            }
            if (o instanceof ItemPedido) {
                ItemPedido itemPedido = (ItemPedido)o;
                if (itemPedido.getProduto() == null || itemPedido.getProduto().getPlanoContaGerencial() == null) {
                    notPlanoConta = true;
                }
                if (notPlanoConta.booleanValue()) continue;
                h = new HashMap();
                h.put(itemPedido.getProduto().getPlanoContaGerencial(), itemPedido.getProduto().getPlanoContaGerencial());
                if (itemPedido.getTipoCondicao() != 0) continue;
                Double valorTotal = itemPedido.getValorTotalComImpostos();
                if (!ToolMethods.isWithData((Number)valorTotal)) {
                    valorTotal = itemPedido.getValorTotal();
                }
                if (s.get(h) != null) {
                    s.put(h, (Double)s.get(h) + valorTotal);
                    continue;
                }
                s.put(h, valorTotal);
                continue;
            }
            if (!(o instanceof ItemOrdemCompra)) continue;
            ItemOrdemCompra itemOrdemCompra = (ItemOrdemCompra)o;
            h = new HashMap();
            h.put(itemOrdemCompra.getProduto().getPlanoContaGerencial(), itemOrdemCompra.getProduto().getPlanoContaGerencial());
            if (s.get(h) != null) {
                s.put(h, (Double)s.get(h) + itemOrdemCompra.getItemOrdemCompraLF().getValorTotal());
                continue;
            }
            s.put(h, itemOrdemCompra.getItemOrdemCompraLF().getValorTotal());
        }
        return s;
    }

    private Double getValorTotalTitulos(List titulos) {
        Double valor = 0.0;
        for (Object o : titulos) {
            valor = valor + ((Titulo)o).getValor();
            valor = ToolFormatter.arrredondarNumero((Double)valor, (int)2);
        }
        return valor;
    }

    public List<LancCtoSaidaItemNota> getLancCtoGerSaida(ItemNotaTerceiros vo, List<LancCtoItemNota> lancCtoEntrada, Empresa emp, Date dataCompetencia) {
        ArrayList<LancCtoSaidaItemNota> result = new ArrayList<LancCtoSaidaItemNota>();
        if (lancCtoEntrada != null && vo.getGrade() != null && vo.getGrade().size() > 0 && ((GradeItemNotaTerceiros)vo.getGrade().get(0)).getMovimentacaoFisica() != null && ((GradeItemNotaTerceiros)vo.getGrade().get(0)).getMovimentacaoFisica().shortValue() == EnumConstantsMentorSimNao.NAO.getValue()) {
            for (LancCtoItemNota l : lancCtoEntrada) {
                LancCtoSaidaItemNota la = new LancCtoSaidaItemNota();
                la.setItemNotaTerceiros(vo);
                LancamentoCentroCusto lc = new LancamentoCentroCusto();
                lc.setCentroCusto(l.getLancCtoCusto().getCentroCusto());
                lc.setDataLancamento(l.getLancCtoCusto().getDataLancamento());
                lc.setEmpresa(emp);
                lc.setDataCadastro(new Date());
                lc.setGradeCor(l.getLancCtoCusto().getGradeCor());
                lc.setProvisao(l.getLancCtoCusto().getProvisao());
                lc.setQuantidade(l.getLancCtoCusto().getQuantidade());
                lc.setValor(l.getLancCtoCusto().getValor());
                lc.setEntSaida(Short.valueOf((short)1));
                la.setLancCtoCusto(lc);
                LancamentoCtbGerencial lct = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, dataCompetencia, dataCompetencia, Short.valueOf(EnumLancamentoCTBGerencial.DEBITO.getValue()), emp, Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()), "Lancamento gerencial de sa\u00edda referente a nota fiscal de terceiros.", vo.getPlanoContaGerencial(), Short.valueOf(EnumProvisionamentoLancamentoCTBGerencial.PROVISAO.getValue()), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO.getValue()), l.getLancCtoCusto().getCentroCusto(), l.getLancCtoCusto().getValor(), null);
                la.setLancCtbGerencial(lct);
                result.add(la);
            }
        }
        return result;
    }

    public List criarLancamentosCTBGerencial(Rps r, Titulo t, Double valor, PlanoContaGerencial planoContaGerencial, CentroCusto centroCusto) {
        LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, t.getDataEmissao(), t.getDataVencimento(), Short.valueOf(EnumLancamentoCTBGerencial.CREDITO.getValue()), t.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()), t.getObservacao(), planoContaGerencial, Short.valueOf(EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue()), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), centroCusto, valor, null);
        ArrayList<LancamentoCtbGerencial> lancs = new ArrayList<LancamentoCtbGerencial>();
        lancs.add(l);
        return lancs;
    }

    public List<LancamentoCtbGerencial> gerarLancamentoCtbGerencial(TipoOperacaoGeracaoFaturamento ti, Titulo t) {
        ArrayList<LancamentoCtbGerencial> lista = new ArrayList<LancamentoCtbGerencial>();
        LancamentoCtbGerencial la = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, t.getDataCadastro(), t.getDataVencimento(), Short.valueOf(EnumLancamentoCTBGerencial.CREDITO.getValue()), t.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Conhecimento de Transporte Eletronico: " + t.getPessoa().getNome(), ti.getTipoOperacao().getPlanoContaGerencial(), t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), null, t.getValor(), null);
        lista.add(la);
        return lista;
    }

    public List<LancamentoCtbGerencial> gerarLancamentoCtbGerencial(DuplicataTransporte vo, Titulo t, Empresa empresa) throws Exception {
        ArrayList<LancamentoCtbGerencial> lista = new ArrayList<LancamentoCtbGerencial>();
        Double vrDescontoFinanceiro = t.getDescontoFinanceiro() != null ? t.getDescontoFinanceiro() : 0.0;
        OpcoesContabeisBaixaTitulos opcoesContabeisBaixaTitulos = this.serviceOpcoesContabeisBaixaTitulosImpl.findOpcaoContabilBaixaTituloComFormaPagCache(t.getPagRec(), t.getTipoDoc(), t.getClassificacaoPessoa(), Short.valueOf((short)1), empresa);
        LancamentoCtbGerencial la = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, t.getDataCadastro(), t.getDataVencimento(), Short.valueOf(EnumLancamentoCTBGerencial.DEBITO.getValue()), t.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Lan\u00e7amento CTRC/CTE: " + t.getPessoa().getNome(), vo.getPlanoContaGerencial(), t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), vo.getCentroCusto(), t.getValor(), null);
        lista.add(la);
        if (vrDescontoFinanceiro > 0.0) {
            LancamentoCtbGerencial lanDesc = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, t.getDataCadastro(), t.getDataVencimento(), Short.valueOf(EnumLancamentoCTBGerencial.CREDITO.getValue()), t.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Lan\u00e7amento Desconto Financeiro CTRC/CTE: " + t.getPessoa().getNome(), opcoesContabeisBaixaTitulos.getPlanoContaDesc1Gerencial(), t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), vo.getCentroCusto(), vrDescontoFinanceiro, null);
            lista.add(lanDesc);
        }
        return lista;
    }

    public List<LancamentoCtbGerencial> gerarLancamentoCtbGerencial(Cte c, Titulo t) {
        ArrayList<LancamentoCtbGerencial> lista = new ArrayList<LancamentoCtbGerencial>();
        LancamentoCtbGerencial la = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, t.getDataCadastro(), t.getDataVencimento(), Short.valueOf(ToolMethods.isEquals((Object)c.getTipoCte().getCodigo(), (Object)2) ? EnumLancamentoCTBGerencial.DEBITO.getValue() : EnumLancamentoCTBGerencial.CREDITO.getValue()), t.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Conhecimento de Transporte Eletronico: " + t.getPessoa().getNome(), c.getTipoOperacaoFrete().getPlanoContaGerencial(), t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), null, t.getValor(), null);
        lista.add(la);
        return lista;
    }

    public List criarLancamentosCTBGerencial(NotaContratoLocacao r, Titulo t, Double valor, PlanoContaGerencial planoContaGerencial, CentroCusto centroCusto) {
        LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, t.getDataCadastro(), t.getDataVencimento(), Short.valueOf(EnumLancamentoCTBGerencial.CREDITO.getValue()), t.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()), t.getObservacao(), planoContaGerencial, Short.valueOf(EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue()), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), centroCusto, valor, null);
        ArrayList<LancamentoCtbGerencial> lancs = new ArrayList<LancamentoCtbGerencial>();
        lancs.add(l);
        return lancs;
    }

    public void criarLancamentosCTBGerencial(PedidoComercio r, List<Titulo> titulos, PlanoContaGerencial pcAcrescimo, PlanoContaGerencial pcDesconto) {
        Titulo t;
        Titulo ob;
        HashMap pc = this.getPlanoContasPedidoComercio(r.getItensPedido());
        Double valorTotalTitulos = this.getValorTotalTitulos(titulos);
        Double valorTotalDesconto = r.getValorDesconto();
        Double valorTotalAcrescimo = r.getValorAcrescimo();
        int nrTitulos = titulos.size();
        int count = 1;
        Double vrAcumuladoDesconto = 0.0;
        Double vrAcumuladoAcrescimo = 0.0;
        Iterator<Titulo> iterator = titulos.iterator();
        while (iterator.hasNext()) {
            Double valorAcrescimo;
            t = ob = iterator.next();
            Double valorDesconto = ContatoFormatUtil.arrredondarNumero((Double)(valorTotalDesconto / (double)nrTitulos), (int)2);
            if (valorDesconto > 0.0 && pcDesconto != null) {
                Double diferenca;
                Double valorLancGer = count == nrTitulos ? ((diferenca = Double.valueOf(valorTotalDesconto - (valorDesconto + vrAcumuladoDesconto))) > 0.0 ? Double.valueOf(valorDesconto + diferenca) : Double.valueOf(valorDesconto - Math.abs(diferenca))) : valorDesconto;
                vrAcumuladoDesconto = vrAcumuladoDesconto + valorDesconto;
                LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, t.getDataCadastro(), t.getDataVencimento(), Short.valueOf(EnumLancamentoCTBGerencial.DEBITO.getValue()), t.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()), t.getObservacao(), pcDesconto, t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), null, valorLancGer, null);
                t.getLancCtbGerencial().add(l);
            }
            if ((valorAcrescimo = ContatoFormatUtil.arrredondarNumero((Double)(valorTotalAcrescimo / (double)nrTitulos), (int)2)) > 0.0 && pcAcrescimo != null) {
                Double diferenca;
                Double valorLancGer = count == nrTitulos ? ((diferenca = Double.valueOf(valorTotalAcrescimo - (valorAcrescimo + vrAcumuladoAcrescimo))) > 0.0 ? Double.valueOf(valorAcrescimo + diferenca) : Double.valueOf(valorAcrescimo - Math.abs(diferenca))) : valorAcrescimo;
                vrAcumuladoAcrescimo = vrAcumuladoAcrescimo + valorAcrescimo;
                LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, t.getDataCadastro(), t.getDataVencimento(), Short.valueOf(EnumLancamentoCTBGerencial.CREDITO.getValue()), t.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()), t.getObservacao(), pcAcrescimo, t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), null, valorLancGer, null);
                t.getLancCtbGerencial().add(l);
            }
            ++count;
        }
        iterator = titulos.iterator();
        while (iterator.hasNext()) {
            t = ob = iterator.next();
            Set keys = pc.keySet();
            List lanc = t.getLancCtbGerencial();
            count = 1;
            double valorDesconto = this.getValorLancamentoDebitoCredito(lanc, EnumLancamentoCTBGerencial.DEBITO.getValue());
            double valorAcrescimo = this.getValorLancamentoDebitoCredito(lanc, EnumLancamentoCTBGerencial.CREDITO.getValue());
            double valorAcumulado = 0.0;
            for (Object o : keys) {
                if (o == null) continue;
                HashMap h = (HashMap)pc.get(o);
                Double valorTotalBruto = (Double)h.get("valorTotal");
                Double valorLanc = ContatoFormatUtil.arrredondarNumero((Double)(t.getValor() / valorTotalTitulos * valorTotalBruto), (int)2);
                Double valorLancGer = 0.0;
                valorLancGer = count == pc.size() ? Double.valueOf(Math.abs(t.getValor() - valorAcrescimo + valorDesconto - valorAcumulado)) : valorLanc;
                valorAcumulado += valorLanc.doubleValue();
                LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, t.getDataCompetencia(), t.getDataVencimento(), Short.valueOf(EnumLancamentoCTBGerencial.CREDITO.getValue()), t.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()), t.getObservacao(), (PlanoContaGerencial)o, t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), null, valorLancGer, null);
                lanc.add(l);
                ++count;
            }
        }
    }

    public LancamentoCtbGerencial criarLancamentoCteGerencial(AdiantamentoViagem vo, FechamAdiantamentoViagem v, Short debitoCredito) throws ExceptionService {
        LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(v.getLancamentoCtbGerencial(), v.getDataFechamento(), v.getDataFechamento(), Short.valueOf(EnumLancamentoCTBGerencial.DEBITO.getValue()), vo.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Valor de " + v.getVrDespesa().toString() + " de " + v.getDespesaViagem().getDescricao() + " ref. Adiantamento Viagem nr. " + vo.getIdentificador().toString(), v.getDespesaViagem().getPlanoContaGerencial(), Short.valueOf(EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue()), Short.valueOf(EnumTipoLancamentoCTBGerencial.LIQUIDACAO.getValue()), vo.getCentroCusto(), v.getVrDespesa(), null);
        return l;
    }

    public void criarLancamentosCTBGerencialLiquidacao(GrupoDeBaixaFormas vo) {
        new AuxBaixaTitulo().criarLancamentosCTBGerencialLiquidacao(vo);
    }

    public void criarLancamentosCTBGerencialMovFinanceiro(MovimentoBancario vo) {
        new AuxMovimentoFinanceiro().criarLancamentosGerenciasMovFinanceiro(vo);
    }

    public List criarLancamentosCTBGerencial(ApuracaoLocacaoContrato r, Titulo t, Double valor, PlanoContaGerencial planoContaGerencial, CentroCusto centroCusto) {
        LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, t.getDataCadastro(), t.getDataVencimento(), Short.valueOf(EnumLancamentoCTBGerencial.CREDITO.getValue()), t.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()), t.getObservacao(), planoContaGerencial, Short.valueOf(EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue()), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), centroCusto, valor, null);
        ArrayList<LancamentoCtbGerencial> lancs = new ArrayList<LancamentoCtbGerencial>();
        lancs.add(l);
        return lancs;
    }

    private LancamentoCtbGerencial getLancamentoCtbGerencialValoresNaoDestacados(Titulo t, Double valor, String historico, Empresa emp, PlanoContaGerencial planoGerencial, Short debCred, CentroCusto centroCusto) {
        Short debCredGer = null;
        if (t.getPagRec() == 0 && debCred.equals(EnumLancamentoCTBGerencial.DEBITO.getValue())) {
            debCredGer = EnumLancamentoCTBGerencial.CREDITO.getValue();
        } else if (t.getPagRec() == 0 && debCred.equals(EnumLancamentoCTBGerencial.CREDITO.getValue())) {
            debCredGer = EnumLancamentoCTBGerencial.DEBITO.getValue();
        } else if (t.getPagRec() == 1 && debCred.equals(EnumLancamentoCTBGerencial.DEBITO.getValue())) {
            debCredGer = EnumLancamentoCTBGerencial.DEBITO.getValue();
        } else if (t.getPagRec() == 1 && debCred.equals(EnumLancamentoCTBGerencial.CREDITO.getValue())) {
            debCredGer = EnumLancamentoCTBGerencial.CREDITO.getValue();
        }
        LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, t.getDataCompetencia(), t.getDataVencimento(), debCredGer, emp, Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()), historico, planoGerencial, t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), centroCusto, valor, null);
        return l;
    }

    private void setLancamentosValoresNaoDestacadosNotaPropria(List titulos, List itensNotaPropria, Empresa emp, PlanoContaGerencial planoGerencialDescontosNaoDest, PlanoContaGerencial planoGerencialFreteNaoDest, PlanoContaGerencial planoGerencialSeguroNaoDest, PlanoContaGerencial planoGerencialDespAcesNaoDest, CentroCusto centroCusto) {
        Double valorDescontoNaoDest = 0.0;
        Double valorFreteNaoDest = 0.0;
        Double valorSeguroNaoDest = 0.0;
        Double valorDespAcesNaoDest = 0.0;
        for (Object o : itensNotaPropria) {
            if (!(o instanceof ItemNotaFiscalPropria)) continue;
            ItemNotaFiscalPropria itemNotaPropria = (ItemNotaFiscalPropria)o;
            if (itemNotaPropria.getVrFreteNaoDest() != null) {
                valorFreteNaoDest = valorFreteNaoDest + itemNotaPropria.getVrFreteNaoDest();
            }
            if (itemNotaPropria.getVrSeguroNaoDest() != null) {
                valorSeguroNaoDest = valorSeguroNaoDest + itemNotaPropria.getVrSeguroNaoDest();
            }
            if (itemNotaPropria.getVrDespAcessoriaNaoDest() != null) {
                valorDespAcesNaoDest = valorDespAcesNaoDest + itemNotaPropria.getVrDespAcessoriaNaoDest();
            }
            if (itemNotaPropria.getVrDescontoNaoDest() == null) continue;
            valorDescontoNaoDest = valorDescontoNaoDest + itemNotaPropria.getVrDescontoNaoDest();
        }
        int qtdeTitulos = titulos.size();
        Double vrAcumuladoDesconto = 0.0;
        Double vrAcumuladoFrete = 0.0;
        Double vrAcumuladoSeguro = 0.0;
        Double vrAcumuladoDespAces = 0.0;
        int count = 1;
        for (Object o : titulos) {
            String historico;
            Double valorLanc;
            Titulo t = (Titulo)o;
            t.setLancCtbGerencial(new ArrayList());
            if (valorDescontoNaoDest > 0.0 && planoGerencialDescontosNaoDest != null) {
                valorLanc = ContatoFormatUtil.arrredondarNumero((Double)(valorDescontoNaoDest / (double)qtdeTitulos), (int)2);
                if (count == qtdeTitulos) {
                    valorLanc = Math.abs(valorDescontoNaoDest - vrAcumuladoDesconto);
                }
                vrAcumuladoDesconto = vrAcumuladoDesconto + valorLanc;
                historico = "Lancamento referente ao desconto nao destacado do Titulo/Parcela: " + t.getNumParcTituloEstnota() + ". Pessoa: " + t.getPessoa().getNome();
                t.getLancCtbGerencial().add(this.getLancamentoCtbGerencialValoresNaoDestacados(t, valorLanc, historico, emp, planoGerencialDescontosNaoDest, EnumLancamentoCTBGerencial.DEBITO.getValue(), centroCusto));
            }
            if (valorFreteNaoDest > 0.0 && planoGerencialFreteNaoDest != null) {
                valorLanc = ContatoFormatUtil.arrredondarNumero((Double)(valorFreteNaoDest / (double)qtdeTitulos), (int)2);
                if (count == qtdeTitulos) {
                    valorLanc = Math.abs(valorFreteNaoDest - vrAcumuladoFrete);
                }
                vrAcumuladoFrete = vrAcumuladoFrete + valorLanc;
                historico = "Lancamento referente ao frete nao destacado do Titulo/Parcela: " + t.getNumParcTituloEstnota() + ". Pessoa: " + t.getPessoa().getNome();
                t.getLancCtbGerencial().add(this.getLancamentoCtbGerencialValoresNaoDestacados(t, valorLanc, historico, emp, planoGerencialFreteNaoDest, EnumLancamentoCTBGerencial.CREDITO.getValue(), centroCusto));
            }
            if (valorSeguroNaoDest > 0.0 && planoGerencialSeguroNaoDest != null) {
                valorLanc = ContatoFormatUtil.arrredondarNumero((Double)(valorSeguroNaoDest / (double)qtdeTitulos), (int)2);
                if (count == qtdeTitulos) {
                    valorLanc = Math.abs(valorSeguroNaoDest - vrAcumuladoSeguro);
                }
                vrAcumuladoSeguro = vrAcumuladoSeguro + valorLanc;
                historico = "Lancamento referente ao seguro nao destacado do Titulo/Parcela: " + t.getNumParcTituloEstnota() + ". Pessoa: " + t.getPessoa().getNome();
                t.getLancCtbGerencial().add(this.getLancamentoCtbGerencialValoresNaoDestacados(t, valorLanc, historico, emp, planoGerencialSeguroNaoDest, EnumLancamentoCTBGerencial.CREDITO.getValue(), centroCusto));
            }
            if (valorDespAcesNaoDest > 0.0 && planoGerencialDespAcesNaoDest != null) {
                valorLanc = ContatoFormatUtil.arrredondarNumero((Double)(valorDespAcesNaoDest / (double)qtdeTitulos), (int)2);
                if (count == qtdeTitulos) {
                    valorLanc = Math.abs(valorDespAcesNaoDest - vrAcumuladoDespAces);
                }
                vrAcumuladoDespAces = vrAcumuladoDespAces + valorLanc;
                historico = "Lancamento referente a despesa acessoria nao destacada do Titulo/Parcela: " + t.getNumParcTituloEstnota() + ". Pessoa: " + t.getPessoa().getNome();
                t.getLancCtbGerencial().add(this.getLancamentoCtbGerencialValoresNaoDestacados(t, valorLanc, historico, emp, planoGerencialDespAcesNaoDest, EnumLancamentoCTBGerencial.CREDITO.getValue(), centroCusto));
            }
            ++count;
        }
    }

    private HashMap getPlanoContasNotaPropria(List<ItemNotaFiscalPropria> itensNota, PlanoContaGerencial planoGerencialDescontosNaoDest, PlanoContaGerencial planoGerencialFreteNaoDest, PlanoContaGerencial planoGerencialSeguroNaoDest, PlanoContaGerencial planoGerencialDespAcesNaoDest) {
        HashMap<PlanoContaGerencial, HashMap> s = new HashMap<PlanoContaGerencial, HashMap>();
        for (ItemNotaFiscalPropria itemNotaPropria : itensNota) {
            HashMap h;
            Double vrDescontoNaoDest = 0.0;
            Double vrFreteNaoDest = 0.0;
            Double vrSeguroNaoDest = 0.0;
            Double vrDespAcesNaoDest = 0.0;
            Double valor = itemNotaPropria.getItemNotaLivroFiscal().getValorTotal();
            if (itemNotaPropria.getVrFreteNaoDest() != null && planoGerencialFreteNaoDest != null) {
                vrFreteNaoDest = itemNotaPropria.getVrFreteNaoDest();
            }
            if (itemNotaPropria.getVrSeguroNaoDest() != null && planoGerencialSeguroNaoDest != null) {
                vrSeguroNaoDest = itemNotaPropria.getVrSeguroNaoDest();
            }
            if (itemNotaPropria.getVrDespAcessoriaNaoDest() != null && planoGerencialDespAcesNaoDest != null) {
                vrDespAcesNaoDest = itemNotaPropria.getVrDespAcessoriaNaoDest();
            }
            if (itemNotaPropria.getVrDescontoNaoDest() != null && planoGerencialDescontosNaoDest != null) {
                vrDescontoNaoDest = itemNotaPropria.getVrDescontoNaoDest();
            }
            if (s.get(itemNotaPropria.getPlanoContaGerencial()) != null) {
                h = (HashMap)s.get(itemNotaPropria.getPlanoContaGerencial());
                h.put("valorTotal", (Double)h.get("valorTotal") + valor);
                h.put("valorDescontoNaoDest", (Double)h.get("valorDescontoNaoDest") + vrDescontoNaoDest);
                h.put("valorSeguroNaoDest", (Double)h.get("valorSeguroNaoDest") + vrSeguroNaoDest);
                h.put("valorFreteNaoDest", (Double)h.get("valorFreteNaoDest") + vrSeguroNaoDest);
                h.put("valorDespAcesNaoDest", (Double)h.get("valorDespAcesNaoDest") + vrDespAcesNaoDest);
                continue;
            }
            h = new HashMap();
            h.put("valorTotal", valor);
            h.put("valorDescontoNaoDest", vrDescontoNaoDest);
            h.put("valorSeguroNaoDest", vrSeguroNaoDest);
            h.put("valorFreteNaoDest", vrFreteNaoDest);
            h.put("valorDespAcesNaoDest", vrDespAcesNaoDest);
            s.put(itemNotaPropria.getPlanoContaGerencial(), h);
        }
        return s;
    }

    private Double getValoresLancamentosGerenciaisNaoDestacadoDesconto(Titulo t) {
        Double valor = 0.0;
        for (LancamentoCtbGerencial l : t.getLancCtbGerencial()) {
            if (t.getPagRec().equals((short)0) && l.getDebCred().equals(EnumLancamentoCTBGerencial.CREDITO.getValue())) {
                valor = valor + l.getValor();
                continue;
            }
            if (!t.getPagRec().equals((short)1) || !l.getDebCred().equals(EnumLancamentoCTBGerencial.DEBITO.getValue())) continue;
            valor = valor + l.getValor();
        }
        return valor;
    }

    public List<IntegracaoCustoProdVendidoLancCtbGerencial> criaLancamentoCtbGerencialIntegrandoCustoProdVendido(IntegCustoProdVendidoData i, Empresa empresa, Short gerarLancAnaliticos) throws ExceptionService {
        ArrayList<IntegracaoCustoProdVendidoLancCtbGerencial> listReturn = new ArrayList<IntegracaoCustoProdVendidoLancCtbGerencial>();
        for (IntegCustoProdVendidoItem item : i.getIntegCustoProdVendItem()) {
            Double valorCusto = item.getPrecoMedio();
            valorCusto = valorCusto * item.getQuantidade();
            Optional<IntegracaoCustoProdVendidoLancCtbGerencial> aux = listReturn.stream().filter(j -> Objects.equals(j.getLacamentoCtbGerencial().getPlanoContaGerencial(), item.getPlanoContaGerencial())).findFirst();
            if (aux.isPresent() && gerarLancAnaliticos.shortValue() != EnumConstantsMentorSimNao.SIM.getValue()) {
                IntegracaoCustoProdVendidoLancCtbGerencial found = aux.get();
                found.getLacamentoCtbGerencial().setValor(Double.valueOf(found.getLacamentoCtbGerencial().getValor() + valorCusto));
                continue;
            }
            LancamentoCtbGerencial lancCtbGerencial = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, i.getDataIntegracao(), i.getDataIntegracao(), Short.valueOf(EnumLancamentoCTBGerencial.DEBITO.getValue()), empresa, Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()), "Lancamento gerado pelo custo do produto vendido pelo " + item.getProduto().getIdentificador() + " - " + item.getProduto().getNome() + " em " + DateUtil.dateToStr(i.getDataIntegracao()), item.getPlanoContaGerencial(), Short.valueOf(EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue()), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO.getValue()), null, valorCusto, null);
            IntegracaoCustoProdVendidoLancCtbGerencial integracao = new IntegracaoCustoProdVendidoLancCtbGerencial();
            integracao.setIntegCustoProdVendidoData(i);
            integracao.setLacamentoCtbGerencial(lancCtbGerencial);
            listReturn.add(integracao);
        }
        return listReturn;
    }

    public void criaLancamentoCtbGerencialRenegociacaoTitulos(List<Titulo> OldTitulos, Titulo newTitulos, RenegociacaoTitulos vo, PlanoContaGerencial planoContaGerencial) {
        List<HashMap> listPlanos = this.getPlanoContaGerencial(OldTitulos, planoContaGerencial);
        ArrayList<LancamentoCtbGerencial> listLancamentos = new ArrayList<LancamentoCtbGerencial>();
        for (HashMap h : listPlanos) {
            LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, newTitulos.getDataCompetencia(), newTitulos.getDataVencimento(), Short.valueOf(ToolMethods.isEquals((Object)newTitulos.getPagRec(), (Object)0) ? EnumLancamentoCTBGerencial.DEBITO.getValue() : EnumLancamentoCTBGerencial.CREDITO.getValue()), newTitulos.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()), vo.getObservacao(), planoContaGerencial, newTitulos.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), (CentroCusto)h.get("centroCusto"), this.getValorLancamento(newTitulos.getValor(), h), null);
            listLancamentos.add(l);
        }
        newTitulos.setLancCtbGerencial(listLancamentos);
    }

    public void criaLancamentoCtbGerencialRenegociacaoTitulos(List<Titulo> OldTitulos, List<Titulo> newTitulos, RenegociacaoTitulos vo, PlanoContaGerencial planoContaGerencial) {
        List<HashMap> listPlanos = this.getPlanoContaGerencial(OldTitulos, planoContaGerencial);
        for (Titulo t : newTitulos) {
            ArrayList<LancamentoCtbGerencial> listLancamentos = new ArrayList<LancamentoCtbGerencial>();
            for (HashMap h : listPlanos) {
                LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, t.getDataCompetencia(), t.getDataVencimento(), Short.valueOf(ToolMethods.isEquals((Object)t.getPagRec(), (Object)0) ? EnumLancamentoCTBGerencial.DEBITO.getValue() : EnumLancamentoCTBGerencial.CREDITO.getValue()), t.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()), vo.getObservacao(), planoContaGerencial, t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), (CentroCusto)h.get("centroCusto"), this.getValorLancamento(t.getValor(), h), null);
                listLancamentos.add(l);
            }
            t.setLancCtbGerencial(listLancamentos);
        }
    }

    private List<HashMap> getPlanoContaGerencial(List<Titulo> titulos, PlanoContaGerencial planoContaGerencial) {
        ArrayList<HashMap> aux = new ArrayList<HashMap>();
        for (Titulo t : titulos) {
            for (LancamentoCtbGerencial lan : t.getLancCtbGerencial()) {
                HashMap<String, CentroCusto> hashPlanoConta = new HashMap<String, CentroCusto>();
                hashPlanoConta.put("centroCusto", lan.getCentroCusto());
                if (aux.contains(hashPlanoConta)) continue;
                aux.add(hashPlanoConta);
            }
        }
        ArrayList<LancamentoCtbGerencial> utilizados = new ArrayList<LancamentoCtbGerencial>();
        for (HashMap h : aux) {
            CentroCusto c = (CentroCusto)h.get("centroCusto");
            Double valorUnificado = 0.0;
            for (Titulo t : titulos) {
                for (LancamentoCtbGerencial lan : t.getLancCtbGerencial()) {
                    if (lan.getCentroCusto() != null && c != null && lan.getCentroCusto().equals((Object)c)) {
                        valorUnificado = valorUnificado + lan.getValor();
                        continue;
                    }
                    if (lan.getCentroCusto() != null || utilizados.contains(lan)) continue;
                    valorUnificado = valorUnificado + lan.getValor();
                    utilizados.add(lan);
                }
            }
            h.put("percentual", this.calculaPercentualPlanoContaGerencial(titulos, valorUnificado));
        }
        return aux;
    }

    private Double calculaPercentualPlanoContaGerencial(List<Titulo> titulos, Double valorUnificado) {
        Double valorTotalTitulo = 0.0;
        for (Titulo t : titulos) {
            valorTotalTitulo = valorTotalTitulo + t.getValor();
        }
        return ContatoFormatUtil.arrredondarNumero((Double)(valorUnificado * 100.0 / valorTotalTitulo), (int)2);
    }

    private Double getValorLancamento(Double valor, HashMap h) {
        Double percentual = (Double)h.get("percentual");
        return ContatoFormatUtil.arrredondarNumero((Double)(valor * percentual / 100.0), (int)2);
    }

    public LancamentoCtbGerencial criarLancamentoGerencialBaixaBens(Double valor, PlanoContaGerencial planoGerencial, CentroCusto centroCusto, Bem bem, Empresa empresa, Date dataBaixa) {
        LancamentoCtbGerencial lancamento = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, dataBaixa, dataBaixa, Short.valueOf(EnumLancamentoCTBGerencial.DEBITO.getValue()), empresa, Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Lan\u00e7amento referente a baixa do bem " + bem.getCodigo() + " - " + bem.getDescricao(), planoGerencial, Short.valueOf(EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue()), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO.getValue()), centroCusto, valor, null);
        return lancamento;
    }

    public LancamentoCtbGerencial criarLancamentoGerencialDepreciacaoBens(Bem bem, DepreciacaoBem c, Date periodo, Empresa empresa) throws ExceptionService {
        PlanoContaBemDepreciacao pl = this.getPlanoContaBemDepr(c.getBemTipoDepreciacao().getTipoDepreciacao(), bem.getTipoBem());
        if (pl == null) {
            throw new ExceptionService("Informe no cadastro do Tipo Deprecia\u00e7\u00e3o: " + c.getBemTipoDepreciacao().getTipoDepreciacao().getDescricao() + ", as contas cont\u00e1beis/gerenciais referente ao Tipo Bem: " + bem.getTipoBem().getDescricao());
        }
        LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, periodo, periodo, Short.valueOf(EnumLancamentoCTBGerencial.DEBITO.getValue()), empresa, Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()), "Vr. Deprecia\u00e7\u00e3o neste m\u00eas ref. Bem nr. " + bem.getIdentificador(), pl.getPlanoContaGerencial(), Short.valueOf(EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue()), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO.getValue()), bem.getCentroCusto(), Double.valueOf(c.getValorDeprecAcelerada() + c.getValorDepreciacao()), null);
        return l;
    }

    private PlanoContaBemDepreciacao getPlanoContaBemDepr(TipoDepreciacao tipoDepreciacao, TipoBem tipoBem) {
        for (Object o : tipoDepreciacao.getPlanoContaBemDepr()) {
            PlanoContaBemDepreciacao pc = (PlanoContaBemDepreciacao)o;
            if (!pc.getTipoBem().equals((Object)tipoBem)) continue;
            return pc;
        }
        return null;
    }

    public LancamentoCtbGerencial criarLancamentoGerencialMovimentoBancario(MovimentoBancario vo, Short debCred, PlanoContaGerencial planoGerencial, Double valor) {
        LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, vo.getDataLancamento(), vo.getDataLancamento(), debCred, vo.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()), vo.getHistorico(), planoGerencial, Short.valueOf(EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue()), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO.getValue()), null, valor, null);
        return l;
    }

    public LancamentoCtbGerencial criarLancamentoGerencialDevolucaoVendas(Double valor, PlanoContaGerencial planoGerencial, CentroCusto centroCusto, Empresa empresa, Date dataVenc, Pessoa pessoa) {
        LancamentoCtbGerencial lancamento = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, new Date(), dataVenc, Short.valueOf(EnumLancamentoCTBGerencial.DEBITO.getValue()), empresa, Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Lan\u00e7amento referente ao titulo a ser devolvido para pessoa:  " + pessoa.getNome() + " no valor de: " + ContatoFormatUtil.formataNumero((Number)valor, (int)2), planoGerencial, Short.valueOf(EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue()), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO.getValue()), centroCusto, valor, null);
        return lancamento;
    }

    public LancamentoCtbGerencial criarLancamentoGerencialDevolucaoPedComercio(Double valor, PlanoContaGerencial planoGerencial, CentroCusto centroCusto, DevolucaoPedComercio vo, Empresa empresa, Date dataVenc, Pessoa pessoa) {
        LancamentoCtbGerencial lancamento = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, new Date(), dataVenc, Short.valueOf(EnumLancamentoCTBGerencial.DEBITO.getValue()), empresa, Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Lan\u00e7amento referente ao titulo a ser devolvido (Devolucao Ped. Comercio) para pessoa:  " + pessoa.getNome() + " no valor de: " + ContatoFormatUtil.formataNumero((Number)valor, (int)2), planoGerencial, Short.valueOf(EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue()), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO.getValue()), centroCusto, valor, null);
        return lancamento;
    }

    public void criarLancamentosCTBGerencial(CancAntecTitulos vo, List<Titulo> titulos, Empresa empresa) {
        for (Titulo t : titulos) {
            LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, t.getDataEmissao(), t.getDataVencimento(), Short.valueOf(ToolMethods.isEquals((Object)t.getPagRec(), (Object)0) ? EnumLancamentoCTBGerencial.DEBITO.getValue() : EnumLancamentoCTBGerencial.CREDITO.getValue()), vo.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()), t.getObservacao(), vo.getPlanoContaGer(), Short.valueOf(EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue()), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO.getValue()), null, t.getValor(), null);
            t.getLancCtbGerencial().add(l);
        }
    }

    public void criarLancamentosCTBGerencial(LancamentoEventoCooperado vo, List<Titulo> titulos, Boolean repasse) {
        for (Titulo t : titulos) {
            LancamentoCtbGerencial lancGerencial = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, t.getDataCompetencia(), t.getDataVencimento(), this.getDebCredito(t.getPagRec()), t.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Titulo referente : " + t.getObservacao(), repasse != false ? vo.getEventoCooperado().getPlanoContaGerencialRepasse() : vo.getEventoCooperado().getPlanoContaGerencial(), t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), null, t.getValor(), null);
            ArrayList<LancamentoCtbGerencial> lanc = new ArrayList<LancamentoCtbGerencial>();
            lanc.add(lancGerencial);
            t.setLancCtbGerencial(lanc);
        }
    }

    private Short getDebCredito(Short tipoTitulo) {
        if (tipoTitulo == 0) {
            return EnumLancamentoCTBGerencial.DEBITO.getValue();
        }
        return EnumLancamentoCTBGerencial.CREDITO.getValue();
    }

    private HashMap getPlanoContasPedidoComercio(List<ItemPedidoComercio> itens) {
        HashMap<PlanoContaGerencial, HashMap> s = new HashMap<PlanoContaGerencial, HashMap>();
        for (ItemPedidoComercio i : itens) {
            HashMap h;
            Double valor = i.getValorTotalBruto();
            Double valorDesconto = i.getValorDesconto();
            Double valorAcrescimo = i.getValorAcrescimo();
            if (s.get(i.getProduto().getPlanoContaGerencial()) != null) {
                h = (HashMap)s.get(i.getProduto().getPlanoContaGerencial());
                h.put("valorTotal", (Double)h.get("valorTotal") + valor);
                h.put("valorAcrescimo", (Double)h.get("valorAcrescimo") + valorAcrescimo);
                h.put("valorDesconto", (Double)h.get("valorDesconto") + valorDesconto);
                continue;
            }
            h = new HashMap();
            h.put("valorTotal", valor);
            h.put("valorAcrescimo", valorAcrescimo);
            h.put("valorDesconto", valorDesconto);
            s.put(i.getProduto().getPlanoContaGerencial(), h);
        }
        return s;
    }

    private double getValorLancamentoDebitoCredito(List<LancamentoCtbGerencial> lanc, short debCred) {
        Double valor = 0.0;
        for (LancamentoCtbGerencial l : lanc) {
            if (!l.getDebCred().equals(debCred)) continue;
            valor = valor + l.getValor();
        }
        return valor;
    }

    public LancamentoCtbGerencial criarLancamentoCtbGerencial(Executante e, PlanoContaGerencial planoContaGerencial) {
        String historico = e.getFechamentoOrdemServico().getOrdemServico().getCentroCusto() != null ? "Lanc. por Fechamento Ordem Servi\u00e7o " + e.getFechamentoOrdemServico().getIdentificador().toString() + " e Ordem de Servico " + e.getFechamentoOrdemServico().getOrdemServico().getIdentificador().toString() + ", para o Executante " + e.getPessoa().getNome() + ", no Centro Custo: " + e.getFechamentoOrdemServico().getOrdemServico().getCentroCusto().getCodigo() + "." : "Lanc. por Fechamento Ordem Servi\u00e7o " + e.getFechamentoOrdemServico().getIdentificador().toString() + " e Ordem de Servico " + e.getFechamentoOrdemServico().getOrdemServico().getIdentificador().toString() + ", para o Executante " + e.getPessoa().getNome() + ".";
        LancamentoCtbGerencial lanc = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(e.getLancamentoCtbGerencial(), e.getFechamentoOrdemServico().getDataFechamento(), e.getFechamentoOrdemServico().getDataFechamento(), Short.valueOf(EnumLancamentoCTBGerencial.DEBITO.getValue()), e.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()), historico, planoContaGerencial, Short.valueOf(EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue()), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO.getValue()), e.getFechamentoOrdemServico().getOrdemServico().getCentroCusto(), e.getValorTotal(), null);
        return lanc;
    }

    public void criarLancamentosCTBGerencial(LoteLancamentoEventoCooperado vo, List<Titulo> titulos, Boolean repasse) {
        for (Titulo t : titulos) {
            LancamentoCtbGerencial lancGerencial = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, t.getDataCompetencia(), t.getDataVencimento(), this.getDebCredito(t.getPagRec()), t.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Titulo referente : " + t.getObservacao(), repasse != false ? vo.getEventoCooperado().getPlanoContaGerencialRepasse() : vo.getEventoCooperado().getPlanoContaGerencial(), t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), null, t.getValor(), null);
            ArrayList<LancamentoCtbGerencial> lanc = new ArrayList<LancamentoCtbGerencial>();
            lanc.add(lancGerencial);
            t.setLancCtbGerencial(lanc);
        }
    }
}

