/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.locacao;

import com.touchcomp.basementor.model.vo.ApuracaoLocacaoContrato;
import com.touchcomp.basementor.model.vo.ApuracaoLocacaoContratoBem;
import com.touchcomp.basementor.model.vo.ContratoLocacao;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.ServicoRPS;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.CoreUtilityFactory;

public class ApuracaoBuildText {
    public static String getDiscriminacaoRPS(List<HistoricoPadrao> historicos, List<ApuracaoLocacaoContrato> apuracoesCotrato, ServicoRPS servico) {
        Object msgRps = "";
        for (HistoricoPadrao historico : historicos) {
            HashMap<String, String> h = new HashMap<String, String>();
            List tokensList = ToolString.getReplaceTokens((String)historico.getDescricao());
            for (Object obj : tokensList) {
                StringToken token = (StringToken)obj;
                h.put(token.getChave(), ApuracaoBuildText.getValues(token.getChave(), apuracoesCotrato));
            }
            msgRps = (String)msgRps + ToolString.build((String)historico.getDescricao(), h);
        }
        if (((String)msgRps).isEmpty()) {
            return servico.getDiscriminacao();
        }
        return msgRps;
    }

    private static String getValues(String token, List<ApuracaoLocacaoContrato> apuracoes) {
        List<ApuracaoLocacaoContratoBem> apuracoesContratoBem = ApuracaoBuildText.getApuracaoContratoBem(apuracoes);
        Date periodo = apuracoes.get(0).getApuracaoLocacao().getPeriodo();
        Object toSet = "";
        switch (token) {
            case "codigo": {
                for (ApuracaoLocacaoContratoBem apuracaoBem : apuracoesContratoBem) {
                    toSet = (String)toSet + " " + apuracaoBem.getContratoLocacaoBem().getAtivo().getCodigo();
                }
                return toSet;
            }
            case "placa": {
                for (ApuracaoLocacaoContratoBem apuracaoBem : apuracoesContratoBem) {
                    if (apuracaoBem.getContratoLocacaoBem().getAtivo().getVeiculo() == null) continue;
                    toSet = (String)toSet + " " + apuracaoBem.getContratoLocacaoBem().getAtivo().getVeiculo().getPlaca();
                }
                return toSet;
            }
            case "dataInicial": {
                if (apuracoes.size() == 1) {
                    String dataInicial = DateUtil.dateToStr(DateUtil.getDateFirstMonthDay(periodo), "dd-MM-yyyy");
                    return dataInicial;
                }
                return "";
            }
            case "dataFinal": {
                if (apuracoes.size() == 1) {
                    String dataFinal = DateUtil.dateToStr(DateUtil.getDateLastMonthDay(periodo), "dd-MM-yyyy");
                    return dataFinal;
                }
                return "";
            }
        }
        if (apuracoes.size() == 1) {
            toSet = (String)toSet + apuracoes.get(0).getContratoLocacao().getIdentificador();
        }
        for (ContratoLocacao contrato : CoreUtilityFactory.getUtilityLocacao().mergeContratos(apuracoes)) {
            toSet = (String)toSet + " " + contrato.getIdentificador();
        }
        return toSet;
    }

    private static List<ApuracaoLocacaoContratoBem> getApuracaoContratoBem(List<ApuracaoLocacaoContrato> apuracoes) {
        ArrayList<ApuracaoLocacaoContratoBem> toReturn = new ArrayList<ApuracaoLocacaoContratoBem>();
        for (ApuracaoLocacaoContrato apuracao : apuracoes) {
            for (ApuracaoLocacaoContratoBem apuracaoBem : apuracao.getApuracaoLocacaoContratoBem()) {
                toReturn.add(apuracaoBem);
            }
        }
        return toReturn;
    }
}

