/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.locacao;

import com.touchcomp.basementor.model.vo.ApuracaoLocacao;
import com.touchcomp.basementor.model.vo.ApuracaoLocacaoContrato;
import com.touchcomp.basementor.model.vo.ApuracaoLocacaoContratoBem;
import com.touchcomp.basementor.model.vo.ApuracaoLocacaoContratoBemEvento;
import com.touchcomp.basementor.model.vo.ApuracaoLocacaoContratoFuncao;
import com.touchcomp.basementor.model.vo.ContratoLocacao;
import com.touchcomp.basementor.model.vo.ContratoLocacaoBem;
import com.touchcomp.basementor.model.vo.ItemContratoLocacao;
import com.touchcomp.basementor.model.vo.NotaContratoLocacao;
import com.touchcomp.basementor.model.vo.RepresentanteContratoComissao;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.CoreServiceFactory;

public class UtilityLocacao {
    public List<HashMap> getBemEmContratoAberto(ContratoLocacao vo) throws ExceptionService {
        ArrayList<HashMap> toReturn = new ArrayList<HashMap>();
        for (ItemContratoLocacao i : vo.getItensContratoLocacao()) {
            for (ContratoLocacaoBem contratoBem : i.getContratoLocacaoBem()) {
                try {
                    CoreRequestContext context = new CoreRequestContext();
                    context.setAttribute("ativo", contratoBem.getAtivo());
                    context.setAttribute("contrato", vo.getIdentificador());
                    ContratoLocacao contratoLocacao = (ContratoLocacao)CoreServiceFactory.getServiceContratoLocacao().execute(context, "getContratoAbertoAtivo");
                    if (contratoLocacao == null) continue;
                    HashMap<String, Long> h = new HashMap<String, Long>();
                    h.put("ativo", contratoBem.getAtivo().getIdentificador());
                    h.put("contrato", contratoLocacao.getNumeroContrato());
                    toReturn.add(h);
                }
                catch (ExceptionService ex) {
                    throw new ExceptionService("Erro ao validar ativos!");
                }
            }
        }
        return toReturn;
    }

    public void totalizarValoresApuracao(ApuracaoLocacao vo) {
        Double valorTotal = 0.0;
        Double valorTotalEventos = 0.0;
        Double valorTotalDesconto = 0.0;
        Double valorDesconto = 0.0;
        Double valorManual = 0.0;
        Double valorTotalManual = 0.0;
        for (ApuracaoLocacaoContrato apuracaoLocacaoContrato : vo.getApuracaoLocacaoContrato()) {
            for (ApuracaoLocacaoContratoBem apuracaoLocacaoContratoBem : apuracaoLocacaoContrato.getApuracaoLocacaoContratoBem()) {
                for (ApuracaoLocacaoContratoBemEvento apuracaoLocacaoContratoBemEvento : apuracaoLocacaoContratoBem.getApuracaoLocacaoContratoBemEvento()) {
                    if (apuracaoLocacaoContratoBemEvento.getValorTotal() == null) continue;
                    valorTotalEventos = valorTotalEventos + apuracaoLocacaoContratoBemEvento.getValorTotal();
                    valorDesconto = valorDesconto + apuracaoLocacaoContratoBemEvento.getValorDesconto();
                    if (apuracaoLocacaoContratoBemEvento.getEventoCobrancaLocacao() != null) continue;
                    valorManual = valorManual + apuracaoLocacaoContratoBemEvento.getValorTotalLiquido();
                }
                apuracaoLocacaoContratoBem.setValorTotal(Double.valueOf(valorTotalEventos - valorDesconto));
                valorTotal = valorTotal + valorTotalEventos;
                valorTotalDesconto = valorTotalDesconto + valorDesconto;
                valorTotalManual = valorTotalManual + valorManual;
                valorManual = 0.0;
                valorDesconto = 0.0;
                valorTotalEventos = 0.0;
            }
            for (ApuracaoLocacaoContratoFuncao a : apuracaoLocacaoContrato.getApuracaoLocacaoContratoFuncao()) {
                valorTotal = valorTotal + a.getValorTotal();
            }
            for (ApuracaoLocacaoContratoFuncao a : apuracaoLocacaoContrato.getApuracaoLocacaoControleArmazem()) {
                valorTotal = valorTotal + a.getValorTotal();
            }
            apuracaoLocacaoContrato.setValorTotal(valorTotal);
            apuracaoLocacaoContrato.setValorDesconto(valorTotalDesconto);
            apuracaoLocacaoContrato.setValorTotalLiquido(Double.valueOf(valorTotal - valorTotalDesconto));
            apuracaoLocacaoContrato.setValorTotalEventosManuais(valorTotalManual);
            valorTotal = 0.0;
            valorTotalEventos = 0.0;
            valorTotalManual = 0.0;
        }
    }

    public void cancelarNota(NotaContratoLocacao notaContrato) throws ExceptionService {
        notaContrato.setApuracaoLocacaoContrato(null);
        this.desvincularRepresentante(notaContrato);
        notaContrato.setGrupoApuracaoLocacao(null);
        notaContrato.setLoteContabil(null);
    }

    public List<ContratoLocacao> mergeContratos(List<ApuracaoLocacaoContrato> apuracoesContrato) {
        HashMap<String, ContratoLocacao> contratos = new HashMap<String, ContratoLocacao>();
        ArrayList<ContratoLocacao> toReturn = new ArrayList<ContratoLocacao>();
        for (ApuracaoLocacaoContrato apuracaoContrato : apuracoesContrato) {
            String idContrato = apuracaoContrato.getContratoLocacao().getIdentificador().toString();
            contratos.put(idContrato, apuracaoContrato.getContratoLocacao());
        }
        toReturn.addAll(contratos.values());
        return toReturn;
    }

    public List<RepresentanteContratoComissao> mergeRepresentantesContratos(List<ContratoLocacao> contratos) {
        ArrayList<RepresentanteContratoComissao> representantes = new ArrayList<RepresentanteContratoComissao>();
        for (ContratoLocacao contrato : contratos) {
            representantes.addAll(contrato.getRepresentantesContrato());
        }
        return representantes;
    }

    private void desvincularRepresentante(NotaContratoLocacao nota) throws ExceptionService {
        ArrayList<RepresentanteContratoComissao> toDelete = new ArrayList<RepresentanteContratoComissao>();
        ArrayList<RepresentanteContratoComissao> toUpdate = new ArrayList<RepresentanteContratoComissao>();
        for (RepresentanteContratoComissao representante : nota.getRepresentantesComissao()) {
            representante.setNotaContratoLocacao(null);
            if (representante.getContratoLocacao() == null) {
                toDelete.add(representante);
                continue;
            }
            toUpdate.add(representante);
        }
        nota.setRepresentantesComissao(new ArrayList());
        CoreService.simpleSaveCollection(CoreDAOFactory.getInstance().getDAORepresentanteComissaoContrato(), toUpdate);
        CoreService.simpleDeleteCollection(CoreDAOFactory.getInstance().getDAORepresentanteComissaoContrato(), toDelete);
    }
}

