/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.lotefabricacao;

import com.touchcomp.basementor.model.vo.FichaTecnicaLoteFabricacao;
import com.touchcomp.basementor.model.vo.GradeFormProdModFichaTec;
import com.touchcomp.basementor.model.vo.GradeFormulaProduto;
import com.touchcomp.basementor.model.vo.ItemModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.ValoresFichaLoteFab;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorspringcontext.Context;
import java.util.LinkedList;
import java.util.Optional;
import mentorcore.exceptions.ExceptionService;
import mentorcore.utilities.CoreUtility;

public class UtilityLoteFabricacao
extends CoreUtility {
    public LoteFabricacao verificaCriaLoteAutoProduto(Produto p, LoteFabricacao lote) throws ExceptionService {
        if (lote != null) {
            return lote;
        }
        if (p.getLoteUnico() == 1) {
            return ((ServiceLoteFabricacaoImpl)Context.get(ServiceLoteFabricacaoImpl.class)).findOrCreateLoteUnico(p);
        }
        LoteFabricacao l = new LoteFabricacao();
        l.setProduto(p);
        l.setStatusLoteFabricacao(p.getStatusLoteFabricacao());
        l.setLoteBloqueado(p.getStatusLoteFabricacao().getLoteBloqueado());
        l.setConfiGerarLoteAuto(p.getConfigGerarLoteAuto());
        l.setUnico(p.getLoteUnico());
        l.setNaoGerarLoteAutomatico(Short.valueOf((short)0));
        if (l.getConfiGerarLoteAuto() != null) {
            l.setLoteFabricacao("Lote sera gerado automaticamente ao salvar");
        }
        return l;
    }

    public void setModelosFichaTecnica(GradeFormulaProduto gradeFormula, LoteFabricacao lote) {
        if (gradeFormula == null) {
            return;
        }
        if (lote == null) {
            return;
        }
        for (GradeFormProdModFichaTec ficha : gradeFormula.getFichasTecnicas()) {
            Optional<FichaTecnicaLoteFabricacao> aux;
            if (ficha.getTipoFichaTec() != 1 || (aux = lote.getFichaTecnica().stream().filter(i -> i.getModeloFichaTecnica().equals((Object)ficha.getModeloFichaTecnica())).findFirst()).isPresent()) continue;
            FichaTecnicaLoteFabricacao f = new FichaTecnicaLoteFabricacao();
            f.setLoteFabricacao(lote);
            f.setModeloFichaTecnica(ficha.getModeloFichaTecnica());
            lote.getFichaTecnica().add(f);
            LinkedList<ValoresFichaLoteFab> temp = new LinkedList<ValoresFichaLoteFab>();
            for (ItemModeloFichaTecnica item : ficha.getModeloFichaTecnica().getItensModeloFichaTecnica()) {
                ValoresFichaLoteFab v = new ValoresFichaLoteFab();
                v.setChave(item.getDescricao());
                v.setFichaTecnica(f);
                v.setValor(item.getValorSugerido());
                v.setValorObrigatorio(item.getCampoObrigatorio());
                v.setItemModeloFichaTecnica(item);
                temp.add(v);
            }
            f.setValoresFicha(temp);
        }
    }
}

