/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.manifestocte;

import com.touchcomp.basementor.model.vo.ManifestoCteEletronico;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorxml.model.XMLManifestoCte;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLManifestoCTe;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import mentorcore.exceptions.ExceptionFileManipulation;
import mentorcore.utilities.CoreUtilityFactory;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public class UtilityManifestoCte {
    private final TLogger logger = TLogger.get(UtilityManifestoCte.class);

    public File recordToFile(ManifestoCteEletronico manifesto, String diretorio) throws ExceptionFileManipulation {
        String xml = this.toXMLString(manifesto);
        String aux = diretorio + File.separator + manifesto.getChaveManifestoCte() + "-procMDFe.xml";
        return CoreUtilityFactory.getUtilityFile().writeStringInFile(aux, xml);
    }

    public File recordToFileEvento(ManifestoCteEletronico manifesto, String diretorio) throws ExceptionFileManipulation {
        String xml = this.toXMLStringEvento(manifesto);
        String aux = diretorio + File.separator + manifesto.getChaveManifestoCte() + "-cancMDFe.xml";
        return CoreUtilityFactory.getUtilityFile().writeStringInFile(aux, xml);
    }

    public String toXMLString(ManifestoCteEletronico manifesto) throws ExceptionFileManipulation {
        try {
            ServiceXMLManifestoCTe service = (ServiceXMLManifestoCTe)ConfApplicationContext.getBean(ServiceXMLManifestoCTe.class);
            System.out.println("\n\n Nr. Manifesto: " + manifesto.getNumero() + " ID:" + manifesto.getIdentificador() + "\n\n");
            SAXBuilder sb = new SAXBuilder();
            SAXBuilder sb1 = new SAXBuilder();
            XMLManifestoCte xml = service.getXMLManifestoCte(manifesto.getIdentificador());
            if (xml == null || xml.getConteudoXML() == null) {
                throw new ExceptionFileManipulation("Nota sem arquivo xml.");
            }
            Document d = sb.build((InputStream)new ByteArrayInputStream(xml.getConteudoXML().getBytes()));
            Element e = null;
            if (xml.getConteudoAprovacao() != null) {
                Document a = sb1.build((InputStream)new ByteArrayInputStream(xml.getConteudoAprovacao().getBytes()));
                e = a.detachRootElement();
            }
            Element mdfeProc = new Element("mdfeProc");
            Attribute at = new Attribute("versao", manifesto.getVersaoManifestoCte().getCodigo());
            mdfeProc.setAttribute(at);
            mdfeProc.setNamespace(Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/mdfe"));
            Element root = d.detachRootElement();
            mdfeProc.addContent((Content)root);
            if (e != null) {
                mdfeProc.addContent((Content)e);
            }
            return new XMLOutputter().outputString(mdfeProc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionFileManipulation("Erro ao exportar o arquivo." + ex.getMessage());
        }
    }

    public String toXMLStringEvento(ManifestoCteEletronico manifesto) throws ExceptionFileManipulation {
        try {
            Document a;
            Document d;
            ServiceXMLManifestoCTe service = (ServiceXMLManifestoCTe)ConfApplicationContext.getBean(ServiceXMLManifestoCTe.class);
            SAXBuilder sb = new SAXBuilder();
            SAXBuilder sb1 = new SAXBuilder();
            XMLManifestoCte xml = service.getXMLManifestoCte(manifesto.getIdentificador());
            if (xml == null) {
                throw new ExceptionFileManipulation("Nota sem arquivo xml.");
            }
            if (xml.getConteudoCancelamento() != null) {
                d = sb.build((InputStream)new ByteArrayInputStream(xml.getConteudoPedCancelamento().getBytes()));
                a = sb1.build((InputStream)new ByteArrayInputStream(xml.getConteudoCancelamento().getBytes()));
            } else {
                d = sb.build((InputStream)new ByteArrayInputStream(xml.getConteudoPedEncerramento().getBytes()));
                a = sb1.build((InputStream)new ByteArrayInputStream(xml.getConteudoEncerramento().getBytes()));
            }
            Element e = d.detachRootElement();
            Element e2 = a.detachRootElement();
            Element mdfeProc = new Element("procEventoMDFe");
            Attribute at = new Attribute("versao", manifesto.getVersaoManifestoCte().getCodigo());
            mdfeProc.setAttribute(at);
            mdfeProc.setNamespace(Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/mdfe"));
            mdfeProc.addContent((Content)e);
            mdfeProc.addContent((Content)e2);
            return new XMLOutputter().outputString(mdfeProc);
        }
        catch (Exception ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionFileManipulation("Erro ao exportar o arquivo.");
        }
    }
}

