/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.movimentofinanceiro;

import com.touchcomp.basementor.model.vo.BaixaChequeTerceiros;
import com.touchcomp.basementor.model.vo.ContraPartMovimentoBancario;
import com.touchcomp.basementor.model.vo.ItemModeloLancBancario;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import java.util.ArrayList;
import mentorcore.utilities.CoreUtilityFactory;

class AuxMovimentoFinanceiro {
    AuxMovimentoFinanceiro() {
    }

    public void gerarMovBancarioBaixaCheque(BaixaChequeTerceiros baixa, Double valorTolerancia) throws Exception {
        if (baixa.getGerarMovFinanceiro() == null || baixa.getGerarMovFinanceiro() == 0) {
            return;
        }
        MovimentoBancario mov = baixa.getMovimentoFinanceiro();
        if (mov == null) {
            mov = new MovimentoBancario();
        }
        mov.setModeloLancamentoBancario(baixa.getModeloLancBancario());
        mov.setBaixaChequeTerceiros(baixa);
        mov.setContaValor(baixa.getContaValor());
        mov.setDataCadastro(baixa.getDataCadastro());
        mov.setDataCompensacao(baixa.getDataBaixa());
        mov.setDataLancamento(baixa.getDataBaixa());
        mov.setDebCred(Short.valueOf((short)0));
        mov.setEmpresa(baixa.getEmpresa());
        mov.setHistorico("Baixa/Devolucao de cheque de terceiros: nr: " + baixa.getChequeTerceiros().getNumero() + " Titular: " + baixa.getChequeTerceiros().getTitular());
        mov.setValor(baixa.getValorBaixa());
        mov.setNaoContabilizarMov(baixa.getModeloLancBancario().getNaoContabilizarMov());
        this.gerarContraPartidasMovimentoFinanceiro(mov, valorTolerancia);
        baixa.setMovimentoFinanceiro(mov);
        mov.setBaixaChequeTerceiros(baixa);
    }

    public void gerarContraPartidasMovimentoFinanceiro(MovimentoBancario mov, Double valorTolerancia) throws Exception {
        ArrayList<ContraPartMovimentoBancario> aux = new ArrayList<ContraPartMovimentoBancario>();
        for (Object o : mov.getModeloLancamentoBancario().getItemModeloLancBancario()) {
            ItemModeloLancBancario item = (ItemModeloLancBancario)o;
            ContraPartMovimentoBancario contraPartida = new ContraPartMovimentoBancario();
            contraPartida.setDebCred(item.getDebCred());
            contraPartida.setBuscaTitulos(item.getBuscarTitulo());
            contraPartida.setHistorico(item.getHistoricoPadrao().getDescricao());
            contraPartida.setHistoricoPadrao(item.getHistoricoPadrao());
            contraPartida.setPlanoConta(item.getPlanoConta());
            contraPartida.setPlanoContaGerencial(item.getPlanoContaGerencial());
            contraPartida.setContraPartidaGeradaModeloLancamentoBancario(item.getContraPartida());
            contraPartida.setValor(mov.getValor());
            aux.add(contraPartida);
        }
        mov.setContraPartMovimentoBancario(aux);
        mov.getContraPartMovimentoBancario().forEach(i -> i.setMovimentoBancario(mov));
        CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentosCTBGerencialMovFinanceiro(mov);
    }
}

