/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.nfe;

import com.touchcomp.basementor.model.vo.EventoNFe;
import com.touchcomp.basementor.model.vo.EvtNFeCancelamento;
import com.touchcomp.basementor.model.vo.EvtNFeCartaCorrecao;
import com.touchcomp.basementor.model.vo.EvtNFeManifestoDest;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorlogger.TLogger;
import java.util.Date;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.CoreUtilityFactory;

public class NFeBuildText {
    private final TLogger logger = TLogger.get(this.getClass());

    private NFeBuildText() {
    }

    public String getValue(String token, NotaFiscalPropria vo) {
        if (token == null || vo == null) {
            return "";
        }
        if ((token = token.replaceAll("\n", "")).equalsIgnoreCase("data emissao np")) {
            return DateUtil.dateToStr(vo.getDataEmissaoNota());
        }
        if (token.equalsIgnoreCase("serie np")) {
            return vo.getSerie();
        }
        if (token.equalsIgnoreCase("numero np")) {
            if (vo.getNumeroNota() != null) {
                return vo.getNumeroNota().toString();
            }
            return "";
        }
        return "";
    }

    public String getValueEmail(String token, NotaFiscalPropria vo, Usuario usuario) {
        if (token == null || vo == null) {
            return "";
        }
        if (token.equalsIgnoreCase("data emissao np")) {
            return DateUtil.dateToStr(vo.getDataEmissaoNota());
        }
        if (token.equalsIgnoreCase("serie np")) {
            return vo.getSerie();
        }
        if (token.equalsIgnoreCase("numero np")) {
            if (vo.getNumeroNota() != null) {
                return vo.getNumeroNota().toString();
            }
            return "";
        }
        if (token.equalsIgnoreCase("chave nfe")) {
            if (vo.getChaveNFE() != null) {
                return vo.getChaveNFE();
            }
            return "";
        }
        if (token.equalsIgnoreCase("nome emissor")) {
            if (vo.getEmpresa().getPessoa().getNome() != null) {
                return vo.getEmpresa().getPessoa().getNome();
            }
            return "";
        }
        if (token.equalsIgnoreCase("cnpj emissor")) {
            if (vo.getEmpresa().getPessoa().getComplemento().getCnpj() != null) {
                return vo.getEmpresa().getPessoa().getComplemento().getCnpj();
            }
            return "";
        }
        if (token.equalsIgnoreCase("numero pedido") && vo.getExpedicao() != null && vo.getExpedicao().getPedido() != null) {
            if (vo.getExpedicao().getPedido().getNrPedidoCliente() != null) {
                return vo.getExpedicao().getPedido().getNrPedidoCliente();
            }
            return "";
        }
        if (token.equalsIgnoreCase("nome cliente")) {
            return vo.getUnidadeFatCliente().getCliente().getPessoa().getNome();
        }
        if (token.equalsIgnoreCase("nome representante") && vo.getExpedicao() != null && vo.getExpedicao().getPedido() != null) {
            return vo.getExpedicao().getPedido().getRepresentante().getPessoa().getNome();
        }
        if (token.equalsIgnoreCase("tipo frete")) {
            return vo.getDadosTransNfPropria().getTipoFrete().getDescricao();
        }
        if (token.equalsIgnoreCase("cond pagamento")) {
            return vo.getCondicaoPagamento().getNome();
        }
        if (token.equalsIgnoreCase("situacao pedido") && vo.getExpedicao() != null && vo.getExpedicao().getPedido() != null) {
            return vo.getExpedicao().getPedido().getSituacaoPedido().getDescricao();
        }
        if (token.equalsIgnoreCase("data hora envio nota")) {
            return DateUtil.dateToStr(new Date(), "dd/MM/yyyy hh:mm:ss");
        }
        if (token.equalsIgnoreCase("usuario envio nota")) {
            if (usuario != null) {
                return usuario.getUsuarioBasico().getPessoa().getNome();
            }
        } else {
            if (token.equalsIgnoreCase("codigo pedido") && vo.getExpedicao() != null && vo.getExpedicao().getPedido() != null) {
                if (vo.getExpedicao().getPedido().getCodigoPedido() != null) {
                    return vo.getExpedicao().getPedido().getCodigoPedido().toString();
                }
                return "";
            }
            if (token.equalsIgnoreCase("id pedido mobile") && vo.getExpedicao() != null && vo.getExpedicao().getPedido() != null) {
                if (vo.getExpedicao().getPedido().getIdPedidoMobile() != null) {
                    return vo.getExpedicao().getPedido().getIdPedidoMobile().toString();
                }
                return "";
            }
            if (vo.getExpedicao() != null && vo.getExpedicao().getPedido() != null) {
                return CoreUtilityFactory.getUtilityPedido().getTextValue(token, vo.getExpedicao().getPedido());
            }
        }
        return "";
    }

    public String getValueEmailEventoNFe(String token, EventoNFe e) {
        if (token == null || e == null) {
            return "";
        }
        NotaFiscalPropria vo = null;
        if (e instanceof EvtNFeCancelamento) {
            EvtNFeCancelamento canc = (EvtNFeCancelamento)e;
            vo = canc.getNotaFiscalPropria();
        } else if (e instanceof EvtNFeCartaCorrecao) {
            EvtNFeCartaCorrecao canc = (EvtNFeCartaCorrecao)e;
            vo = canc.getNotaFiscalPropria();
        } else if (e instanceof EvtNFeManifestoDest) {
            vo = null;
        }
        if (vo == null) {
            return "";
        }
        if (token.equalsIgnoreCase("data emissao np")) {
            return DateUtil.dateToStr(vo.getDataEmissaoNota());
        }
        if (token.equalsIgnoreCase("serie np")) {
            return vo.getSerie();
        }
        if (token.equalsIgnoreCase("numero np")) {
            if (vo.getNumeroNota() != null) {
                return vo.getNumeroNota().toString();
            }
            return "";
        }
        if (token.equalsIgnoreCase("chave nfe")) {
            if (vo.getChaveNFE() != null) {
                return vo.getChaveNFE();
            }
            return "";
        }
        if (token.equalsIgnoreCase("nome emissor")) {
            if (vo.getEmpresa().getPessoa().getNome() != null) {
                return vo.getEmpresa().getPessoa().getNome();
            }
            return "";
        }
        if (token.equalsIgnoreCase("cnpj emissor")) {
            if (vo.getEmpresa().getPessoa().getComplemento().getCnpj() != null) {
                return vo.getEmpresa().getPessoa().getComplemento().getCnpj();
            }
            return "";
        }
        if (token.equalsIgnoreCase("numero pedido") && vo.getExpedicao() != null && vo.getExpedicao().getPedido() != null) {
            if (vo.getExpedicao().getPedido().getNrPedidoCliente() != null) {
                return vo.getExpedicao().getPedido().getNrPedidoCliente();
            }
            return "";
        }
        if (token.equalsIgnoreCase("nome cliente")) {
            return vo.getUnidadeFatCliente().getCliente().getPessoa().getNome();
        }
        if (token.equalsIgnoreCase("nome representante") && vo.getExpedicao() != null && vo.getExpedicao().getPedido() != null) {
            return vo.getExpedicao().getPedido().getRepresentante().getPessoa().getNome();
        }
        if (token.equalsIgnoreCase("tipo frete")) {
            return vo.getDadosTransNfPropria().getTipoFrete().getDescricao();
        }
        if (token.equalsIgnoreCase("cond pagamento")) {
            return vo.getCondicaoPagamento().getNome();
        }
        if (token.equalsIgnoreCase("situacao pedido") && vo.getExpedicao() != null && vo.getExpedicao().getPedido() != null) {
            return vo.getExpedicao().getPedido().getSituacaoPedido().getDescricao();
        }
        if (token.equalsIgnoreCase("codigo pedido") && vo.getExpedicao() != null && vo.getExpedicao().getPedido() != null) {
            if (vo.getExpedicao().getPedido().getCodigoPedido() != null) {
                return vo.getExpedicao().getPedido().getCodigoPedido().toString();
            }
            return "";
        }
        if (token.equalsIgnoreCase("id pedido mobile") && vo.getExpedicao() != null && vo.getExpedicao().getPedido() != null) {
            if (vo.getExpedicao().getPedido().getIdPedidoMobile() != null) {
                return vo.getExpedicao().getPedido().getIdPedidoMobile().toString();
            }
            return "";
        }
        if (token.equalsIgnoreCase("tipo evento")) {
            if (e instanceof EvtNFeCartaCorrecao) {
                return "Carta Corre\u00e7\u00e3o";
            }
            if (e instanceof EvtNFeCancelamento) {
                return "Cancelamento";
            }
        } else if (token.equalsIgnoreCase("data hora envio nota")) {
            return DateUtil.dateToStr(new Date(), "dd/MM/yyyy hh:mm:ss");
        }
        return "";
    }

    public static NFeBuildText getInstance() {
        return new NFeBuildText();
    }
}

