/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.nfe;

import com.touchcomp.basementor.constants.ConstantsNotaFiscal;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeVersao;
import com.touchcomp.basementor.model.vo.EventoNFe;
import com.touchcomp.basementor.model.vo.EvtNFeCancelamento;
import com.touchcomp.basementor.model.vo.EvtNFeCartaCorrecao;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementor.model.vo.VersaoNFe;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorxml.model.XMLEventoNFe;
import com.touchcomp.basementorxml.model.XMLNfePropria;
import com.touchcomp.basementorxml.model.XMLNfeTerceiros;
import com.touchcomp.basementorxml.model.XMLNfseRPS;
import com.touchcomp.basementorxml.service.impl.xmlnfeterceiros.ServiceXMLNFeTerceirosImpl;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLEventoNFe;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLNFePropria;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLNFseRPS;
import contatocore.util.ContatoFormatUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.List;
import java.util.Random;
import mentorcore.exceptions.ExceptionFileManipulation;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.ClearUtil;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.CoreUtility;
import mentorcore.utilities.CoreUtilityFactory;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public class UtilityNFe
extends CoreUtility {
    private final TLogger logger = TLogger.get(UtilityNFe.class);

    public String toXMLStringCanc(NotaFiscalPropria n) throws ExceptionFileManipulation {
        ServiceXMLNFePropria service = (ServiceXMLNFePropria)ConfApplicationContext.getBean(ServiceXMLNFePropria.class);
        try {
            SAXBuilder sb = new SAXBuilder();
            SAXBuilder sb1 = new SAXBuilder();
            XMLNfePropria xml = (XMLNfePropria)service.get((Serializable)n.getIdentificador());
            if (xml == null) {
                throw new ExceptionFileManipulation("Nota sem arquivo xml.");
            }
            Document d = sb.build((InputStream)new ByteArrayInputStream(xml.getConteudoPedCancelamento().getBytes()));
            Document a = sb1.build((InputStream)new ByteArrayInputStream(xml.getConteudoCancelamento().getBytes()));
            Element e = a.detachRootElement();
            Element nfeProc = new Element("procCancNFe");
            Attribute at = new Attribute("versao", n.getVersaoNfe().getCodigo());
            nfeProc.setAttribute(at);
            nfeProc.setNamespace(Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/nfe"));
            Element root = d.detachRootElement();
            nfeProc.addContent((Content)root);
            nfeProc.addContent((Content)e);
            return new XMLOutputter().outputString(nfeProc);
        }
        catch (Exception ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionFileManipulation("Erro ao exportar o arquivo.");
        }
    }

    public String toXMLStringEventoNFe(EventoNFe n) throws ExceptionFileManipulation {
        try {
            ServiceXMLEventoNFe service = (ServiceXMLEventoNFe)ConfApplicationContext.getBean(ServiceXMLEventoNFe.class);
            SAXBuilder sb = new SAXBuilder();
            SAXBuilder sb1 = new SAXBuilder();
            XMLEventoNFe xml = (XMLEventoNFe)service.get((Serializable)n.getIdentificador());
            if (xml == null) {
                throw new ExceptionFileManipulation("Evento sem arquivo xml.");
            }
            Document d = sb.build((InputStream)new ByteArrayInputStream(xml.getConteudoEnviado().getBytes()));
            Document a = sb1.build((InputStream)new ByteArrayInputStream(xml.getConteudoRecebido().getBytes()));
            Element e = a.detachRootElement();
            Element nfeProc = new Element("procEventoNFe");
            Attribute at = new Attribute("versao", "1.00");
            nfeProc.setAttribute(at);
            nfeProc.setNamespace(Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/nfe"));
            Element root = d.detachRootElement();
            nfeProc.addContent((Content)root);
            nfeProc.addContent((Content)e);
            return new XMLOutputter().outputString(nfeProc);
        }
        catch (ExceptionFileManipulation ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionFileManipulation("Erro ao exportar o arquivo.");
        }
    }

    public String toXMLStringNFSe(Rps r) throws ExceptionFileManipulation {
        try {
            ServiceXMLNFseRPS service = (ServiceXMLNFseRPS)ConfApplicationContext.getBean(ServiceXMLNFseRPS.class);
            SAXBuilder sb = new SAXBuilder();
            XMLNfseRPS xml = (XMLNfseRPS)service.get((Serializable)r.getIdentificador());
            if (xml == null) {
                throw new ExceptionFileManipulation("NFSe " + r.getNumero() + " sem arquivo xml.");
            }
            String nota = xml.getConteudoXML();
            nota = ToolString.clearInvalidUTF8Char((String)nota);
            nota = ToolString.removeIllegalXMLChar((String)nota);
            Document d = sb.build((Reader)new StringReader(nota));
            Element e = d.detachRootElement();
            return new XMLOutputter().outputString(e);
        }
        catch (ExceptionFileManipulation ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionFileManipulation("Erro ao exportar o arquivo.");
        }
    }

    public File recordToFile(NotaFiscalTerceiros nf, String diretorio, boolean alterarQtd) throws ExceptionFileManipulation {
        String xml = this.toXMLStringTerceiros(nf, alterarQtd);
        String caminhoCompleto = diretorio + File.separator + "NFe-" + nf.getNumeroNota() + ".xml";
        return CoreUtilityFactory.getUtilityFile().writeStringInFile(caminhoCompleto, xml);
    }

    public File recordToFileCancelamento(NotaFiscalPropria nf, String diretorio) throws ExceptionFileManipulation {
        String xml = this.toXMLStringCanc(nf);
        String aux = diretorio + File.separator + nf.getChaveNFE() + "-canc.xml";
        return CoreUtilityFactory.getUtilityFile().writeStringInFile(aux, xml);
    }

    public File recordToFileEventoNFe(EventoNFe e, String diretorio) throws ExceptionFileManipulation {
        String xml = this.toXMLStringEventoNFe(e);
        Object aux = "";
        if (e instanceof EvtNFeCartaCorrecao) {
            EvtNFeCartaCorrecao evt = (EvtNFeCartaCorrecao)e;
            aux = diretorio + File.separator + "110110-" + evt.getNotaFiscalPropria().getChaveNFE() + "-" + evt.getNumSeqEvento() + "-procEventoNFe.xml";
        } else if (e instanceof EvtNFeCancelamento) {
            EvtNFeCancelamento evt = (EvtNFeCancelamento)e;
            aux = diretorio + File.separator + "110111-" + evt.getNotaFiscalPropria().getChaveNFE() + "-" + evt.getNumSeqEvento() + "-procEventoNFe.xml";
        }
        return CoreUtilityFactory.getUtilityFile().writeStringInFile((String)aux, xml);
    }

    public File recordToFileNFSe(Rps rps, String diretorio) throws ExceptionFileManipulation {
        String xml = this.toXMLStringNFSe(rps);
        String aux = diretorio + File.separator + rps.getNumeroNFse() + "-nfse.xml";
        return CoreUtilityFactory.getUtilityFile().writeStringInFile(aux, xml);
    }

    private String toXMLStringTerceiros(NotaFiscalTerceiros nt, boolean alterarQtd) throws ExceptionFileManipulation {
        try {
            ServiceXMLNFeTerceirosImpl service = (ServiceXMLNFeTerceirosImpl)ConfApplicationContext.getBean(ServiceXMLNFeTerceirosImpl.class);
            System.out.println("\n\n Exportando nota...\n NR NOTA: " + nt.getNumeroNota() + " ID:" + nt.getIdentificador() + "\n\n");
            XMLNfeTerceiros xmlNFeTerceiros = service.getXMlNfeTerceiros(nt.getIdentificador());
            if (TMethods.isNull((Object)xmlNFeTerceiros).booleanValue() && TMethods.isNull((Object)(xmlNFeTerceiros = service.getXMlNfeTerceiros(nt.getIdentificador()))).booleanValue()) {
                xmlNFeTerceiros = service.getByChave(nt.getChaveNFE());
            }
            if (xmlNFeTerceiros == null) {
                throw new ExceptionFileManipulation("Nota sem arquivo xml.");
            }
            String st = xmlNFeTerceiros.getConteudoXML();
            if (alterarQtd) {
                st = this.alterarQTD(nt, st);
            }
            return st;
        }
        catch (JDOMException ex) {
            this.logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionFileManipulation("Erro ao salvar o XML.");
        }
        catch (IOException ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionFileManipulation("Erro ao salvar o XML.");
        }
        catch (ExceptionService ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionFileManipulation("Erro ao salvar o XML.");
        }
    }

    private String alterarQTD(NotaFiscalTerceiros nt, String conteudo) throws JDOMException, IOException, ExceptionService {
        SAXBuilder sb = new SAXBuilder();
        Document d = sb.build((InputStream)new ByteArrayInputStream(conteudo.getBytes()));
        Element e = d.detachRootElement();
        Element root = e.getChild("NFe", ConstantsNotaFiscal.NAMESPACE_XML_NFE_X1);
        Element infNfe = root.getChild("infNFe", ConstantsNotaFiscal.NAMESPACE_XML_NFE_X1);
        List listItens = infNfe.getChildren("det", ConstantsNotaFiscal.NAMESPACE_XML_NFE_X1);
        for (Element element : listItens) {
            Element produto = element.getChild("prod", ConstantsNotaFiscal.NAMESPACE_XML_NFE_X1);
            String cProd = produto.getChildText("cProd", ConstantsNotaFiscal.NAMESPACE_XML_NFE_X1);
            Double qCom = Double.parseDouble(produto.getChildText("qCom", ConstantsNotaFiscal.NAMESPACE_XML_NFE_X1));
            Double qTrib = Double.parseDouble(produto.getChildText("qTrib", ConstantsNotaFiscal.NAMESPACE_XML_NFE_X1));
            Double vUnCom = Double.parseDouble(produto.getChildText("vUnCom", ConstantsNotaFiscal.NAMESPACE_XML_NFE_X1));
            Double vUnTrib = Double.parseDouble(produto.getChildText("vUnTrib", ConstantsNotaFiscal.NAMESPACE_XML_NFE_X1));
            Double valorConversaoItem = UtilityNFe.getValorConversaoItem(nt, cProd);
            produto.getChild("qCom", ConstantsNotaFiscal.NAMESPACE_XML_NFE_X1).setText(String.valueOf(valorConversaoItem * qCom));
            produto.getChild("qTrib", ConstantsNotaFiscal.NAMESPACE_XML_NFE_X1).setText(String.valueOf(valorConversaoItem * qTrib));
            produto.getChild("vUnCom", ConstantsNotaFiscal.NAMESPACE_XML_NFE_X1).setText(String.valueOf(vUnCom / (valorConversaoItem * qTrib)));
            produto.getChild("vUnTrib", ConstantsNotaFiscal.NAMESPACE_XML_NFE_X1).setText(String.valueOf(vUnTrib / (valorConversaoItem * qTrib)));
        }
        return new XMLOutputter().outputString(e);
    }

    private static Double getValorConversaoItem(NotaFiscalTerceiros nt, String cProd) throws ExceptionService {
        for (ItemNotaTerceiros i : nt.getItemNotaTerceiros()) {
            CoreRequestContext r = new CoreRequestContext();
            r.setAttribute("idFornecedor", nt.getUnidadeFatFornecedor().getFornecedor().getIdentificador());
            r.setAttribute("idProduto", i.getProduto().getIdentificador());
            List codProduto = (List)CoreServiceFactory.getServiceProduto().execute(r, "getFatorConversaoItem");
            for (Object o : codProduto) {
                if (!o.equals(cProd)) continue;
                return i.getFatorConversao();
            }
        }
        return new Double(1.0);
    }

    public String getNumeroNFeChave(String chave) {
        if (chave == null || chave.length() < 35) {
            return null;
        }
        return chave.substring(25, 34);
    }

    public Integer getCodAcesso(VersaoNFe vo) {
        Random r = new Random();
        if (vo != null && (vo.getCodigo().equalsIgnoreCase(EnumConstNFeVersao.VERSAO_2_00.getCodigoStr()) || vo.getCodigo().equalsIgnoreCase(EnumConstNFeVersao.VERSAO_3_10.getCodigoStr()) || vo.getCodigo().equalsIgnoreCase(EnumConstNFeVersao.VERSAO_4_00.getCodigoStr()))) {
            return r.nextInt(100000000);
        }
        if (vo != null && vo.getCodigo().equalsIgnoreCase(EnumConstNFeVersao.VERSAO_1_10.getCodigoStr())) {
            return r.nextInt(1000000000);
        }
        return null;
    }

    public int getCodigoVerificador(StringBuilder sb) {
        char[] chave = sb.toString().toCharArray();
        int multily = 2;
        int soma = 0;
        for (int counter = chave.length - 1; counter >= 0; --counter) {
            char c = chave[counter];
            soma += Integer.valueOf(String.valueOf(c)) * multily;
            if (++multily <= 9) continue;
            multily = 2;
        }
        int resto = soma % 11;
        int cDV = resto == 0 || resto == 1 ? 0 : 11 - resto;
        return cDV;
    }

    public String getChaveAcessoAuxFS(NotaFiscalPropria vo) {
        if (vo.getPeriodoEmissaoNFe() == null) {
            return null;
        }
        if (vo.getPeriodoEmissaoNFe().getTipoEmissaoNfe().getCodigo() == 2 || vo.getPeriodoEmissaoNFe().getTipoEmissaoNfe().getCodigo() == 5) {
            StringBuilder sb = new StringBuilder();
            sb.append(vo.getUnidadeFatCliente().getCliente().getPessoa().getEndereco().getCidade().getUf().getCodIbge());
            sb.append(vo.getPeriodoEmissaoNFe().getTipoEmissaoNfe().getCodigo());
            sb.append(ContatoFormatUtil.completaZerosEsquerda((String)ClearUtil.refina(vo.getUnidadeFatCliente().getCliente().getPessoa().getComplemento().getCnpj()), (int)14));
            sb.append(ContatoFormatUtil.completaZerosEsquerda((String)ClearUtil.refina(ContatoFormatUtil.formataNumero((Number)vo.getValoresNfPropria().getValorTotal(), (int)2)), (int)14));
            if (vo.getValoresNfPropria().getValorIcms() > 0.0) {
                sb.append(1);
            } else {
                sb.append(2);
            }
            if (vo.getValoresNfPropria().getValorIcmsSt() > 0.0) {
                sb.append(1);
            } else {
                sb.append(2);
            }
            sb.append(DateUtil.dateToStr(vo.getDataEmissaoNota(), "dd"));
            int codDV = CoreUtilityFactory.getUtilityNFe().getCodigoVerificador(sb);
            sb.append(codDV);
            return sb.toString();
        }
        return null;
    }
}

