/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.notafiscalpropria;

import com.touchcomp.basementor.model.impl.LivroFiscalItem;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalIpi;
import com.touchcomp.basementor.model.vo.ModeloFiscalPisCofins;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ObservacaoLivroFiscal;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.SituacaoDocumento;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.VolumeNFe;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorservice.components.calculovalores.BaseCalculoValores;
import com.touchcomp.basementorservice.components.totalizadores.CompTotalizadores;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.utilities.impl.ajustes.UtilityAjustesIcmsDocFiscalNotaPropria;

public class UtilityNotaFiscalPropria {
    public void calcularSetarVolumesAuto(NotaFiscalPropria n, OpcoesFaturamento op) {
        if (op.getRatearPesoVolumesExp() != null && op.getRatearPesoVolumesExp() == 1 && op.getTipoFaturamento() == 0) {
            double peso = 0.0;
            int qtd = 0;
            for (Object o : n.getItensNotaPropria()) {
                double qtdPorVolume;
                ItemNotaFiscalPropria i = (ItemNotaFiscalPropria)o;
                peso += (i.getProduto().getPesoUnitario() + i.getProduto().getPesoEmbalagem()) * i.getQuantidadeTotal();
                double d = qtdPorVolume = i.getProduto().getQtdVolume() != null ? i.getProduto().getQtdVolume() : 0.0;
                if (qtdPorVolume <= 0.0) {
                    qtdPorVolume = 1.0;
                }
                qtd = (int)((double)qtd + i.getQuantidadeTotal() / qtdPorVolume);
            }
            VolumeNFe v = new VolumeNFe();
            v.setEmbalagem(op.getEmbalagem());
            v.setNumeroVolume(Long.valueOf(1L));
            v.setQuantidade(Integer.valueOf(qtd));
            v.setPesoBruto(Double.valueOf(peso + v.getEmbalagem().getPeso()));
            v.setPesoLiquido(Double.valueOf(peso));
            v.setNotaFiscalPropria(n);
            ArrayList<VolumeNFe> vl = new ArrayList<VolumeNFe>();
            vl.add(v);
            n.setVolumes(vl);
        }
    }

    public List getLivroFiscaisResumo(List itens, List livrosOld, ModeloDocFiscal modeloDocFiscal, SituacaoDocumento situacaoDoc) throws ExceptionAvaliadorExpressoes {
        if (modeloDocFiscal == null) {
            return new ArrayList();
        }
        if (itens == null || modeloDocFiscal.getGeraLivroFiscal() != null && modeloDocFiscal.getGeraLivroFiscal() != 1) {
            return new ArrayList();
        }
        LivroFiscal lv = null;
        ArrayList<LivroFiscal> livros = new ArrayList<LivroFiscal>();
        boolean achou = false;
        HashMap<LivroFiscal, LivroFiscalItem> h = new HashMap<LivroFiscal, LivroFiscalItem>();
        for (Object o : itens) {
            ItemNotaFiscalPropria itemNotaFiscalPropria = (ItemNotaFiscalPropria)o;
            Date dataLivro = null;
            PlanoConta planoConta = null;
            dataLivro = itemNotaFiscalPropria.getNotaFiscalPropria().getDataEmissaoNota();
            planoConta = itemNotaFiscalPropria.getPlanoContaCred();
            lv = new LivroFiscal(itemNotaFiscalPropria.getItemNotaLivroFiscal().getCfop(), planoConta, itemNotaFiscalPropria.getIncidenciaIcms(), itemNotaFiscalPropria.getIncidenciaIpi(), itemNotaFiscalPropria.getItemNotaLivroFiscal().getAliquotaIcms(), itemNotaFiscalPropria.getProduto().getAliquotaIcms(), itemNotaFiscalPropria.getNotaFiscalPropria() != null ? dataLivro : new Date(), itemNotaFiscalPropria.getIncidenciaPisCofins(), itemNotaFiscalPropria.getIncidenciaPisCofins(), itemNotaFiscalPropria.getItemNotaLivroFiscal().getAliquotaPis(), itemNotaFiscalPropria.getItemNotaLivroFiscal().getAliquotaCofins(), itemNotaFiscalPropria.getItemNotaLivroFiscal().getAliquotaPisQtde(), itemNotaFiscalPropria.getItemNotaLivroFiscal().getAliquotaCofinsQtde());
            int aux = livros.indexOf(lv);
            if (aux > -1) {
                lv = (LivroFiscal)livros.get(aux);
                achou = true;
                if (h.get(lv) != null) {
                    LivroFiscalItem itemLivroItem = (LivroFiscalItem)h.get(lv);
                    itemLivroItem.getItensNotaPopria().add(itemNotaFiscalPropria);
                    h.put(lv, itemLivroItem);
                }
            }
            ItemNotaLivroFiscal lf = itemNotaFiscalPropria.getItemNotaLivroFiscal();
            lv.setValorFreteIcmsST(itemNotaFiscalPropria.getItemNotaLivroFiscal().getFreteIcmsST());
            lv.setCancelado(Short.valueOf((short)0));
            lv.setValorBCIcmsSt(Double.valueOf(lv.getValorBCIcmsSt() + lf.getVrBcCalculoIcmsSt()));
            lv.setValorIcms(ContatoFormatUtil.arrredondarNumero((Double)(lv.getValorIcms() + lf.getVrIcms()), (int)2));
            lv.setValorIcmsIsento(Double.valueOf(lv.getValorIcmsIsento() + lf.getVrIcmsIsento()));
            lv.setValorIcmsOutros(Double.valueOf(lv.getValorIcmsOutros() + lf.getVrIcmsOutros()));
            lv.setValorIcmsSt(Double.valueOf(lv.getValorIcmsSt() + lf.getVrIcmsSt()));
            lv.setValorIcmsTributado(Double.valueOf(lv.getValorIcmsTributado() + lf.getVrIcmsTributado()));
            lv.setValorIcmsSemAprov(Double.valueOf(lv.getValorIcmsSemAprov() + lf.getVrIcmsSemAprov()));
            lv.setValorInss(Double.valueOf(lv.getValorInss() + lf.getVrInss()));
            lv.setValorIpiIndustria(Double.valueOf(lv.getValorIpiIndustria() + lf.getVrIpiIndustria()));
            lv.setValorIpiIsento(Double.valueOf(lv.getValorIpiIsento() + lf.getVrIpiIsento()));
            lv.setValorIpiOutros(Double.valueOf(lv.getValorIpiOutros() + lf.getVrIpiOutros()));
            lv.setValorIpiTributado(Double.valueOf(lv.getValorIpiTributado() + lf.getVrIpiTributado()));
            lv.setValorIpiComercio(Double.valueOf(lv.getValorIpiComercio() + lf.getVrIpiComercio()));
            lv.setValorIpiObservacao(Double.valueOf(lv.getValorIpiObservacao() + lf.getVrIpiObservacao()));
            lv.setValorIrrf(Double.valueOf(lv.getValorIrrf() + lf.getVrIrrf()));
            lv.setValorIss(Double.valueOf(lv.getValorIss() + lf.getVrIss()));
            lv.setValorLei10833(Double.valueOf(lv.getValorLei10833() + lf.getVrLei10833()));
            lv.setValorFunrural(Double.valueOf(lv.getValorFunrural() + lf.getVrFunrural()));
            lv.setValorOutros(Double.valueOf(lv.getValorOutros() + lf.getVrOutros()));
            lv.setValorTotal(ContatoFormatUtil.arrredondarNumero((Double)(lv.getValorTotal() + lf.getValorTotal()), (int)2));
            lv.setVrBCCofins(Double.valueOf(lv.getVrBCCofins() + lf.getVrBCCofins()));
            lv.setVrBCPis(Double.valueOf(lv.getVrBCPis() + lf.getVrBCPis()));
            if (lv.getValorDifAliquota() == null) {
                lv.setValorDifAliquota(Double.valueOf(0.0));
            }
            lv.setValorDifAliquota(Double.valueOf(lv.getValorDifAliquota() + lf.getVrDifAliquota()));
            lv.setUfIcmsSt(lf.getUfIcmsSt());
            if (lv.getValorContSocial() == null) {
                lv.setValorContSocial(Double.valueOf(0.0));
            }
            if (lf.getVrContSoc() == null) {
                lf.setVrContSoc(Double.valueOf(0.0));
            }
            lv.setValorContSocial(Double.valueOf(lv.getValorContSocial() + lf.getVrContSoc()));
            if (lv.getValorCofins() == null) {
                lv.setValorCofins(Double.valueOf(0.0));
            }
            lv.setValorCofins(Double.valueOf(lv.getValorCofins() + lf.getVrCofins()));
            if (lv.getValorPis() == null) {
                lv.setValorPis(Double.valueOf(0.0));
            }
            lv.setValorPis(Double.valueOf(lv.getValorPis() + lf.getVrPis()));
            if (lf.getValorSestSenat() == null) {
                lf.setValorSestSenat(Double.valueOf(0.0));
            }
            lv.setValorSestSenat(Double.valueOf(lv.getValorSestSenat() + lf.getValorSestSenat()));
            if (lf.getVrNaoTribICMS() == null) {
                lf.setVrNaoTribICMS(Double.valueOf(0.0));
            }
            lv.setVrNaoTribIcms(Double.valueOf(lv.getVrNaoTribIcms() + lf.getVrNaoTribICMS()));
            if (itemNotaFiscalPropria.getNotaFiscalPropria() != null) {
                lv.setEmpresa(itemNotaFiscalPropria.getNotaFiscalPropria().getEmpresa());
                lv.setUf(itemNotaFiscalPropria.getNotaFiscalPropria().getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf());
                lv.setCidade(itemNotaFiscalPropria.getNotaFiscalPropria().getUnidadeFatCliente().getPessoa().getEndereco().getCidade());
            }
            if (itemNotaFiscalPropria.getNotaFiscalPropria().getNaturezaOperacao() != null) {
                lv.setEntradaSaidaNaturezaOp(itemNotaFiscalPropria.getNotaFiscalPropria().getNaturezaOperacao().getEntradaSaida());
            }
            if (situacaoDoc != null && situacaoDoc.getCodigo().equalsIgnoreCase("02")) {
                lv.setCancelado(Short.valueOf((short)1));
            }
            if (itemNotaFiscalPropria.getModeloFiscal() != null) {
                lv.setDescartarDapi(itemNotaFiscalPropria.getModeloFiscal().getDescartarDapi());
            }
            lv.setVrBCCustoICMSST(Double.valueOf(lv.getVrBCCustoICMSST() + lf.getVrBCCustoICMSST()));
            lv.setVrCustoICMSST(Double.valueOf(lv.getVrCustoICMSST() + lf.getVrCustoICMSST()));
            lv.setValorIcmsPartilhaDest(Double.valueOf(lv.getValorIcmsPartilhaDest() + lf.getValorIcmsPartilhaDest()));
            lv.setValorIcmsPartilhaRem(Double.valueOf(lv.getValorIcmsPartilhaRem() + lf.getValorIcmsPartilhaRem()));
            lv.setValorFundoPobreza(Double.valueOf(lv.getValorFundoPobreza() + lf.getValorFundoPobreza()));
            lv.setValorFCP(Double.valueOf(lv.getValorFCP() + lf.getValorFCP()));
            lv.setAliquotaFCP(lf.getAliquotaFCP());
            lv.setValorFCPSt(Double.valueOf(lv.getValorFCPSt() + lf.getValorFCPSt()));
            lv.setAliquotaFCPSt(lf.getAliquotaFCPSt());
            lv.setValorFCPStRetido(Double.valueOf(lv.getValorFCPStRetido() + lf.getValorFCPStRetido()));
            lv.setAliquotaFCPStRetido(lf.getAliquotaFCPStRetido());
            lv.setValorIpiDevolucao(Double.valueOf(lv.getValorIpiDevolucao() + lf.getValorIpiDevolucao()));
            if (lf.getValorIcmsDiferimento() == null) {
                lf.setValorIcmsDiferimento(Double.valueOf(0.0));
            }
            lv.setValorIcmsDiferimento(Double.valueOf(lv.getValorIcmsDiferimento() + lf.getValorIcmsDiferimento()));
            if (lf.getVrIcmsDesonerado() == null) {
                lf.setVrIcmsDesonerado(Double.valueOf(0.0));
            }
            lv.setValorIcmsDesonerado(Double.valueOf(lv.getValorIcmsDesonerado() + lf.getVrIcmsDesonerado()));
            if (!achou) {
                livros.add(lv);
                LivroFiscalItem l = new LivroFiscalItem();
                l.setLivroFiscal(lv);
                l.getItensNotaPopria().add(itemNotaFiscalPropria);
                h.put(lv, l);
            }
            achou = false;
        }
        ArrayList<LivroFiscalItem> lista = new ArrayList<LivroFiscalItem>();
        for (Object e : livros) {
            LivroFiscal lvf = (LivroFiscal)e;
            LivroFiscalItem livroItem = (LivroFiscalItem)h.get(lvf);
            if (livroItem == null) continue;
            lista.add(livroItem);
        }
        this.updateLivros(livrosOld, livros);
        new UtilityAjustesIcmsDocFiscalNotaPropria().gerarAjustesIcmsDocFiscal(lista);
        return livros;
    }

    private void updateLivros(List livrosOld, List livros) {
        if (livrosOld != null && !livrosOld.isEmpty()) {
            for (Object o : livros) {
                LivroFiscal lvNew = (LivroFiscal)o;
                int index = livrosOld.indexOf(lvNew);
                if (index <= -1) continue;
                LivroFiscal lvOld = (LivroFiscal)livrosOld.get(index);
                lvNew.setIdentificador(lvOld.getIdentificador());
                lvNew.setObsLivroFiscal(lvOld.getObsLivroFiscal());
                if (lvNew.getObsLivroFiscal() == null) continue;
                for (Object oc : lvNew.getObsLivroFiscal()) {
                    ObservacaoLivroFiscal os = (ObservacaoLivroFiscal)oc;
                    os.setLivroFiscal(lvNew);
                }
            }
        }
    }

    public void calcularTotalizadores(NotaFiscalPropria nf) {
        CompTotalizadores calc = new CompTotalizadores();
        calc.calculaTotalizadores(nf);
    }

    public static HashMap calcularTotalizadores(List itens) {
        HashMap<String, Double> h = new HashMap<String, Double>();
        if (itens == null) {
            return h;
        }
        Double valorProduto = 0.0;
        Double valorServico = 0.0;
        Double valorFrete = 0.0;
        Double valorSeguro = 0.0;
        Double valorDesconto = 0.0;
        Double valorDespAcessoria = 0.0;
        Double valorIcmsTributado = 0.0;
        Double valorIcms = 0.0;
        Double bcICMST = 0.0;
        Double valorICMST = 0.0;
        Double valorIpiTributado = 0.0;
        Double valorInssNaoRet = 0.0;
        Double valorIrrf = 0.0;
        Double valorInss = 0.0;
        Double valorTotal = 0.0;
        Double valorIcmsIsento = 0.0;
        Double valorIcmsOutros = 0.0;
        Double valorIpiOutros = 0.0;
        Double valorIpiIsento = 0.0;
        Double valorIpiIndustria = 0.0;
        Double valorIpiObservacao = 0.0;
        Double valorIcmsSA = 0.0;
        Double valorLei10833 = 0.0;
        Double valorISS = 0.0;
        Double valorFunrural = 0.0;
        Double valorPis = 0.0;
        Double valorCofins = 0.0;
        Double valorContSoc = 0.0;
        Double valorOutros = 0.0;
        Double valorSestSenat = 0.0;
        Double valorPisST = 0.0;
        Double valorCofinsST = 0.0;
        Double valorIPIComercio = 0.0;
        Double valorDifAliquota = 0.0;
        Double valorBCPis = 0.0;
        Double valorBCCofins = 0.0;
        Double valorImpImportacao = 0.0;
        Double valorEstimadoImp = 0.0;
        Double valorFCP = 0.0;
        Double valorFCPSt = 0.0;
        Double valorFCPStRetido = 0.0;
        Double valorIpiDevolucao = 0.0;
        Double valorIcmsDiferimento = 0.0;
        Double valorRat = 0.0;
        Double valorTaxaSanidadeAnimal = 0.0;
        Double valorSenar = 0.0;
        Double valorIcmsDesonerado = 0.0;
        for (Object o : itens) {
            ItemNotaFiscalPropria vo = (ItemNotaFiscalPropria)o;
            valorProduto = valorProduto + vo.getVrProduto();
            if (vo.getVrServico() != null) {
                valorServico = valorServico + vo.getVrServico();
            } else {
                vo.setVrServico(Double.valueOf(0.0));
            }
            if (vo.getValorFrete() != null) {
                valorFrete = valorFrete + vo.getValorFrete();
            } else {
                vo.setValorFrete(Double.valueOf(0.0));
            }
            if (vo.getVrSeguro() != null) {
                valorSeguro = valorSeguro + vo.getVrSeguro();
            } else {
                vo.setVrSeguro(Double.valueOf(0.0));
            }
            if (vo.getValorDesconto() != null) {
                valorDesconto = valorDesconto + vo.getValorDesconto();
            } else {
                vo.setValorDesconto(Double.valueOf(0.0));
            }
            if (vo.getValorDespAcessoria() != null) {
                valorDespAcessoria = valorDespAcessoria + vo.getValorDespAcessoria();
            } else {
                vo.setValorDespAcessoria(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrIcmsTributado() != null) {
                valorIcmsTributado = valorIcmsTributado + vo.getItemNotaLivroFiscal().getVrIcmsTributado();
            } else {
                vo.getItemNotaLivroFiscal().setVrIcmsTributado(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrInssNaoRetido() != null) {
                valorInssNaoRet = valorInssNaoRet + vo.getItemNotaLivroFiscal().getVrInssNaoRetido();
            } else {
                vo.getItemNotaLivroFiscal().setVrInssNaoRetido(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrIcms() != null) {
                valorIcms = valorIcms + vo.getItemNotaLivroFiscal().getVrIcms();
            } else {
                vo.getItemNotaLivroFiscal().setVrIcms(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrIcmsOutros() != null) {
                valorIcmsOutros = valorIcmsOutros + vo.getItemNotaLivroFiscal().getVrIcmsOutros();
            } else {
                vo.getItemNotaLivroFiscal().setVrIcmsOutros(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrBcCalculoIcmsSt() != null) {
                bcICMST = bcICMST + vo.getItemNotaLivroFiscal().getVrBcCalculoIcmsSt();
            } else {
                vo.getItemNotaLivroFiscal().setVrBcCalculoIcmsSt(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrIcmsSt() != null) {
                valorICMST = valorICMST + vo.getItemNotaLivroFiscal().getVrIcmsSt();
            } else {
                vo.getItemNotaLivroFiscal().setVrIcmsSt(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrIpiTributado() != null) {
                valorIpiTributado = valorIpiTributado + vo.getItemNotaLivroFiscal().getVrIpiTributado();
            } else {
                vo.getItemNotaLivroFiscal().setVrIpiTributado(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrIpiIsento() != null) {
                valorIpiIsento = valorIpiIsento + vo.getItemNotaLivroFiscal().getVrIpiIsento();
            } else {
                vo.getItemNotaLivroFiscal().setVrIpiIsento(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrIpiIndustria() != null) {
                valorIpiIndustria = valorIpiIndustria + vo.getItemNotaLivroFiscal().getVrIpiIndustria();
            } else {
                vo.getItemNotaLivroFiscal().setVrIpiIndustria(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrIpiOutros() != null) {
                valorIpiOutros = valorIpiOutros + vo.getItemNotaLivroFiscal().getVrIpiOutros();
            } else {
                vo.getItemNotaLivroFiscal().setVrIpiOutros(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrIrrf() != null) {
                valorIrrf = valorIrrf + vo.getItemNotaLivroFiscal().getVrIrrf();
            } else {
                vo.getItemNotaLivroFiscal().setVrIrrf(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrInss() != null) {
                valorInss = valorInss + vo.getItemNotaLivroFiscal().getVrInss();
            } else {
                vo.getItemNotaLivroFiscal().setVrInss(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrIss() != null) {
                valorISS = valorISS + vo.getItemNotaLivroFiscal().getVrIss();
            } else {
                vo.getItemNotaLivroFiscal().setVrIss(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getValorTotal() != null) {
                valorTotal = valorTotal + vo.getItemNotaLivroFiscal().getValorTotal();
            } else {
                vo.getItemNotaLivroFiscal().setValorTotal(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrIpiObservacao() != null) {
                valorIpiObservacao = valorIpiObservacao + vo.getItemNotaLivroFiscal().getVrIpiObservacao();
            } else {
                vo.getItemNotaLivroFiscal().setVrIpiObservacao(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrIcmsSemAprov() != null) {
                valorIcmsSA = valorIcmsSA + vo.getItemNotaLivroFiscal().getVrIcmsSemAprov();
            } else {
                vo.getItemNotaLivroFiscal().setVrIcmsSemAprov(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrLei10833() != null) {
                valorLei10833 = valorLei10833 + vo.getItemNotaLivroFiscal().getVrLei10833();
            } else {
                vo.getItemNotaLivroFiscal().setVrLei10833(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrFunrural() != null) {
                valorFunrural = valorFunrural + vo.getItemNotaLivroFiscal().getVrFunrural();
            } else {
                vo.getItemNotaLivroFiscal().setVrFunrural(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrPisSt() != null) {
                valorPisST = valorPisST + vo.getItemNotaLivroFiscal().getVrPisSt();
            } else {
                vo.getItemNotaLivroFiscal().setVrPisSt(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrCofinsSt() != null) {
                valorCofinsST = valorCofinsST + vo.getItemNotaLivroFiscal().getVrCofinsSt();
            } else {
                vo.getItemNotaLivroFiscal().setVrCofinsSt(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrIpiComercio() != null) {
                valorIPIComercio = valorIPIComercio + vo.getItemNotaLivroFiscal().getVrIpiComercio();
            } else {
                vo.getItemNotaLivroFiscal().setVrIpiComercio(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrPis() != null) {
                valorPis = valorPis + vo.getItemNotaLivroFiscal().getVrPis();
            } else {
                vo.getItemNotaLivroFiscal().setVrPis(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrCofins() != null) {
                valorCofins = valorCofins + vo.getItemNotaLivroFiscal().getVrCofins();
            } else {
                vo.getItemNotaLivroFiscal().setVrCofins(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrContSoc() != null) {
                valorContSoc = valorContSoc + vo.getItemNotaLivroFiscal().getVrContSoc();
            } else {
                vo.getItemNotaLivroFiscal().setVrContSoc(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrOutros() != null) {
                valorOutros = valorOutros + vo.getItemNotaLivroFiscal().getVrOutros();
            } else {
                vo.getItemNotaLivroFiscal().setVrOutros(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getValorSestSenat() != null) {
                valorSestSenat = valorSestSenat + vo.getItemNotaLivroFiscal().getValorSestSenat();
            } else {
                vo.getItemNotaLivroFiscal().setValorSestSenat(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrIcmsIsento() != null) {
                valorIcmsIsento = valorIcmsIsento + vo.getItemNotaLivroFiscal().getVrIcmsIsento();
            } else {
                vo.getItemNotaLivroFiscal().setVrIcmsIsento(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrDifAliquota() != null) {
                valorDifAliquota = valorDifAliquota + vo.getItemNotaLivroFiscal().getVrDifAliquota();
            } else {
                vo.getItemNotaLivroFiscal().setVrDifAliquota(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrBCPis() != null) {
                valorBCPis = valorBCPis + vo.getItemNotaLivroFiscal().getVrBCPis();
            } else {
                vo.getItemNotaLivroFiscal().setVrBCPis(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrBCCofins() != null) {
                valorBCCofins = valorBCCofins + vo.getItemNotaLivroFiscal().getVrBCCofins();
            } else {
                vo.getItemNotaLivroFiscal().setVrBCCofins(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrImpostoImportacao() != null) {
                valorImpImportacao = valorImpImportacao + vo.getItemNotaLivroFiscal().getVrImpostoImportacao();
            } else {
                vo.getItemNotaLivroFiscal().setVrImpostoImportacao(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVlrImpostosEstimado() != null) {
                valorEstimadoImp = valorEstimadoImp + vo.getItemNotaLivroFiscal().getVlrImpostosEstimado();
            } else {
                vo.getItemNotaLivroFiscal().setVlrImpostosEstimado(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getValorFCP() != null) {
                valorFCP = valorFCP + vo.getItemNotaLivroFiscal().getValorFCP();
            } else {
                vo.getItemNotaLivroFiscal().setValorFCP(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getValorFCPSt() != null) {
                valorFCPSt = valorFCPSt + vo.getItemNotaLivroFiscal().getValorFCPSt();
            } else {
                vo.getItemNotaLivroFiscal().setValorFCPSt(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getValorFCPStRetido() != null) {
                valorFCPStRetido = valorFCPStRetido + vo.getItemNotaLivroFiscal().getValorFCPStRetido();
            } else {
                vo.getItemNotaLivroFiscal().setValorFCPStRetido(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getValorIpiDevolucao() != null) {
                valorIpiDevolucao = valorIpiDevolucao + vo.getItemNotaLivroFiscal().getValorIpiDevolucao();
            } else {
                vo.getItemNotaLivroFiscal().setValorIpiDevolucao(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getValorIcmsDiferimento() != null) {
                valorIcmsDiferimento = valorIcmsDiferimento + vo.getItemNotaLivroFiscal().getValorIcmsDiferimento();
            } else {
                vo.getItemNotaLivroFiscal().setValorIcmsDiferimento(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getValorSenar() != null) {
                valorSenar = valorSenar + vo.getItemNotaLivroFiscal().getValorSenar();
            } else {
                vo.getItemNotaLivroFiscal().setValorSenar(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getValorRat() != null) {
                valorRat = valorRat + vo.getItemNotaLivroFiscal().getValorRat();
            } else {
                vo.getItemNotaLivroFiscal().setValorRat(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getValorTaxaSanidadeAnimal() != null) {
                valorTaxaSanidadeAnimal = valorTaxaSanidadeAnimal + vo.getItemNotaLivroFiscal().getValorTaxaSanidadeAnimal();
            } else {
                vo.getItemNotaLivroFiscal().setValorTaxaSanidadeAnimal(Double.valueOf(0.0));
            }
            if (vo.getItemNotaLivroFiscal().getVrIcmsDesonerado() != null) {
                valorIcmsDesonerado = valorIcmsDesonerado + vo.getItemNotaLivroFiscal().getVrIcmsDesonerado();
                continue;
            }
            vo.getItemNotaLivroFiscal().setVrIcmsDesonerado(Double.valueOf(0.0));
        }
        h.put("vlrTotal", ContatoFormatUtil.arrredondarNumero((Double)valorTotal, (int)2));
        h.put("vlrDesconto", ContatoFormatUtil.arrredondarNumero((Double)valorDesconto, (int)2));
        h.put("vlrInssNaoRet", ContatoFormatUtil.arrredondarNumero((Double)valorInssNaoRet, (int)2));
        h.put("vlrFrete", ContatoFormatUtil.arrredondarNumero((Double)valorFrete, (int)2));
        h.put("vlrSeguro", ContatoFormatUtil.arrredondarNumero((Double)valorSeguro, (int)2));
        h.put("vlrDespAcess", ContatoFormatUtil.arrredondarNumero((Double)valorDespAcessoria, (int)2));
        h.put("vlrProduto", ContatoFormatUtil.arrredondarNumero((Double)valorProduto, (int)2));
        h.put("vlrServico", ContatoFormatUtil.arrredondarNumero((Double)valorServico, (int)2));
        h.put("vlrIpiIsento", ContatoFormatUtil.arrredondarNumero((Double)valorIpiIsento, (int)2));
        h.put("vlrIpiOutros", ContatoFormatUtil.arrredondarNumero((Double)valorIpiOutros, (int)2));
        h.put("bcIpi", ContatoFormatUtil.arrredondarNumero((Double)valorIpiTributado, (int)2));
        h.put("vlrIpiObs", ContatoFormatUtil.arrredondarNumero((Double)valorIpiObservacao, (int)2));
        h.put("vlrIpiInd", ContatoFormatUtil.arrredondarNumero((Double)valorIpiIndustria, (int)2));
        h.put("vlrIcmsSA", ContatoFormatUtil.arrredondarNumero((Double)valorIcmsSA, (int)2));
        h.put("bcIcmsSt", ContatoFormatUtil.arrredondarNumero((Double)bcICMST, (int)2));
        h.put("vlrIcmsSt", ContatoFormatUtil.arrredondarNumero((Double)valorICMST, (int)2));
        h.put("vlrLei10833", ContatoFormatUtil.arrredondarNumero((Double)valorLei10833, (int)2));
        h.put("vlrInss", ContatoFormatUtil.arrredondarNumero((Double)valorInss, (int)2));
        h.put("vlrIss", ContatoFormatUtil.arrredondarNumero((Double)valorISS, (int)2));
        h.put("vlrFunrural", ContatoFormatUtil.arrredondarNumero((Double)valorFunrural, (int)2));
        h.put("vlrPis", ContatoFormatUtil.arrredondarNumero((Double)valorPis, (int)2));
        h.put("vlrCofins", ContatoFormatUtil.arrredondarNumero((Double)valorCofins, (int)2));
        h.put("vlrContSoc", ContatoFormatUtil.arrredondarNumero((Double)valorContSoc, (int)2));
        h.put("vlrOutros", ContatoFormatUtil.arrredondarNumero((Double)valorOutros, (int)2));
        h.put("vlrSestSenat", ContatoFormatUtil.arrredondarNumero((Double)valorSestSenat, (int)2));
        h.put("vlrIrrf", ContatoFormatUtil.arrredondarNumero((Double)valorIrrf, (int)2));
        h.put("vlrIcms", ContatoFormatUtil.arrredondarNumero((Double)valorIcms, (int)2));
        h.put("vlrIcmsIsento", ContatoFormatUtil.arrredondarNumero((Double)valorIcmsIsento, (int)2));
        h.put("vlrIcmsTrib", ContatoFormatUtil.arrredondarNumero((Double)valorIcmsTributado, (int)2));
        h.put("vlrIcmsOutros", ContatoFormatUtil.arrredondarNumero((Double)valorIcmsOutros, (int)2));
        h.put("vlrPisST", ContatoFormatUtil.arrredondarNumero((Double)valorPisST, (int)2));
        h.put("vlrCofinsSt", ContatoFormatUtil.arrredondarNumero((Double)valorCofinsST, (int)2));
        h.put("vlrIpiComercio", ContatoFormatUtil.arrredondarNumero((Double)valorIPIComercio, (int)2));
        h.put("valorDifAliquota", ContatoFormatUtil.arrredondarNumero((Double)valorDifAliquota, (int)2));
        h.put("valorBcCofins", ContatoFormatUtil.arrredondarNumero((Double)valorBCCofins, (int)2));
        h.put("vlrBCPis", ContatoFormatUtil.arrredondarNumero((Double)valorBCPis, (int)2));
        h.put("valorImpImportacao", ContatoFormatUtil.arrredondarNumero((Double)valorImpImportacao, (int)2));
        h.put("vlrEstimadoImp", ContatoFormatUtil.arrredondarNumero((Double)valorEstimadoImp, (int)2));
        if (valorProduto + valorServico > 0.0) {
            h.put("aliqEstimadaImp", ContatoFormatUtil.arrredondarNumero((Double)(valorEstimadoImp / (valorProduto + valorServico) * 100.0), (int)2));
        } else {
            h.put("aliqEstimadaImp", ContatoFormatUtil.arrredondarNumero((Double)0.0, (int)2));
        }
        h.put("valorFCP", ContatoFormatUtil.arrredondarNumero((Double)valorFCP, (int)2));
        h.put("valorFCPSt", ContatoFormatUtil.arrredondarNumero((Double)valorFCPSt, (int)2));
        h.put("valorFCPStRetido", ContatoFormatUtil.arrredondarNumero((Double)valorFCPStRetido, (int)2));
        h.put("valorIpiDevolucao", ContatoFormatUtil.arrredondarNumero((Double)valorIpiDevolucao, (int)2));
        h.put("valorIcmsDiferimento", ContatoFormatUtil.arrredondarNumero((Double)valorIcmsDiferimento, (int)2));
        h.put("valorSenar", ContatoFormatUtil.arrredondarNumero((Double)valorSenar, (int)2));
        h.put("valorRat", ContatoFormatUtil.arrredondarNumero((Double)valorRat, (int)2));
        h.put("valorTaxaSanidadeAnimal", ContatoFormatUtil.arrredondarNumero((Double)valorTaxaSanidadeAnimal, (int)2));
        h.put("valorIcmsDesonerado", ContatoFormatUtil.arrredondarNumero((Double)valorIcmsDesonerado, (int)2));
        return h;
    }

    public static HashMap calcularTotalizadoresLivroFiscal(List itens) {
        HashMap<String, Double> h = new HashMap<String, Double>();
        if (itens == null) {
            return h;
        }
        double valorIcmsTributado = 0.0;
        double valorIcms = 0.0;
        double bcICMST = 0.0;
        double valorICMST = 0.0;
        double valorIpiTributado = 0.0;
        double valorTotal = 0.0;
        double valorIcmsIsento = 0.0;
        double valorIcmsOutros = 0.0;
        double valorIpiOutros = 0.0;
        double valorIpiIsento = 0.0;
        double valorIpiIndustria = 0.0;
        double valorIpiObservacao = 0.0;
        double valorIcmsSA = 0.0;
        double valorPis = 0.0;
        double valorCofins = 0.0;
        double valorIPIComercio = 0.0;
        double valorDifAliquota = 0.0;
        double valorBCPis = 0.0;
        double valorBCCofins = 0.0;
        double valorIcmsDiferimento = 0.0;
        for (Object o : itens) {
            LivroFiscal vo = (LivroFiscal)o;
            if (vo.getValorIcmsTributado() != null) {
                valorIcmsTributado += vo.getValorIcmsTributado().doubleValue();
            } else {
                vo.setValorIcmsTributado(Double.valueOf(0.0));
            }
            if (vo.getValorIcms() != null) {
                valorIcms += vo.getValorIcms().doubleValue();
            } else {
                vo.setValorIcms(Double.valueOf(0.0));
            }
            if (vo.getValorIcmsOutros() != null) {
                valorIcmsOutros += vo.getValorIcmsOutros().doubleValue();
            } else {
                vo.setValorIcmsOutros(Double.valueOf(0.0));
            }
            if (vo.getValorBCIcmsSt() != null) {
                bcICMST += vo.getValorBCIcmsSt().doubleValue();
            } else {
                vo.setValorBCIcmsSt(Double.valueOf(0.0));
            }
            if (vo.getValorIcmsSt() != null) {
                valorICMST += vo.getValorIcmsSt().doubleValue();
            } else {
                vo.setValorIcmsSt(Double.valueOf(0.0));
            }
            if (vo.getValorIpiTributado() != null) {
                valorIpiTributado += vo.getValorIpiTributado().doubleValue();
            } else {
                vo.setValorIpiTributado(Double.valueOf(0.0));
            }
            if (vo.getValorIpiIsento() != null) {
                valorIpiIsento += vo.getValorIpiIsento().doubleValue();
            } else {
                vo.setValorIpiIsento(Double.valueOf(0.0));
            }
            if (vo.getValorIpiIndustria() != null) {
                valorIpiIndustria += vo.getValorIpiIndustria().doubleValue();
            } else {
                vo.setValorIpiIndustria(Double.valueOf(0.0));
            }
            if (vo.getValorIpiOutros() != null) {
                valorIpiOutros += vo.getValorIpiOutros().doubleValue();
            } else {
                vo.setValorIpiOutros(Double.valueOf(0.0));
            }
            if (vo.getValorTotal() != null) {
                valorTotal += vo.getValorTotal().doubleValue();
            } else {
                vo.setValorTotal(Double.valueOf(0.0));
            }
            if (vo.getValorIpiObservacao() != null) {
                valorIpiObservacao += vo.getValorIpiObservacao().doubleValue();
            } else {
                vo.setValorIpiObservacao(Double.valueOf(0.0));
            }
            if (vo.getValorIcmsSemAprov() != null) {
                valorIcmsSA += vo.getValorIcmsSemAprov().doubleValue();
            } else {
                vo.setValorIcmsSemAprov(Double.valueOf(0.0));
            }
            if (vo.getValorIpiComercio() != null) {
                valorIPIComercio += vo.getValorIpiComercio().doubleValue();
            } else {
                vo.setValorIpiComercio(Double.valueOf(0.0));
            }
            if (vo.getValorPis() != null) {
                valorPis += vo.getValorPis().doubleValue();
            } else {
                vo.setValorPis(Double.valueOf(0.0));
            }
            if (vo.getValorCofins() != null) {
                valorCofins += vo.getValorCofins().doubleValue();
            } else {
                vo.setValorCofins(Double.valueOf(0.0));
            }
            if (vo.getValorIcmsIsento() != null) {
                valorIcmsIsento += vo.getValorIcmsIsento().doubleValue();
            } else {
                vo.setValorIcmsIsento(Double.valueOf(0.0));
            }
            if (vo.getValorDifAliquota() != null) {
                valorDifAliquota += vo.getValorDifAliquota().doubleValue();
            } else {
                vo.setValorDifAliquota(Double.valueOf(0.0));
            }
            if (vo.getVrBCPis() != null) {
                valorBCPis += vo.getVrBCPis().doubleValue();
            } else {
                vo.setVrBCPis(Double.valueOf(0.0));
            }
            if (vo.getVrBCCofins() != null) {
                valorBCCofins += vo.getVrBCCofins().doubleValue();
            } else {
                vo.setVrBCCofins(Double.valueOf(0.0));
            }
            if (vo.getValorIcmsDiferimento() != null) {
                valorIcmsDiferimento += vo.getValorIcmsDiferimento().doubleValue();
                continue;
            }
            vo.setValorIcmsDiferimento(Double.valueOf(0.0));
        }
        h.put("valorIcmsDiferimento", ContatoFormatUtil.arrredondarNumero((Double)valorIcmsDiferimento, (int)2));
        h.put("vlrTotal", ContatoFormatUtil.arrredondarNumero((Double)valorTotal, (int)2));
        h.put("vlrIpiIsento", ContatoFormatUtil.arrredondarNumero((Double)valorIpiIsento, (int)2));
        h.put("vlrIpiOutros", ContatoFormatUtil.arrredondarNumero((Double)valorIpiOutros, (int)2));
        h.put("bcIpi", ContatoFormatUtil.arrredondarNumero((Double)valorIpiTributado, (int)2));
        h.put("vlrIpiObs", ContatoFormatUtil.arrredondarNumero((Double)valorIpiObservacao, (int)2));
        h.put("vlrIpiInd", ContatoFormatUtil.arrredondarNumero((Double)valorIpiIndustria, (int)2));
        h.put("vlrIcmsSA", ContatoFormatUtil.arrredondarNumero((Double)valorIcmsSA, (int)2));
        h.put("bcIcmsSt", ContatoFormatUtil.arrredondarNumero((Double)bcICMST, (int)2));
        h.put("vlrIcmsSt", ContatoFormatUtil.arrredondarNumero((Double)valorICMST, (int)2));
        h.put("vlrPis", ContatoFormatUtil.arrredondarNumero((Double)valorPis, (int)2));
        h.put("vlrCofins", ContatoFormatUtil.arrredondarNumero((Double)valorCofins, (int)2));
        h.put("vlrIcms", ContatoFormatUtil.arrredondarNumero((Double)valorIcms, (int)2));
        h.put("vlrIcmsIsento", ContatoFormatUtil.arrredondarNumero((Double)valorIcmsIsento, (int)2));
        h.put("vlrIcmsTrib", ContatoFormatUtil.arrredondarNumero((Double)valorIcmsTributado, (int)2));
        h.put("vlrIcmsOutros", ContatoFormatUtil.arrredondarNumero((Double)valorIcmsOutros, (int)2));
        h.put("vlrIpiComercio", ContatoFormatUtil.arrredondarNumero((Double)valorIPIComercio, (int)2));
        h.put("valorDifAliquota", ContatoFormatUtil.arrredondarNumero((Double)valorDifAliquota, (int)2));
        h.put("valorBcCofins", ContatoFormatUtil.arrredondarNumero((Double)valorBCCofins, (int)2));
        h.put("vlrBCPis", ContatoFormatUtil.arrredondarNumero((Double)valorBCPis, (int)2));
        return h;
    }

    public Double getAliquotaIPI(ModeloFiscalIpi modeloFiscalIpi, Produto produto) {
        Double aliquotaIpi = BaseCalculoValores.getAliquotaIpi((Produto)produto, (ModeloFiscalIpi)modeloFiscalIpi);
        return aliquotaIpi;
    }

    public UnidadeFederativa getUfConsumoComb(Cfop cf, UnidadeFederativa uf) {
        String cfop;
        if (cf != null && ((cfop = cf.getCodigo()).equals("1.651") || cfop.equals("1.652") || cfop.equals("1.653") || cfop.equals("1.658") || cfop.equals("1.659") || cfop.equals("1.660") || cfop.equals("1.661") || cfop.equals("1.662") || cfop.equals("1.663") || cfop.equals("1.664") || cfop.equals("2.651") || cfop.equals("2.652") || cfop.equals("2.653") || cfop.equals("2.658") || cfop.equals("2.659") || cfop.equals("2.660") || cfop.equals("2.661") || cfop.equals("2.662") || cfop.equals("2.663") || cfop.equals("2.664") || cfop.equals("3.651") || cfop.equals("3.652") || cfop.equals("3.653") || cfop.equals("5.651") || cfop.equals("5.652") || cfop.equals("5.653") || cfop.equals("5.654") || cfop.equals("5.655") || cfop.equals("5.656") || cfop.equals("5.657") || cfop.equals("5.658") || cfop.equals("5.659") || cfop.equals("5.660") || cfop.equals("5.661") || cfop.equals("5.662") || cfop.equals("5.663") || cfop.equals("5.664") || cfop.equals("5.665") || cfop.equals("5.666") || cfop.equals("5.667") || cfop.equals("6.651") || cfop.equals("6.652") || cfop.equals("6.653") || cfop.equals("6.654") || cfop.equals("6.655") || cfop.equals("6.656") || cfop.equals("6.657") || cfop.equals("6.658") || cfop.equals("6.659") || cfop.equals("6.660") || cfop.equals("6.661") || cfop.equals("6.662") || cfop.equals("6.663") || cfop.equals("6.664") || cfop.equals("6.665") || cfop.equals("6.666") || cfop.equals("6.667") || cfop.equals("7.651") || cfop.equals("7.654") || cfop.equals("7.667"))) {
            return uf;
        }
        return null;
    }

    public Double getAliquotaPis(ModeloFiscalPisCofins modeloFiscalPis, Produto produto) {
        Double aliquota = BaseCalculoValores.getAliquotaPis((Produto)produto, (ModeloFiscalPisCofins)modeloFiscalPis);
        return aliquota;
    }

    public Double getAliquotaCofins(ModeloFiscalPisCofins modeloFiscalCofins, Produto produto) {
        Double aliquota = BaseCalculoValores.getAliquotaCofins((Produto)produto, (ModeloFiscalPisCofins)modeloFiscalCofins);
        return aliquota;
    }

    public Double getAliquotaPisSt(ModeloFiscalPisCofins modeloFiscalPis, Produto produto) {
        Double aliquotaPis = BaseCalculoValores.getAliquotaPisST((Produto)produto, (ModeloFiscalPisCofins)modeloFiscalPis);
        return aliquotaPis;
    }

    public Double getAliquotaCofinsSt(ModeloFiscalPisCofins modeloFiscalCofins, Produto produto) {
        Double aliquota = BaseCalculoValores.getAliquotaCofinsST((Produto)produto, (ModeloFiscalPisCofins)modeloFiscalCofins);
        return aliquota;
    }
}

