/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.obsfaturamento;

import com.touchcomp.basementor.constants.enums.modelofiscal.EnumConstModeloFiscalObs;
import com.touchcomp.basementor.constants.enums.obsfaturamento.EnumConstObsFaturamentoTipo;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.DadosContainer;
import com.touchcomp.basementor.model.vo.DocumentosRefNFProdutorPR;
import com.touchcomp.basementor.model.vo.DocumentosRefNFPropriaPR;
import com.touchcomp.basementor.model.vo.DocumentosRefNFTerceirosPR;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.EnderecoTranspRedes;
import com.touchcomp.basementor.model.vo.GradeItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.GrupoDocumentosRefPR;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalObsContrib;
import com.touchcomp.basementor.model.vo.ModeloFiscalObsFisco;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.ObsFaturamento;
import com.touchcomp.basementor.model.vo.ObsIntFiscoPedido;
import com.touchcomp.basementor.model.vo.ObservacaoIntFiscalNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ObservacaoIntFiscoNFTerceiros;
import com.touchcomp.basementor.model.vo.ObservacaoNotaPropria;
import com.touchcomp.basementor.model.vo.ObservacaoNotaTerceiros;
import com.touchcomp.basementor.model.vo.ObservacaoPedidoFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.ProcessoImportacao;
import com.touchcomp.basementor.model.vo.TicketFiscal;
import com.touchcomp.basementor.model.vo.TransportadorRedespacho;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.obsdinamica.CompOBSDinamica;
import com.touchcomp.basementorservice.components.obsfaturamento.CompOBSFaturamento;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.DateUtil;

public class ObsFaturamentoUtilities {
    private static TLogger logger = TLogger.get(ObsFaturamentoUtilities.class);

    private static Object getFixedValue(String valor, NotaFiscalPropria est) throws ExceptionService {
        String ret = null;
        if (valor == null) {
            return null;
        }
        ret = ObsFaturamentoUtilities.getDadosRedespacho(valor, est);
        if (ret != null) {
            return ret;
        }
        ret = ObsFaturamentoUtilities.getDadosEnderecoEntrega(valor, est);
        if (ret != null) {
            return ret;
        }
        ret = ObsFaturamentoUtilities.getDadosNota(valor, est);
        if (ret != null) {
            return ret;
        }
        ret = ObsFaturamentoUtilities.getDadosPedido(valor, est);
        if (ret != null) {
            return ret;
        }
        ret = ObsFaturamentoUtilities.getDadosSuframa(valor, est);
        if (ret != null) {
            return ret;
        }
        ret = ObsFaturamentoUtilities.getDadosProcessoImportacao(valor, est);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    private static Double getVrIcmsDispensado(NotaFiscalPropria est) {
        Double vlr = 0.0;
        for (Object o : est.getItensNotaPropria()) {
            ItemNotaFiscalPropria i = (ItemNotaFiscalPropria)o;
            vlr = vlr + i.getItemNotaLivroFiscal().getVrIcmsDesonerado();
        }
        return vlr;
    }

    private static String buildOBS(ObsFaturamento obs, String texto, NotaFiscalPropria n) {
        EnumConstObsFaturamentoTipo tipo = EnumConstObsFaturamentoTipo.get((Object)obs.getTipoObsNormalDinamica());
        if (ToolMethods.isEquals((Object)tipo, (Object)EnumConstObsFaturamentoTipo.OBS_DINAMICA) && obs.getObservacaoDinamica() != null) {
            try {
                CompOBSDinamica comp = (CompOBSDinamica)ConfApplicationContext.getBean(CompOBSDinamica.class);
                return comp.build((Object)n, obs.getObservacaoDinamica().getObservacao());
            }
            catch (Exception ex) {
                logger.error(ex.getClass(), (Throwable)ex);
                throw new RuntimeException("Verifique a OBS " + String.valueOf(obs) + "\n" + ex.getMessage());
            }
        }
        try {
            String st = ObsFaturamentoUtilities.buildObsEstoqueTerceiros(texto, n);
            List token = ToolString.getReplaceTokens((String)st);
            HashMap<String, Object> m = new HashMap<String, Object>();
            for (Object o : token) {
                StringToken sk = (StringToken)o;
                Object retorno = ObsFaturamentoUtilities.getFixedValue(sk.getChave(), n);
                if (retorno == null) continue;
                m.put(sk.getChave(), retorno);
            }
            st = ToolString.build((String)st, m);
            return st;
        }
        catch (ExceptionService e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String buildOBS(EnumConstObsFaturamentoTipo tipo, String obsFat, NotaFiscalTerceiros n) {
        if (ToolMethods.isEquals((Object)tipo, (Object)EnumConstObsFaturamentoTipo.OBS_DINAMICA)) {
            try {
                CompOBSDinamica comp = (CompOBSDinamica)ConfApplicationContext.getBean(CompOBSDinamica.class);
                return comp.build((Object)n, obsFat);
            }
            catch (Exception ex) {
                logger.error(ex.getClass(), (Throwable)ex);
                throw new RuntimeException(ex.getMessage());
            }
        }
        return obsFat;
    }

    private static String returnNrNFRef(GrupoDocumentosRefPR grupo) {
        List notasTerceiros;
        List notasProprias;
        Object nr = "";
        if (grupo == null) {
            return nr;
        }
        List notasProdutor = grupo.getNotasProdutor();
        if (notasProdutor != null) {
            for (Iterator o : notasProdutor) {
                DocumentosRefNFProdutorPR c = (DocumentosRefNFProdutorPR)o;
                nr = (String)nr + c.getNumero().toString() + ",";
            }
        }
        if ((notasProprias = grupo.getNotasProprias()) != null) {
            for (Object o : notasProprias) {
                DocumentosRefNFPropriaPR c = (DocumentosRefNFPropriaPR)o;
                if (c.getNotaFiscalPropria() == null) continue;
                nr = (String)nr + c.getNotaFiscalPropria().getNumeroNota().toString() + ",";
            }
        }
        if ((notasTerceiros = grupo.getNotasTerceiros()) != null) {
            for (Object o : notasTerceiros) {
                DocumentosRefNFTerceirosPR c = (DocumentosRefNFTerceirosPR)o;
                if (c.getNotaFiscalTerceiros() == null) continue;
                nr = (String)nr + c.getNotaFiscalTerceiros().getNumeroNota().toString() + ",";
            }
        }
        if (((String)nr).trim().length() > 2) {
            nr = ((String)nr).substring(0, ((String)nr).length() - 1);
        }
        if (((String)nr).trim().length() > 0) {
            return nr;
        }
        return null;
    }

    private static String buildObsEstoqueTerceiros(String st, NotaFiscalPropria n) {
        StringBuilder sb = new StringBuilder();
        if (st != null && (st.contains("dtEmissaoNotaInd") || st.contains("fornecedorNotaInd") || st.contains("numeroNotaInd") || st.contains("valorNotaInd") || st.contains("produtoNotaInd") || st.contains("serieNotaInd"))) {
            HashSet itens = ObsFaturamentoUtilities.getItensTerceirosSet(n);
            List tokensValues = ObsFaturamentoUtilities.getTokensValues(itens);
            for (Object o : tokensValues) {
                HashMap h1 = (HashMap)o;
                sb.append(ToolString.build((String)st, (Map)h1));
            }
        } else {
            sb.append(st);
        }
        return sb.toString();
    }

    private static HashSet getItensTerceirosSet(NotaFiscalPropria n) {
        HashSet<Object> h = new HashSet<Object>();
        for (Object o : n.getItensNotaPropria()) {
            ItemNotaFiscalPropria i = (ItemNotaFiscalPropria)o;
            for (GradeItemNotaFiscalPropria g : i.getGradesNotaFiscalPropria()) {
                if (g.getEstoqueTerceiros() == null || g.getEstoqueTerceiros().getEstoqueTerceirosMae() == null) continue;
                if (g.getEstoqueTerceiros().getEstoqueTerceirosMae().getGradeItemNotaTerceiros() != null && !h.contains(g.getEstoqueTerceiros().getEstoqueTerceirosMae().getGradeItemNotaTerceiros().getItemNotaTerceiros())) {
                    h.add(g.getEstoqueTerceiros().getEstoqueTerceirosMae().getGradeItemNotaTerceiros().getItemNotaTerceiros());
                    continue;
                }
                if (g.getEstoqueTerceiros().getEstoqueTerceirosMae().getGradeItemNotaPropria() == null || h.contains(g.getEstoqueTerceiros().getEstoqueTerceirosMae().getGradeItemNotaPropria().getItemNotaFiscalPropria())) continue;
                h.add(g.getEstoqueTerceiros().getEstoqueTerceirosMae().getGradeItemNotaPropria().getItemNotaFiscalPropria());
            }
        }
        return h;
    }

    private static List getTokensValues(HashSet h) {
        ArrayList ret = new ArrayList();
        for (Object o : h) {
            HashMap<String, String> h1 = new HashMap<String, String>();
            ItemNotaTerceiros i = null;
            if (o instanceof ItemNotaTerceiros) {
                i = (ItemNotaTerceiros)o;
            }
            if (o instanceof ItemNotaFiscalPropria) {
                n = ((ItemNotaFiscalPropria)o).getNotaFiscalPropria();
                h1.put("dtEmissaoNotaInd", DateUtil.dateToStr(n.getDataEmissaoNota()));
                h1.put("produtoNotaInd", ((ItemNotaFiscalPropria)o).getProduto().getNome());
                h1.put("numeroNotaInd", n.getNumeroNota().toString());
                h1.put("serieNotaInd", n.getSerie());
                h1.put("fornecedorNotaInd", n.getUnidadeFatCliente().getCliente().getPessoa().getNome());
                h1.put("valorNotaInd", ContatoFormatUtil.formataNumero((Number)n.getValoresNfPropria().getValorTotal(), (int)2));
            } else if (o instanceof ItemNotaTerceiros) {
                n = ((ItemNotaTerceiros)o).getNotaFiscalTerceiros();
                h1.put("dtEmissaoNotaInd", DateUtil.dateToStr(i.getNotaFiscalTerceiros().getDataEmissao()));
                h1.put("produtoNotaInd", i.getProduto().getNome());
                h1.put("numeroNotaInd", n.getNumeroNota().toString());
                h1.put("serieNotaInd", n.getSerie());
                h1.put("fornecedorNotaInd", n.getUnidadeFatFornecedor().getFornecedor().getPessoa().getNome());
                h1.put("valorNotaInd", ContatoFormatUtil.formataNumero((Number)n.getValoresNfTerceiros().getValorTotal(), (int)2));
            }
            ret.add(h1);
        }
        return ret;
    }

    private static Object getValoresTokenPedido(String chave, NotaFiscalPropria nf) throws ExceptionService {
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("nota", nf);
        HashMap h = (HashMap)CoreServiceFactory.getServicePedido().execute(r, "findDadosPedidosObs");
        return h.get(chave);
    }

    private static String getDadosRedespacho(String valor, NotaFiscalPropria est) {
        TransportadorRedespacho u = est.getTransportadorRedespacho();
        if (u == null) {
            return null;
        }
        if (valor.equalsIgnoreCase("redespacho")) {
            return u.getNome();
        }
        EnderecoTranspRedes end = u.getEndereco();
        if (end == null) {
            return null;
        }
        if (valor.equalsIgnoreCase("uf redespacho") && end.getCidade() != null) {
            String ret = end.getCidade().getUf().getSigla();
            return ret == null ? "" : ret;
        }
        if (valor.equalsIgnoreCase("bairro redespacho")) {
            String ret = end.getBairro();
            return ret == null ? "" : ret;
        }
        if (valor.equalsIgnoreCase("cep redespacho")) {
            String ret = end.getCep();
            return ret == null ? "" : ret;
        }
        if (valor.equalsIgnoreCase("cidade redespacho") && end.getCidade() != null) {
            String ret = end.getCidade().getDescricao();
            return ret == null ? "" : ret;
        }
        if (valor.equalsIgnoreCase("endereco redespacho")) {
            String ret = end.getLogradouro();
            return ret == null ? "" : ret;
        }
        if (valor.equalsIgnoreCase("numero redespacho")) {
            String ret = end.getNumero();
            return ret == null ? "" : ret;
        }
        if (valor.equalsIgnoreCase("telefone redespacho") && u.getComplemento() != null) {
            String ret = u.getComplemento().getFone1();
            return ret == null ? "" : ret;
        }
        return null;
    }

    private static String getDadosEnderecoEntrega(String valor, NotaFiscalPropria est) {
        if (est.getInformarLocalEntregaNFPropria() == null || est.getInformarLocalEntregaNFPropria() == 0 || est.getLocalEntregaNFPropria() == null || est.getLocalEntregaNFPropria().getEnderecoEntrega() == null) {
            return null;
        }
        Endereco u = est.getLocalEntregaNFPropria().getEnderecoEntrega();
        if (valor.equalsIgnoreCase("endereco entrega bairro")) {
            String ret = u.getBairro();
            return ret == null ? "" : ret;
        }
        if (valor.equalsIgnoreCase("endereco entrega cep")) {
            String ret = u.getCep();
            return ret == null ? "" : ret;
        }
        if (valor.equalsIgnoreCase("endereco entrega cidade")) {
            String ret = u.getCidade().getDescricao();
            return ret == null ? "" : ret;
        }
        if (valor.equalsIgnoreCase("endereco entrega endereco")) {
            String ret = u.getLogradouro();
            return ret == null ? "" : ret;
        }
        if (valor.equalsIgnoreCase("endereco entrega numero")) {
            String ret = u.getNumero();
            return ret == null ? "" : ret;
        }
        if (valor.equalsIgnoreCase("endereco entrega uf")) {
            String ret = u.getCidade().getUf().getSigla();
            return ret == null ? "" : ret;
        }
        if (valor.equalsIgnoreCase("endereco entrega referencia")) {
            String ret = u.getReferencia();
            return ret == null ? "" : ret;
        }
        if (valor.equalsIgnoreCase("endereco entrega observacao")) {
            String ret = u.getObservacao();
            return ret == null ? "" : ret;
        }
        return null;
    }

    private static String getDadosNota(String valor, NotaFiscalPropria est) {
        UnidadeFatCliente u = est.getUnidadeFatCliente();
        if (valor.equalsIgnoreCase("uf cliente")) {
            return u.getCliente().getPessoa().getEndereco().getCidade().getUf().getSigla();
        }
        if (valor.equalsIgnoreCase("idCliente")) {
            return u.getCliente().getIdentificador().toString();
        }
        if (valor.equalsIgnoreCase("nomeCliente")) {
            return u.getCliente().getPessoa().getNome();
        }
        if (valor.equalsIgnoreCase("codigoCliente")) {
            if (u.getCliente().getCodigoCliente() != null) {
                return u.getCliente().getCodigoCliente();
            }
            return "";
        }
        if (valor.equalsIgnoreCase("uf empresa")) {
            return est.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getSigla();
        }
        if (valor.equalsIgnoreCase("numeroNotaRef")) {
            String ret = ObsFaturamentoUtilities.returnNrNFRef(est.getGrupoDocumentosRefPR());
            return ret == null ? "" : ret;
        }
        if (valor.equalsIgnoreCase("numeroTicketFiscal")) {
            String ret = ObsFaturamentoUtilities.returnNrTicketFiscal(est.getTicketsFiscal());
            return ret == null ? "" : ret;
        }
        if (valor.equalsIgnoreCase("vr icms dispensado")) {
            Double f = ObsFaturamentoUtilities.getVrIcmsDispensado(est);
            if (f == null || f <= 0.0) {
                f = 0.0;
            }
            return ContatoFormatUtil.formataNumero((Number)f, (int)2);
        }
        if (valor.equalsIgnoreCase("valorPrevImpostos")) {
            return ContatoFormatUtil.formataNumero((Number)est.getValoresNfPropria().getValorEstImpostos(), (int)2);
        }
        if (valor.equalsIgnoreCase("aliquotaPrevImpostos")) {
            return ContatoFormatUtil.formataNumero((Number)est.getValoresNfPropria().getAliquotaEstImpostos(), (int)2);
        }
        if (valor.equalsIgnoreCase("valorTotalNota")) {
            return ContatoFormatUtil.formataNumero((Number)est.getValoresNfPropria().getValorTotal(), (int)2);
        }
        if (valor.equalsIgnoreCase("valorTotalProdutos")) {
            return ContatoFormatUtil.formataNumero((Number)(est.getValoresNfPropria().getValorProduto() + est.getValoresNfPropria().getValorServico()), (int)2);
        }
        if (valor.equalsIgnoreCase("percDesconto")) {
            double percDesc = 0.0;
            for (ItemNotaFiscalPropria it : est.getItensNotaPropria()) {
                percDesc += it.getPercDesconto().doubleValue();
            }
            return ContatoFormatUtil.formataNumero((Number)(percDesc / (double)est.getItensNotaPropria().size()), (int)2);
        }
        if (valor.equalsIgnoreCase("percDespAcess")) {
            double percDesc = 0.0;
            for (ItemNotaFiscalPropria it : est.getItensNotaPropria()) {
                percDesc += it.getPercDespAcessoria().doubleValue();
            }
            return ContatoFormatUtil.formataNumero((Number)(percDesc / (double)est.getItensNotaPropria().size()), (int)2);
        }
        if (valor.equalsIgnoreCase("percFrete")) {
            double percDesc = 0.0;
            for (ItemNotaFiscalPropria it : est.getItensNotaPropria()) {
                percDesc += it.getPercFrete().doubleValue();
            }
            return ContatoFormatUtil.formataNumero((Number)(percDesc / (double)est.getItensNotaPropria().size()), (int)2);
        }
        if (valor.equalsIgnoreCase("percSeguro")) {
            double percDesc = 0.0;
            for (ItemNotaFiscalPropria it : est.getItensNotaPropria()) {
                percDesc += it.getPercSeguro().doubleValue();
            }
            return ContatoFormatUtil.formataNumero((Number)(percDesc / (double)est.getItensNotaPropria().size()), (int)2);
        }
        if (valor.equalsIgnoreCase("valorDesconto")) {
            return ContatoFormatUtil.formataNumero((Number)est.getValoresNfPropria().getValorDesconto(), (int)2);
        }
        if (valor.equalsIgnoreCase("valorSeguro")) {
            return ContatoFormatUtil.formataNumero((Number)est.getValoresNfPropria().getValorSeguro(), (int)2);
        }
        if (valor.equalsIgnoreCase("valorDespAcess")) {
            return ContatoFormatUtil.formataNumero((Number)est.getValoresNfPropria().getValorDespAcess(), (int)2);
        }
        if (valor.equalsIgnoreCase("valorFrete")) {
            return ContatoFormatUtil.formataNumero((Number)est.getValoresNfPropria().getValorFrete(), (int)2);
        }
        if (valor.equalsIgnoreCase("valorIcmsSimples")) {
            Double f = ObsFaturamentoUtilities.getVrIcmsSimples(est);
            if (f == null || f <= 0.0) {
                f = 0.0;
            }
            return ContatoFormatUtil.formataNumero((Number)f, (int)2);
        }
        if (valor.equalsIgnoreCase("aliqIcmsSimples")) {
            Double f = ObsFaturamentoUtilities.getAliqIcmsSimples(est);
            if (f == null || f <= 0.0) {
                f = 0.0;
            }
            return ContatoFormatUtil.formataNumero((Number)f, (int)2);
        }
        if (valor.equalsIgnoreCase("valorIcmsPartilhaRem")) {
            Double f = ObsFaturamentoUtilities.getValorIcmsRem(est);
            if (f == null || f <= 0.0) {
                f = 0.0;
            }
            return ContatoFormatUtil.formataNumero((Number)f, (int)2);
        }
        if (valor.equalsIgnoreCase("valorIcmsPartilhaDest")) {
            Double f = ObsFaturamentoUtilities.getValorIcmsDest(est);
            if (f == null || f <= 0.0) {
                f = 0.0;
            }
            return ContatoFormatUtil.formataNumero((Number)f, (int)2);
        }
        if (valor.equalsIgnoreCase("valorIcmsPartilhaTotal")) {
            Double f = ObsFaturamentoUtilities.getValorIcmsDest(est);
            if ((f = Double.valueOf(f + ObsFaturamentoUtilities.getValorIcmsRem(est))) == null || f <= 0.0) {
                f = 0.0;
            }
            return ContatoFormatUtil.formataNumero((Number)f, (int)2);
        }
        if (valor.equalsIgnoreCase("valorIcmsFundoPobreza")) {
            Double f = ObsFaturamentoUtilities.getValorIcmsFundoPobreza(est);
            if (f == null || f <= 0.0) {
                f = 0.0;
            }
            return ContatoFormatUtil.formataNumero((Number)f, (int)2);
        }
        if (valor.equalsIgnoreCase("valorIcmsDest+IcmsFundoPobreza")) {
            Double f = ObsFaturamentoUtilities.getValorIcmsFundoPobreza(est);
            if ((f = Double.valueOf(f + ObsFaturamentoUtilities.getValorIcmsDest(est))) == null || f <= 0.0) {
                f = 0.0;
            }
            return ContatoFormatUtil.formataNumero((Number)f, (int)2);
        }
        if (valor.equalsIgnoreCase("valorFCP")) {
            Double f = ObsFaturamentoUtilities.getValorFCP(est);
            if (f == null || f <= 0.0) {
                f = 0.0;
            }
            return ContatoFormatUtil.formataNumero((Number)f, (int)2);
        }
        if (valor.equalsIgnoreCase("valorFCPSt")) {
            Double f = ObsFaturamentoUtilities.getValorFCPSt(est);
            if (f == null || f <= 0.0) {
                f = 0.0;
            }
            return ContatoFormatUtil.formataNumero((Number)f, (int)2);
        }
        if (valor.equalsIgnoreCase("valorFCPStRetido")) {
            Double f = ObsFaturamentoUtilities.getValorFCPStRetido(est);
            if (f == null || f <= 0.0) {
                f = 0.0;
            }
            return ContatoFormatUtil.formataNumero((Number)f, (int)2);
        }
        return null;
    }

    private static String getDadosPedido(String valor, NotaFiscalPropria est) throws ExceptionService {
        if (valor.equalsIgnoreCase("identificadorPedCliente")) {
            Long id = (Long)ObsFaturamentoUtilities.getValoresTokenPedido("ID_PEDIDO", est);
            return id == null ? "" : id.toString();
        }
        if (valor.equalsIgnoreCase("nomeRepresentantePed")) {
            String ret = (String)ObsFaturamentoUtilities.getValoresTokenPedido("NOME_REPRESENTANTE", est);
            return ret == null ? "" : ret;
        }
        if (valor.equalsIgnoreCase("numeroPedCliente")) {
            String ret = (String)ObsFaturamentoUtilities.getValoresTokenPedido("NR_PED_CLIENTE", est);
            return ret == null ? "" : ret;
        }
        if (valor.equalsIgnoreCase("observacaoPedido")) {
            String ret = (String)ObsFaturamentoUtilities.getValoresTokenPedido("OBSERVACAO_PEDIDO", est);
            return ret == null ? "" : ret;
        }
        if (valor.equalsIgnoreCase("identifcadorRepresentatePed")) {
            Long id = (Long)ObsFaturamentoUtilities.getValoresTokenPedido("ID_REPRESENTANTE", est);
            return id == null ? "" : id.toString();
        }
        if (valor.equalsIgnoreCase("dataEmissaoPed")) {
            Date data = (Date)ObsFaturamentoUtilities.getValoresTokenPedido("DATA_EMISSAO", est);
            return data == null ? "" : DateUtil.dateToStr(data);
        }
        if (valor.equalsIgnoreCase("pedidoCodPedido")) {
            Long cod = (Long)ObsFaturamentoUtilities.getValoresTokenPedido("COD_PEDIDO", est);
            return cod == null ? "" : cod.toString();
        }
        if (valor.equalsIgnoreCase("pedidoNrSequencial")) {
            Integer nrSequencial = (Integer)ObsFaturamentoUtilities.getValoresTokenPedido("NR_SEQUENCIAL", est);
            return nrSequencial == null ? "" : nrSequencial.toString();
        }
        if (valor.equalsIgnoreCase("pedidoVolume")) {
            Double volumeTotal = (Double)ObsFaturamentoUtilities.getValoresTokenPedido("VOLUME_TOTAL", est);
            return volumeTotal == null ? "0" : ContatoFormatUtil.formataNumero((Number)volumeTotal, (int)2);
        }
        return null;
    }

    private static String getDadosSuframa(String valor, NotaFiscalPropria est) {
        Cliente cl = est.getUnidadeFatCliente().getCliente();
        if (valor.equalsIgnoreCase("inscricao suframa")) {
            String ret = est.getInscricaoSuframa();
            return ret == null ? "" : ret;
        }
        if (valor.equalsIgnoreCase("perc desconto icms suframa")) {
            return ContatoFormatUtil.formataNumero((Number)cl.getFaturamento().getPercentualIcmsSufr(), (int)2);
        }
        if (valor.equalsIgnoreCase("perc desconto ipi suframa")) {
            return ContatoFormatUtil.formataNumero((Number)cl.getFaturamento().getPercentualIpiSufr(), (int)2);
        }
        if (valor.equalsIgnoreCase("perc desconto pis cofins suframa")) {
            return ContatoFormatUtil.formataNumero((Number)(cl.getFaturamento().getPercentualPisSufr() + cl.getFaturamento().getPercentualCofinsSufr()), (int)2);
        }
        if (valor.equalsIgnoreCase("perc desconto total suframa")) {
            return ContatoFormatUtil.formataNumero((Number)(cl.getFaturamento().getPercentualPisSufr() + cl.getFaturamento().getPercentualCofinsSufr() + cl.getFaturamento().getPercentualIpiSufr() + cl.getFaturamento().getPercentualIcmsSufr()), (int)2);
        }
        return null;
    }

    private static Double getVrIcmsSimples(NotaFiscalPropria est) {
        Double vlr = 0.0;
        for (Object o : est.getItensNotaPropria()) {
            ItemNotaFiscalPropria i = (ItemNotaFiscalPropria)o;
            vlr = vlr + i.getItemNotaLivroFiscal().getValorICMSSimples();
        }
        return vlr;
    }

    private static Double getAliqIcmsSimples(NotaFiscalPropria est) {
        Double vlr;
        block0: {
            vlr = 0.0;
            Iterator iterator = est.getItensNotaPropria().iterator();
            if (!iterator.hasNext()) break block0;
            Object o = iterator.next();
            ItemNotaFiscalPropria i = (ItemNotaFiscalPropria)o;
            vlr = i.getItemNotaLivroFiscal().getAliquotaICMSSimples();
        }
        return vlr;
    }

    private static Double getValorIcmsDest(NotaFiscalPropria est) {
        Double vlr = 0.0;
        for (Object o : est.getItensNotaPropria()) {
            ItemNotaFiscalPropria i = (ItemNotaFiscalPropria)o;
            vlr = vlr + i.getItemNotaLivroFiscal().getValorIcmsPartilhaDest();
        }
        return vlr;
    }

    private static Double getValorIcmsRem(NotaFiscalPropria est) {
        Double vlr = 0.0;
        for (Object o : est.getItensNotaPropria()) {
            ItemNotaFiscalPropria i = (ItemNotaFiscalPropria)o;
            vlr = vlr + i.getItemNotaLivroFiscal().getValorIcmsPartilhaRem();
        }
        return vlr;
    }

    private static Double getValorIcmsFundoPobreza(NotaFiscalPropria est) {
        Double vlr = 0.0;
        for (Object o : est.getItensNotaPropria()) {
            ItemNotaFiscalPropria i = (ItemNotaFiscalPropria)o;
            vlr = vlr + i.getItemNotaLivroFiscal().getValorFundoPobreza();
        }
        return vlr;
    }

    private static Double getValorFCP(NotaFiscalPropria est) {
        Double vlr = 0.0;
        for (Object o : est.getItensNotaPropria()) {
            ItemNotaFiscalPropria i = (ItemNotaFiscalPropria)o;
            vlr = vlr + i.getItemNotaLivroFiscal().getValorFCP();
        }
        return vlr;
    }

    private static Double getValorFCPSt(NotaFiscalPropria est) {
        Double vlr = 0.0;
        for (Object o : est.getItensNotaPropria()) {
            ItemNotaFiscalPropria i = (ItemNotaFiscalPropria)o;
            vlr = vlr + i.getItemNotaLivroFiscal().getValorFCPSt();
        }
        return vlr;
    }

    private static Double getValorFCPStRetido(NotaFiscalPropria est) {
        Double vlr = 0.0;
        for (Object o : est.getItensNotaPropria()) {
            ItemNotaFiscalPropria i = (ItemNotaFiscalPropria)o;
            vlr = vlr + i.getItemNotaLivroFiscal().getValorFCPStRetido();
        }
        return vlr;
    }

    private static String getDadosProcessoImportacao(String valor, NotaFiscalPropria vo) {
        if (vo.getProcessoImportacao() == null) {
            return null;
        }
        ProcessoImportacao processo = vo.getProcessoImportacao();
        if (valor.equalsIgnoreCase("processo importacao bl")) {
            return processo.getBl() == null ? "" : processo.getBl();
        }
        if (valor.equalsIgnoreCase("processo importacao data chegada porto")) {
            return processo.getDataChegadaPorto() == null ? "" : DateUtil.dateToStr(processo.getDataChegadaPorto());
        }
        if (valor.equalsIgnoreCase("processo importacao data embarque")) {
            return processo.getDataEmbarque() == null ? "" : DateUtil.dateToStr(processo.getDataEmbarque());
        }
        if (valor.equalsIgnoreCase("processo importacao data encerramento")) {
            return processo.getDataEncerramento() == null ? "" : DateUtil.dateToStr(processo.getDataEncerramento());
        }
        if (valor.equalsIgnoreCase("processo importacao data fabrica")) {
            return processo.getDataFabrica() == null ? "" : DateUtil.dateToStr(processo.getDataFabrica());
        }
        if (valor.equalsIgnoreCase("processo importacao data registro di")) {
            return processo.getDataRegistroDI() == null ? "" : DateUtil.dateToStr(processo.getDataRegistroDI());
        }
        if (valor.equalsIgnoreCase("processo importacao invoice")) {
            return processo.getInvoice() == null ? "" : processo.getInvoice();
        }
        if (valor.equalsIgnoreCase("processo importacao navio")) {
            return processo.getNavio() == null ? "" : processo.getNavio();
        }
        if (valor.equalsIgnoreCase("processo importacao nr di")) {
            return processo.getNrDI() == null ? "" : processo.getNrDI();
        }
        if (valor.equalsIgnoreCase("processo importacao numero controle")) {
            return processo.getNumeroControle() == null ? "" : processo.getNumeroControle();
        }
        if (valor.equalsIgnoreCase("processo importacao referencia maritima")) {
            return processo.getReferenciaMaritima() == null ? "" : processo.getReferenciaMaritima();
        }
        if (valor.equalsIgnoreCase("processo importacao status documentacao")) {
            return processo.getStatusDocumentacao() == null ? "" : processo.getStatusDocumentacao().getDescricao();
        }
        if (valor.equalsIgnoreCase("processo importacao status financeiro")) {
            return processo.getStatusFinanceiro() == null ? "" : processo.getStatusFinanceiro().getDescricao();
        }
        if (valor.equalsIgnoreCase("processo importacao status fisico")) {
            return processo.getStatusFisico() == null ? "" : processo.getStatusFisico().getDescricao();
        }
        if (valor.equalsIgnoreCase("processo importacao valor")) {
            return processo.getValor() == null ? "" : ContatoFormatUtil.formataNumero((Number)processo.getValor(), (int)2);
        }
        if (valor.equalsIgnoreCase("processo importacao qtd container")) {
            return processo.getValor() == null ? "" : String.valueOf(processo.getDadosContainer().size());
        }
        if (valor.equalsIgnoreCase("processo importacao nome embaraco aduaneiro")) {
            return processo.getValor() == null ? "" : processo.getDesembaracoAduaneiro();
        }
        if (valor.equalsIgnoreCase("processo importacao nr container")) {
            return processo.getValor() == null ? "" : ObsFaturamentoUtilities.getNumerosContaineres(processo);
        }
        return null;
    }

    private static String getNumerosContaineres(ProcessoImportacao processo) {
        Object ret = "";
        int sizeCount = processo.getDadosContainer().size();
        for (DadosContainer d : processo.getDadosContainer()) {
            ret = (String)ret + d.getNumeroContainer();
            if (--sizeCount <= 0) continue;
            ret = (String)ret + ", ";
        }
        return ret;
    }

    private static String returnNrTicketFiscal(List<TicketFiscal> tickets) {
        Object nr = "";
        if (tickets == null || tickets.isEmpty()) {
            return nr;
        }
        for (TicketFiscal t : tickets) {
            nr = (String)nr + t.getNumero().toString() + ",";
        }
        if (((String)nr).trim().length() > 2) {
            nr = ((String)nr).substring(0, ((String)nr).length() - 1);
        }
        if (((String)nr).trim().length() > 0) {
            return nr;
        }
        return null;
    }

    public static void buildObs(NotaFiscalTerceiros notaFiscalTerceiros, boolean updateAddOBS) {
        LinkedList obsModContrib = new LinkedList();
        List obsNF = notaFiscalTerceiros.getObservacaoNotaTerceiros();
        notaFiscalTerceiros.getItemNotaTerceiros().forEach(i -> ObsFaturamentoUtilities.addObsModContrib(obsModContrib, i.getModeloFiscal()));
        for (ObsFaturamento ob : obsModContrib) {
            Optional<ObservacaoNotaTerceiros> found = obsNF.stream().filter(i -> ToolMethods.isEquals((Object)i.getObsFaturamento(), (Object)ob)).findFirst();
            ObservacaoNotaTerceiros bo = null;
            if (found.isPresent()) continue;
            if (updateAddOBS && bo == null) {
                bo = new ObservacaoNotaTerceiros();
                obsNF.add(bo);
            }
            if (bo == null) continue;
            bo.setObsFaturamento(ob);
            bo.setNotaTerceiros(notaFiscalTerceiros);
            bo.setConteudo(ObsFaturamentoUtilities.getObservacao(ob));
            bo.setConteudo(ObsFaturamentoUtilities.buildOBS(EnumConstObsFaturamentoTipo.get((Object)ob.getTipoObsNormalDinamica()), bo.getConteudo(), notaFiscalTerceiros));
        }
        for (ObsFaturamento ob : obsNF) {
            ob.setConteudo(ObsFaturamentoUtilities.buildOBS(EnumConstObsFaturamentoTipo.get((Object)ob.getObsFaturamento().getTipoObsNormalDinamica()), ob.getConteudo(), notaFiscalTerceiros));
        }
        LinkedList obsModFisco = new LinkedList();
        List obsNFFisco = notaFiscalTerceiros.getObservacoesIntFisco();
        notaFiscalTerceiros.getItemNotaTerceiros().forEach(i -> ObsFaturamentoUtilities.addObsModFisco(obsModFisco, i.getModeloFiscal()));
        for (ModeloFiscalObsFisco ob : obsModFisco) {
            Optional<ObservacaoIntFiscoNFTerceiros> found = obsNFFisco.stream().filter(i -> ToolMethods.isEquals((Object)i.getObsFaturamento(), (Object)ob.getObsFaturamento())).findFirst();
            ObservacaoIntFiscoNFTerceiros bo = null;
            if (found.isPresent()) continue;
            if (updateAddOBS && bo == null) {
                bo = new ObservacaoIntFiscoNFTerceiros();
                obsNFFisco.add(bo);
            }
            if (bo == null) continue;
            bo.setObsFaturamento(ob.getObsFaturamento());
            bo.setNotaFiscalTerceiros(notaFiscalTerceiros);
            bo.setConteudo(ObsFaturamentoUtilities.getObservacao(ob.getObsFaturamento()));
            bo.setConteudo(ObsFaturamentoUtilities.buildOBS(EnumConstObsFaturamentoTipo.get((Object)ob.getObsFaturamento().getTipoObsNormalDinamica()), bo.getConteudo(), notaFiscalTerceiros));
        }
        for (ModeloFiscalObsFisco ob : obsNFFisco) {
            ob.setConteudo(ObsFaturamentoUtilities.buildOBS(EnumConstObsFaturamentoTipo.get((Object)ob.getObsFaturamento().getTipoObsNormalDinamica()), ob.getConteudo(), notaFiscalTerceiros));
        }
    }

    public static void buildObs(NotaFiscalPropria notaFiscalPropria, ObsFaturamento obsRedespacho, boolean updateAddOBS, OpcoesFaturamento opFat) {
        LinkedList<ObsFaturamento> obsFaturamento = new LinkedList<ObsFaturamento>();
        if (notaFiscalPropria.getTransportadorRedespacho() != null && obsRedespacho != null) {
            obsFaturamento.add(obsRedespacho);
        }
        if (notaFiscalPropria.getDadosTransNfPropria() != null && notaFiscalPropria.getDadosTransNfPropria().getTransportador() != null) {
            notaFiscalPropria.getDadosTransNfPropria().getTransportador().getObservacaoFaturamento().forEach(i -> obsFaturamento.add(i.getObsFaturamento()));
        }
        if (notaFiscalPropria.getUnidadeFatCliente() != null && ToolMethods.isStrWithData((String)notaFiscalPropria.getUnidadeFatCliente().getCliente().getFaturamento().getObservacaoFaturamento()) && opFat != null && opFat.getObsClienteFaturamento() != null) {
            ObsFaturamento obsCliente = opFat.getObsClienteFaturamento();
            obsCliente.setObservacao(notaFiscalPropria.getUnidadeFatCliente().getCliente().getFaturamento().getObservacaoFaturamento());
            obsFaturamento.add(obsCliente);
        }
        List obsNF = notaFiscalPropria.getObservacaoNota();
        notaFiscalPropria.getItensNotaPropria().forEach(i -> ObsFaturamentoUtilities.addObsModContrib(obsFaturamento, i.getModeloFiscal()));
        for (ObsFaturamento ob : obsFaturamento) {
            Optional<ObservacaoNotaPropria> found = obsNF.stream().filter(i -> ToolMethods.isEquals((Object)i.getObsFaturamento(), (Object)ob)).findFirst();
            ObservacaoNotaPropria bo = null;
            if (found.isPresent()) continue;
            if (updateAddOBS && bo == null) {
                bo = new ObservacaoNotaPropria();
                obsNF.add(bo);
            }
            if (bo == null) continue;
            bo.setObsFaturamento(ob);
            bo.setNotaFiscalPropria(notaFiscalPropria);
            bo.setConteudo(ObsFaturamentoUtilities.getObservacao(ob));
            bo.setConteudo(ObsFaturamentoUtilities.buildOBS(ob, bo.getConteudo(), notaFiscalPropria));
        }
        for (ObservacaoNotaPropria bo : obsNF) {
            bo.setConteudo(ObsFaturamentoUtilities.buildOBS(bo.getObsFaturamento(), bo.getConteudo(), notaFiscalPropria));
        }
        LinkedList obsModFisco = new LinkedList();
        List obsNFFisco = notaFiscalPropria.getObservacaoIntFiscalNotaFiscalPropria();
        notaFiscalPropria.getItensNotaPropria().forEach(i -> ObsFaturamentoUtilities.addObsModFisco(obsModFisco, i.getModeloFiscal()));
        for (ModeloFiscalObsFisco ob : obsModFisco) {
            Optional<ObservacaoIntFiscalNotaFiscalPropria> found = obsNFFisco.stream().filter(i -> ToolMethods.isEquals((Object)i.getObsFaturamento(), (Object)ob.getObsFaturamento())).findFirst();
            ObservacaoIntFiscalNotaFiscalPropria bo = null;
            if (found.isPresent()) continue;
            if (updateAddOBS && bo == null) {
                bo = new ObservacaoIntFiscalNotaFiscalPropria();
                obsNFFisco.add(bo);
            }
            if (bo == null) continue;
            bo.setObsFaturamento(ob.getObsFaturamento());
            bo.setNotaFiscalPropria(notaFiscalPropria);
            bo.setConteudo(ObsFaturamentoUtilities.getObservacao(ob.getObsFaturamento()));
            bo.setConteudo(ObsFaturamentoUtilities.buildOBS(ob.getObsFaturamento(), bo.getConteudo(), notaFiscalPropria));
        }
        for (ObservacaoNotaPropria bo : obsNFFisco) {
            bo.setConteudo(ObsFaturamentoUtilities.buildOBS(bo.getObsFaturamento(), bo.getConteudo(), notaFiscalPropria));
        }
    }

    public static void buildObs(List<ItemPedido> itens, List<ObservacaoPedidoFaturamento> obsNF, List<ObsIntFiscoPedido> obsNFFisco, boolean updateAddOBS) {
        LinkedList obsFaturamento = new LinkedList();
        itens.forEach(i -> ObsFaturamentoUtilities.addObsModContrib(obsFaturamento, i.getModeloFiscal()));
        for (ObsFaturamento ob : obsFaturamento) {
            Optional<ObservacaoPedidoFaturamento> found = obsNF.stream().filter(i -> ToolMethods.isEquals((Object)i.getObservacaoFaturamento(), (Object)ob)).findFirst();
            ObservacaoPedidoFaturamento bo = null;
            if (found.isPresent()) continue;
            if (updateAddOBS && bo == null) {
                bo = new ObservacaoPedidoFaturamento();
                obsNF.add(bo);
            }
            if (bo == null) continue;
            bo.setObservacaoFaturamento(ob);
            if (bo.getObservacao() != null) continue;
            bo.setObservacao(ObsFaturamentoUtilities.getObservacao(ob));
        }
        LinkedList obsModFisco = new LinkedList();
        itens.forEach(i -> ObsFaturamentoUtilities.addObsModFisco(obsModFisco, i.getModeloFiscal()));
        for (ModeloFiscalObsFisco ob : obsModFisco) {
            Optional<ObsIntFiscoPedido> found = obsNFFisco.stream().filter(i -> ToolMethods.isEquals((Object)i.getObservacaoFaturamento(), (Object)ob.getObsFaturamento())).findFirst();
            ObsIntFiscoPedido bo = null;
            if (found.isPresent()) {
                bo = found.get();
            }
            if (updateAddOBS && bo == null) {
                bo = new ObsIntFiscoPedido();
                obsNFFisco.add(bo);
            }
            if (bo == null) continue;
            bo.setObservacao(ObsFaturamentoUtilities.getObservacao(ob.getObsFaturamento()));
            bo.setObservacaoFaturamento(ob.getObsFaturamento());
        }
    }

    public static void buildObs(Pedido pedido, boolean updateAddOBS) {
        if (pedido == null) {
            return;
        }
        ObsFaturamentoUtilities.buildObs(pedido.getItemPedido(), pedido.getObservacoes(), pedido.getObservacaoIntFisco(), updateAddOBS);
        for (ObsIntFiscoPedido ob : pedido.getObservacaoIntFisco()) {
            ob.setPedido(pedido);
        }
        for (ObsIntFiscoPedido ob : pedido.getObservacoes()) {
            ob.setPedido(pedido);
        }
    }

    private static void addObsModFisco(List<ModeloFiscalObsFisco> obsModFisco, ModeloFiscal modeloFiscal) {
        if (modeloFiscal == null) {
            return;
        }
        for (ModeloFiscalObsFisco ob : modeloFiscal.getObservacoesFisco()) {
            if (!ToolMethods.isEquals((Object)ob.getAtivo(), (Object)1) || ToolMethods.isEquals((Object)ob.getUsarNFCe(), (Object)1) || ToolMethods.isEquals((Object)ob.getTipoObservacao(), (Object)EnumConstModeloFiscalObs.TIPO_OBS_PRODUTO.getValue()) || obsModFisco.contains(ob)) continue;
            obsModFisco.add(ob);
        }
    }

    private static void addObsModContrib(List<ObsFaturamento> obsModContrib, ModeloFiscal modeloFiscal) {
        if (modeloFiscal == null) {
            return;
        }
        for (ModeloFiscalObsContrib ob : modeloFiscal.getObservacoesContrib()) {
            if (!ToolMethods.isEquals((Object)ob.getAtivo(), (Object)1) || ToolMethods.isEquals((Object)ob.getUsarNFCe(), (Object)1) || ToolMethods.isEquals((Object)ob.getTipoObservacao(), (Object)1) || obsModContrib.contains(ob.getObsFaturamento())) continue;
            obsModContrib.add(ob.getObsFaturamento());
        }
    }

    private static String getObservacao(ObsFaturamento ob) {
        return ((CompOBSFaturamento)Context.get(CompOBSFaturamento.class)).getObservacao(ob);
    }
}

