/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.ordemcompra;

import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.GradeItemOrdemCompra;
import com.touchcomp.basementor.model.vo.ItemOrdemCompra;
import com.touchcomp.basementor.model.vo.ItemOrdemCompraLivroFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import java.util.HashMap;
import java.util.List;
import mentorcore.exceptions.ExceptionCalculoICMS;
import mentorcore.exceptions.ExceptionCalculoIPI;
import mentorcore.exceptions.ExceptionCalculoPisCofins;
import mentorcore.exceptions.ExceptionService;
import mentorcore.utilities.impl.calculoimpostos.CalculoICMSEntUtilities;
import mentorcore.utilities.impl.calculoimpostos.CalculoIPIEntUtilities;
import mentorcore.utilities.impl.calculoimpostos.CalculoOutrosImpostos;
import mentorcore.utilities.impl.calculoimpostos.CalculoPisCofins;

class AuxCalcImpostosOrdemCompra {
    AuxCalcImpostosOrdemCompra() {
    }

    public List calcularImpostosFiscaisItOrdemCompra(List itensNota, UnidadeFatFornecedor fornecedor, UnidadeFederativa ufEmpresa, EmpresaContabilidade empresaContabilidade) throws ExceptionService, ExceptionCalculoPisCofins, ExceptionCalculoIPI, ExceptionCalculoICMS {
        for (Object o : itensNota) {
            ItemOrdemCompra item = (ItemOrdemCompra)o;
            this.calcularImpostosFiscaisItOrdemCompra(item, fornecedor, ufEmpresa, empresaContabilidade);
        }
        return itensNota;
    }

    public void calcularImpostosFiscaisItOrdemCompra(ItemOrdemCompra item, UnidadeFatFornecedor fornecedor, UnidadeFederativa ufEmpresa, EmpresaContabilidade empresaContabilidade) throws ExceptionService, ExceptionCalculoPisCofins, ExceptionCalculoIPI, ExceptionCalculoICMS {
        Produto produto = item.getProduto();
        if (item.getItemOrdemCompraLF() == null) {
            item.setItemOrdemCompraLF(new ItemOrdemCompraLivroFiscal());
        }
        ItemOrdemCompraLivroFiscal itLF = item.getItemOrdemCompraLF();
        ModeloFiscal modeloFiscal = item.getModeloFiscal();
        double qtdTotal = this.getQuantidadeTotal(item.getGradeItemOrdemCompra());
        double vlrProduto = qtdTotal * item.getValorUnitario();
        double bcCalculoGeral = item.getValorDesconto() * -1.0 + item.getValorDespAcessoria() + item.getValorFrete() + item.getVrSeguro() + item.getValorAgregado();
        if (produto.getTipoProduto() != null && produto.getTipoProduto() == 1) {
            item.setVrServico(Double.valueOf(vlrProduto));
            itLF.setVrIrrf(Double.valueOf(produto.getAliquotaIrrf() / 100.0 * (bcCalculoGeral += item.getVrServico().doubleValue())));
            itLF.setVrInss(Double.valueOf(produto.getAliquotaInss() / 100.0 * bcCalculoGeral));
            itLF.setVrIss(Double.valueOf(produto.getAliquotaIss() / 100.0 * bcCalculoGeral));
            itLF.setAliquotaIcms(Double.valueOf(0.0));
            itLF.setAliquotaIpi(Double.valueOf(0.0));
            itLF.setVrBcCalculoIcmsSt(Double.valueOf(0.0));
            itLF.setVrDifAliquota(Double.valueOf(0.0));
            itLF.setVrIcms(Double.valueOf(0.0));
            itLF.setVrIcmsIsento(Double.valueOf(0.0));
            itLF.setVrIcmsOutros(Double.valueOf(0.0));
            itLF.setVrIcmsSemAprov(Double.valueOf(0.0));
            itLF.setVrIcmsSt(Double.valueOf(0.0));
            itLF.setVrIcmsTributado(Double.valueOf(0.0));
            item.setVrProduto(Double.valueOf(0.0));
        } else {
            item.setVrProduto(Double.valueOf(vlrProduto));
            bcCalculoGeral += item.getVrProduto().doubleValue();
            item.setVrServico(Double.valueOf(0.0));
        }
        if (item.getModeloFiscal() != null && fornecedor != null) {
            this.valoresIpiItemOrdemCompra(modeloFiscal, itLF, item, produto, fornecedor);
            this.valoresIcmsIcmsSTItemOrdemCompra(modeloFiscal, item, produto, ufEmpresa, fornecedor.getFornecedor().getPessoa().getEndereco().getCidade().getUf(), itLF, empresaContabilidade);
            this.calculoOutrosImpostos(item.getItemOrdemCompraLF(), item, bcCalculoGeral);
        }
        Double valor = item.getVrProduto() + item.getVrServico() - item.getValorDesconto() + item.getValorFrete() + item.getVrSeguro() + item.getValorDespAcessoria() + itLF.getVrIpiIndustria() + itLF.getVrIpiObservacao() + itLF.getVrIcmsSt() - itLF.getVrIcmsDispensado();
        itLF.setValorTotal(ToolFormatter.arrredondarNumero((Double)valor, (int)2));
        if (item.getModeloFiscal() != null && fornecedor != null) {
            this.calcularDiferencaAliquota(modeloFiscal, fornecedor.getFornecedor().getPessoa().getEndereco().getCidade().getUf(), ufEmpresa, itLF, produto, item);
        }
        this.atualizarGrades(item, itLF, item.getGradeItemOrdemCompra(), modeloFiscal);
    }

    private void calculoOutrosImpostos(ItemOrdemCompraLivroFiscal itLF, ItemOrdemCompra item, Double bcCalculoGeral) throws ExceptionCalculoPisCofins {
        HashMap h = new CalculoPisCofins(item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiSeguro(), item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiFrete(), item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiDespAcess(), item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiDesconto(), item.getModeloFiscal().getModeloFiscalPisCofins().getValorMinimoCofins(), item.getModeloFiscal().getModeloFiscalPisCofins().getValorMinimoPis(), item.getModeloFiscal().getModeloFiscalPisCofins().getAbaterValorIcms(), item.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIcmsDesonerado(), item.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIcmsSemAproveitamento(), item.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIpiObservacao()).calculoPisCofins(item.getModeloFiscal().getModeloFiscalPisCofins().getCalcularPisNormal(), item.getModeloFiscal().getModeloFiscalPisCofins().getCalcularPisSt(), item.getModeloFiscal().getModeloFiscalPisCofins().getCalcularCofinsNormal(), item.getModeloFiscal().getModeloFiscalPisCofins().getCalcularCofinsSt(), item.getModeloFiscal().getModeloFiscalPisCofins().getIncidenciaPisCofins(), itLF.getAliquotaPis(), itLF.getAliquotaPisSt(), itLF.getAliquotaCofins(), itLF.getAliquotaCofinsSt(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), item.getVrProduto() + item.getVrServico(), 4, item.getProduto().getPisCofinsTributadoQuantidade(), item.getQuantidadeTotal(), 0.0, 0.0, itLF.getVrIcms(), itLF.getVrIcmsDispensado(), itLF.getVrIcmsSemAprov(), itLF.getVrIpiObservacao());
        itLF.setAliquotaPis((Double)h.get("aliquotaPis"));
        itLF.setAliquotaPisSt((Double)h.get("aliquotaPisSt"));
        itLF.setAliquotaCofins((Double)h.get("aliquotaCofins"));
        itLF.setAliquotaCofinsSt((Double)h.get("aliquotaCofinsSt"));
        itLF.setVrPis((Double)h.get("valorPis"));
        itLF.setVrPisSt((Double)h.get("valorPisSt"));
        itLF.setVrCofins((Double)h.get("valorCofins"));
        itLF.setVrCofinsSt((Double)h.get("valorCofinsSt"));
        itLF.setVrBCCofins((Double)h.get("valorBCCofins"));
        itLF.setVrBCCofinsSt((Double)h.get("valorBCCofinsSt"));
        itLF.setVrBCPis((Double)h.get("valorBCPis"));
        itLF.setVrBCPisSt((Double)h.get("valorBCPisSt"));
        h = CalculoOutrosImpostos.calculoContSoc(item.getModeloFiscal().getTipoContSoc(), itLF.getAliquotaContSoc(), itLF.getPercRedContSoc(), item.getModeloFiscal().getValorMinimoCSLL(), itLF.getVrContSoc(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), item.getVrProduto() + item.getVrServico(), (short)4);
        itLF.setAliquotaContSoc((Double)h.get("aliquotaContSoc"));
        itLF.setVrContSoc((Double)h.get("valorContSoc"));
        h = CalculoOutrosImpostos.calculoFunrural(item.getModeloFiscal(), itLF.getAliquotaFunrural(), itLF.getPercRedFunrural(), itLF.getVrFunrural(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), item.getVrProduto() + item.getVrServico(), (short)4);
        itLF.setAliquotaFunrural((Double)h.get("aliquotaFunrural"));
        itLF.setVrFunrural((Double)h.get("valorFunrural"));
        h = CalculoOutrosImpostos.calculoLei10833(item.getModeloFiscal(), itLF.getAliquotaLei10833(), itLF.getPercRedLei10833(), itLF.getVrLei10833(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), item.getVrProduto() + item.getVrServico(), (short)4);
        itLF.setAliquotaLei10833((Double)h.get("aliquotaLei10833"));
        itLF.setVrLei10833((Double)h.get("valorLei10833"));
        h = CalculoOutrosImpostos.calculoINSS(item.getModeloFiscal().getTipoINSS(), itLF.getAliquotaInss(), itLF.getPercRedBcInss(), itLF.getVrInss(), 0.0, item.getModeloFiscal().getValorMinimoInss(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), item.getVrProduto() + item.getVrServico(), (short)4);
        itLF.setAliquotaInss((Double)h.get("aliquotaInss"));
        itLF.setVrInss((Double)h.get("valorInss"));
        itLF.setPercRedBcInss((Double)h.get("percRedInss"));
        h = CalculoOutrosImpostos.calculoIRRF(item.getModeloFiscal().getTipoIRRF(), itLF.getAliquotaIrrf(), itLF.getPercRedIrrf(), itLF.getVrIrrf(), item.getModeloFiscal().getValorMinimoIR(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), item.getVrProduto() + item.getVrServico(), (short)4);
        itLF.setAliquotaIrrf((Double)h.get("aliquotaIrrf"));
        itLF.setVrIrrf((Double)h.get("valorIrrf"));
        h = CalculoOutrosImpostos.calculoISS(item.getModeloFiscal().getIssRetido(), itLF.getAliquotaIss(), 0.0, itLF.getVrIss(), item.getModeloFiscal().getValorMinimoISS(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), item.getVrProduto() + item.getVrServico(), (short)4);
        itLF.setAliquotaIss((Double)h.get("aliquotaIss"));
        itLF.setVrIss((Double)h.get("valorIss"));
        h = CalculoOutrosImpostos.calculoOutros(item.getModeloFiscal().getTipoOutros(), itLF.getAliquotaOutros(), itLF.getPercRedOutros(), itLF.getVrOutros(), item.getModeloFiscal().getValorMinimoOutros(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), item.getVrProduto() + item.getVrServico(), (short)4);
        itLF.setAliquotaOutros((Double)h.get("aliquotaOutros"));
        itLF.setVrOutros((Double)h.get("valorOutros"));
        h = CalculoOutrosImpostos.calculoSestSenat(item.getModeloFiscal(), itLF.getAliquotaSestSenat(), itLF.getPercRedSestSenat(), itLF.getValorSestSenat(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), item.getVrProduto() + item.getVrServico(), (short)4);
        itLF.setAliquotaSestSenat((Double)h.get("aliquotaSestSenat"));
        itLF.setValorSestSenat((Double)h.get("valorSestSenat"));
        itLF.setPercRedSestSenat((Double)h.get("percRedSestSenat"));
    }

    private void atualizarGrades(ItemOrdemCompra item, ItemOrdemCompraLivroFiscal itLF, List grades, ModeloFiscal modeloFiscal) {
        item.setValorCusto(Double.valueOf(item.getVrProduto() + item.getVrServico() - item.getValorDesconto() + item.getValorFrete() + item.getVrSeguro() + item.getValorDespAcessoria() + itLF.getVrIcmsSt() + itLF.getVrDifAliquota() + itLF.getVrFreteExterno() - itLF.getVrCofins() - itLF.getVrPis() - itLF.getVrIpiComercio() + item.getValorAgregado()));
        if (modeloFiscal != null && modeloFiscal.getModeloFiscalIcms() != null && modeloFiscal.getModeloFiscalIcms().getRecuperarTributosIcms() == 1) {
            item.setValorCusto(Double.valueOf(item.getValorCusto() - itLF.getVrIcms()));
        }
        if (modeloFiscal != null && modeloFiscal.getModeloFiscalIcms() != null && modeloFiscal.getModeloFiscalIcms().getCalcularIcmsSimples() == 1) {
            item.setValorCusto(Double.valueOf(item.getValorCusto() - itLF.getValorIcmsSimples()));
        }
        item.setValorCusto(Double.valueOf(item.getValorCusto() + itLF.getVrIpiObservacao()));
        item.setValorCusto(ToolFormatter.arrredondarNumero((Double)(item.getValorCusto() / (item.getQuantidadeTotal() * item.getFatorConversao())), (int)6));
        item.setValorCusto(ToolFormatter.arrredondarNumero((Double)item.getValorCusto(), (int)6));
    }

    private Double getQuantidadeTotal(List grades) {
        double qtdTotal = 0.0;
        if (grades != null) {
            for (Object o : grades) {
                GradeItemOrdemCompra item = (GradeItemOrdemCompra)o;
                qtdTotal += item.getQuantidade().doubleValue();
            }
        }
        return qtdTotal;
    }

    public Double getValorTotalItens(List itens) {
        double qtdTotal = 0.0;
        if (itens != null) {
            for (Object o : itens) {
                ItemOrdemCompra item = (ItemOrdemCompra)o;
                qtdTotal += item.getVrServico() + item.getVrProduto();
            }
        }
        return qtdTotal;
    }

    private void valoresIpiItemOrdemCompra(ModeloFiscal modeloFiscal, ItemOrdemCompraLivroFiscal itLF, ItemOrdemCompra item, Produto produto, UnidadeFatFornecedor fornecedor) throws ExceptionCalculoIPI {
        HashMap h = new CalculoIPIEntUtilities(modeloFiscal.getModeloFiscalIpi().getIncluiSeguro(), modeloFiscal.getModeloFiscalIpi().getIncluiFrete(), modeloFiscal.getModeloFiscalIpi().getIncluiDespAcess(), modeloFiscal.getModeloFiscalIpi().getIncluiSeguro()).calcularIpi(modeloFiscal.getModeloFiscalIpi(), modeloFiscal.getModeloFiscalIpi().getIncidenciaIpi(), fornecedor, produto, itLF.getAliquotaIpi(), (short)4, item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), item.getVrProduto() + item.getVrServico(), item.getQuantidadeTotal());
        itLF.setVrIpiComercio((Double)h.get("ipiComercio"));
        itLF.setVrIpiIndustria((Double)h.get("ipiIndustria"));
        itLF.setVrIpiIsento((Double)h.get("ipiIsento"));
        itLF.setVrIpiObservacao((Double)h.get("ipiObservacao"));
        itLF.setVrIpiOutros((Double)h.get("ipiOutros"));
        itLF.setVrIpiTributado((Double)h.get("ipiTributado"));
    }

    private void valoresIcmsIcmsSTItemOrdemCompra(ModeloFiscal modeloFiscal, ItemOrdemCompra item, Produto produto, UnidadeFederativa ufEmpresa, UnidadeFederativa ufFornecedor, ItemOrdemCompraLivroFiscal itLF, EmpresaContabilidade empresaContabilidade) throws ExceptionService, ExceptionCalculoICMS {
        HashMap h = new CalculoICMSEntUtilities(modeloFiscal.getModeloFiscalIcms().getIncluiSeguro(), modeloFiscal.getModeloFiscalIcms().getIncluiFrete(), modeloFiscal.getModeloFiscalIcms().getIncluiDespAcess(), modeloFiscal.getModeloFiscalIcms().getIncluiDesconto(), modeloFiscal.getModeloFiscalIcms().getIncluiSeguroST(), modeloFiscal.getModeloFiscalIcms().getIncluiFreteST(), modeloFiscal.getModeloFiscalIcms().getIncluiDespAcessST(), modeloFiscal.getModeloFiscalIcms().getIncluiDescontoST(), modeloFiscal.getModeloFiscalIcms().getIncluiIPIST(), modeloFiscal.getModeloFiscalIcms().getIncluirIcmsDesonerado()).valoresIcms(modeloFiscal.getModeloFiscalIcms(), modeloFiscal.getModeloFiscalIpi(), itLF.getVrIpiIndustria(), itLF.getVrIpiObservacao(), itLF.getAliquotaIcms(), itLF.getPercReducaoBCIcms(), produto, (short)4, item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), item.getVrProduto() + item.getVrServico(), empresaContabilidade, 0.0, 0.0, item.getQuantidadeTotal());
        itLF.setAliquotaIcms((Double)h.get("aliquotaIPI"));
        itLF.setVrBcCalculoIcms((Double)h.get("bcIcms"));
        itLF.setVrIcmsIsento((Double)h.get("icmsIsento"));
        itLF.setVrIcmsOutros((Double)h.get("icmsOutros"));
        itLF.setVrIcmsSemAprov((Double)h.get("icmsSemAprov"));
        itLF.setVrIcmsTributado((Double)h.get("icmsTributado"));
        itLF.setVrIcmsDispensado((Double)h.get("valorIcmsDesonerado"));
        itLF.setVrIcms((Double)h.get("valorIcms"));
        if (itLF.getCalcularIcmsST() != null && itLF.getCalcularIcmsST() == 1) {
            h = new CalculoICMSEntUtilities(modeloFiscal.getModeloFiscalIcms().getIncluiSeguro(), modeloFiscal.getModeloFiscalIcms().getIncluiFrete(), modeloFiscal.getModeloFiscalIcms().getIncluiDespAcess(), modeloFiscal.getModeloFiscalIcms().getIncluiDesconto(), modeloFiscal.getModeloFiscalIcms().getIncluiSeguroST(), modeloFiscal.getModeloFiscalIcms().getIncluiFreteST(), modeloFiscal.getModeloFiscalIcms().getIncluiDespAcessST(), modeloFiscal.getModeloFiscalIcms().getIncluiDescontoST(), modeloFiscal.getModeloFiscalIcms().getIncluiIPIST(), modeloFiscal.getModeloFiscalIcms().getIncluirIcmsDesonerado()).calcularSt(itLF.getVrIcms() + itLF.getVrIcmsSemAprov(), itLF.getIndiceAlteracaoIcmsST(), itLF.getAliquotaIcmsST(), itLF.getDescontoPadraoIcmsST(), item.getQuantidadeTotal(), produto, itLF.getModalidadeIcmsSt(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), item.getVrProduto() + item.getVrServico(), itLF.getVrIpiIndustria(), itLF.getVrIpiObservacao(), modeloFiscal.getModeloFiscalIcms().getReducaoBaseCalcIcmsST());
            itLF.setIndiceAlteracaoIcmsST((Double)h.get("indiceAlteracaoST"));
            itLF.setDescontoPadraoIcmsST((Double)h.get("descontoPadraoST"));
            itLF.setAliquotaIcmsST((Double)h.get("aliquotaSt"));
            itLF.setVrBcCalculoIcmsSt((Double)h.get("bcIcmsST"));
            itLF.setVrIcmsSt((Double)h.get("valorIcmsST"));
        }
    }

    private void calcularDiferencaAliquota(ModeloFiscal modeloFiscal, UnidadeFederativa ufFornecedor, UnidadeFederativa ufEmpresa, ItemOrdemCompraLivroFiscal itLF, Produto produto, ItemOrdemCompra item) throws ExceptionService {
        HashMap h = new CalculoICMSEntUtilities(modeloFiscal.getModeloFiscalIcms().getIncluiSeguro(), modeloFiscal.getModeloFiscalIcms().getIncluiFrete(), modeloFiscal.getModeloFiscalIcms().getIncluiDespAcess(), modeloFiscal.getModeloFiscalIcms().getIncluiDesconto(), modeloFiscal.getModeloFiscalIcms().getIncluiSeguroST(), modeloFiscal.getModeloFiscalIcms().getIncluiFreteST(), modeloFiscal.getModeloFiscalIcms().getIncluiDespAcessST(), modeloFiscal.getModeloFiscalIcms().getIncluiDescontoST(), modeloFiscal.getModeloFiscalIcms().getIncluiIPIST(), modeloFiscal.getModeloFiscalIcms().getIncluirIcmsDesonerado()).calcularDiferencaAliquota(modeloFiscal.getModeloFiscalIcms(), ufFornecedor, ufEmpresa, produto, item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), item.getVrProduto() + item.getVrServico(), modeloFiscal.getModeloFiscalIcms().getIpiCompoeBCDifAliquota(), itLF.getVrIpiComercio() + itLF.getVrIpiIndustria() + itLF.getVrIpiObservacao(), itLF.getAliquotaIcms(), itLF.getVrIcms() + itLF.getVrIcmsSemAprov());
        itLF.setVrDifAliquota((Double)h.get("valorDifAliquota"));
    }

    public void ratearValoresAcessorios(List<ItemOrdemCompra> itens, double valorDesc, double percDesc, short tipoDesc, double valorDesp, double percDesp, short tipoDesp, double valorFrete, double percFrete, short tipoFrete, double valorSeg, double percSeg, short tipoSeg) throws ExceptionService {
        AuxCalcImpostosOrdemCompra.ratearDesconto(itens, valorDesc, percDesc, tipoDesc);
        AuxCalcImpostosOrdemCompra.ratearDespAcess(itens, valorDesp, percDesp, tipoDesp);
        AuxCalcImpostosOrdemCompra.ratearFrete(itens, valorFrete, percFrete, tipoFrete);
        AuxCalcImpostosOrdemCompra.ratearSeguro(itens, valorSeg, percSeg, tipoSeg);
    }

    private static void ratearDesconto(List<ItemOrdemCompra> itens, double valorDesc, double percDesc, short tipoDesc) throws ExceptionService {
        double valorTotal = 0.0;
        if (tipoDesc == 0) {
            valorDesc = 0.0;
        }
        for (ItemOrdemCompra it : itens) {
            if (it.getDescontoItem() == 1) continue;
            valorTotal += it.getQuantidadeTotal() * it.getValorUnitario();
        }
        if (valorTotal <= 0.0 && valorDesc > 0.0) {
            throw new ExceptionService("N\u00e3o existe itens para ratear o desconto.");
        }
        ItemOrdemCompra lastItem = null;
        double valorDescTotal = 0.0;
        for (ItemOrdemCompra item : itens) {
            double vlrProduto = item.getValorUnitario() * item.getQuantidadeTotal();
            double valorDescCalc = 0.0;
            double percDescCalc = 0.0;
            if (item.getDescontoItem() != 1) {
                if (tipoDesc == 0) {
                    valorDescCalc = ToolFormatter.arrredondarNumero((Double)(percDesc / 100.0 * vlrProduto), (int)2);
                    percDescCalc = percDesc;
                } else {
                    percDescCalc = valorDesc > 0.0 && valorTotal > 0.0 ? ToolFormatter.arrredondarNumero((Double)(valorDesc / valorTotal * 100.0), (int)4) : 0.0;
                    valorDescCalc = ToolFormatter.arrredondarNumero((Double)(item.getQuantidadeTotal() * item.getValorUnitario() * percDescCalc / 100.0), (int)2);
                }
                valorDescTotal += valorDescCalc;
                lastItem = item;
                item.setPercDesconto(Double.valueOf(percDescCalc));
                item.setValorDesconto(Double.valueOf(valorDescCalc));
                continue;
            }
            if (item.getTipoDesconto() == 0) {
                if (!(item.getPercDesconto() > 0.0)) continue;
                item.setValorDesconto(ToolFormatter.arrredondarNumero((Double)(item.getPercDesconto() / 100.0 * vlrProduto), (int)2));
                continue;
            }
            item.setValorDesconto(ToolFormatter.arrredondarNumero((Double)item.getValorDesconto(), (int)2));
            if (!(item.getValorDesconto() > 0.0) || !(vlrProduto > 0.0)) continue;
            item.setPercDesconto(ToolFormatter.arrredondarNumero((Double)(item.getValorDesconto() * 100.0 / vlrProduto), (int)4));
        }
        if (lastItem != null && valorDesc > 0.0) {
            lastItem.setValorDesconto(Double.valueOf(lastItem.getValorDesconto() + (valorDesc - valorDescTotal)));
        }
    }

    private static void ratearFrete(List<ItemOrdemCompra> itens, double valorFrete, double percFrete, short tipoFrete) throws ExceptionService {
        double valorTotal = 0.0;
        if (tipoFrete == 0) {
            valorFrete = 0.0;
        }
        for (ItemOrdemCompra it : itens) {
            if (it.getFreteItem() == 1) continue;
            valorTotal += it.getQuantidadeTotal() * it.getValorUnitario();
        }
        ItemOrdemCompra lastItem = null;
        double valorFreteTotal = 0.0;
        for (ItemOrdemCompra item : itens) {
            double vlrProduto = item.getValorUnitario() * item.getQuantidadeTotal();
            double valorFreteCalc = 0.0;
            double percFreteCalc = 0.0;
            if (item.getFreteItem() != 1) {
                if (tipoFrete == 0) {
                    valorFreteCalc = ToolFormatter.arrredondarNumero((Double)(percFrete / 100.0 * vlrProduto), (int)2);
                    percFreteCalc = percFrete;
                } else {
                    percFreteCalc = valorFrete > 0.0 && valorTotal > 0.0 ? ToolFormatter.arrredondarNumero((Double)(valorFrete / valorTotal * 100.0), (int)4) : 0.0;
                    valorFreteCalc = ToolFormatter.arrredondarNumero((Double)(item.getQuantidadeTotal() * item.getValorUnitario() * percFreteCalc / 100.0), (int)2);
                }
                valorFreteTotal += valorFreteCalc;
                lastItem = item;
                item.setPercFrete(Double.valueOf(percFreteCalc));
                item.setValorFrete(Double.valueOf(valorFreteCalc));
                continue;
            }
            if (item.getTipoFrete() == 0) {
                if (!(item.getPercFrete() > 0.0)) continue;
                item.setValorFrete(ToolFormatter.arrredondarNumero((Double)(item.getPercFrete() / 100.0 * vlrProduto), (int)2));
                continue;
            }
            item.setValorFrete(ToolFormatter.arrredondarNumero((Double)item.getValorFrete(), (int)2));
            if (!(item.getValorFrete() > 0.0) || !(vlrProduto > 0.0)) continue;
            item.setPercFrete(ToolFormatter.arrredondarNumero((Double)(item.getValorFrete() * 100.0 / vlrProduto), (int)4));
        }
        if (lastItem != null && valorFrete > 0.0) {
            lastItem.setValorFrete(Double.valueOf(lastItem.getValorFrete() + (valorFrete - valorFreteTotal)));
        }
    }

    private static void ratearDespAcess(List<ItemOrdemCompra> itens, double valorDesp, double percDesp, short tipoDesp) throws ExceptionService {
        double valorTotal = 0.0;
        if (tipoDesp == 0) {
            valorDesp = 0.0;
        }
        for (ItemOrdemCompra it : itens) {
            if (it.getDespAcessItem() == 1) continue;
            valorTotal += it.getQuantidadeTotal() * it.getValorUnitario();
        }
        ItemOrdemCompra lastItem = null;
        double valorDespTotal = 0.0;
        for (ItemOrdemCompra item : itens) {
            double vlrProduto = item.getValorUnitario() * item.getQuantidadeTotal();
            double valorDespCalc = 0.0;
            double percDespCalc = 0.0;
            if (item.getDespAcessItem() != 1) {
                if (tipoDesp == 0) {
                    valorDespCalc = ToolFormatter.arrredondarNumero((Double)(percDesp / 100.0 * vlrProduto), (int)2);
                    percDespCalc = percDesp;
                } else {
                    percDespCalc = valorDesp > 0.0 && valorTotal > 0.0 ? ToolFormatter.arrredondarNumero((Double)(valorDesp / valorTotal * 100.0), (int)4) : 0.0;
                    valorDespCalc = ToolFormatter.arrredondarNumero((Double)(item.getQuantidadeTotal() * item.getValorUnitario() * percDespCalc / 100.0), (int)2);
                }
                valorDespTotal += valorDespCalc;
                lastItem = item;
                item.setPercDespesaAcessoria(Double.valueOf(percDespCalc));
                item.setValorDespAcessoria(Double.valueOf(valorDespCalc));
                continue;
            }
            if (item.getTipoDespAcessoria() == 0) {
                if (!(item.getPercDespesaAcessoria() > 0.0)) continue;
                item.setValorDespAcessoria(ToolFormatter.arrredondarNumero((Double)(item.getPercDespesaAcessoria() / 100.0 * vlrProduto), (int)2));
                continue;
            }
            item.setValorDespAcessoria(ToolFormatter.arrredondarNumero((Double)item.getValorDespAcessoria(), (int)2));
            if (!(item.getValorDespAcessoria() > 0.0) || !(vlrProduto > 0.0)) continue;
            item.setPercDespesaAcessoria(ToolFormatter.arrredondarNumero((Double)(item.getValorDespAcessoria() * 100.0 / vlrProduto), (int)4));
        }
        if (lastItem != null && valorDesp > 0.0) {
            lastItem.setValorDespAcessoria(Double.valueOf(lastItem.getValorDespAcessoria() + (valorDesp - valorDespTotal)));
        }
    }

    private static void ratearSeguro(List<ItemOrdemCompra> itens, double valorSeguro, double percSeguro, short tipoSeguro) throws ExceptionService {
        double valorTotal = 0.0;
        if (tipoSeguro == 0) {
            valorSeguro = 0.0;
        }
        for (ItemOrdemCompra it : itens) {
            if (it.getSeguroItem() == 1) continue;
            valorTotal += it.getQuantidadeTotal() * it.getValorUnitario();
        }
        ItemOrdemCompra lastItem = null;
        double valorSeguroTotal = 0.0;
        for (ItemOrdemCompra item : itens) {
            double vlrProduto = item.getValorUnitario() * item.getQuantidadeTotal();
            double valorSeguroCalc = 0.0;
            double percSeguroCalc = 0.0;
            if (item.getSeguroItem() != 1) {
                if (tipoSeguro == 0) {
                    valorSeguroCalc = ToolFormatter.arrredondarNumero((Double)(percSeguro / 100.0 * vlrProduto), (int)2);
                    percSeguroCalc = percSeguro;
                } else {
                    percSeguroCalc = valorSeguro > 0.0 && valorTotal > 0.0 ? ToolFormatter.arrredondarNumero((Double)(valorSeguro / valorTotal * 100.0), (int)4) : 0.0;
                    valorSeguroCalc = ToolFormatter.arrredondarNumero((Double)(item.getQuantidadeTotal() * item.getValorUnitario() * percSeguroCalc / 100.0), (int)2);
                }
                valorSeguroTotal += valorSeguroCalc;
                lastItem = item;
                item.setPercSeguro(Double.valueOf(percSeguroCalc));
                item.setVrSeguro(Double.valueOf(valorSeguroCalc));
                continue;
            }
            if (item.getTipoSeguro() == 0) {
                if (!(item.getPercSeguro() > 0.0)) continue;
                item.setVrSeguro(ToolFormatter.arrredondarNumero((Double)(item.getPercSeguro() / 100.0 * vlrProduto), (int)2));
                continue;
            }
            item.setVrSeguro(ToolFormatter.arrredondarNumero((Double)item.getVrSeguro(), (int)2));
            if (!(item.getVrSeguro() > 0.0) || !(vlrProduto > 0.0)) continue;
            item.setPercSeguro(ToolFormatter.arrredondarNumero((Double)(item.getVrSeguro() * 100.0 / vlrProduto), (int)4));
        }
        if (lastItem != null && valorSeguro > 0.0) {
            lastItem.setVrSeguro(Double.valueOf(lastItem.getVrSeguro() + (valorSeguro - valorSeguroTotal)));
        }
    }

    public void calculoValoresOrdemCompra(List<ItemOrdemCompra> itens) {
        for (ItemOrdemCompra it : itens) {
            this.putQuantidadeTotal(it);
            this.putValorProduto(it);
            this.putValorTotal(it);
        }
    }

    private void putQuantidadeTotal(ItemOrdemCompra it) {
        double qtd = 0.0;
        for (GradeItemOrdemCompra g : it.getGradeItemOrdemCompra()) {
            qtd += g.getQuantidade().doubleValue();
        }
        it.setQuantidadeTotal(Double.valueOf(qtd));
    }

    private void putValorProduto(ItemOrdemCompra item) {
        item.setVrProduto(Double.valueOf(item.getValorUnitario() * item.getQuantidadeTotal()));
    }

    private void putValorTotal(ItemOrdemCompra item) {
        if (item.getItemOrdemCompraLF() != null) {
            Double valorTotal = item.getVrProduto() - item.getValorDesconto() + item.getValorFrete() + item.getVrSeguro() + item.getValorDespAcessoria();
            item.getItemOrdemCompraLF().setValorTotal(valorTotal);
        }
    }
}

