/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.ordemcompra;

import com.touchcomp.basementor.constants.enums.ConstEnumFormImprBI;
import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistema;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.ItemOrdemCompra;
import com.touchcomp.basementor.model.vo.ItemOrdemCompraNecCompra;
import com.touchcomp.basementor.model.vo.ModeloEmail;
import com.touchcomp.basementor.model.vo.OpcoesRelacionamento;
import com.touchcomp.basementor.model.vo.OrdemCompra;
import com.touchcomp.basementor.model.vo.ServidorEmail;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorservice.components.businessintelligence.CompBIDefaultParams;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.ServiceBuildBusinessIntelligenceImpl;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.email.Email;
import com.touchcomp.basementortools.tools.email.ToolSendEmail;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import mentorcore.exceptions.ExceptionExportRelatorio;
import mentorcore.exceptions.ExceptionService;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.jasperreports.auxiliar.FormImpressaoExporterPDF;

public class UtilityEmailOrdemCompra {
    public void criarEmail(OrdemCompra vo, OpcoesRelacionamento op, BusinessIntelligence bi, Empresa empresa, Usuario usuario, Grupo grupoUsuarios, Boolean envSomenteSolicitante) throws ExceptionService, IOException, ExceptionExportRelatorio, Exception {
        Email e = new Email(false);
        ServidorEmail serv = null;
        ModeloEmail modeloEmail = null;
        if (op.getUtilizarServidorPrefUsuario() != null && op.getUtilizarServidorPrefUsuario().equals((short)1)) {
            serv = usuario.getUsuarioConfiguracoes().getServidorEmail();
            modeloEmail = usuario.getUsuarioConfiguracoes().getModeloEmail();
        }
        if (serv == null) {
            serv = op.getServidorEmailOrdemCompra();
        }
        if (modeloEmail == null) {
            modeloEmail = op.getModeloEmailOrdemCompra();
        }
        e.setAssunto(modeloEmail.getTituloEmail());
        e.setRemetente(serv.getEmail());
        e.setCorpoMensagem(this.getTextoEmail(new String(modeloEmail.getModelo()), vo));
        e.setServidor(new Email.ServidorEmail(serv.getServidor(), serv.getServidorImap(), serv.getServidorPop(), serv.getEmail(), serv.getSenha(), serv.getPortaEmail(), serv.getNaoAutenticarEmail(), serv.getLogin(), serv.getServerProperties(), serv.getGerarArquivoExtensaoEml(), serv.getDebugServer()));
        e.setDestinatariosStr(this.getDestinatariosContato(vo, op.getEmailCopiaOrdemCompra(), op.getEnviarXMLNFeTransportadora(), envSomenteSolicitante));
        e.addAnexos(this.getAnexos(vo, bi, empresa, usuario, grupoUsuarios));
        ToolSendEmail.sendEmailWithException((Email)e);
    }

    private HashSet<String> getDestinatariosContato(OrdemCompra vo, String emailCopiaOC, Short enviarEmailTransportador, Boolean envSomenteSolicitante) {
        ArrayList<String> emails = new ArrayList<String>();
        if (!envSomenteSolicitante.booleanValue()) {
            for (EmailPessoa e : vo.getUnidadeFatFornecedor().getFornecedor().getPessoa().getComplemento().getEmails()) {
                if (e.getEnviarDadosCotacao() == null || e.getEnviarDadosCotacao() != 1 || e.getEmail() == null || e.getEmail().trim().length() <= 0 || emails.contains(e.getEmail())) continue;
                emails.add(e.getEmail());
            }
            if (enviarEmailTransportador != null && enviarEmailTransportador == 1 && vo.getTransportador() != null) {
                for (EmailPessoa e : vo.getTransportador().getPessoa().getComplemento().getEmails()) {
                    if (e.getEnviarDadosCotacao() == null || e.getEnviarDadosCotacao() != 1 || e.getEmail() == null || e.getEmail().trim().length() <= 0 || emails.contains(e.getEmail())) continue;
                    emails.add(e.getEmail());
                }
            }
            for (EmailPessoa e : vo.getEmailsOrdemCompra()) {
                if (emails.contains(e.getEmail())) continue;
                emails.add(e.getEmail());
            }
        }
        for (ItemOrdemCompra i : vo.getItemOrdemCompra()) {
            for (ItemOrdemCompraNecCompra o : i.getItemOrdemCompraNecCompra()) {
                for (EmailPessoa e : o.getNecessidadeCompra().getUsuarioSolicitante().getUsuarioBasico().getPessoa().getComplemento().getEmails()) {
                    if (e.getEnviarDadosCotacao() == null || e.getEnviarDadosCotacao() != 1 || e.getEmail() == null || e.getEmail().trim().length() <= 0 || emails.contains(e.getEmail())) continue;
                    emails.add(e.getEmail());
                }
            }
        }
        if (emailCopiaOC != null && !emails.contains(emailCopiaOC)) {
            emails.add(emailCopiaOC);
        }
        HashSet<String> r = new HashSet<String>();
        emails.forEach(email -> r.addAll(this.separarEmails((String)email)));
        return r;
    }

    private Collection separarEmails(String emails) {
        StringTokenizer sk = new StringTokenizer(emails, ";");
        ArrayList<String> r = new ArrayList<String>();
        while (sk.hasMoreTokens()) {
            r.add(sk.nextToken());
        }
        return r;
    }

    private List<File> getAnexos(OrdemCompra vo, BusinessIntelligence bi, Empresa empresa, Usuario usuario, Grupo grupoUsuario) throws ExceptionService, IOException, ExceptionExportRelatorio {
        try {
            CompBIDefaultParams comp = (CompBIDefaultParams)Context.get(CompBIDefaultParams.class);
            comp.buildDefValuesParams(bi, CompBIDefaultParams.getDefParamsMap((Empresa)empresa, (Usuario)usuario, (Grupo)grupoUsuario, (Object[])new Object[]{vo}), (Object)vo);
            DataOutputBI out = ((ServiceBuildBusinessIntelligenceImpl)ConfApplicationContext.getBean(ServiceBuildBusinessIntelligenceImpl.class)).gerarConverterFormatoImpBI(bi, ConstEnumFormImprBI.PDF, EnumConstTipoSistema.DESKTOP, CompBIDefaultParams.getDefParamsMap((Empresa)empresa, (Usuario)usuario, (Grupo)grupoUsuario, (Object[])new Object[]{vo}));
            File f = File.createTempFile("Ordem Compra " + vo.getIdentificador().toString(), ".pdf");
            CoreUtilityFactory.getUtilityJasperReports().export(new FormImpressaoExporterPDF(), out, f);
            ArrayList<File> list = new ArrayList<File>();
            list.add(f);
            return list;
        }
        catch (ExceptionBuildBI | ExceptionIO ex) {
            Logger.getLogger(UtilityEmailOrdemCompra.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionService(ex);
        }
    }

    private String getTextoEmail(String modelo, OrdemCompra ordemCompra) {
        List tokens = ToolString.getReplaceTokens((String)modelo);
        HashMap<String, String> values = new HashMap<String, String>();
        for (Object o : tokens) {
            StringToken tk = (StringToken)o;
            String value = this.getValueEmail(tk.getChave(), ordemCompra);
            values.put(tk.getChave(), value);
        }
        return ToolString.build((String)modelo, values);
    }

    private String getValueEmail(String token, OrdemCompra vo) {
        if (token == null || vo == null) {
            return "";
        }
        if (token.equalsIgnoreCase("numero")) {
            return vo.getIdentificador().toString();
        }
        if (token.equalsIgnoreCase("fornecedor")) {
            return vo.getUnidadeFatFornecedor().getFornecedor().getPessoa().getNome();
        }
        if (token.equalsIgnoreCase("dataPrevFaturamento")) {
            return DateUtil.dateToStr(vo.getDataPrevFaturamento());
        }
        if (token.equalsIgnoreCase("dataPrevChegada")) {
            return DateUtil.dateToStr(vo.getDataPrevChegada());
        }
        if (token.equalsIgnoreCase("dataEmissao")) {
            return DateUtil.dateToStr(vo.getDataEmissao());
        }
        if (token.equalsIgnoreCase("usuarioComprador")) {
            return vo.getUsuario().getUsuarioBasico().getPessoa().getNome();
        }
        return "";
    }
}

