/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.pedido;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.Expedicao;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesRelacionamento;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.ServidorEmail;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.email.Email;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.utilities.impl.nfe.NFeBuildText;
import mentorcore.utilities.impl.pedido.PedidoBuildText;

class AuxEmailPedido {
    private final TLogger logger = TLogger.get(AuxEmailPedido.class);
    private final Pedido pedido;
    private final OpcoesRelacionamento opcoesRelacionamento;
    private Usuario usuario;

    public AuxEmailPedido(Pedido p, OpcoesRelacionamento opcoes) {
        this.pedido = p;
        this.opcoesRelacionamento = opcoes;
    }

    public AuxEmailPedido(Pedido p, OpcoesRelacionamento opcoes, Usuario usuario) {
        this.pedido = p;
        this.opcoesRelacionamento = opcoes;
        this.usuario = usuario;
    }

    public Email gerarEmail() throws ExceptionService {
        Email email = null;
        if (this.pedido.getSituacaoPedido() != null && this.pedido.getSituacaoPedido().getModeloEmail() != null && this.isValidToCreateEmail(this.pedido)) {
            try {
                ServidorEmail servidor = this.opcoesRelacionamento.getServidorEmail();
                email = new Email(true);
                email.setRemetente(servidor.getEmail());
                email.setDestinatariosStr(this.getRecipientes(this.pedido.getUnidadeFatCliente().getCliente().getPessoa()));
                email.setAssunto(this.pedido.getSituacaoPedido().getModeloEmail().getTituloEmail());
                String texto = this.getTextoEmail(new String(this.pedido.getSituacaoPedido().getModeloEmail().getModelo()), this.pedido);
                email.setCorpoMensagem(texto);
                email.setServidor(new Email.ServidorEmail(servidor.getServidor(), servidor.getServidorImap(), servidor.getServidorPop(), servidor.getEmail(), servidor.getSenha(), servidor.getPortaEmail(), servidor.getNaoAutenticarEmail(), servidor.getLogin(), servidor.getServerProperties(), servidor.getGerarArquivoExtensaoEml(), servidor.getDebugServer()));
                email.addAnexos(this.getAnexos(this.pedido));
                email.setZiparAnexos(servidor.getZiparEmails() != null && servidor.getZiparEmails() == 1);
            }
            catch (IOException ex) {
                this.logger.error(ex.getClass(), (Throwable)ex);
                throw new ExceptionService(ex);
            }
        }
        return email;
    }

    private boolean isValidToCreateEmail(Pedido p) throws ExceptionService {
        if (p.getUnidadeFatCliente().getCliente().getPessoa().getComplemento().getEmails() == null) {
            return false;
        }
        if (p.getUnidadeFatCliente().getCliente().getPessoa().getComplemento().getEmails().isEmpty()) {
            return false;
        }
        if (this.opcoesRelacionamento == null) {
            return false;
        }
        if (this.opcoesRelacionamento.getServidorEmail() == null) {
            return false;
        }
        if (p.getSituacaoPedido().getEmail() == null || p.getSituacaoPedido().getEmail() != 1) {
            return false;
        }
        if (p.getSituacaoPedido().getEnviarSomenteNfAprovada() != null && p.getSituacaoPedido().getEnviarSomenteNfAprovada() == 1 && (p.getExpedicao() == null || p.getExpedicao().isEmpty() || ((Expedicao)p.getExpedicao().get(0)).getNotaFiscalPropria() == null)) {
            return false;
        }
        if (p.getExpedicao() != null && !p.getExpedicao().isEmpty() && ((Expedicao)p.getExpedicao().get(0)).getNotaFiscalPropria() != null && p.getSituacaoPedido().getEnviarSomenteNfAprovada() != null && p.getSituacaoPedido().getEnviarSomenteNfAprovada() == 1) {
            HashMap<String, NotaFiscalPropria> h = new HashMap<String, NotaFiscalPropria>();
            h.put("nota", ((Expedicao)p.getExpedicao().get(0)).getNotaFiscalPropria());
            Short aux = ((Expedicao)p.getExpedicao().get(0)).getNotaFiscalPropria().getStatus();
            if (aux == null || !EnumConstNFeStatus.isStatusAutorizada((Integer)aux.intValue())) {
                return false;
            }
        }
        return true;
    }

    private HashSet<String> getRecipientes(Pessoa p) {
        HashSet<String> emails = new HashSet<String>();
        if (p.getComplemento().getEmails() != null) {
            for (EmailPessoa o : p.getComplemento().getEmails()) {
                if (o.getAtivo() == null || o.getAtivo() != 1 || o.getEnviarDadosNfe() == null || o.getEnviarDadosNfe() != 1) continue;
                emails.add(o.getEmail());
            }
        }
        String email = this.opcoesRelacionamento.getEmailCopia();
        if (this.opcoesRelacionamento.getEnviarCopia() != null && this.opcoesRelacionamento.getEnviarCopia() == 1 && email != null && email.trim().length() > 0) {
            emails.add(email);
        }
        return emails;
    }

    private String getTextoEmail(String modelo, NotaFiscalPropria nota, Usuario usuario) {
        List tokens = ToolString.getReplaceTokens((String)modelo);
        HashMap<String, String> values = new HashMap<String, String>();
        for (Object o : tokens) {
            StringToken tk = (StringToken)o;
            String value = NFeBuildText.getInstance().getValueEmail(tk.getChave(), nota, usuario);
            values.put(tk.getChave(), value);
        }
        return ToolString.build((String)modelo, values);
    }

    private List getAnexos(Pedido p) throws IOException, ExceptionService {
        ArrayList anexos = new ArrayList();
        return anexos;
    }

    private String getTextoEmail(String modelo, Pedido pedido) {
        List tokens = ToolString.getReplaceTokens((String)modelo);
        HashMap<String, String> values = new HashMap<String, String>();
        for (Object o : tokens) {
            StringToken tk = (StringToken)o;
            String value = PedidoBuildText.getInstance().getValue(tk.getChave(), pedido);
            values.put(tk.getChave(), value);
        }
        return ToolString.build((String)modelo, values);
    }
}

