/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.pedido;

import com.touchcomp.basementor.model.deprecated.PreFaturamentoPedItem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeItemPedido;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.rateio.CompRateio;
import com.touchcomp.basementorservice.components.totalizadores.CompTotalizadores;
import com.touchcomp.basementorservice.helpers.impl.condicoespagamento.HelperCondicoesPagamento;
import com.touchcomp.basementorservice.helpers.impl.pedido.HelperPedido;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.exceptions.ExceptionCalculoICMS;
import mentorcore.exceptions.ExceptionCalculoIPI;
import mentorcore.exceptions.ExceptionCalculoPisCofins;
import mentorcore.exceptions.ExceptionCategoriaSTNotFound;
import mentorcore.exceptions.ExceptionService;
import mentorcore.utilities.impl.calculoimpostos.CalculosImpFiscaisPedidos;

class CalculoValoresPedido {
    private static final TLogger logger = TLogger.get(CalculoValoresPedido.class);

    CalculoValoresPedido() {
    }

    public void calculoValoresPedido(List<ItemPedido> itens, Representante rep, NaturezaOperacao nat, Empresa emp, Date dataEmissao, UnidadeFatCliente unid, OpcoesFaturamento opcoesFaturamento) throws ExceptionService {
        for (ItemPedido it : itens) {
            this.putQuantidadeTotal(it);
            this.putValorDescTrib(it);
            this.putValorTotalBruto(it);
            this.putBancoCredito(it);
            this.putValorTotal(it);
            this.putPeso(it);
        }
    }

    private void putValorDescTrib(ItemPedido it) {
        if (it.getPercDescTrib() != null) {
            it.setValorUnitarioDescTrib(Double.valueOf(it.getValorUnitario() - it.getValorUnitario() * (it.getPercDescTrib() / 100.0)));
        } else {
            it.setValorUnitarioDescTrib(it.getValorUnitario());
        }
    }

    private void putQuantidadeTotal(ItemPedido it) {
        if (it.getTipoCondicao() == 0) {
            double qtd = 0.0;
            for (GradeItemPedido g : it.getGradeItemPedido()) {
                qtd += g.getQuantidade().doubleValue();
            }
            it.setQuantidadeTotal(Double.valueOf(qtd));
        }
    }

    private void putValorTotalBruto(ItemPedido item) {
        item.setValorTotalBruto(ToolFormatter.arrredondarNumero((Double)(item.getValorUnitario() * item.getQuantidadeTotal()), (int)2));
        item.setValorTotalBrutoDescTrib(ToolFormatter.arrredondarNumero((Double)(item.getValorUnitarioDescTrib() * item.getQuantidadeTotal()), (int)2));
    }

    private void putBancoCredito(ItemPedido it) {
        if (it.getTipoCondicao() == 0) {
            double valorBC = it.getValorTotalBruto();
            it.setValorBancoCredito(Double.valueOf(valorBC -= it.getQuantidadeTotal() * it.getValorMinimo()));
        }
    }

    private void putValorTotal(ItemPedido item) {
        if (item.getTipoCondicao() == 0) {
            Double valorTotal = item.getValorTotalBruto() - item.getValorDesconto() + item.getValorFrete() + item.getValorSeguro() + item.getValorDespesaAcessoria();
            item.setValorTotal(valorTotal);
            Double valorTotalDescTrib = item.getValorTotalBrutoDescTrib() - item.getValorDesconto() + item.getValorFrete() + item.getValorSeguro() + item.getValorDespesaAcessoria();
            item.setValorTotalDescTrib(valorTotalDescTrib);
            item.setValorTotalComImpostos(valorTotalDescTrib);
        }
    }

    private void putPeso(ItemPedido it) {
        if (it.getTipoCondicao() == 0) {
            Double pesoItem = it.getProduto().getPesoUnitario() + it.getProduto().getPesoEmbalagem();
            if (pesoItem == null) {
                pesoItem = 0.0;
            }
            Double d = pesoItem * it.getQuantidadeTotal();
        }
    }

    public void calcularTotalizadores(Pedido ped, OpcoesFinanceiras opcoesFinanceiras) {
        CompTotalizadores c = new CompTotalizadores();
        c.calculoTotalizadores(ped);
        new HelperPedido().calcularPercDescontoSuframa(ped);
        new HelperPedido().calcularComissao(ped, opcoesFinanceiras);
    }

    public void calcularValoresPedido(Pedido ped, OpcoesFaturamento opcoes, OpcoesFinanceiras opcoesFinanceiras) throws ExceptionService {
        int ret = ((HelperCondicoesPagamento)Context.get(HelperCondicoesPagamento.class)).calcularNrDiasMedios(ped.getCondicoesPagamento(), ped.getCondPagMut());
        ped.setDiasMediosCondPag(Short.valueOf((short)ret));
        CompRateio comp = new CompRateio();
        comp.rateioValores(ped, opcoes);
        new CalculoValoresPedido().calculoValoresPedido(ped.getItemPedido(), ped.getRepresentante(), ped.getNaturezaOperacao(), ped.getEmpresa(), ped.getDataEmissao(), ped.getUnidadeFatCliente(), opcoes);
        if (opcoes.getCalcularImpPrevPedido() != null && opcoes.getCalcularImpPrevPedido() == 1) {
            try {
                CalculosImpFiscaisPedidos.calcularImpostosFiscaisItemPedido(ped.getItemPedido(), ped.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf(), ped.getEmpresa(), opcoes.getTipoCalculoST(), ped.getUnidadeFatCliente().getCliente().getPessoa().getComplemento().getCnae(), (short)ped.getUnidadeFatCliente().getCliente().getPessoa().getComplemento().getContribuinteEstado(), (short)opcoes.getUsarCategoriaST(), ped.getUnidadeFatCliente().getCliente().getFaturamento().getTipoConsumidor(), null, ped.getUnidadeFatCliente(), opcoes.getVersaoNFe(), opcoes);
            }
            catch (ExceptionCalculoIPI ex) {
                logger.error(ex.getClass(), (Throwable)ex);
            }
            catch (ExceptionCalculoPisCofins ex) {
                logger.error(ex.getClass(), (Throwable)ex);
            }
            catch (ExceptionCalculoICMS ex) {
                logger.error(ex.getClass(), (Throwable)ex);
            }
            catch (ExceptionCategoriaSTNotFound ex) {
                logger.error(ex.getClass(), (Throwable)ex);
            }
        }
        new CalculoValoresPedido().calcularTotalizadores(ped, opcoesFinanceiras);
    }

    public HashMap getValorTotalItemPedido(List itens, double percDescFinance) {
        HashMap<String, Double> h = new HashMap<String, Double>();
        Double valor = 0.0;
        Double valorIcmsSt = 0.0;
        Double valorParaBCComissaoTitulo = 0.0;
        for (Object o : itens) {
            ItemPedido i = (ItemPedido)o;
            if (i.getModeloFiscal().getGerarFinanceiro() != 1) continue;
            valor = i.getValorTotalComImpostos() >= 0.0 ? Double.valueOf(valor + (i.getValorTotalComImpostos() - i.getValorTotalComImpostos() * (percDescFinance / 100.0))) : Double.valueOf(valor + (i.getValorTotal() - i.getValorTotal() * (percDescFinance / 100.0)));
            valorParaBCComissaoTitulo = valorParaBCComissaoTitulo + i.getValorTotal();
            if (i.getItemPedidoFiscal() == null || !(i.getItemPedidoFiscal().getVrIcmsSt() > 0.0)) continue;
            valorIcmsSt = valorIcmsSt + i.getItemPedidoFiscal().getVrIcmsSt();
        }
        h.put("valorTotal", valor);
        h.put("valorICMSST", valorIcmsSt);
        h.put("valorParaBCComissaoTitulo", valorParaBCComissaoTitulo);
        return h;
    }

    public HashMap getValorTotalItemPedido(Pedido pedido) {
        HashMap<String, Double> h = new HashMap<String, Double>();
        Double valor = 0.0;
        Double valorIcmsSt = 0.0;
        if (ToolMethods.isEquals((Object)pedido.getSituacaoPedido().getGerarFinanceiroNFCe(), (Object)0)) {
            for (Object o : pedido.getItemPedido()) {
                ItemPedido i = (ItemPedido)o;
                if (i.getModeloFiscal() != null && i.getModeloFiscal().getGerarFinanceiro() != 1) continue;
                valor = valor + i.getValorTotal();
            }
        } else {
            for (Object o : pedido.getItemPedido()) {
                ItemPedido i = (ItemPedido)o;
                if (i.getModeloFiscal() != null && i.getModeloFiscal().getGerarFinanceiro() != 1) continue;
                valor = valor + i.getValorTotalComImpostos();
            }
        }
        h.put("valorTotal", valor);
        h.put("valorICMSST", valorIcmsSt);
        return h;
    }

    public HashMap getValorTotalItemPreFaturamento(List<PreFaturamentoPedItem> itens, double percDescFinance) {
        HashMap<String, Double> h = new HashMap<String, Double>();
        Double valor = 0.0;
        Double valorIcmsSt = 0.0;
        Double valorParaBCComissaoTitulo = 0.0;
        for (PreFaturamentoPedItem preItem : itens) {
            if (preItem.getGerarFinanceiro() != 1) continue;
            valor = valor + (preItem.getValorTotal() - preItem.getValorTotal() * (percDescFinance / 100.0));
            valorParaBCComissaoTitulo = valorParaBCComissaoTitulo + preItem.getValorTotal();
        }
        h.put("valorTotal", valor);
        h.put("valorICMSST", valorIcmsSt);
        h.put("valorParaBCComissaoTitulo", valorParaBCComissaoTitulo);
        return h;
    }
}

