/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.pedido;

import com.touchcomp.basementor.model.deprecated.PreFaturamentoPedItem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Expedicao;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.LiberacaoPedidoPedItem;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesRelacionamento;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.email.Email;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import mentorcore.exceptions.ExceptionService;
import mentorcore.utilities.CoreUtility;
import mentorcore.utilities.impl.pedido.AuxEmailPedido;
import mentorcore.utilities.impl.pedido.CalculoValoresPedido;
import mentorcore.utilities.impl.pedido.PedidoBuildText;

public class UtilityPedido
extends CoreUtility {
    public Email gerarEmail(Pedido p, OpcoesRelacionamento opcoes, Usuario usuario) throws ExceptionService {
        return new AuxEmailPedido(p, opcoes, usuario).gerarEmail();
    }

    public void calcularValoresPedido(Pedido ped, OpcoesFaturamento opcoes, OpcoesFinanceiras opcoesFinanceiras) throws ExceptionService {
        new CalculoValoresPedido().calcularValoresPedido(ped, opcoes, opcoesFinanceiras);
    }

    public HashMap getValorTotalItemPedido(Pedido pedido) {
        return new CalculoValoresPedido().getValorTotalItemPedido(pedido);
    }

    public HashMap getValorTotalItemPedido(List<ItemPedido> itemPedido, Double percFinanceiro) {
        return new CalculoValoresPedido().getValorTotalItemPedido(itemPedido, percFinanceiro);
    }

    public void calculoValoresPedido(List<ItemPedido> its, Representante representante, NaturezaOperacao naturezaOperacao, Empresa logedEmpresa, Date date, UnidadeFatCliente unidadeFatCliente, OpcoesFaturamento opcoesFaturamento) throws ExceptionService {
        new CalculoValoresPedido().calculoValoresPedido(its, representante, naturezaOperacao, logedEmpresa, date, unidadeFatCliente, opcoesFaturamento);
    }

    public void calcularTotalizadores(Pedido p, OpcoesFinanceiras opcoesFinanceiras) {
        new CalculoValoresPedido().calcularTotalizadores(p, opcoesFinanceiras);
    }

    public String getTextValue(String token, Pedido pedido) {
        return new PedidoBuildText().getValue(token, pedido);
    }

    public HashMap getValorTotalItemPreFaturamento(List<PreFaturamentoPedItem> itensPre, Double percDescFinanceiro) {
        return new CalculoValoresPedido().getValorTotalItemPreFaturamento(itensPre, percDescFinanceiro);
    }

    public boolean pedidoFaturado(Pedido p) {
        if (p.getExpedicao() == null) {
            return false;
        }
        Optional<Expedicao> found = p.getExpedicao().stream().filter(it -> it.getNotaFiscalPropria() != null).findFirst();
        return found.isPresent();
    }

    public void libBloqPedAcordoItens(Pedido ped, OpcoesFaturamento op) {
        if (ped.getSituacaoPedido() == null) {
            return;
        }
        if (ped.getSituacaoPedido().getCancelarTitulos() != null && ped.getSituacaoPedido().getCancelarTitulos() == 1) {
            ped.getLiberacaoPedidoPed().setLiberado(Short.valueOf((short)1));
            return;
        }
        boolean achou = false;
        for (LiberacaoPedidoPedItem iten : ped.getLiberacaoPedidoPed().getItens()) {
            if (iten.getLiberado() != 0) continue;
            achou = true;
        }
        if (!achou) {
            ped.getLiberacaoPedidoPed().setLiberado(Short.valueOf((short)1));
            ped.getLiberacaoPedidoPed().setDataLiberacaoTdItens(new Date());
        } else {
            ped.getLiberacaoPedidoPed().setLiberado(Short.valueOf((short)0));
            if (op.getSituacaoPedidosBloqueio() != null) {
                ped.setSituacaoPedido(op.getSituacaoPedidosBloqueio());
            }
        }
    }
}

