/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.pedidocomercio;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FechamentoPedidoComercio;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemPedidoComercio;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.PedComercioFormasPag;
import com.touchcomp.basementor.model.vo.PedidoComercio;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorspringcontext.Context;
import contatocore.util.ContatoFormatUtil;
import java.util.Date;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoQTD;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOCARREGAMENTO;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOSALDO;
import mentorcore.utilities.impl.saldoestoque.SaldoEstoqueUtilities;

public class UtilityPedidoComercio {
    private static final TLogger logger = TLogger.get(UtilityPedidoComercio.class);

    public void calculaValoresTotaisPedido(PedidoComercio p) {
        this.calcularValoresItens(p);
        Double vlrTotal = this.getValorTotalBruto(p);
        p.setValorTotalBruto(vlrTotal);
        this.ratearDesconto(p);
        this.ratearAcrescimo(p);
        this.recalcularValorTotalItens(p);
        p.setValorTotal(this.getValorTotal(p));
        this.calcularRecebimento(p);
        this.recalcularComissao(p);
    }

    public void calculaValoresTotaisPedido(FechamentoPedidoComercio fechamento) {
        Double percAcrescimo = 0.0;
        Double percDesconto = 0.0;
        if (fechamento.getTipoAcrescimo().equals((short)1)) {
            percAcrescimo = ContatoFormatUtil.arrredondarNumero((Double)(fechamento.getValorAcrescimo() * 100.0 / fechamento.getValorTotalBruto()), (int)2);
        } else {
            percAcrescimo = fechamento.getPercAcrescimo();
            fechamento.setValorAcrescimo(ContatoFormatUtil.arrredondarNumero((Double)(fechamento.getValorTotalBruto() * percAcrescimo / 100.0), (int)2));
        }
        if (fechamento.getTipoDesconto().equals((short)1)) {
            percDesconto = ContatoFormatUtil.arrredondarNumero((Double)(fechamento.getValorDesconto() * 100.0 / fechamento.getValorTotalBruto()), (int)2);
        } else {
            percDesconto = fechamento.getPercDesconto();
            fechamento.setValorDesconto(ContatoFormatUtil.arrredondarNumero((Double)(fechamento.getValorTotalBruto() * percDesconto / 100.0), (int)2));
        }
        Double valorDescontoAcum = 0.0;
        Double valorAcrescimoAcum = 0.0;
        Integer nrPedidos = fechamento.getPedidosComercio().size();
        Integer cont = 1;
        for (PedidoComercio p : fechamento.getPedidosComercio()) {
            this.calcularValoresItens(p);
            Double vlrTotal = this.getValorTotalBruto(p);
            p.setValorTotalBruto(vlrTotal);
            Double valorDesconto = ContatoFormatUtil.arrredondarNumero((Double)(vlrTotal * (percDesconto / 100.0)), (int)2);
            Double valorAcrescimo = ContatoFormatUtil.arrredondarNumero((Double)(vlrTotal * (percAcrescimo / 100.0)), (int)2);
            valorDescontoAcum = valorDescontoAcum + valorDesconto;
            valorAcrescimoAcum = valorAcrescimoAcum + valorAcrescimo;
            if (cont.equals(nrPedidos) && fechamento.getValorDesconto() > valorDescontoAcum) {
                valorDesconto = fechamento.getValorDesconto() - valorDescontoAcum + valorDesconto;
            }
            if (cont.equals(nrPedidos) && fechamento.getValorAcrescimo() > valorAcrescimoAcum) {
                valorAcrescimo = fechamento.getValorAcrescimo() - valorAcrescimoAcum + valorAcrescimo;
            }
            this.ratearDescontoFechamento(p, valorDesconto, percDesconto, fechamento.getTipoDesconto());
            this.ratearAcrescimoFechamento(p, valorAcrescimo, percAcrescimo, fechamento.getTipoAcrescimo());
            this.recalcularValorTotalItens(p);
            p.setValorTotal(this.getValorTotal(p));
            Integer n = cont;
            cont = cont + 1;
        }
        this.calcularRecebimentoFechamento(fechamento);
    }

    private Double getValorTotal(PedidoComercio p) {
        double vlr = 0.0;
        for (ItemPedidoComercio i : p.getItensPedido()) {
            if (i.getItemCancelado() != null && i.getItemCancelado() == 1) continue;
            vlr += i.getValorTotal().doubleValue();
        }
        return vlr;
    }

    private Double getValorTotalBruto(PedidoComercio p) {
        double vlr = 0.0;
        for (ItemPedidoComercio i : p.getItensPedido()) {
            if (i.getItemCancelado() != null && i.getItemCancelado() == 1) continue;
            vlr += i.getValorTotalBruto().doubleValue();
        }
        return vlr;
    }

    private void ratearDesconto(PedidoComercio p) {
        double vlrDesconto = 0.0;
        double vlrDescontoAcu = 0.0;
        double vlrBrutoItensNaoCanc = this.getVlrTotalBrutoDescNaoCancInf(p);
        double percentualDesc = 0.0;
        if (vlrBrutoItensNaoCanc <= 0.0 && (p.getPercDescontoInf() > 0.0 || p.getValorDescontoInf() > 0.0)) {
            throw new RuntimeException("N\u00e3o existem itens para ratear o desconto.");
        }
        if (p.getTipoDesconto() != null && p.getTipoDesconto() == 0) {
            percentualDesc = p.getPercDescontoInf();
        } else if (p.getValorDescontoInf() > 0.0 && vlrBrutoItensNaoCanc > 0.0) {
            percentualDesc = ContatoFormatUtil.arrredondarNumero((Double)(p.getValorDescontoInf() / vlrBrutoItensNaoCanc * 100.0), (int)4);
        }
        for (ItemPedidoComercio i : p.getItensPedido()) {
            if (i.getItemCancelado() != null && i.getItemCancelado() == 1) continue;
            if (i.getDescontoItem() == 0 && percentualDesc > 0.0) {
                double aux = ContatoFormatUtil.arrredondarNumero((Double)(i.getValorTotalBruto() * (percentualDesc / 100.0)), (int)2);
                i.setValorDesconto(Double.valueOf(aux));
                i.setPercentualDesconto(Double.valueOf(percentualDesc));
                vlrDescontoAcu += aux;
            } else if (i.getDescontoItem() == 1) {
                vlrDesconto += i.getValorDesconto().doubleValue();
            }
            if (i.getDescontoItem() == null || i.getDescontoItem() != 0 || !(percentualDesc <= 0.0)) continue;
            i.setValorDesconto(Double.valueOf(0.0));
            i.setPercentualDesconto(Double.valueOf(0.0));
        }
        p.setPercDescontoInf(Double.valueOf(percentualDesc));
        p.setValorDesconto(Double.valueOf(p.getValorDescontoInf() + vlrDesconto));
        Double percDesc = 0.0;
        if (p.getValorDesconto() > 0.0 && p.getValorTotalBruto() > 0.0) {
            percDesc = ContatoFormatUtil.arrredondarNumero((Double)(p.getValorDesconto() / p.getValorTotalBruto() * 100.0), (int)4);
        }
        p.setPercDesconto(percDesc);
        ItemPedidoComercio toAcerto = this.getUltimoItemNaoCanceladoAndNaoInfDesconto(p.getItensPedido());
        if (toAcerto != null) {
            toAcerto.setValorDesconto(ContatoFormatUtil.arrredondarNumero((Double)(toAcerto.getValorDesconto() + (p.getValorDescontoInf() - vlrDescontoAcu)), (int)2));
        }
    }

    private void ratearAcrescimo(PedidoComercio p) {
        double vlrAcrescimo = 0.0;
        double vlrAcrescimoAcu = 0.0;
        double vlrBrutoItensNaoCanc = this.getVlrTotalBrutoAcresNaoCancInf(p);
        double percentualAcres = 0.0;
        if (vlrBrutoItensNaoCanc <= 0.0 && (p.getPercAcrescimoInf() > 0.0 || p.getValorAcrescimoInf() > 0.0)) {
            throw new RuntimeException("N\u00e3o existem itens para ratear o acr\u00e9scimo.");
        }
        if (p.getTipoAcrescimo() != null && p.getTipoAcrescimo() == 0) {
            percentualAcres = p.getPercAcrescimoInf();
        } else if (p.getValorAcrescimoInf() > 0.0 && vlrBrutoItensNaoCanc > 0.0) {
            percentualAcres = ContatoFormatUtil.arrredondarNumero((Double)(p.getValorAcrescimoInf() / vlrBrutoItensNaoCanc * 100.0), (int)4);
        }
        for (ItemPedidoComercio i : p.getItensPedido()) {
            if (i.getItemCancelado() != null && i.getItemCancelado() == 1) continue;
            if (i.getAcrescimoItem() != 1 && percentualAcres > 0.0) {
                double aux = ContatoFormatUtil.arrredondarNumero((Double)(i.getValorTotalBruto() * (percentualAcres / 100.0)), (int)2);
                i.setValorAcrescimo(Double.valueOf(aux));
                i.setPercAcrescimo(Double.valueOf(percentualAcres));
                vlrAcrescimoAcu += aux;
            } else {
                vlrAcrescimo += i.getValorAcrescimo().doubleValue();
            }
            if (i.getAcrescimoItem() == null || i.getAcrescimoItem() != 0 || !(percentualAcres <= 0.0)) continue;
            i.setValorAcrescimo(Double.valueOf(0.0));
            i.setPercAcrescimo(Double.valueOf(0.0));
        }
        p.setPercAcrescimoInf(Double.valueOf(percentualAcres));
        p.setValorAcrescimo(Double.valueOf(p.getValorAcrescimoInf() + vlrAcrescimo));
        Double percAcres = 0.0;
        if (p.getValorAcrescimo() > 0.0 && p.getValorTotalBruto() > 0.0) {
            percAcres = ContatoFormatUtil.arrredondarNumero((Double)(p.getValorAcrescimo() / p.getValorTotalBruto() * 100.0), (int)4);
        }
        p.setPercAcrescimo(percAcres);
        ItemPedidoComercio toAcerto = this.getUltimoItemNaoCanceladoAndNaoInfAcrescimo(p.getItensPedido());
        if (toAcerto != null) {
            toAcerto.setValorAcrescimo(ContatoFormatUtil.arrredondarNumero((Double)(toAcerto.getValorAcrescimo() + (p.getValorAcrescimoInf() - vlrAcrescimoAcu)), (int)2));
        }
    }

    private void recalcularValorTotalItens(PedidoComercio p) {
        for (Object o : p.getItensPedido()) {
            ItemPedidoComercio i = (ItemPedidoComercio)o;
            if (i.getItemCancelado() != null && i.getItemCancelado() == 1) continue;
            i.setValorTotal(Double.valueOf(i.getValorTotalBruto() - i.getValorDesconto() + i.getValorAcrescimo()));
        }
    }

    private void calcularValoresItens(PedidoComercio p) {
        for (ItemPedidoComercio i : p.getItensPedido()) {
            if (i.getItemCancelado() != null && i.getItemCancelado() == 1) continue;
            i.setValorTotalBruto(Double.valueOf(i.getQuantidadeTotal() * i.getValorUnitario()));
        }
    }

    private ItemPedidoComercio getUltimoItemNaoCancelado(List<ItemPedidoComercio> itensPedido) {
        for (int i = itensPedido.size() - 1; i >= 0; --i) {
            ItemPedidoComercio item = itensPedido.get(i);
            if (item.getItemCancelado() != null && item.getItemCancelado() == 1) continue;
            return item;
        }
        return null;
    }

    private ItemPedidoComercio getUltimoItemNaoCanceladoAndNaoInfDesconto(List<ItemPedidoComercio> itensPedido) {
        for (int i = itensPedido.size() - 1; i >= 0; --i) {
            ItemPedidoComercio item = itensPedido.get(i);
            if (item.getItemCancelado() == null || item.getItemCancelado() == 1 || item.getDescontoItem() == null || item.getDescontoItem() == 1) continue;
            return item;
        }
        return null;
    }

    private ItemPedidoComercio getUltimoItemNaoCanceladoAndNaoInfAcrescimo(List<ItemPedidoComercio> itensPedido) {
        for (int i = itensPedido.size() - 1; i >= 0; --i) {
            ItemPedidoComercio item = itensPedido.get(i);
            if (item.getItemCancelado() == null || item.getItemCancelado() == 1 || item.getAcrescimoItem() == null || item.getAcrescimoItem() == 1) continue;
            return item;
        }
        return null;
    }

    private void calcularRecebimento(PedidoComercio p) {
        if (p.getFechamentoPedidoComercio() != null) {
            p.getFechamentoPedidoComercio().setValorTotal(ContatoFormatUtil.arrredondarNumero((Double)p.getValorTotal(), (int)2));
            Double valorTotalRec = 0.0;
            for (PedComercioFormasPag f : p.getFechamentoPedidoComercio().getFormasPagCupomFiscal()) {
                valorTotalRec = valorTotalRec + f.getValor();
            }
            valorTotalRec = ContatoFormatUtil.arrredondarNumero((Double)valorTotalRec, (int)2);
            p.getFechamentoPedidoComercio().setValorRecebido(valorTotalRec);
            p.getFechamentoPedidoComercio().setValorTroco(ContatoFormatUtil.arrredondarNumero((Double)(valorTotalRec - p.getValorTotal()), (int)2));
            if (p.getFechamentoPedidoComercio().getValorTroco() < 0.01 && p.getFechamentoPedidoComercio().getValorTroco() > -0.01) {
                p.getFechamentoPedidoComercio().setValorTroco(Double.valueOf(0.0));
            }
            p.getFechamentoPedidoComercio().setValorAcrescimo(p.getValorAcrescimo());
            p.getFechamentoPedidoComercio().setValorDesconto(p.getValorDesconto());
            p.getFechamentoPedidoComercio().setPercAcrescimo(p.getPercAcrescimo());
            p.getFechamentoPedidoComercio().setPercDesconto(p.getPercDesconto());
            p.getFechamentoPedidoComercio().setTipoAcrescimo(p.getTipoAcrescimo());
            p.getFechamentoPedidoComercio().setTipoDesconto(p.getTipoDesconto());
        }
    }

    private void calcularRecebimentoFechamento(FechamentoPedidoComercio fechamentoPedido) {
        Double percAcrescimo = 0.0;
        Double percDesconto = 0.0;
        Double valorAcrescimo = 0.0;
        Double valorDesconto = 0.0;
        Double valorBruto = 0.0;
        Double valorTotal = 0.0;
        for (PedidoComercio p : fechamentoPedido.getPedidosComercio()) {
            percAcrescimo = p.getPercAcrescimo();
            percDesconto = p.getPercDesconto();
            valorAcrescimo = valorAcrescimo + p.getValorAcrescimo();
            valorDesconto = valorDesconto + p.getValorDesconto();
            valorBruto = valorBruto + p.getValorTotalBruto();
            valorTotal = valorTotal + p.getValorTotal();
        }
        fechamentoPedido.setValorTotal(ContatoFormatUtil.arrredondarNumero((Double)valorTotal, (int)2));
        fechamentoPedido.setValorTotalBruto(ContatoFormatUtil.arrredondarNumero((Double)valorBruto, (int)2));
        fechamentoPedido.setValorAcrescimo(ContatoFormatUtil.arrredondarNumero((Double)valorAcrescimo, (int)2));
        fechamentoPedido.setValorDesconto(ContatoFormatUtil.arrredondarNumero((Double)valorDesconto, (int)2));
        fechamentoPedido.setPercAcrescimo(ContatoFormatUtil.arrredondarNumero((Double)percAcrescimo, (int)2));
        fechamentoPedido.setPercDesconto(ContatoFormatUtil.arrredondarNumero((Double)percDesconto, (int)2));
        Double valorTotalRec = 0.0;
        for (PedComercioFormasPag f : fechamentoPedido.getFormasPagCupomFiscal()) {
            valorTotalRec = valorTotalRec + f.getValor();
        }
        valorTotalRec = ContatoFormatUtil.arrredondarNumero((Double)valorTotalRec, (int)2);
        fechamentoPedido.setValorRecebido(valorTotalRec);
        fechamentoPedido.setValorTroco(ContatoFormatUtil.arrredondarNumero((Double)(valorTotalRec - fechamentoPedido.getValorTotal()), (int)2));
        if (fechamentoPedido.getValorTroco() < 0.01 && fechamentoPedido.getValorTroco() > -0.01) {
            fechamentoPedido.setValorTroco(Double.valueOf(0.0));
        }
    }

    private void ratearDescontoFechamento(PedidoComercio p, Double valorDesconto, Double percDesconto, Short tipoDesconto) {
        p.setValorDesconto(valorDesconto);
        p.setPercDesconto(percDesconto);
        p.setTipoDesconto(tipoDesconto);
        Double vlrDescontoAcu = 0.0;
        for (ItemPedidoComercio i : p.getItensPedido()) {
            if (i.getItemCancelado() != null && i.getItemCancelado() == 1) continue;
            double aux = ContatoFormatUtil.arrredondarNumero((Double)(i.getValorTotalBruto() * (p.getPercDesconto() / 100.0)), (int)2);
            i.setValorDesconto(Double.valueOf(aux));
            vlrDescontoAcu = vlrDescontoAcu + aux;
            i.setValorDesconto(Double.valueOf(aux));
        }
        ItemPedidoComercio toAcerto = this.getUltimoItemNaoCancelado(p.getItensPedido());
        if (toAcerto != null) {
            toAcerto.setValorDesconto(ContatoFormatUtil.arrredondarNumero((Double)(toAcerto.getValorDesconto() + (valorDesconto - vlrDescontoAcu)), (int)2));
        }
    }

    private void ratearAcrescimoFechamento(PedidoComercio p, Double valorAcrescimo, Double percAcrescimo, Short tipoAcrescimo) {
        p.setValorAcrescimo(valorAcrescimo);
        p.setPercAcrescimo(percAcrescimo);
        p.setTipoAcrescimo(tipoAcrescimo);
        Double vlrAcrescimoAcu = 0.0;
        for (ItemPedidoComercio i : p.getItensPedido()) {
            if (i.getItemCancelado() != null && i.getItemCancelado() == 1) continue;
            double aux = ContatoFormatUtil.arrredondarNumero((Double)(i.getValorTotalBruto() * (p.getPercAcrescimo() / 100.0)), (int)2);
            i.setValorAcrescimo(Double.valueOf(aux));
            vlrAcrescimoAcu = vlrAcrescimoAcu + aux;
            i.setValorAcrescimo(Double.valueOf(aux));
        }
        ItemPedidoComercio toAcerto = this.getUltimoItemNaoCancelado(p.getItensPedido());
        if (toAcerto != null) {
            toAcerto.setValorAcrescimo(ContatoFormatUtil.arrredondarNumero((Double)(toAcerto.getValorAcrescimo() + (valorAcrescimo - vlrAcrescimoAcu)), (int)2));
        }
    }

    private void recalcularComissao(PedidoComercio p) {
        double vlrComissao = 0.0;
        for (ItemPedidoComercio item : p.getItensPedido()) {
            if (item.getPercComissao() != null && item.getPercComissao() > 0.0) {
                item.setValorComissao(Double.valueOf(item.getValorTotal() * (item.getPercComissao() / 100.0)));
            } else {
                item.setValorComissao(Double.valueOf(0.0));
            }
            vlrComissao += item.getValorComissao().doubleValue();
        }
        p.setValorComissao(Double.valueOf(vlrComissao));
        if (p.getValorTotal() > 0.0) {
            p.setPercComissaoMedio(Double.valueOf(p.getValorComissao() / p.getValorTotal() * 100.0));
        }
    }

    public void movimentarEstoque(PedidoComercio vo, CentroEstoque centro, Short movimentarEstoque) throws ExceptionService {
        if (vo.getTipoPedido() == 2 && !vo.getStatusPedido().equals((short)2)) {
            return;
        }
        if (vo.getTipoPedido() == 1) {
            this.desativarMovimentoEstoque(vo);
            return;
        }
        if (movimentarEstoque == 0) {
            this.desativarMovimentoEstoque(vo);
            return;
        }
        if (vo.getStatusPedido() == 0) {
            this.desativarMovimentoEstoque(vo);
            return;
        }
        if (vo.getStatusPedido() == 2) {
            this.desativarMovimentoEstoque(vo);
            return;
        }
        this.movimentarEstoquePedido(vo, centro);
    }

    private void desativarMovimentoEstoque(PedidoComercio vo) {
        for (ItemPedidoComercio item : vo.getItensPedido()) {
            item.setMovimentarEstoque(Short.valueOf((short)0));
        }
    }

    private void movimentarEstoquePedido(PedidoComercio vo, CentroEstoque centro) throws ExceptionService {
        for (ItemPedidoComercio item : vo.getItensPedido()) {
            item.setDataMovimentacao(vo.getDataEmissao());
            if (item.getItemCancelado() != null && item.getItemCancelado() != 1 && vo.getTipoPedido() == 0 && item.getProduto().getTipoProduto() == 0) {
                if (item.getCentroEstoque() == null) {
                    if (centro == null) {
                        throw new ExceptionService("Informe o Centro de estoque em op\u00e7\u00f5es pedido comercio.");
                    }
                    item.setCentroEstoque(centro);
                    item.setEmpresa(vo.getEmpresa());
                }
                if (item.getLoteFabricacao() == null) {
                    item.setLoteFabricacao(this.getLoteFabricacao(item.getProduto(), item.getGradeCor(), item.getCentroEstoque(), vo.getEmpresa()));
                }
                item.setMovimentarEstoque(Short.valueOf((short)1));
                continue;
            }
            item.setMovimentarEstoque(Short.valueOf((short)0));
        }
    }

    public LoteFabricacao getLoteFabricacao(Produto prod, GradeCor grade, CentroEstoque centroEstoque, Empresa empresa) throws ExceptionService {
        SaldoEstoqueGeral saldo = SaldoEstoqueUtilities.findSaldoGradeCentroEstoqueLote(prod, grade, new Date(), null, centroEstoque, empresa, EnumConstantsSaldoTIPOSALDO.TIPO_SALDO_LOTE_FABRICACAO, EnumConstantsSaldoQTD.TIPO_SALDO_QTQ_MAIOR_0, EnumConstantsSaldoTIPOCARREGAMENTO.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS.getValue(), centroEstoque != null ? centroEstoque.getTipoEstProprioTerceiros() : EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue(), null);
        if (saldo != null) {
            if (saldo.getLoteFabricacao() == null) {
                throw new ExceptionService("N\u00e3o foi encontrado lote de fabrica\u00e7\u00e3o para o produto. Verifique se h\u00e1 saldo no centro de estoque informado em op\u00e7\u00f5es pedido com\u00e9rcio: " + prod.getIdentificador() + " - " + prod.getNome());
            }
            return saldo.getLoteFabricacao();
        }
        if (prod.getLoteUnico() != null && prod.getLoteUnico() == 0) {
            throw new ExceptionService("No produto, n\u00e3o est\u00e1 marcado lote unico, e n\u00e3o foi encontrado nenhum lote disponivel para o produto.");
        }
        LoteFabricacao lote = ((ServiceLoteFabricacaoImpl)Context.get(ServiceLoteFabricacaoImpl.class)).findOrCreateLoteUnico(prod);
        if (lote == null) {
            throw new ExceptionService("N\u00e3o foi encontrado lote de fabrica\u00e7\u00e3o para o produto " + prod.getNome());
        }
        return lote;
    }

    private double getVlrTotalBrutoDescNaoCancInf(PedidoComercio p) {
        double vlrTotal = 0.0;
        for (ItemPedidoComercio item : p.getItensPedido()) {
            if (item.getItemCancelado() == null || item.getItemCancelado() == 1 || item.getDescontoItem() == null || item.getDescontoItem() == 1) continue;
            vlrTotal += item.getValorTotalBruto().doubleValue();
        }
        return ContatoFormatUtil.arrredondarNumero((Double)vlrTotal, (int)2);
    }

    private double getVlrTotalBrutoAcresNaoCancInf(PedidoComercio p) {
        double vlrTotal = 0.0;
        for (ItemPedidoComercio item : p.getItensPedido()) {
            if (item.getItemCancelado() == null || item.getItemCancelado() == 1 || item.getAcrescimoItem() == null || item.getAcrescimoItem() == 1) continue;
            vlrTotal += item.getValorTotalBruto().doubleValue();
        }
        return vlrTotal;
    }
}

