/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.pessoa;

import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.vo.EmailEnviadoRelPessoa;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.Pessoa;
import java.util.ArrayList;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.dao.CoreDAOFactory;

public class UtilityPessoa {
    private final String DESC_CLIENTE = "Cliente";
    private final String DESC_FORNECEDOR = "Fornecedor";
    private final String DESC_TRANSPORTADOR = "Transportador";
    private final String DESC_EMPRESA = "Empresa";
    private final String DESC_REPRESENTANTE = "Representante";
    private final String DESC_OUTRO_DEVEDOR = "Outro Devedor";
    private final String DESC_OUTRO_CREDOR = "Outro Credor";
    private final String DESC_INSTITUICAO = "Institui\u00e7\u00e3o Financeira";
    private final String DESC_PESSOA = "Pessoa";
    private final String DESC_COLABORADOR = "Colaborador";

    public List getEmailsAtivosEnviarRel(Pessoa pessoa) {
        ArrayList<EmailEnviadoRelPessoa> ret = new ArrayList<EmailEnviadoRelPessoa>();
        for (EmailPessoa e : pessoa.getComplemento().getEmails()) {
            if (e.getAtivo() != 1 || e.getEnviarDadosRelacionamento() != 1) continue;
            EmailEnviadoRelPessoa em = new EmailEnviadoRelPessoa();
            em.setEmail(e.getEmail());
            ret.add(em);
        }
        return ret;
    }

    public EmailPessoa getPrimeiroEmailsAtivosEnviarRel(Pessoa pessoa) {
        if (pessoa == null) {
            return null;
        }
        for (EmailPessoa e : pessoa.getComplemento().getEmails()) {
            if (e.getAtivo() == null || e.getAtivo() != 1 || e.getEnviarDadosRelacionamento() != 1) continue;
            return e;
        }
        return null;
    }

    public String getDescricaoPessoa(short tipoPessoa) {
        if (tipoPessoa == EnumConstPessoa.CLIENTE.getEnumId()) {
            return "Cliente";
        }
        if (tipoPessoa == EnumConstPessoa.REPRESENTANTE.getEnumId()) {
            return "Representante";
        }
        if (tipoPessoa == EnumConstPessoa.EMPRESA.getEnumId()) {
            return "Empresa";
        }
        if (tipoPessoa == EnumConstPessoa.FORNECEDOR.getEnumId()) {
            return "Fornecedor";
        }
        if (tipoPessoa == EnumConstPessoa.AGENCIA_VALOR.getEnumId()) {
            return "Institui\u00e7\u00e3o Financeira";
        }
        if (tipoPessoa == EnumConstPessoa.OUTRO_CREDOR.getEnumId()) {
            return "Outro Credor";
        }
        if (tipoPessoa == EnumConstPessoa.OUTRO_DEVEDOR.getEnumId()) {
            return "Outro Devedor";
        }
        if (tipoPessoa == EnumConstPessoa.TRANSPORTADOR.getEnumId()) {
            return "Transportador";
        }
        if (tipoPessoa == EnumConstPessoa.PESSOA.getEnumId()) {
            return "Pessoa";
        }
        if (tipoPessoa == EnumConstPessoa.COLABORADOR.getEnumId()) {
            return "Colaborador";
        }
        return "";
    }

    public List getTipoPessoas() {
        ArrayList<TipoPessoa> aux = new ArrayList<TipoPessoa>();
        TipoPessoa t = new TipoPessoa(EnumConstPessoa.CLIENTE.getEnumId(), CoreDAOFactory.getInstance().getDAOCliente(), "Cliente");
        aux.add(t);
        TipoPessoa c = new TipoPessoa(EnumConstPessoa.FORNECEDOR.getEnumId(), CoreDAOFactory.getInstance().getDAOFornecedor(), "Fornecedor");
        aux.add(c);
        TipoPessoa r = new TipoPessoa(EnumConstPessoa.REPRESENTANTE.getEnumId(), CoreDAOFactory.getInstance().getDAORepresentante(), "Representante");
        aux.add(r);
        TipoPessoa tr = new TipoPessoa(EnumConstPessoa.TRANSPORTADOR.getEnumId(), CoreDAOFactory.getInstance().getDAOTransportador(), "Transportador");
        aux.add(tr);
        TipoPessoa e = new TipoPessoa(EnumConstPessoa.EMPRESA.getEnumId(), CoreDAOFactory.getInstance().getDAOEmpresa(), "Empresa");
        aux.add(e);
        TipoPessoa i = new TipoPessoa(EnumConstPessoa.AGENCIA_VALOR.getEnumId(), CoreDAOFactory.getInstance().getDAOContaValores(), "Agencia de Valor");
        aux.add(i);
        TipoPessoa te = new TipoPessoa(EnumConstPessoa.PESSOA.getEnumId(), CoreDAOFactory.getInstance().getDAOPessoa(), "Pessoa");
        aux.add(te);
        TipoPessoa col = new TipoPessoa(EnumConstPessoa.COLABORADOR.getEnumId(), CoreDAOFactory.getInstance().getDAOColaborador(), "Colaborador");
        aux.add(col);
        TipoPessoa tom = new TipoPessoa(EnumConstPessoa.TOMADOR_PRESTADOR_RPS.getEnumId(), CoreDAOFactory.getInstance().getDAOTomadorPrestadorRps(), "Tomador/Prestador Servico");
        aux.add(tom);
        return aux;
    }

    public static class TipoPessoa {
        private Short tipoPessoa;
        private CoreBaseDAO dao;
        private String descricao;

        public TipoPessoa(Short tipoPessoa, CoreBaseDAO dao, String descricao) {
            this.tipoPessoa = tipoPessoa;
            this.dao = dao;
            this.descricao = descricao;
        }

        public Short getTipoPessoa() {
            return this.tipoPessoa;
        }

        public void setTipoPessoa(Short tipoPessoa) {
            this.tipoPessoa = tipoPessoa;
        }

        public CoreBaseDAO getDao() {
            return this.dao;
        }

        public void setDao(CoreBaseDAO dao) {
            this.dao = dao;
        }

        public String getDescricao() {
            return this.descricao;
        }

        public void setDescricao(String descricao) {
            this.descricao = descricao;
        }

        public String toString() {
            return this.descricao;
        }
    }
}

