/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.saldoestoque;

import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeralBasico;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.Produto;
import java.util.Date;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoQTD;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOCARREGAMENTO;
import mentorcore.utilities.impl.saldoestoque.EnumConstantsSaldoTIPOSALDO;

public class SaldoEstoqueUtilities {
    public static SaldoEstoqueGeral findSaldoGradeCentroEstoqueLote(Produto produto, GradeCor gradeCor, Date data, LoteFabricacao lote, CentroEstoque centro, Empresa empresa, EnumConstantsSaldoTIPOSALDO tipoSaldo, EnumConstantsSaldoQTD tipoQtde, EnumConstantsSaldoTIPOCARREGAMENTO tipoCarregamento, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoque, Long idParceiro) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("produto", produto);
        request.setAttribute("grade", gradeCor);
        request.setAttribute("empresa", empresa);
        request.setAttribute("data", data);
        request.setAttribute("lote", lote);
        request.setAttribute("centro", centro);
        request.setAttribute("tipoSaldo", tipoSaldo.value);
        request.setAttribute("tipoQtde", tipoQtde.value);
        request.setAttribute("tipoCarregamento", tipoCarregamento.value);
        request.setAttribute("tipoDisponibilidade", tipoDisponibilidade);
        request.setAttribute("tipoEstoqueCentroEstoque", tipoEstoqueCentroEstoque);
        request.setAttribute("idParceiro", idParceiro);
        return (SaldoEstoqueGeral)CoreServiceFactory.getServiceSaldoEstProprio().execute(request, "findSaldoGradeCentroEstoqueLote");
    }

    public static List<SaldoEstoqueGeral> findSaldoGradeCentroEstoqueLoteLista(Produto produtoInicial, Produto produtoFinal, GradeCor gradeCorInicial, GradeCor gradeCorFinal, Date data, LoteFabricacao lote, CentroEstoque centroInicial, CentroEstoque centroFinal, Empresa empresaInicial, Empresa empresaFinal, EnumConstantsSaldoTIPOSALDO tipoSaldo, EnumConstantsSaldoQTD tipoQtde, EnumConstantsSaldoTIPOCARREGAMENTO tipoCarregamento, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoque, Long idParceiro) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("produtoInicial", produtoInicial);
        request.setAttribute("produtoFinal", produtoFinal);
        request.setAttribute("gradeInicial", gradeCorInicial);
        request.setAttribute("gradeFinal", gradeCorFinal);
        request.setAttribute("empresaInicial", empresaInicial);
        request.setAttribute("empresaFinal", empresaFinal);
        request.setAttribute("data", data);
        request.setAttribute("lote", lote);
        request.setAttribute("centroInicial", centroInicial);
        request.setAttribute("centroFinal", centroFinal);
        request.setAttribute("tipoSaldo", tipoSaldo.value);
        request.setAttribute("tipoQtde", tipoQtde.value);
        request.setAttribute("tipoCarregamento", tipoCarregamento.value);
        request.setAttribute("tipoDisponibilidade", tipoDisponibilidade);
        request.setAttribute("tipoEstoqueCentroEstoque", tipoEstoqueCentroEstoque);
        request.setAttribute("idParceiro", idParceiro);
        return (List)CoreServiceFactory.getServiceSaldoEstProprio().execute(request, "findSaldoGradeCentroEstoqueLoteLista");
    }

    public static SaldoEstoqueGeralBasico findSaldoGradeCorCentroEstoqueBasico(Produto produto, GradeCor gradeCor, Date data, CentroEstoque centro, Empresa empresa, EnumConstantsSaldoTIPOSALDO tipoSaldo, EnumConstantsSaldoQTD tipoQtde, EnumConstantsSaldoTIPOCARREGAMENTO tipoCarregamento, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoque, Long idParceiro) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("produto", produto);
        request.setAttribute("grade", gradeCor);
        request.setAttribute("empresa", empresa);
        request.setAttribute("data", data);
        request.setAttribute("centroEstoque", centro);
        request.setAttribute("tipoSaldo", tipoSaldo.value);
        request.setAttribute("tipoQtde", tipoQtde.value);
        request.setAttribute("tipoCarregamento", tipoCarregamento.value);
        request.setAttribute("tipoDisponibilidade", tipoDisponibilidade);
        request.setAttribute("tipoEstoqueCentroEstoque", tipoEstoqueCentroEstoque);
        request.setAttribute("idParceiro", idParceiro);
        return (SaldoEstoqueGeralBasico)CoreServiceFactory.getServiceSaldoEstProprio().execute(request, "findSaldoGradeCorCentroEstoque");
    }

    public static List<SaldoEstoqueGeralBasico> findSaldoGradeCorCentroEstoqueListaBasico(Produto produtoInicial, Produto produtoFinal, GradeCor gradeCorInicial, GradeCor gradeCorFinal, Date data, CentroEstoque centroEstoqueInicial, CentroEstoque centroEstoqueFinal, Empresa empresaInicial, Empresa empresaFinal, EnumConstantsSaldoTIPOSALDO tipoSaldo, EnumConstantsSaldoQTD tipoQtde, EnumConstantsSaldoTIPOCARREGAMENTO tipoCarregamento, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoque, Long idParceiro) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("produtoInicial", produtoInicial);
        request.setAttribute("produtoFinal", produtoFinal);
        request.setAttribute("gradeInicial", gradeCorInicial);
        request.setAttribute("gradeFinal", gradeCorFinal);
        request.setAttribute("empresaInicial", empresaInicial);
        request.setAttribute("empresaFinal", empresaFinal);
        request.setAttribute("data", data);
        request.setAttribute("centroEstoqueInicial", centroEstoqueInicial);
        request.setAttribute("centroEstoqueFinal", centroEstoqueFinal);
        request.setAttribute("tipoSaldo", tipoSaldo.value);
        request.setAttribute("tipoQtde", tipoQtde.value);
        request.setAttribute("tipoCarregamento", tipoCarregamento.value);
        request.setAttribute("tipoDisponibilidade", tipoDisponibilidade);
        request.setAttribute("tipoEstoqueCentroEstoque", tipoEstoqueCentroEstoque);
        request.setAttribute("idParceiro", idParceiro);
        return (List)CoreServiceFactory.getServiceSaldoEstProprio().execute(request, "findSaldoGradeCorCentroEstoqueLista");
    }

    public static SaldoEstoqueGeralBasico findSaldoGradeCorBasico(Produto produto, GradeCor gradeCor, Date data, Empresa empresa, EnumConstantsSaldoTIPOSALDO tipoSaldo, EnumConstantsSaldoQTD tipoQtde, EnumConstantsSaldoTIPOCARREGAMENTO tipoCarregamento, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoque, Long idParceiro) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("produto", produto);
        request.setAttribute("grade", gradeCor);
        request.setAttribute("empresa", empresa);
        request.setAttribute("data", data);
        request.setAttribute("tipoSaldo", tipoSaldo.value);
        request.setAttribute("tipoQtde", tipoQtde.value);
        request.setAttribute("tipoCarregamento", tipoCarregamento.value);
        request.setAttribute("tipoDisponibilidade", tipoDisponibilidade);
        request.setAttribute("tipoEstoqueCentroEstoque", tipoEstoqueCentroEstoque);
        request.setAttribute("idParceiro", idParceiro);
        return (SaldoEstoqueGeralBasico)CoreServiceFactory.getServiceSaldoEstProprio().execute(request, "findSaldoGradeCor");
    }

    public static List<SaldoEstoqueGeral> findSaldoGradeCorLista(Long idProdutoInicial, Long idProdutoFinal, Long idGradeCorInicial, Long idGradeCorFinal, Date data, Long idEmpresaInicial, Long idEmpresaFinal, EnumConstantsSaldoTIPOSALDO tipoSaldo, EnumConstantsSaldoQTD tipoQtde, EnumConstantsSaldoTIPOCARREGAMENTO tipoCarregamento, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoque, Long idParceiro) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("idProdutoInicial", idProdutoInicial);
        request.setAttribute("idProdutoFinal", idProdutoFinal);
        request.setAttribute("idGradeCorInicial", idGradeCorInicial);
        request.setAttribute("idGradeCorFinal", idGradeCorFinal);
        request.setAttribute("idEmpresaInicial", idEmpresaInicial);
        request.setAttribute("idEmpresaFinal", idEmpresaFinal);
        request.setAttribute("data", data);
        request.setAttribute("tipoSaldo", tipoSaldo.value);
        request.setAttribute("tipoQtde", tipoQtde.value);
        request.setAttribute("tipoCarregamento", tipoCarregamento.value);
        request.setAttribute("tipoDisponibilidade", tipoDisponibilidade);
        request.setAttribute("tipoEstoqueCentroEstoque", tipoEstoqueCentroEstoque);
        request.setAttribute("idParceiro", idParceiro);
        return (List)CoreServiceFactory.getServiceSaldoEstProprio().execute(request, "findSaldoIdGradeCorLista");
    }

    public static List<SaldoEstoqueGeralBasico> findSaldoGradeCorListaBasico(Long idProdutoInicial, Long idProdutoFinal, Long idGradeCorInicial, Long idGradeCorFinal, Date data, Long idEmpresaInicial, Long idEmpresaFinal, EnumConstantsSaldoTIPOSALDO tipoSaldo, EnumConstantsSaldoQTD tipoQtde, EnumConstantsSaldoTIPOCARREGAMENTO tipoCarregamento, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoque, Long idParceiro) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("idProdutoInicial", idProdutoInicial);
        request.setAttribute("idProdutoFinal", idProdutoFinal);
        request.setAttribute("idGradeCorInicial", idGradeCorInicial);
        request.setAttribute("idGradeCorFinal", idGradeCorFinal);
        request.setAttribute("idEmpresaInicial", idEmpresaInicial);
        request.setAttribute("idEmpresaFinal", idEmpresaFinal);
        request.setAttribute("data", data);
        request.setAttribute("tipoSaldo", tipoSaldo.value);
        request.setAttribute("tipoQtde", tipoQtde.value);
        request.setAttribute("tipoCarregamento", tipoCarregamento.value);
        request.setAttribute("tipoDisponibilidade", tipoDisponibilidade);
        request.setAttribute("tipoEstoqueCentroEstoque", tipoEstoqueCentroEstoque);
        request.setAttribute("idParceiro", idParceiro);
        return (List)CoreServiceFactory.getServiceSaldoEstProprio().execute(request, "findSaldoIdGradeCorListaBasico");
    }

    public static SaldoEstoqueGeralBasico findSaldoProdutoBasico(Produto produto, Date data, Empresa empresa, EnumConstantsSaldoTIPOSALDO tipoSaldo, EnumConstantsSaldoQTD tipoQtde, EnumConstantsSaldoTIPOCARREGAMENTO tipoCarregamento, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoque, Long idParceiro) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("produto", produto);
        request.setAttribute("empresa", empresa);
        request.setAttribute("data", data);
        request.setAttribute("tipoSaldo", tipoSaldo.value);
        request.setAttribute("tipoQtde", tipoQtde.value);
        request.setAttribute("tipoCarregamento", tipoCarregamento.value);
        request.setAttribute("tipoDisponibilidade", tipoDisponibilidade);
        request.setAttribute("tipoEstoqueCentroEstoque", tipoEstoqueCentroEstoque);
        request.setAttribute("idParceiro", idParceiro);
        return (SaldoEstoqueGeralBasico)CoreServiceFactory.getServiceSaldoEstProprio().execute(request, "findSaldoProdutoBasico");
    }

    public static List<SaldoEstoqueGeral> findSaldoProdutoLista(Produto produtoInicial, Produto produtoFinal, Date data, Empresa empresaInicial, Empresa empresaFinal, EnumConstantsSaldoTIPOSALDO tipoSaldo, EnumConstantsSaldoQTD tipoQtde, EnumConstantsSaldoTIPOCARREGAMENTO tipoCarregamento, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoque, Long idParceiro) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("produtoInicial", produtoInicial);
        request.setAttribute("produtoFinal", produtoFinal);
        request.setAttribute("empresaInicial", empresaInicial);
        request.setAttribute("empresaFinal", empresaFinal);
        request.setAttribute("data", data);
        request.setAttribute("tipoSaldo", tipoSaldo.value);
        request.setAttribute("tipoQtde", tipoQtde.value);
        request.setAttribute("tipoCarregamento", tipoCarregamento.value);
        request.setAttribute("tipoDisponibilidade", tipoDisponibilidade);
        request.setAttribute("tipoEstoqueCentroEstoque", tipoEstoqueCentroEstoque);
        request.setAttribute("idParceiro", idParceiro);
        return (List)CoreServiceFactory.getServiceSaldoEstProprio().execute(request, "findSaldoProdutoLista");
    }

    public static List<SaldoEstoqueGeralBasico> findSaldoProdutoListaBasico(Produto produtoInicial, Produto produtoFinal, Date data, Empresa empresaInicial, Empresa empresaFinal, EnumConstantsSaldoTIPOSALDO tipoSaldo, EnumConstantsSaldoQTD tipoQtde, EnumConstantsSaldoTIPOCARREGAMENTO tipoCarregamento, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoque, Long idParceiro) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("produtoInicial", produtoInicial);
        request.setAttribute("produtoFinal", produtoFinal);
        request.setAttribute("empresaInicial", empresaInicial);
        request.setAttribute("empresaFinal", empresaFinal);
        request.setAttribute("data", data);
        request.setAttribute("tipoSaldo", tipoSaldo.value);
        request.setAttribute("tipoQtde", tipoQtde.value);
        request.setAttribute("tipoCarregamento", tipoCarregamento.value);
        request.setAttribute("tipoDisponibilidade", tipoDisponibilidade);
        request.setAttribute("tipoEstoqueCentroEstoque", tipoEstoqueCentroEstoque);
        request.setAttribute("idParceiro", idParceiro);
        return (List)CoreServiceFactory.getServiceSaldoEstProprio().execute(request, "findSaldoProdutoListaBasico");
    }

    public static Double findPrecoMedioPorProduto(Date data, Produto produto, Empresa empresa, EnumConstantsSaldoTIPOSALDO tipoSaldo, EnumConstantsSaldoQTD tipoQtde, EnumConstantsSaldoTIPOCARREGAMENTO tipoCarregamento, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoque, Long idParceiro) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("produto", produto);
        request.setAttribute("empresa", empresa);
        request.setAttribute("data", data);
        request.setAttribute("tipoSaldo", tipoSaldo.value);
        request.setAttribute("tipoQtde", tipoQtde.value);
        request.setAttribute("tipoCarregamento", tipoCarregamento.value);
        request.setAttribute("tipoDisponibilidade", tipoDisponibilidade);
        request.setAttribute("tipoEstoqueCentroEstoque", tipoEstoqueCentroEstoque);
        request.setAttribute("idParceiro", idParceiro);
        return (Double)CoreServiceFactory.getServiceSaldoEstProprio().execute(request, "findPrecoMedioProduto");
    }

    public static Double findPrecoMedioPorIdProduto(Date data, Long idProduto, Long idEmpresa, EnumConstantsSaldoTIPOSALDO tipoSaldo, EnumConstantsSaldoQTD tipoQtde, EnumConstantsSaldoTIPOCARREGAMENTO tipoCarregamento, Short tipoDisponibilidade, Short tipoEstoqueCentroEstoque, Long idParceiro) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("idProduto", idProduto);
        request.setAttribute("idEmpresa", idEmpresa);
        request.setAttribute("data", data);
        request.setAttribute("tipoSaldo", tipoSaldo.value);
        request.setAttribute("tipoQtde", tipoQtde.value);
        request.setAttribute("tipoCarregamento", tipoCarregamento.value);
        request.setAttribute("tipoDisponibilidade", tipoDisponibilidade);
        request.setAttribute("tipoEstoqueCentroEstoque", tipoEstoqueCentroEstoque);
        request.setAttribute("idParceiro", idParceiro);
        return (Double)CoreServiceFactory.getServiceSaldoEstProprio().execute(request, "findPrecoMedioIdProduto");
    }
}

