/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.security;

import com.touchcomp.basementorlogger.TLogger;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import mentorcore.exceptions.ExceptionEncryptDecrypt;
import org.apache.commons.codec.binary.Base64;

public final class UtilitySecurity {
    private static final String ALGORITHM = "AES";
    private static final byte[] keyValue = new byte[]{84, 104, 105, 115, 73, 115, 65, 83, 101, 99, 114, 101, 116, 75, 101, 121};
    private static TLogger logger = TLogger.get(UtilitySecurity.class);

    private static Key generateKey() throws Exception {
        SecretKeySpec key = new SecretKeySpec(keyValue, ALGORITHM);
        return key;
    }

    public final String encrypt(String text) throws ExceptionEncryptDecrypt {
        try {
            Key key = UtilitySecurity.generateKey();
            Cipher c = Cipher.getInstance(ALGORITHM);
            c.init(1, key);
            byte[] encValue = c.doFinal(text.getBytes());
            String encryptedValue = new String(Base64.encodeBase64((byte[])encValue));
            return encryptedValue;
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionEncryptDecrypt("Erro ao criptografar/descriptografar dados.");
        }
    }

    public final String decrypt(String text) throws ExceptionEncryptDecrypt {
        try {
            Key key = UtilitySecurity.generateKey();
            Cipher c = Cipher.getInstance(ALGORITHM);
            c.init(2, key);
            byte[] decordedValue = Base64.decodeBase64((byte[])text.getBytes());
            byte[] decValue = c.doFinal(decordedValue);
            String decryptedValue = new String(decValue);
            return decryptedValue;
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionEncryptDecrypt("Erro ao criptografar/descriptografar dados.");
        }
    }
}

