/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.tabelaprecosbase;

import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCen;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseProduto;
import mentorcore.utilities.CoreUtility;

public class UtilityTabelaPrecosBase
extends CoreUtility {
    public int valorEstaDentroTolerancia(TabelaPrecoBaseProduto r, AnalisePrVendaProdCen cenario) {
        double temp = (1.0 - r.getValorVenda() / cenario.getResultado()) * 100.0;
        if (temp > 0.0 && Math.abs(temp) > cenario.getAnalisePrVendaProd().getToleranciaPrecoAbaixo()) {
            return -1;
        }
        if (temp < 0.0 && Math.abs(temp) > cenario.getAnalisePrVendaProd().getToleranciaPrecoAcima()) {
            return 1;
        }
        return 0;
    }

    public void recalcMargem(TabelaPrecoBaseProduto vo) {
        if (vo.getValorCusto() > 0.0) {
            vo.setMargemLucro(Double.valueOf((vo.getValorVenda() - vo.getValorCusto()) / vo.getValorCusto() * 100.0));
        } else {
            vo.setMargemLucro(Double.valueOf(0.0));
        }
    }

    public void recalcValorMinimo(TabelaPrecoBaseProduto vo) {
        vo.setValorMinimo(Double.valueOf(vo.getValorVenda() - vo.getPercMinimo() / 100.0 * vo.getValorVenda()));
    }

    public void recalcPercMinimo(TabelaPrecoBaseProduto vo) {
        if (vo.getValorVenda() > 0.0) {
            vo.setPercMinimo(Double.valueOf((vo.getValorVenda() - vo.getValorMinimo()) / vo.getValorVenda() * 100.0));
        } else {
            vo.setPercMinimo(Double.valueOf(0.0));
        }
    }

    public void recalcPercMaximo(TabelaPrecoBaseProduto vo) {
        if (vo.getValorVenda() != 0.0) {
            vo.setPercMaximo(Double.valueOf((vo.getValorMaximo() - vo.getValorVenda()) / vo.getValorVenda() * 100.0));
        } else {
            vo.setPercMaximo(Double.valueOf(0.0));
        }
    }

    public void recalcValorMaximo(TabelaPrecoBaseProduto vo) {
        vo.setValorMaximo(Double.valueOf(vo.getValorVenda() + vo.getPercMaximo() / 100.0 * vo.getValorVenda()));
    }

    public void recalcValorVenda(TabelaPrecoBaseProduto vo) {
        vo.setValorVenda(Double.valueOf(vo.getValorCusto() + vo.getValorCusto() * vo.getMargemLucro() / 100.0));
    }

    public void atualizarValoresAposAtValorVenda(TabelaPrecoBaseProduto tt, Double resultado) {
        tt.setValorVenda(resultado);
        this.recalcValorMaximo(tt);
        this.recalcValorMinimo(tt);
        this.recalcMargem(tt);
    }

    public void atualizarValoresAposAtValorMinimo(TabelaPrecoBaseProduto tt, Double resultado) {
        tt.setValorMinimo(resultado);
        this.recalcPercMinimo(tt);
    }

    public void atualizarValoresAposAtValorMaximo(TabelaPrecoBaseProduto tt, Double resultado) {
        tt.setValorMaximo(resultado);
        this.recalcPercMaximo(tt);
    }
}

