/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.titulos;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.vo.AdiantamentoViagem;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesFinanceirasTaxas;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfinanceiras.HelperOpcoesFinanceiras;
import com.touchcomp.basementorspringcontext.Context;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

class AuxAdiantamentoViagem {
    AuxAdiantamentoViagem() {
    }

    public Titulo criarTitulos(AdiantamentoViagem vo, Titulo t, OpcoesFinanceiras op, OpcoesGerenciais opcoesGerenciais) {
        if (t == null) {
            t = new Titulo();
        }
        t.setAdiantamentoViagem(vo);
        t.setPagRec(Short.valueOf((short)0));
        t.setCarteiraCobranca(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(op).getCarteiraCobranca(t.getPagRec().shortValue()));
        t.setDataCadastro(new Date());
        t.setDataCompetencia(vo.getDataEmissao());
        t.setDataEntradaSaida(t.getDataCompetencia());
        t.setDataEmissao(vo.getDataEmissao());
        t.setDataVencimento(vo.getDataEmissao());
        t.setDataVencimentoBase(vo.getDataEmissao());
        t.setEmpresa(vo.getEmpresa());
        t.setNumParcTituloEstnota(Short.valueOf(Short.parseShort("1")));
        t.setObservacao("Adiantamento Viagem: " + vo.getObservacao());
        t.setPessoa(vo.getPessoa());
        t.setClassificacaoPessoa(op.getClassificacaoClientes());
        t.setPlanoConta(vo.getPlanoConta());
        t.setProvisao(Short.valueOf((short)1));
        t.setTipoDoc(op.getTipoDocFinanceiro());
        t.setTipoPessoa(EnumConstPessoa.PESSOA.getEnumId());
        t.setValor(vo.getValorAdiantamento());
        t.setMeioPagamento(op.getMeioPagamento());
        ArrayList<LancamentoCtbGerencial> lista = new ArrayList<LancamentoCtbGerencial>();
        LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, t.getDataEmissao(), t.getDataVencimento(), Short.valueOf(EnumLancamentoCTBGerencial.DEBITO.getValue()), t.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Lanc. do Titulo referente a Adiantamento Viagem: " + t.getPessoa().getNome(), vo.getPlanoContaGerencial(), t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), opcoesGerenciais != null && opcoesGerenciais.getCentroCustoAdiantViagem() != null ? opcoesGerenciais.getCentroCustoAdiantViagem() : vo.getCentroCusto(), t.getValor(), null);
        lista.add(l);
        t.setLancCtbGerencial(lista);
        return t;
    }

    public Titulo criarTitulos(Double valorTotalFechamento, AdiantamentoViagem vo, Titulo t, OpcoesFinanceiras op, OpcoesGerenciais opcoesGerenciais) {
        if (t == null) {
            t = new Titulo();
        }
        t.setAdiantamentoViagemFechamento(vo.getFechamento());
        t.setDataCadastro(new Date());
        t.setDataCompetencia(vo.getDataFechamento());
        t.setDataEntradaSaida(t.getDataCompetencia());
        t.setDataEmissao(vo.getDataFechamento());
        t.setDataVencimento(vo.getDataFechamento());
        t.setDataVencimentoBase(vo.getDataFechamento());
        t.setEmpresa(vo.getEmpresa());
        t.setNumParcTituloEstnota(Short.valueOf(Short.parseShort("1")));
        t.setObservacao("Fechamento Adiant. Viagem: " + vo.getObservacao());
        t.setPlanoConta(vo.getPlanoConta());
        t.setProvisao(Short.valueOf((short)1));
        t.setTipoDoc(op.getTipoDocFinanceiro());
        t.setTipoPessoa(EnumConstPessoa.PESSOA.getEnumId());
        t.setMeioPagamento(op.getMeioPagamento());
        Double valor = vo.getValorAdiantamento() - valorTotalFechamento;
        if (valor > 0.0) {
            t.setValor(valor);
            t.setPagRec(Short.valueOf((short)1));
            t.setPessoa(vo.getPessoa());
            t.setCartCobrancaDestino(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(op).getCarteiraCobrancaDestino(vo.getPessoa(), null));
            this.setarPercJurosMultaDesconto(t, op);
        } else if (valor < 0.0) {
            t.setValor(Double.valueOf(Math.abs(valor)));
            t.setPagRec(Short.valueOf((short)0));
            t.setPessoa(vo.getPessoa());
        } else {
            t.setValor(valor);
            t.setPessoa(vo.getPessoa());
        }
        t.setClassificacaoPessoa(op.getClassificacaoClientes());
        t.setCarteiraCobranca(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(op).getCarteiraCobranca(t.getPagRec().shortValue()));
        List lista = t.getLancCtbGerencial();
        lista.clear();
        LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, t.getDataEmissao(), t.getDataVencimento(), Short.valueOf(valor > 0.0 ? EnumLancamentoCTBGerencial.CREDITO.getValue() : EnumLancamentoCTBGerencial.DEBITO.getValue()), t.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Lanc. do Titulo referente ao Fechamento do Adiantamento Viagem de: " + t.getPessoa().getNome(), vo.getPlanoContaGerencial(), t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), opcoesGerenciais != null && opcoesGerenciais.getCentroCustoAdiantViagem() != null ? opcoesGerenciais.getCentroCustoAdiantViagem() : vo.getCentroCusto(), Double.valueOf(Math.abs(valor)), null);
        lista.add(l);
        t.setLancCtbGerencial(lista);
        return t;
    }

    private void setarPercJurosMultaDesconto(Titulo t, OpcoesFinanceiras op) {
        if (t.getPagRec() == 1) {
            Double percJuros = op.getPercJurosMes();
            Double percDesc = op.getPercDescMes();
            Double percMulta = op.getPercMulta();
            OpcoesFinanceirasTaxas opTaxas = this.getOpcoesFinanceirasTaxas(t.getMeioPagamento(), op);
            if (opTaxas != null) {
                percJuros = opTaxas.getPercJurosMes();
                percDesc = opTaxas.getPercDescMes();
                percMulta = opTaxas.getPercMulta();
            }
            if (percJuros != null) {
                t.setPercJurosMes(percJuros);
                t.setVrJurosDia(Double.valueOf(t.getValor() * (percJuros / 100.0) / 30.0));
            } else {
                t.setPercJurosMes(Double.valueOf(0.0));
                t.setVrJurosDia(Double.valueOf(0.0));
            }
            if (percDesc != null) {
                t.setPercDescontoMes(percDesc);
            } else {
                t.setPercDescontoMes(Double.valueOf(0.0));
            }
            if (percMulta != null) {
                t.setPercMulta(percMulta);
            } else {
                t.setPercMulta(Double.valueOf(0.0));
            }
        } else {
            t.setPercMulta(Double.valueOf(0.0));
            t.setPercJurosMes(Double.valueOf(0.0));
            t.setVrJurosDia(Double.valueOf(0.0));
            t.setPercDescontoMes(Double.valueOf(0.0));
        }
    }

    private OpcoesFinanceirasTaxas getOpcoesFinanceirasTaxas(MeioPagamento meioPagamento, OpcoesFinanceiras op) {
        if (meioPagamento != null) {
            for (OpcoesFinanceirasTaxas taxa : op.getTaxas()) {
                if (!taxa.getMeioPagamento().equals((Object)meioPagamento)) continue;
                return taxa;
            }
        }
        return null;
    }
}

