/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.titulos;

import com.touchcomp.basementor.constants.enums.opcoeslocacao.EnumGerTituloApuracao;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.vo.ApuracaoLocacaoContrato;
import com.touchcomp.basementor.model.vo.ApuracaoLocacaoContratoBem;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesLocacao;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TituloRepresentante;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfinanceiras.HelperOpcoesFinanceiras;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.tools.ContatoFormatUtil;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.titulos.AuxTitulos;

class AuxApuracaoLocacaoContrato {
    private final SCompPlanoConta scPlanoConta = (SCompPlanoConta)ConfApplicationContext.getBean(SCompPlanoConta.class);

    AuxApuracaoLocacaoContrato() {
    }

    public List criarTitulos(ApuracaoLocacaoContrato vo, OpcoesFinanceiras op, OpcoesLocacao opcoesLocacao, OpcoesContabeis opcoesCont) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        List titulos = new ArrayList();
        Pessoa pessoa = null;
        Short tipoPessoa = null;
        PlanoConta planoConta = null;
        Object observacao = "";
        if (vo.getContratoLocacao().getCliente() != null) {
            pessoa = vo.getContratoLocacao().getCliente().getPessoa();
            planoConta = this.scPlanoConta.getPlanoConta(vo.getContratoLocacao().getCliente(), opcoesCont);
            tipoPessoa = EnumConstPessoa.CLIENTE.getEnumId();
            observacao = "Apuracao Locacao: " + vo.getApuracaoLocacao().getIdentificador() + ", Contrato de Locacao nr: " + vo.getContratoLocacao().getNumeroContrato() + " do cliente: " + String.valueOf(pessoa);
        } else if (vo.getContratoLocacao().getTomador() != null) {
            pessoa = vo.getContratoLocacao().getTomador().getPessoa();
            planoConta = vo.getContratoLocacao().getTomador().getPlanoContaCliente();
            if (planoConta == null) {
                throw new ExceptionGeracaoTitulos("Primeiro informe um Plano de Contas Cliente, no cadastro do Tomador/Prestador RPS informado no Contrato de Loca\u00e7\u00e3o!");
            }
            tipoPessoa = EnumConstPessoa.TOMADOR_PRESTADOR_RPS.getEnumId();
            observacao = "Apuracao Locacao: " + vo.getApuracaoLocacao().getIdentificador() + ", Contrato de Locacao nr: " + vo.getContratoLocacao().getNumeroContrato() + " do tomador: " + String.valueOf(pessoa);
        } else {
            throw new ExceptionGeracaoTitulos("Primeiro informe um Cliente ou Tomador no Contrato!");
        }
        Double valorLiquido = vo.getValorTotalLiquido();
        Date dataVencimento = vo.getApuracaoLocacao().getDataVencimento();
        titulos = vo.getContratoLocacao().getCondicoesPagamento().getCondMutante() != null && vo.getContratoLocacao().getCondicoesPagamento().getCondMutante() == 1 ? new AuxTitulos().getTitulosMutanteInternal(vo.getContratoLocacao().getCondicoesPagamento(), pessoa, valorLiquido, planoConta, null, vo.getContratoLocacao().getParcelas(), tipoPessoa, (short)1, (short)1, dataVencimento != null ? dataVencimento : new Date(), (String)observacao, new Date(), new Date(), new Date(), new Date(), vo.getApuracaoLocacao().getEmpresa(), op, op.getMeioPagamento(), null) : new AuxTitulos().getTitulosNaoMutanteInternal(vo.getContratoLocacao().getCondicoesPagamento(), pessoa, valorLiquido, planoConta, null, tipoPessoa, (short)1, (short)1, dataVencimento != null ? dataVencimento : new Date(), (String)observacao, new Date(), new Date(), new Date(), new Date(), vo.getContratoLocacao().getEmpresa(), op, op.getMeioPagamento(), null);
        if (opcoesLocacao != null && opcoesLocacao.getTipoCentroCustoLancGerencial() != null && opcoesLocacao.getTipoCentroCustoLancGerencial().equals(EnumGerTituloApuracao.CENTRO_CUSTO_ATIVO.getValue())) {
            if (vo.getApuracaoLocacaoContratoBem() != null && !vo.getApuracaoLocacaoContratoBem().isEmpty()) {
                Double valorApurContratos = 0.0;
                for (Object a : vo.getApuracaoLocacaoContratoBem()) {
                    valorApurContratos = valorApurContratos + a.getValorTotal();
                }
                Double perc = ContatoFormatUtil.arrredondarNumero(valorLiquido * 100.0 / valorApurContratos, 4);
                for (Titulo t : titulos) {
                    Double valorAcumLanc = 0.0;
                    t.setApuracaoLocacaoContrato(vo);
                    t.setTipoDoc(op.getTipoDocFinanceiro());
                    t.setCarteiraCobranca(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(op).getCarteiraCobranca(t.getPagRec().shortValue()));
                    int qtdeBens = vo.getApuracaoLocacaoContratoBem().size();
                    int qtdeAux = 0;
                    for (ApuracaoLocacaoContratoBem a : vo.getApuracaoLocacaoContratoBem()) {
                        Double valor = ContatoFormatUtil.arrredondarNumero(a.getValorTotal() * perc / 100.0 / (double)titulos.size(), 2);
                        if (++qtdeAux == qtdeBens) {
                            Double diferenca = valor + valorAcumLanc - t.getValor();
                            valor = valor - diferenca;
                        }
                        t.getLancCtbGerencial().addAll(CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentosCTBGerencial(vo, t, valor, a.getContratoLocacaoBem().getAtivo().getContaGerencial(), a.getContratoLocacaoBem().getAtivo().getCentroCusto()));
                        valorAcumLanc = valorAcumLanc + valor;
                    }
                }
            }
        } else {
            for (Titulo t : titulos) {
                t.setApuracaoLocacaoContrato(vo);
                t.setTipoDoc(op.getTipoDocFinanceiro());
                t.setCarteiraCobranca(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(op).getCarteiraCobranca(t.getPagRec().shortValue()));
                t.setLancCtbGerencial(CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentosCTBGerencial(vo, t, t.getValor(), vo.getContratoLocacao().getPlanoContaGerencial(), vo.getContratoLocacao().getCentroCusto()));
            }
        }
        for (Titulo titulo : titulos) {
            ArrayList<TituloRepresentante> titulosRepresentantes = new ArrayList<TituloRepresentante>();
            Double valorContrato = vo.getValorTotalLiquido() - vo.getValorTotalEventosManuais();
            valorContrato = valorContrato / (double)titulos.size();
            titulosRepresentantes.addAll(AuxTitulos.gerarTitulosRepresentante(vo.getContratoLocacao().getRepresentantesContrato(), titulo, valorContrato, opcoesLocacao.getPercBCComissaoRepresentante()));
            titulo.setRepresentantes(titulosRepresentantes);
        }
        return titulos;
    }
}

