/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.titulos;

import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.ContratoLocacao;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.utilities.impl.titulos.AuxTitulos;

class AuxContratoLocacao {
    private final SCompPlanoConta scPlanoConta = (SCompPlanoConta)ConfApplicationContext.getBean(SCompPlanoConta.class);

    AuxContratoLocacao() {
    }

    public List criarTitulos(ContratoLocacao vo, OpcoesFinanceiras op, OpcoesContabeis opcoesCont) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        List titulos = new ArrayList();
        Pessoa pessoa = null;
        PlanoConta planoConta = null;
        Short tipoPessoa = null;
        ClassificacaoClientes classificacao = null;
        if (vo.getCliente() != null) {
            pessoa = vo.getCliente().getPessoa();
            planoConta = this.scPlanoConta.getPlanoConta(vo.getCliente(), opcoesCont);
            tipoPessoa = EnumConstPessoa.CLIENTE.getEnumId();
            classificacao = vo.getCliente().getClassificacaoClientes();
        } else if (vo.getTomador() != null) {
            pessoa = vo.getTomador().getPessoa();
            planoConta = vo.getTomador().getPlanoContaCliente();
            tipoPessoa = EnumConstPessoa.TOMADOR_PRESTADOR_RPS.getEnumId();
            classificacao = vo.getTomador().getClassificacaoPessoa();
        } else {
            throw new ExceptionGeracaoTitulos("O Contrato de Loca\u00e7\u00e3o deve possui Cliente ou Tomador");
        }
        Double valorTotalContrato = vo.getValorTotalContrato();
        String observacao = "Contrato de loca\u00e7ao " + pessoa.getNome();
        titulos = vo.getCondicoesPagamento().getCondMutante() != null && vo.getCondicoesPagamento().getCondMutante() == 1 ? new AuxTitulos().getTitulosMutanteInternal(vo.getCondicoesPagamento(), pessoa, valorTotalContrato, planoConta, null, vo.getParcelas(), tipoPessoa, (short)1, (short)0, vo.getDataCadastro(), observacao, vo.getDataCadastro(), vo.getDataCadastro(), new Date(), vo.getDataCadastro(), vo.getEmpresa(), op, op.getMeioPagamento(), classificacao) : new AuxTitulos().getTitulosNaoMutanteInternal(vo.getCondicoesPagamento(), pessoa, valorTotalContrato, planoConta, null, tipoPessoa, (short)1, (short)0, vo.getDataCadastro(), observacao, vo.getDataCadastro(), vo.getDataCadastro(), new Date(), vo.getDataCadastro(), vo.getEmpresa(), op, op.getMeioPagamento(), classificacao);
        return titulos;
    }
}

