/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.titulos;

import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TituloRepresentante;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoFormatUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.exceptions.ExceptionValidation;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.titulos.AuxTitulos;

public class AuxCte {
    private final SCompPlanoConta scPlanoConta = (SCompPlanoConta)ConfApplicationContext.getBean(SCompPlanoConta.class);

    public List criarTitulos(Cte vo, OpcoesFinanceiras opcoes, OpcoesContabeis opcoesCont, EmpresaContabilidade empresaContabilidade) throws ExceptionGeracaoTitulos, ExceptionService, ExceptionInvalidData {
        List titulos = new ArrayList();
        Pessoa pessoa = vo.getClienteTomador().getCliente().getPessoa();
        PlanoConta pc = this.scPlanoConta.getPlanoConta(vo.getClienteTomador().getCliente(), opcoesCont);
        ClassificacaoClientes classificacaoPessoa = vo.getClienteTomador().getCliente().getClassificacaoClientes();
        short tipoPessoa = EnumConstPessoa.CLIENTE.getEnumId();
        short tipoTitulo = 1;
        if (ToolMethods.isEquals((Object)vo.getTipoCte().getCodigo(), (Object)2)) {
            tipoTitulo = 0;
        }
        double valorTotalNota = vo.getCteVlrImpostos().getVrPrestacao();
        String obs = "CTe: " + pessoa.getNome();
        CondicoesPagamento cond = vo.getClienteTomador().getCliente().getFaturamento().getCondicaoPagamento();
        if (vo.getClienteTomador().getCliente().getFaturamento().getCondicaoPagamento() == null) {
            throw new ExceptionGeracaoTitulos("N\u00e3o foi encontrado Condi\u00e7\u00e3o de Pagamento vinculado ao Cliente " + vo.getClienteTomador().getCliente().getPessoa().getNome() + "!");
        }
        titulos = cond.getCondMutante() != null && cond.getCondMutante() == 1 ? new AuxTitulos().getTitulosMutanteInternal(vo.getClienteTomador().getCliente().getFaturamento().getCondicaoPagamento(), pessoa, valorTotalNota, pc, 0.0, cond.getParcelasMutante(), tipoPessoa, tipoTitulo, (short)1, vo.getDataEmissao(), obs, vo.getDataEmissao(), vo.getDataEmissao(), vo.getDataCadastro(), vo.getDataEmissao(), vo.getEmpresa(), opcoes, opcoes.getMeioPagamento(), classificacaoPessoa) : new AuxTitulos().getTitulosNaoMutanteInternal(cond, pessoa, valorTotalNota, pc, 0.0, tipoPessoa, tipoTitulo, (short)1, vo.getDataEmissao(), obs, vo.getDataEmissao(), vo.getDataEmissao(), vo.getDataCadastro(), vo.getDataEmissao(), vo.getEmpresa(), opcoes, opcoes.getMeioPagamento(), classificacaoPessoa);
        for (Titulo t : titulos) {
            if (vo.getRepresentante() != null) {
                AuxCte.getTituloRepresentante(vo.getRepresentante(), t, valorTotalNota, valorTotalNota);
            }
            t.setCte(vo);
            t.setLancCtbGerencial(CoreUtilityFactory.getUtilityLancamentosGerenciais().gerarLancamentoCtbGerencial(vo, t));
        }
        return titulos;
    }

    private static List<TituloRepresentante> getTituloRepresentante(Representante representante, Titulo titulo, Double percentual, Double vrBaseCalculoPercentual) {
        ArrayList<TituloRepresentante> lista = new ArrayList<TituloRepresentante>();
        TituloRepresentante t = new TituloRepresentante();
        t.setRepresentante(representante);
        t.setTitulo(titulo);
        if (percentual != null && percentual > 0.0) {
            t.setPercComissao(percentual);
        }
        if (vrBaseCalculoPercentual != null && vrBaseCalculoPercentual > 0.0) {
            t.setVrBCComissao(vrBaseCalculoPercentual);
        }
        lista.add(t);
        return lista;
    }

    void validarValoresTitulos(Cte ct) throws ExceptionValidation {
        Double valorTotalNota = ct.getCteVlrImpostos().getVrPrestacao();
        Double valorTitulos = 0.0;
        if (ct.getTitulos() != null && !ct.getTitulos().isEmpty()) {
            for (Object o : ct.getTitulos()) {
                Titulo t = (Titulo)o;
                valorTitulos = valorTitulos + t.getValor();
            }
            BigDecimal bd = new BigDecimal(valorTitulos);
            bd = bd.setScale(2, 5);
            valorTitulos = bd.doubleValue();
            bd = new BigDecimal(valorTotalNota);
            bd = bd.setScale(2, 5);
            valorTotalNota = bd.doubleValue();
            Double diferenca = valorTitulos - valorTotalNota;
            if ((diferenca = ContatoFormatUtil.arrredondarNumero((Double)diferenca, (int)2)) > 0.2 || diferenca < -0.2) {
                throw new ExceptionValidation("Existe uma diferen\u00e7a entre o valor total do CTe e dos t\u00edtulos. " + ContatoFormatUtil.formataNumero((Number)diferenca, (int)2));
            }
        }
    }
}

