/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.titulos;

import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.vo.DuplicataTransporte;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfinanceiras.HelperOpcoesFinanceiras;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import java.util.Date;
import java.util.List;
import mentorcore.utilities.CoreUtilityFactory;

class AuxDuplicataTransporte {
    AuxDuplicataTransporte() {
    }

    public Titulo criarTitulos(DuplicataTransporte vo, Date dataEmissao, Date dataVencimento, Date dataCompetencia, OpcoesFinanceiras opcoesFinanceiras, Double valor, Double descFinancTitulo, Empresa empresa, OpcoesContabeis opcoesContabeis) throws Exception {
        Titulo t = vo.getTitulo();
        if (t == null) {
            t = new Titulo();
            t.setDataCadastro(new Date());
        }
        t.setDataCompetencia(dataCompetencia);
        t.setDataEntradaSaida(t.getDataCompetencia());
        t.setPagRec(Short.valueOf((short)0));
        t.setProvisao(Short.valueOf((short)1));
        t.setCarteiraCobranca(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(opcoesFinanceiras).getCarteiraCobranca(t.getPagRec().shortValue()));
        t.setTipoDoc(opcoesFinanceiras.getTipoDocFinanceiro());
        t.setObservacao("Duplicata nr " + vo.getNrDuplicata() + " " + vo.getUnidadeFatFornecedor().getFornecedor().getPessoa().getNome());
        t.setValor(valor);
        t.setNumParcTituloEstnota(Short.valueOf((short)1));
        t.setPessoa(vo.getUnidadeFatFornecedor().getFornecedor().getPessoa());
        if (vo.getUnidadeFatFornecedor().getFornecedor().getClassificacaoPessoa() != null) {
            t.setClassificacaoPessoa(vo.getUnidadeFatFornecedor().getFornecedor().getClassificacaoPessoa());
        } else {
            t.setClassificacaoPessoa(opcoesFinanceiras.getClassificacaoClientes());
        }
        t.setTipoPessoa(EnumConstPessoa.FORNECEDOR.getEnumId());
        t.setDataEmissao(dataEmissao);
        t.setDataVencimento(dataVencimento);
        t.setDataVencimentoBase(dataVencimento);
        t.setEmpresa(vo.getEmpresa());
        t.setDescontoFinanceiro(descFinancTitulo);
        SCompPlanoConta compPlanoConta = (SCompPlanoConta)ConfApplicationContext.getBean(SCompPlanoConta.class);
        t.setPlanoConta(compPlanoConta.getPlanoConta(vo.getUnidadeFatFornecedor().getFornecedor(), opcoesContabeis));
        t.setLancCtbGerencial(this.gerarLancamentoCtbGerencial(vo, t, empresa));
        t.setMeioPagamento(opcoesFinanceiras.getMeioPagamento());
        return t;
    }

    private List<LancamentoCtbGerencial> gerarLancamentoCtbGerencial(DuplicataTransporte vo, Titulo t, Empresa empresa) throws Exception {
        return CoreUtilityFactory.getUtilityLancamentosGerenciais().gerarLancamentoCtbGerencial(vo, t, empresa);
    }
}

