/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.titulos;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.CompensacaoChequeTerceiros;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesFinanceirasTaxas;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TituloRepresentante;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

class AuxGeraTituloChequeTerceiros {
    AuxGeraTituloChequeTerceiros() {
    }

    public void criarTituloDevolucaoCheque(CompensacaoChequeTerceiros vo, PlanoContaGerencial pcGer, Empresa emp, OpcoesFinanceiras opFinanceiros, OpcoesContabeis opContabeis) {
        Titulo t = vo.getTitulo();
        if (t == null) {
            t = new Titulo();
        }
        PlanoConta pc = vo.getPlanoConta();
        if (!ToolMethods.isEquals((Object)opContabeis.getUsarContaDeUltimoBorderoParaTitulosDeChequesDevolvidos(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            pc = this.getPlanoConta(vo);
        }
        t.setCompensacaoChequeTerceiros(vo);
        t.setPagRec(Short.valueOf((short)1));
        t.setCarteiraCobranca(opFinanceiros.getCarteiraCobrancaChequeDev());
        t.setDataCadastro(new Date());
        t.setDataCompetencia(vo.getDataCompensacao());
        t.setDataEntradaSaida(t.getDataCompetencia());
        t.setDataEmissao(vo.getDataCompensacao());
        t.setDataVencimento(vo.getCheque().getDataVencimento());
        t.setDataVencimentoBase(vo.getCheque().getDataVencimento());
        t.setEmpresa(emp);
        t.setNumParcTituloEstnota(Short.valueOf(Short.parseShort("1")));
        t.setObservacao("Devolucao cheque nao compensado: " + vo.getCheque().getNumero());
        t.setPessoa(vo.getCheque().getPessoa());
        if (vo.getCheque().getClassificacaoPessoa() != null) {
            t.setClassificacaoPessoa(vo.getCheque().getClassificacaoPessoa());
        } else {
            t.setClassificacaoPessoa(opFinanceiros.getClassificacaoClientes());
        }
        t.setPlanoConta(pc);
        t.setProvisao(Short.valueOf((short)1));
        if (opFinanceiros.getTipoDocFinanceiroChequeDev() != null) {
            t.setTipoDoc(opFinanceiros.getTipoDocFinanceiroChequeDev());
        } else {
            t.setTipoDoc(opFinanceiros.getTipoDocFinanceiro());
        }
        t.setTipoPessoa(EnumConstPessoa.PESSOA.getEnumId());
        t.setValor(vo.getCheque().getValor());
        this.setarPercJurosMultaDesconto(t, opFinanceiros);
        ArrayList<LancamentoCtbGerencial> lista = new ArrayList<LancamentoCtbGerencial>();
        LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, t.getDataCadastro(), t.getDataVencimento(), Short.valueOf(EnumLancamentoCTBGerencial.DEBITO.getValue()), t.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Devolucao cheque nao compensado: " + t.getPessoa().getNome(), pcGer, t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), null, t.getValor(), null);
        lista.add(l);
        TituloRepresentante tr = new TituloRepresentante();
        tr.setPercComissao(Double.valueOf(0.0));
        tr.setVrBCComissao(Double.valueOf(0.0));
        tr.setRepresentante(vo.getCheque().getRepresentante());
        tr.setTitulo(t);
        ArrayList<TituloRepresentante> aux = new ArrayList<TituloRepresentante>();
        aux.add(tr);
        t.setRepresentantes(aux);
        t.setLancCtbGerencial(lista);
        t.setCompensacaoChequeTerceiros(vo);
        if (opFinanceiros.getMeioPagamentoChequeDev() != null) {
            t.setMeioPagamento(opFinanceiros.getMeioPagamentoChequeDev());
        } else {
            t.setMeioPagamento(opFinanceiros.getMeioPagamento());
        }
        vo.setTitulo(t);
    }

    private PlanoConta getPlanoConta(CompensacaoChequeTerceiros vo) {
        Iterator iterator;
        if (vo.getCheque().getGrupoDeBaixaFormasRec() != null && (iterator = vo.getCheque().getGrupoDeBaixaFormasRec().getBaixaTitulo().iterator()).hasNext()) {
            BaixaTitulo baixaTitulo = (BaixaTitulo)iterator.next();
            return baixaTitulo.getTitulo().getPlanoConta();
        }
        if (vo.getCheque().getGrupoDeBaixaFormasPag() != null && (iterator = vo.getCheque().getGrupoDeBaixaFormasPag().getBaixaTitulo().iterator()).hasNext()) {
            BaixaTitulo baixaTitulo = (BaixaTitulo)iterator.next();
            return baixaTitulo.getTitulo().getPlanoConta();
        }
        return vo.getPlanoConta();
    }

    private void setarPercJurosMultaDesconto(Titulo t, OpcoesFinanceiras op) {
        if (t.getPagRec() == 1) {
            Double percJuros = op.getPercJurosMes();
            Double percDesc = op.getPercDescMes();
            Double percMulta = op.getPercMulta();
            OpcoesFinanceirasTaxas opTaxas = this.getOpcoesFinanceirasTaxas(t.getMeioPagamento(), op);
            if (opTaxas != null) {
                percJuros = opTaxas.getPercJurosMes();
                percDesc = opTaxas.getPercDescMes();
                percMulta = opTaxas.getPercMulta();
            }
            if (percJuros != null) {
                t.setPercJurosMes(percJuros);
                t.setVrJurosDia(Double.valueOf(t.getValor() * (percJuros / 100.0) / 30.0));
            } else {
                t.setPercJurosMes(Double.valueOf(0.0));
                t.setVrJurosDia(Double.valueOf(0.0));
            }
            if (percDesc != null) {
                t.setPercDescontoMes(percDesc);
            } else {
                t.setPercDescontoMes(Double.valueOf(0.0));
            }
            if (percMulta != null) {
                t.setPercMulta(percMulta);
            } else {
                t.setPercMulta(Double.valueOf(0.0));
            }
        } else {
            t.setPercMulta(Double.valueOf(0.0));
            t.setPercJurosMes(Double.valueOf(0.0));
            t.setVrJurosDia(Double.valueOf(0.0));
            t.setPercDescontoMes(Double.valueOf(0.0));
        }
    }

    private OpcoesFinanceirasTaxas getOpcoesFinanceirasTaxas(MeioPagamento meioPagamento, OpcoesFinanceiras op) {
        if (meioPagamento != null) {
            for (OpcoesFinanceirasTaxas taxa : op.getTaxas()) {
                if (!taxa.getMeioPagamento().equals((Object)meioPagamento)) continue;
                return taxa;
            }
        }
        return null;
    }
}

