/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.titulos;

import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.vo.ClienteFaturamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FaturaCte;
import com.touchcomp.basementor.model.vo.GeracaoFaturamento;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesFinanceirasTaxas;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.TipoOperacaoGeracaoFaturamento;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TituloRepresentante;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfinanceiras.HelperOpcoesFinanceiras;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import java.util.ArrayList;
import java.util.List;
import mentorcore.dao.CoreBaseDAO;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.CoreServiceFactory;
import mentorcore.service.impl.cliente.ServiceCliente;
import mentorcore.utilities.CoreUtilityFactory;

class AuxGeracaoFaturamento {
    private final SCompPlanoConta scPlanoConta = (SCompPlanoConta)ConfApplicationContext.getBean(SCompPlanoConta.class);

    AuxGeracaoFaturamento() {
    }

    public List criarTitulos(TipoOperacaoGeracaoFaturamento ti, GeracaoFaturamento vo, FaturaCte f, Titulo t, OpcoesContabeis opcoesCont) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        try {
            ArrayList<Titulo> l = new ArrayList<Titulo>();
            OpcoesFinanceiras opcoes = AuxGeracaoFaturamento.getOpcoesFinanceiras(vo.getEmpresa());
            if (t == null) {
                t = new Titulo();
            }
            t.setFaturaCte(f);
            t.setPessoa(f.getPessoa());
            t.setClassificacaoPessoa(opcoes.getClassificacaoClientes());
            t.setCartCobrancaDestino(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(opcoes).getCarteiraCobrancaDestino(f.getPessoa(), null));
            t.setPagRec(Short.valueOf((short)1));
            t.setTipoDoc(vo.getTipoDoc());
            t.setCarteiraCobranca(vo.getCarteiraCobranca());
            ClienteFaturamento c = AuxGeracaoFaturamento.buscarClienteFaturamento(f.getPessoa());
            t.setProvisao(Short.valueOf((short)1));
            t.setDataVencimento(f.getDataVencimento());
            t.setDataVencimentoBase(f.getDataVencimento());
            t.setDataEmissao(vo.getDataEmissao());
            t.setValor(f.getVlrFatura());
            t.setDataCadastro(vo.getDataCadastro());
            t.setEmpresa(vo.getEmpresa());
            t.setPlanoConta(this.scPlanoConta.getPlanoConta(c.getCliente(), opcoesCont));
            t.setTipoPessoa(EnumConstPessoa.CLIENTE.getEnumId());
            t.setDataCompetencia(vo.getDataEmissao());
            t.setDataEntradaSaida(t.getDataCompetencia());
            t.setNumParcTituloEstnota(Short.valueOf(Short.parseShort("1")));
            t.setRepresentantes(AuxGeracaoFaturamento.getTituloRepresentante(c.getRepresentante(), t, c.getRepresentante().getPercentualComissao(), t.getValor()));
            t.setObservacao("CTe: " + String.valueOf(f.getPessoa()) + " (1/1");
            t.setLancCtbGerencial(this.gerarLancamentoCtbGerencial(ti, t));
            this.setarPercJurosMultaDesconto(t, opcoes);
            l.add(t);
            return l;
        }
        catch (ExceptionService ex) {
            throw new ExceptionGeracaoTitulos(ex.getMessage(), (Throwable)ex);
        }
    }

    private List<LancamentoCtbGerencial> gerarLancamentoCtbGerencial(TipoOperacaoGeracaoFaturamento ti, Titulo t) {
        return CoreUtilityFactory.getUtilityLancamentosGerenciais().gerarLancamentoCtbGerencial(ti, t);
    }

    private static ClienteFaturamento buscarClienteFaturamento(Pessoa p) throws ExceptionService {
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("pessoa", p.getIdentificador());
        ClienteFaturamento c = (ClienteFaturamento)CoreServiceFactory.getServiceCliente().execute(r, ServiceCliente.FIND_CLIENTE_FATURAMENTO);
        return c;
    }

    private static List<TituloRepresentante> getTituloRepresentante(Representante representante, Titulo titulo, Double percentual, Double vrBaseCalculoPercentual) {
        ArrayList<TituloRepresentante> lista = new ArrayList<TituloRepresentante>();
        TituloRepresentante t = new TituloRepresentante();
        t.setRepresentante(representante);
        t.setTitulo(titulo);
        if (percentual != null && percentual > 0.0) {
            t.setPercComissao(percentual);
        }
        if (vrBaseCalculoPercentual != null && vrBaseCalculoPercentual > 0.0) {
            t.setVrBCComissao(vrBaseCalculoPercentual);
        }
        lista.add(t);
        return lista;
    }

    private static OpcoesFinanceiras getOpcoesFinanceiras(Empresa empresa) throws ExceptionService {
        return (OpcoesFinanceiras)AuxGeracaoFaturamento.loadUniqueEntity(CoreDAOFactory.getInstance().getOpcoesFinanceirasDAO(), empresa);
    }

    private static Object loadUniqueEntity(CoreBaseDAO entityDAO, Empresa empresa) throws ExceptionService {
        return CoreService.simpleFindByCriteriaUniqueResult(entityDAO, "empresa", empresa, 0);
    }

    private void setarPercJurosMultaDesconto(Titulo t, OpcoesFinanceiras op) {
        if (t.getPagRec() == 1) {
            Double percJuros = op.getPercJurosMes();
            Double percDesc = op.getPercDescMes();
            Double percMulta = op.getPercMulta();
            OpcoesFinanceirasTaxas opTaxas = this.getOpcoesFinanceirasTaxas(t.getMeioPagamento(), op);
            if (opTaxas != null) {
                percJuros = opTaxas.getPercJurosMes();
                percDesc = opTaxas.getPercDescMes();
                percMulta = opTaxas.getPercMulta();
            }
            if (percJuros != null) {
                t.setPercJurosMes(percJuros);
                t.setVrJurosDia(Double.valueOf(t.getValor() * (percJuros / 100.0) / 30.0));
            } else {
                t.setPercJurosMes(Double.valueOf(0.0));
                t.setVrJurosDia(Double.valueOf(0.0));
            }
            if (percDesc != null) {
                t.setPercDescontoMes(percDesc);
            } else {
                t.setPercDescontoMes(Double.valueOf(0.0));
            }
            if (percMulta != null) {
                t.setPercMulta(percMulta);
            } else {
                t.setPercMulta(Double.valueOf(0.0));
            }
        } else {
            t.setPercMulta(Double.valueOf(0.0));
            t.setPercJurosMes(Double.valueOf(0.0));
            t.setVrJurosDia(Double.valueOf(0.0));
            t.setPercDescontoMes(Double.valueOf(0.0));
        }
    }

    private OpcoesFinanceirasTaxas getOpcoesFinanceirasTaxas(MeioPagamento meioPagamento, OpcoesFinanceiras op) {
        if (meioPagamento != null) {
            for (OpcoesFinanceirasTaxas taxa : op.getTaxas()) {
                if (!taxa.getMeioPagamento().equals((Object)meioPagamento)) continue;
                return taxa;
            }
        }
        return null;
    }
}

