/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.titulos;

import com.touchcomp.basementor.constants.enums.geracaotitulosimpostosretidos.EnumConstGeracaoTitulosImpostosRetidos;
import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeFinalidadeEmissao;
import com.touchcomp.basementor.constants.enums.opcoescontabeis.EnumConstImpostosRetidos;
import com.touchcomp.basementor.constants.enums.pedido.EnumConstGeracaoTitulosPreVendaPedido;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstGerarDocFinanceiro;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.Expedicao;
import com.touchcomp.basementor.model.vo.IncidenciaPisCofins;
import com.touchcomp.basementor.model.vo.InfPagamentoNfPropria;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.ItemParamCreditoLoja;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.Ncm;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesContabeisBaixaTitulos;
import com.touchcomp.basementor.model.vo.OpcoesContabeisDifal;
import com.touchcomp.basementor.model.vo.OpcoesContabeisImpostosRetidos;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TituloPisCofins;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.components.opcoes.CompOpcoesContabeis;
import com.touchcomp.basementorservice.helpers.impl.lotecontabil.HelperLoteContabil;
import com.touchcomp.basementorservice.helpers.impl.titulo.HelperTitulos;
import com.touchcomp.basementorservice.service.impl.meiopagamento.ServiceMeioPagamentoImpl;
import com.touchcomp.basementorservice.service.impl.opcoescontabeisbaixatitulos.ServiceOpcoesContabeisBaixaTitulosImpl;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorservice.service.interfaces.ServiceParamCreditoLoja;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoFormatUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mentorcore.exceptions.ExceptionService;
import mentorcore.exceptions.ExceptionValidation;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.titulos.AuxTitulos;
import mentorcore.utilities.impl.titulos.AuxTitulosDifal;
import mentorcore.utilities.impl.titulos.AuxTitulosRetidos;
import mentorcore.utilities.impl.titulos.model.InfPagNF;

class AuxNotaFiscalPropria {
    private final ServiceOpcoesContabeisBaixaTitulosImpl serviceOpcoesContabeisBaixaTitulosImpl = (ServiceOpcoesContabeisBaixaTitulosImpl)Context.get(ServiceOpcoesContabeisBaixaTitulosImpl.class);
    private final SCompPlanoConta scPlanoConta = (SCompPlanoConta)ConfApplicationContext.getBean(SCompPlanoConta.class);
    private final HelperLoteContabil helperLote = (HelperLoteContabil)Context.get(HelperLoteContabil.class);

    AuxNotaFiscalPropria() {
    }

    void atualizarDtTitulos(UnidadeFatCliente unid, Empresa empresa, InfPagamentoNfPropria inf, Date dataPrimeiroTit) {
        if (inf == null || inf.getCondicoesPagamento() == null || dataPrimeiroTit == null) {
            return;
        }
        if (!ToolMethods.isWithData((Collection)inf.getTitulos())) {
            return;
        }
        Integer dias = inf.getCondicoesPagamento().getNumeroDiasVencimento();
        if (!ToolMethods.isWithData((Number)dias)) {
            dias = 30;
        }
        Titulo t = (Titulo)inf.getTitulos().get(0);
        t.setDataVencimento(dataPrimeiroTit);
        if (!this.ajustarVencParamCredLoja(unid, inf, empresa, dataPrimeiroTit)) {
            int count = 0;
            for (Titulo tit : inf.getTitulos()) {
                Date dataVencimento = ToolDate.nextDays((Date)dataPrimeiroTit, (int)count);
                tit.setDataVencimento(dataVencimento);
                count += 30;
            }
        }
    }

    void criarTitulos(NotaFiscalPropria vo, OpcoesFinanceiras op, EmpresaContabilidade empresaContabil, OpcoesContabeis opcoesContabeis) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        InfPagNF inf = this.getValorTotal(vo, opcoesContabeis);
        if (inf.getValorTotal() == 0.0 && inf.getValorNaoGeraFinanceiro() == 0.0) {
            return;
        }
        if (vo.getExpedicao() != null && vo.getExpedicao().getPedido() != null && ToolMethods.isEquals((Object)vo.getExpedicao().getPedido().getSituacaoPedido().getGerarFinanceiroNFCe(), (Object)EnumConstGeracaoTitulosPreVendaPedido.GERAR_TITULOS_REALIZADOS.getValue())) {
            if (ToolMethods.isWithData((Collection)vo.getInfPagamentoNfPropria()) && vo.getInfPagamentoNfPropria().size() == 1) {
                ((InfPagamentoNfPropria)vo.getInfPagamentoNfPropria().get(0)).setValor(inf.getValorTotal());
            }
            return;
        }
        if (vo.getNfceControleCaixa() != null) {
            return;
        }
        if (vo.getInfPagamentoNfPropria().isEmpty() && inf.getValorTotal() > 0.0) {
            InfPagamentoNfPropria a = this.criarInfPagamentoPadrao(vo, op);
            vo.getInfPagamentoNfPropria().add(a);
        }
        for (InfPagamentoNfPropria infPag : vo.getInfPagamentoNfPropria()) {
            if (infPag.getMeioPagamento() != null) continue;
            throw new ExceptionGeracaoTitulos("Primeiro informe o Meio de Pagamento no cadastro de Condi\u00e7\u00f5es de Pagamento, ou na pr\u00f3pria Nota Fiscal ou em Op\u00e7\u00f5es Financeiras!");
        }
        this.determinarValorInfPagamento(vo, inf);
        int cont = 1;
        ArrayList<Titulo> titulosAll = new ArrayList<Titulo>();
        for (InfPagamentoNfPropria infPagamento : vo.getInfPagamentoNfPropria()) {
            if (infPagamento.getMeioPagamento() != null && Objects.equals(infPagamento.getMeioPagamento().getGerarFinanceiro(), EnumConstGerarDocFinanceiro.GERAR_TITULOS.value)) {
                List<Titulo> titulos = new ArrayList();
                Pessoa pessoa = vo.getUnidadeFatCliente().getCliente().getPessoa();
                PlanoConta pc = this.getPlanoContaClienteFornecedor(vo, opcoesContabeis);
                if (infPagamento.getMeioPagamento() != null && infPagamento.getMeioPagamento().getAlterarPessoaTitulo().equals((short)1)) {
                    pessoa = infPagamento.getMeioPagamento().getPessoa();
                    pc = infPagamento.getMeioPagamento().getPlanoConta();
                }
                short tipoPessoa = EnumConstPessoa.CLIENTE.getEnumId();
                short tipoTitulo = this.getTipoTituloNotaPropria(vo);
                Double valorPagamento = infPagamento.getValor();
                String obs = "Nota Fiscal Propria: " + pessoa.toString();
                CondicoesPagamento cond = infPagamento.getCondicoesPagamento();
                String parcelas = infPagamento.getParcelas();
                if (cond == null) {
                    cond = vo.getCondicaoPagamento();
                    parcelas = vo.getParcelas();
                }
                titulos = cond.getCondMutante() != null && cond.getCondMutante() == 1 ? new AuxTitulos().getTitulosMutanteInternal(cond, pessoa, valorPagamento, pc, 0.0, parcelas, tipoPessoa, tipoTitulo, (short)1, vo.getDataEmissaoNota(), obs, vo.getDataEmissaoNota(), vo.getDataEntradaSaida(), vo.getDataCadastro(), vo.getDataEmissaoNota(), vo.getEmpresa(), op, infPagamento.getMeioPagamento(), vo.getClassificacaoCliente()) : new AuxTitulos().getTitulosNaoMutanteInternal(cond, pessoa, valorPagamento, pc, 0.0, tipoPessoa, tipoTitulo, (short)1, vo.getDataEmissaoNota(), obs, vo.getDataEmissaoNota(), vo.getDataEmissaoNota(), vo.getDataCadastro(), vo.getDataEmissaoNota(), vo.getEmpresa(), op, infPagamento.getMeioPagamento(), vo.getClassificacaoCliente());
                for (Titulo t : titulos) {
                    t.setInfPagamentoNfPropria(infPagamento);
                }
                infPagamento.setTitulos(titulos);
                if (cont == 1 && !titulos.isEmpty()) {
                    double subtrai = ContatoFormatUtil.arrredondarNumero((Double)(inf.getValorIcmsST() / (double)titulos.size()), (int)2);
                    double totalSubtrai = 0.0;
                    for (int i = 0; i < titulos.size(); ++i) {
                        Titulo t = titulos.get(i);
                        if (i == 0) {
                            t.setValor(Double.valueOf(t.getValor() + inf.getValorIcmsST()));
                        }
                        totalSubtrai += subtrai;
                        if (i == titulos.size() - 1) {
                            double diferenca = ContatoFormatUtil.arrredondarNumero((Double)(inf.getValorIcmsST() - totalSubtrai), (int)2);
                            t.setValor(Double.valueOf(t.getValor() - subtrai - diferenca));
                        } else {
                            t.setValor(Double.valueOf(t.getValor() - subtrai));
                        }
                        if (t.getPercJurosMes() == null || !(t.getPercJurosMes() > 0.0)) continue;
                        t.setVrJurosDia(Double.valueOf(t.getValor() * (t.getPercJurosMes() / 100.0) / 30.0));
                    }
                }
                this.ajustarVencParamCredLoja(vo.getUnidadeFatCliente(), infPagamento, vo.getEmpresa(), vo.getDataEmissaoNota());
                this.atualizarTitulosPorMeioPagamento(vo, opcoesContabeis);
                this.gerarPisCofinsTitulos(vo);
                this.inverterTitulosInfPag(titulos, vo);
                titulosAll.addAll(titulos);
                ++cont;
                continue;
            }
            infPagamento.getTitulos().clear();
        }
        OpcoesContabeisBaixaTitulos opbt = this.getOpcoesContabeisBaixaTitulos(vo.getUnidadeFatCliente().getCliente().getClassificacaoClientes());
        CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentosCTBGerencialNotaPropria(vo.getItensNotaPropria(), titulosAll, op.getEmpresa(), opbt != null ? opbt.getPlanoGerencialDescontoNaoDest() : null, opbt != null ? opbt.getPlanoGerencialFreteNaoDest() : null, opbt != null ? opbt.getPlanoGerencialSeguroNaoDest() : null, opbt != null ? opbt.getPlanoGerencialDespAcessNaoDest() : null, opbt != null ? opbt.getCentroCustoLiquidacao() : null);
        try {
            this.verificarSetarRepTitulos(vo, op);
        }
        catch (ExceptionService ex) {
            throw new ExceptionGeracaoTitulos("Erro ao atualizar os t\u00edtulos dos representantes.", (Throwable)ex);
        }
        this.gerarTitulosRetidos(vo, empresaContabil, op, inf, opcoesContabeis);
        this.gerarTitulosDifal(vo, opcoesContabeis, op, inf);
        if (inf.getValorNaoGeraFinanceiro() > 0.0) {
            this.gerarInfPagSemPagamento(vo, inf);
        }
    }

    private OpcoesContabeisBaixaTitulos getOpcoesContabeisBaixaTitulos(ClassificacaoClientes classificacaoClientes) throws ExceptionObjectNotFound {
        if (classificacaoClientes == null) {
            return null;
        }
        OpcoesContabeisBaixaTitulos found = this.serviceOpcoesContabeisBaixaTitulosImpl.findOpcoesContabeisBaixaTituloPorClassificacaoCliente(classificacaoClientes);
        if (found == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0051.001", new Object[]{classificacaoClientes}));
        }
        return found;
    }

    private boolean ajustarVencParamCredLoja(UnidadeFatCliente unid, InfPagamentoNfPropria infPagamento, Empresa empresa, Date dataEmissaoNota) {
        if (infPagamento.getTipoPagamentoNFe().getCodigo().equals("05")) {
            ClassificacaoClientes classificacaoClientes = unid.getCliente().getClassificacaoClientes();
            ItemParamCreditoLoja param = this.getParamCreditoLoja(empresa, classificacaoClientes, dataEmissaoNota);
            int i = 0;
            if (param != null) {
                for (Titulo t : infPagamento.getTitulos()) {
                    if (i == 0) {
                        t.setDataVencimento(param.getDataVencimento());
                    } else {
                        t.setDataVencimento(ToolDate.addMonthToDate((Date)param.getDataVencimento(), (Integer)i));
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    private InfPagNF getValorTotal(NotaFiscalPropria vo, OpcoesContabeis cont) {
        Double valor = 0.0;
        Double valorIcmsSt = 0.0;
        Double valorIcmsStDev = 0.0;
        Double vrTotalRetido = 0.0;
        Double valorNaoGeraFinanceiro = 0.0;
        for (Object o : vo.getItensNotaPropria()) {
            ItemNotaFiscalPropria i = (ItemNotaFiscalPropria)o;
            if (i.getGerarFinanceiro() == 1) {
                valor = valor + i.getItemNotaLivroFiscal().getValorTotal();
                if (i.getItemNotaLivroFiscal().getVrDevICMSST() != null) {
                    valorIcmsStDev = valorIcmsStDev + i.getItemNotaLivroFiscal().getVrDevICMSST();
                }
                if (valor == 0.0) {
                    valor = i.getVrProduto() + i.getVrServico();
                }
                if (i.getModeloFiscal().getModeloFiscalIcms().getCalcularIcmsStCliente() != null && i.getModeloFiscal().getModeloFiscalIcms().getCalcularIcmsStCliente() != 1) {
                    valorIcmsSt = valorIcmsSt + (i.getItemNotaLivroFiscal().getVrIcmsSt() + i.getItemNotaLivroFiscal().getValorFCPSt());
                }
            }
            if (i.getGerarFinanceiro() == 0 && (valorNaoGeraFinanceiro = Double.valueOf(valorNaoGeraFinanceiro + i.getItemNotaLivroFiscal().getValorTotal())) == 0.0) {
                valorNaoGeraFinanceiro = i.getVrProduto() + i.getVrServico();
            }
            if (i.getIssRetido() != null && i.getIssRetido().equals((short)1)) {
                vrTotalRetido = vrTotalRetido + i.getItemNotaLivroFiscal().getVrIss();
            }
            OpcoesContabeisImpostosRetidos inss = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)cont, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.INSS);
            OpcoesContabeisImpostosRetidos irrf = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)cont, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.IRRF);
            OpcoesContabeisImpostosRetidos lei10833 = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)cont, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.LEI_10833);
            OpcoesContabeisImpostosRetidos funrural = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)cont, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.FUNRURAL);
            OpcoesContabeisImpostosRetidos sestSenat = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)cont, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.SEST_SENAT);
            OpcoesContabeisImpostosRetidos senar = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)cont, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.SENAR);
            OpcoesContabeisImpostosRetidos rat = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)cont, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.RAT);
            OpcoesContabeisImpostosRetidos taxaSA = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)cont, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.TAXA_SANIDADE_ANIMAL);
            if (inss != null && inss.getPessoaImpostoRetido() != null) {
                vrTotalRetido = vrTotalRetido + i.getItemNotaLivroFiscal().getVrInss();
            }
            if (irrf != null && irrf.getPessoaImpostoRetido() != null) {
                vrTotalRetido = vrTotalRetido + i.getItemNotaLivroFiscal().getVrIrrf();
            }
            if (lei10833 != null && lei10833.getPessoaImpostoRetido() != null) {
                vrTotalRetido = vrTotalRetido + i.getItemNotaLivroFiscal().getVrLei10833();
            }
            if (funrural != null && funrural.getPessoaImpostoRetido() != null) {
                vrTotalRetido = vrTotalRetido + i.getItemNotaLivroFiscal().getVrFunrural();
            }
            if (vo.getNaturezaOperacao().getEntradaSaida().equals((short)1)) {
                vrTotalRetido = vrTotalRetido + i.getItemNotaLivroFiscal().getVrOutros();
            }
            vrTotalRetido = vrTotalRetido + i.getItemNotaLivroFiscal().getVrPisSt();
            vrTotalRetido = vrTotalRetido + i.getItemNotaLivroFiscal().getVrCofinsSt();
            vrTotalRetido = vrTotalRetido + i.getItemNotaLivroFiscal().getVrContSoc();
            if (sestSenat != null && sestSenat.getPessoaImpostoRetido() != null) {
                vrTotalRetido = vrTotalRetido + i.getItemNotaLivroFiscal().getValorSestSenat();
            }
            if (senar != null && senar.getPessoaImpostoRetido() != null) {
                vrTotalRetido = vrTotalRetido + i.getItemNotaLivroFiscal().getValorSenar();
            }
            if (rat != null && rat.getPessoaImpostoRetido() != null) {
                vrTotalRetido = vrTotalRetido + i.getItemNotaLivroFiscal().getValorRat();
            }
            if (taxaSA == null || taxaSA.getPessoaImpostoRetido() == null) continue;
            vrTotalRetido = vrTotalRetido + i.getItemNotaLivroFiscal().getValorTaxaSanidadeAnimal();
        }
        InfPagNF i = new InfPagNF();
        i.setValorTotal(valor);
        i.setValorIcmsST(valorIcmsSt);
        i.setValorIcmsSTDev(valorIcmsStDev);
        i.setValorImpostoRetido(vrTotalRetido);
        i.setValorNaoGeraFinanceiro(valorNaoGeraFinanceiro);
        return i;
    }

    public void verificarSetarRepTitulos(NotaFiscalPropria vo, OpcoesFinanceiras opFin) throws ExceptionService {
        this.calculaBCComissaoRepresentante(vo, opFin);
    }

    public static HashMap findDadosComissaoRepPedido(Expedicao vo) throws ExceptionService {
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("expedicao", vo);
        return (HashMap)CoreServiceFactory.getServicePedido().execute(r, "findDadosComissaoRep");
    }

    private void calculaBCComissaoRepresentante(NotaFiscalPropria vo, OpcoesFinanceiras opFin) {
        HelperTitulos helper = (HelperTitulos)Context.get(HelperTitulos.class);
        helper.atualizaTitulosRep(vo, opFin);
    }

    private short getTipoTituloNotaPropria(NotaFiscalPropria vo) {
        if (vo.getNaturezaOperacao().getEntradaSaida().equals((short)0) || vo.getNaturezaOperacao().getEntradaSaida().equals((short)2)) {
            return 0;
        }
        return 1;
    }

    void validarValoresTitulos(NotaFiscalPropria vo, EmpresaContabilidade cont, OpcoesFaturamento opFat, OpcoesContabeis opcoesContabeis) throws ExceptionValidation {
        if (vo.getExpedicao() != null && vo.getExpedicao().getPedido() != null && vo.getExpedicao().getPedido().getGeracaoTituloPedido() != null) {
            return;
        }
        InfPagNF inf = this.getValorTotal(vo, opcoesContabeis);
        Double valorTotalNota = inf.getValorTotal() - inf.getValorIcmsSTDev();
        Double valorTitulos = 0.0;
        if (vo.getInfPagamentoNfPropria() != null && !vo.getInfPagamentoNfPropria().isEmpty()) {
            for (InfPagamentoNfPropria i : vo.getInfPagamentoNfPropria()) {
                if (!ToolMethods.isEquals((Object)i.getTipoPagDifal(), (Object)0)) continue;
                for (Object o : i.getTitulos()) {
                    Titulo t = (Titulo)o;
                    valorTitulos = valorTitulos + t.getValor();
                }
            }
            if (ToolMethods.isEquals((Object)opcoesContabeis.getTipoGeracaoTitulosImpostosRetidos(), (Object)EnumConstGeracaoTitulosImpostosRetidos.GERAR_TITULO_APURACAO_MANUAL.getValue())) {
                valorTitulos = valorTitulos + CoreUtilityFactory.getUtilityTitulos().getTotalImpostosRetidosNFPropria(vo);
            }
            BigDecimal bd = new BigDecimal(valorTitulos);
            bd = bd.setScale(2, 5);
            valorTitulos = bd.doubleValue();
            bd = new BigDecimal(valorTotalNota);
            bd = bd.setScale(2, 5);
            valorTotalNota = bd.doubleValue();
            Double diferenca = valorTitulos - valorTotalNota;
            diferenca = ContatoFormatUtil.arrredondarNumero((Double)diferenca, (int)2);
            if (opFat.getBloqSalvarNFVlrDifTitulo().equals((short)1) && (diferenca > opFat.getValorMinBloqTit() || diferenca < -opFat.getValorMinBloqTit().doubleValue())) {
                throw new ExceptionValidation("Existe uma diferen\u00e7a entre o valor total da nota e dos t\u00edtulos. " + ContatoFormatUtil.formataNumero((Number)diferenca, (int)2));
            }
        }
    }

    private void atualizarTitulosPorMeioPagamento(NotaFiscalPropria vo, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        for (InfPagamentoNfPropria i : vo.getInfPagamentoNfPropria()) {
            if (i.getMeioPagamento() == null || !i.getMeioPagamento().getAlterarPessoaTitulo().equals((short)1)) continue;
            for (Titulo t : i.getTitulos()) {
                t.setLoteAdLancamentos(this.getLoteAdicionalContabil(vo, t, vo.getMeioPagamento(), opcoes));
            }
        }
    }

    private LoteContabil getLoteAdicionalContabil(NotaFiscalPropria vo, Titulo t, MeioPagamento meioPagamento, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        LoteContabil lote = this.helperLote.criaRecriaLoteContabil(t.getLoteAdLancamentos(), t.getDataCompetencia(), vo.getEmpresa(), ConstEnumOrigemLoteContabil.NOTA_PROPRIA);
        Lancamento l = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)vo.getEmpresa());
        PlanoConta pc = this.scPlanoConta.getPlanoConta(vo.getUnidadeFatCliente().getCliente(), opcoes);
        l.setPlanoContaCred(pc);
        l.setPlanoContaDeb(t.getPlanoConta());
        l.setGerado(Short.valueOf((short)0));
        l.setHistorico("Lancamento gerado pela transferencia de titulos do cliente: " + String.valueOf(vo.getUnidadeFatCliente()) + " para a conta do Meio de Pagamento: " + meioPagamento.getDescricao());
        l.setValor(t.getValor());
        l.setLoteContabil(lote);
        lote.getLancamentos().add(l);
        return lote;
    }

    private InfPagamentoNfPropria criarInfPagamentoPadrao(NotaFiscalPropria vo, OpcoesFinanceiras op) {
        InfPagamentoNfPropria i = new InfPagamentoNfPropria();
        i.setCondicoesPagamento(vo.getCondicaoPagamento());
        i.setParcelas(vo.getParcelas());
        if (vo.getMeioPagamento() != null) {
            i.setMeioPagamento(vo.getMeioPagamento());
        } else if (vo.getCondicaoPagamento() != null && vo.getCondicaoPagamento().getMeioPagamento() != null) {
            i.setMeioPagamento(vo.getCondicaoPagamento().getMeioPagamento());
        } else {
            i.setMeioPagamento(op.getMeioPagamento());
        }
        if (i.getMeioPagamento() != null) {
            i.setTipoPagamentoNFe(i.getMeioPagamento().getTipoPagamentoNFe());
        }
        i.setNotaFiscalPropria(vo);
        return i;
    }

    private void determinarValorInfPagamento(NotaFiscalPropria vo, InfPagNF i) {
        Double valorTotal = i.getValorTotal() - i.getValorIcmsSTDev() - i.getValorImpostoRetido();
        int cont = vo.getInfPagamentoNfPropria().size();
        int contValorMaiorZero = 0;
        double somaValorMaiorZero = 0.0;
        if (cont <= 1) {
            for (InfPagamentoNfPropria pag : vo.getInfPagamentoNfPropria()) {
                if (!(pag.getValor() > 0.0) || !ToolMethods.isEquals((Object)pag.getTipoPagRetido(), (Object)0) || !ToolMethods.isEquals((Object)pag.getTipoPagDifal(), (Object)0)) continue;
                somaValorMaiorZero += pag.getValor().doubleValue();
                ++contValorMaiorZero;
            }
            valorTotal = valorTotal - somaValorMaiorZero;
            cont -= contValorMaiorZero;
            for (InfPagamentoNfPropria pag : vo.getInfPagamentoNfPropria()) {
                if (pag.getMeioPagamento() != null && pag.getMeioPagamento().getGerarFinanceiro() != null && ToolMethods.isEquals((Object)EnumConstGerarDocFinanceiro.get((Object)pag.getMeioPagamento().getGerarFinanceiro()), (Object)EnumConstGerarDocFinanceiro.NAO_GERAR_DOC_FINANCEIRO.getValue())) {
                    pag.setValor(Double.valueOf(0.0));
                    pag.setValorBruto(Double.valueOf(0.0));
                    pag.setValorTroco(Double.valueOf(0.0));
                    continue;
                }
                if (pag.getValor() == 0.0 && cont > 0) {
                    pag.setValor(Double.valueOf(valorTotal / (double)cont));
                }
                if (!(pag.getValor() > 0.0) || cont != 0) continue;
                pag.setValor(Double.valueOf(pag.getValor() + valorTotal));
            }
        }
    }

    private void gerarPisCofinsTitulos(NotaFiscalPropria vo) {
        Double valorTotalTitulo = 0.0;
        for (InfPagamentoNfPropria i : vo.getInfPagamentoNfPropria()) {
            if (!ToolMethods.isEquals((Object)i.getTipoPagRetido(), (Object)0) || !ToolMethods.isEquals((Object)i.getTipoPagDifal(), (Object)0)) continue;
            for (Titulo t : i.getTitulos()) {
                valorTotalTitulo = valorTotalTitulo + t.getValor();
            }
        }
        if (valorTotalTitulo > 0.0) {
            ArrayList<ItemPisCofins> itens = new ArrayList<ItemPisCofins>();
            for (ItemNotaFiscalPropria item : vo.getItensNotaPropria()) {
                ItemNotaLivroFiscal lv = item.getItemNotaLivroFiscal();
                boolean achou = false;
                for (ItemPisCofins i : itens) {
                    if (!i.getAliquotaPis().equals(lv.getAliquotaPis()) || !i.getAliquotaCofins().equals(lv.getAliquotaCofins()) || !i.getIncidenciaPisCofins().equals((Object)item.getIncidenciaPisCofins()) || !i.getModeloDocFiscal().equals((Object)vo.getModeloDocFiscal()) || !i.getCfop().equals((Object)lv.getCfop()) || !i.getNcm().equals((Object)item.getProduto().getNcm())) continue;
                    i.setValorBCPis(i.getValorBCPis() + lv.getVrBCPis());
                    i.setValorBCCofins(i.getValorBCCofins() + lv.getVrBCCofins());
                    i.setValorPis(i.getValorPis() + lv.getVrPis());
                    i.setValorCofins(i.getValorCofins() + lv.getVrCofins());
                    i.setValorIcmsST(i.getValorIcmsST() + lv.getVrIcmsSt());
                    i.setValorIcms(i.getValorIcms() + lv.getVrIcms());
                    i.setValorIpi(i.getValorIpi() + lv.getVrIpiComercio() + lv.getVrIpiIndustria());
                    i.setValorProduto(i.getValorProduto() + lv.getValorTotal() - (lv.getVrIpiComercio() + lv.getVrIpiIndustria() + lv.getVrIcmsSt()));
                    achou = true;
                    break;
                }
                if (achou) continue;
                ItemPisCofins i = new ItemPisCofins(this);
                i.setIncidenciaPisCofins(item.getIncidenciaPisCofins());
                i.setModeloDocFiscal(vo.getModeloDocFiscal());
                i.setCfop(lv.getCfop());
                i.setNcm(item.getProduto().getNcm());
                i.setAliquotaCofins(lv.getAliquotaCofins());
                i.setAliquotaPis(lv.getAliquotaPis());
                i.setValorBCCofins(lv.getVrBCCofins());
                i.setValorBCPis(lv.getVrBCPis());
                i.setValorCofins(lv.getVrCofins());
                i.setValorPis(lv.getVrPis());
                i.setValorIcmsST(lv.getVrIcmsSt());
                i.setValorIcms(lv.getVrIcms());
                i.setValorIpi(lv.getVrIpiComercio() + lv.getVrIpiIndustria());
                i.setValorProduto(lv.getValorTotal() - (lv.getVrIpiComercio() + lv.getVrIpiIndustria() + lv.getVrIcmsSt()));
                if (i.getValorPis() > 0.0) {
                    i.setPercCofins(ToolFormatter.arrredondarNumero((Double)(i.getValorPis() * 100.0 / valorTotalTitulo), (int)4));
                }
                if (i.getValorCofins() > 0.0) {
                    i.setPercPis(ToolFormatter.arrredondarNumero((Double)(i.getValorCofins() * 100.0 / valorTotalTitulo), (int)4));
                }
                if (i.getValorProduto() > 0.0) {
                    i.setPercProduto(ToolFormatter.arrredondarNumero((Double)(i.getValorProduto() * 100.0 / valorTotalTitulo), (int)4));
                }
                if (i.getValorIpi() > 0.0) {
                    i.setPercIpi(ToolFormatter.arrredondarNumero((Double)(i.getValorIpi() * 100.0 / valorTotalTitulo), (int)4));
                }
                if (i.getValorIcmsST() > 0.0) {
                    i.setPercIcmsST(ToolFormatter.arrredondarNumero((Double)(i.getValorIcmsST() * 100.0 / valorTotalTitulo), (int)4));
                }
                if (i.getValorIcms() > 0.0) {
                    i.setPercIcms(ToolFormatter.arrredondarNumero((Double)(i.getValorIcms() * 100.0 / valorTotalTitulo), (int)4));
                }
                itens.add(i);
            }
            for (InfPagamentoNfPropria i : vo.getInfPagamentoNfPropria()) {
                if (!ToolMethods.isEquals((Object)i.getTipoPagRetido(), (Object)0) || !ToolMethods.isEquals((Object)i.getTipoPagDifal(), (Object)0)) continue;
                for (Titulo t : i.getTitulos()) {
                    Double percentualTitulo = ToolFormatter.arrredondarNumero((Double)(t.getValor() * 100.0 / valorTotalTitulo), (int)4);
                    for (ItemPisCofins ipc : itens) {
                        boolean achou = false;
                        Double valorBCPis = ToolFormatter.arrredondarNumero((Double)(ipc.getValorBCPis() * percentualTitulo / 100.0), (int)2);
                        Double valorBCCofins = ToolFormatter.arrredondarNumero((Double)(ipc.getValorBCCofins() * percentualTitulo / 100.0), (int)2);
                        Double valorPis = ToolFormatter.arrredondarNumero((Double)(ipc.getValorPis() * percentualTitulo / 100.0), (int)2);
                        Double valorCofins = ToolFormatter.arrredondarNumero((Double)(ipc.getValorCofins() * percentualTitulo / 100.0), (int)2);
                        Double valorIpi = ToolFormatter.arrredondarNumero((Double)(ipc.getValorIpi() * percentualTitulo / 100.0), (int)2);
                        Double valorIcmsST = ToolFormatter.arrredondarNumero((Double)(ipc.getValorIcmsST() * percentualTitulo / 100.0), (int)2);
                        Double valorIcms = ToolFormatter.arrredondarNumero((Double)(ipc.getValorIcms() * percentualTitulo / 100.0), (int)2);
                        Double valorProduto = ToolFormatter.arrredondarNumero((Double)(ipc.getValorProduto() * percentualTitulo / 100.0), (int)2);
                        for (TituloPisCofins tpc : t.getTituloPisCofins()) {
                            if (!tpc.getAliquotaCofins().equals(ipc.getAliquotaCofins()) || !tpc.getAliquotaPis().equals(ipc.getAliquotaPis()) || !tpc.getIncidenciaPisCofins().equals((Object)ipc.getIncidenciaPisCofins()) || !tpc.getCfop().equals((Object)ipc.getCfop()) || !tpc.getModeloDocFiscal().equals((Object)ipc.getModeloDocFiscal()) || !tpc.getNcm().equals((Object)ipc.getNcm())) continue;
                            tpc.setValorBCPis(Double.valueOf(valorBCPis + tpc.getValorBCPis()));
                            tpc.setValorBCCofins(Double.valueOf(valorBCCofins + tpc.getValorBCCofins()));
                            tpc.setValorPis(Double.valueOf(valorPis + tpc.getValorPis()));
                            tpc.setValorCofins(Double.valueOf(valorCofins + tpc.getValorCofins()));
                            tpc.setValorProduto(Double.valueOf(valorProduto + tpc.getValorProduto()));
                            tpc.setValorIcmsST(Double.valueOf(valorIcmsST + tpc.getValorIcmsST()));
                            tpc.setValorIcms(Double.valueOf(valorIcms + tpc.getValorIcms()));
                            tpc.setValorIpi(Double.valueOf(valorIpi + tpc.getValorIpi()));
                            achou = true;
                            break;
                        }
                        if (achou) continue;
                        TituloPisCofins tpc = new TituloPisCofins();
                        tpc.setIncidenciaPisCofins(ipc.getIncidenciaPisCofins());
                        tpc.setModeloDocFiscal(ipc.getModeloDocFiscal());
                        tpc.setCfop(ipc.getCfop());
                        tpc.setNcm(ipc.getNcm());
                        tpc.setAliquotaCofins(ipc.getAliquotaCofins());
                        tpc.setAliquotaPis(ipc.getAliquotaPis());
                        tpc.setValorBCPis(valorBCPis);
                        tpc.setValorBCCofins(valorBCCofins);
                        tpc.setValorPis(valorPis);
                        tpc.setValorCofins(valorCofins);
                        tpc.setValorProduto(valorProduto);
                        tpc.setValorIpi(valorIpi);
                        tpc.setValorIcmsST(valorIcmsST);
                        tpc.setValorIcms(valorIcms);
                        tpc.setTitulo(t);
                        t.getTituloPisCofins().add(tpc);
                    }
                }
            }
        }
    }

    private void gerarTitulosRetidos(NotaFiscalPropria vo, EmpresaContabilidade empresaContabil, OpcoesFinanceiras op, InfPagNF inf, OpcoesContabeis opcoesContabeis) throws ExceptionGeracaoTitulos {
        if (vo.getNaturezaOperacao().getEntradaSaida() == 2 && ToolMethods.isEquals((Object)opcoesContabeis.getTipoGeracaoTitulosImpostosRetidos(), (Object)EnumConstGeracaoTitulosImpostosRetidos.GERAR_TITULO_DOCUMENTOS_FISCAIS.getValue())) {
            InfPagamentoNfPropria infPag;
            Optional<InfPagamentoNfPropria> found = vo.getInfPagamentoNfPropria().stream().filter(i -> ToolMethods.isEquals((Object)i.getMeioPagamento(), (Object)op.getMeioPagamentoTituloRetido()) && ToolMethods.isEquals((Object)i.getTipoPagRetido(), (Object)1)).findFirst();
            boolean add = false;
            if (found.isPresent()) {
                infPag = found.get();
            } else {
                MeioPagamento meioPagamento = op.getMeioPagamentoTituloRetido();
                if (meioPagamento == null) {
                    throw new ExceptionGeracaoTitulos("Para a gera\u00e7\u00e3o de t\u00edtulos retidos, \u00e9 necess\u00e1rio o cadastro de um meio de pagamento com o tipo \"Sem Pagamento\" no recurso de Op\u00e7\u00f5es Financeiras.");
                }
                infPag = new InfPagamentoNfPropria();
                infPag.setMeioPagamento(meioPagamento);
                infPag.setTipoPagamentoNFe(meioPagamento.getTipoPagamentoNFe());
                infPag.setNotaFiscalPropria(vo);
                infPag.setTipoPagRetido(Short.valueOf((short)1));
                add = true;
            }
            infPag.getTitulos().clear();
            new AuxTitulosRetidos().calcularTitulosRetidos(infPag, vo, inf.getValorTotal(), op, empresaContabil, opcoesContabeis);
            infPag.setValor(Double.valueOf(0.0));
            infPag.setValorBruto(Double.valueOf(0.0));
            for (Titulo tit : infPag.getTitulos()) {
                infPag.setValor(Double.valueOf(tit.getValor() + infPag.getValor()));
                infPag.setValorBruto(Double.valueOf(tit.getValor() + infPag.getValorBruto()));
            }
            if (infPag.getTitulos().size() > 0 && add) {
                vo.getInfPagamentoNfPropria().add(infPag);
            }
        }
    }

    private void gerarTitulosDifal(NotaFiscalPropria vo, OpcoesContabeis opcoesContabeis, OpcoesFinanceiras op, InfPagNF inf) throws ExceptionGeracaoTitulos {
        Boolean achou = false;
        OpcoesContabeisDifal uf = null;
        for (OpcoesContabeisDifal difalUF : opcoesContabeis.getOpcoesContabeisDifal()) {
            if (!difalUF.getUf().equals((Object)vo.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf())) continue;
            achou = true;
            uf = difalUF;
        }
        if (!achou.booleanValue()) {
            return;
        }
        achou = false;
        for (LivroFiscal lv : vo.getLivrosFiscais()) {
            if (!(lv.getValorIcmsPartilhaDest() > 0.0)) continue;
            achou = true;
        }
        if (!achou.booleanValue()) {
            return;
        }
        if (vo.getNaturezaOperacao().getEntradaSaida() == 1) {
            InfPagamentoNfPropria infPag;
            Optional<InfPagamentoNfPropria> found = vo.getInfPagamentoNfPropria().stream().filter(i -> ToolMethods.isEquals((Object)i.getTipoPagamentoNFe().getCodigo(), (Object)"90") && ToolMethods.isEquals((Object)i.getTipoPagDifal(), (Object)1)).findFirst();
            if (found.isPresent()) {
                infPag = found.get();
            } else {
                ServiceMeioPagamentoImpl service = (ServiceMeioPagamentoImpl)ConfApplicationContext.getBean(ServiceMeioPagamentoImpl.class);
                MeioPagamento meioPagamento = service.getPorTipoPagamento("90");
                if (meioPagamento == null) {
                    throw new ExceptionGeracaoTitulos("Para a gera\u00e7\u00e3o de t\u00edtulos do difal, \u00e9 necess\u00e1rio o cadastro de um meio de pagamento com o tipo \"Sem Pagamento\".");
                }
                infPag = new InfPagamentoNfPropria();
                infPag.setMeioPagamento(meioPagamento);
                infPag.setTipoPagamentoNFe(meioPagamento.getTipoPagamentoNFe());
                infPag.setNotaFiscalPropria(vo);
                infPag.setTipoPagDifal(Short.valueOf((short)1));
                vo.getInfPagamentoNfPropria().add(infPag);
            }
            infPag.getTitulos().clear();
            new AuxTitulosDifal().calcularTitulosDifal(infPag, vo, infPag.getValor(), op, opcoesContabeis, uf);
            infPag.setValor(Double.valueOf(0.0));
            infPag.setValorBruto(Double.valueOf(0.0));
            for (Titulo tit : infPag.getTitulos()) {
                infPag.setValor(Double.valueOf(tit.getValor() + infPag.getValor()));
                infPag.setValorBruto(Double.valueOf(tit.getValor() + infPag.getValorBruto()));
            }
        }
    }

    private void inverterTitulosInfPag(List<Titulo> titulos, NotaFiscalPropria vo) {
        EnumConstNFeFinalidadeEmissao tipo = EnumConstNFeFinalidadeEmissao.get((Object)vo.getFinalidadeEmNFe().getCodigo());
        if (tipo.isDevolucao() && vo.getNaturezaOperacao() != null && ToolMethods.isEquals((Object)vo.getNaturezaOperacao().getEntradaSaida(), (Object)2)) {
            PlanoConta pc = null;
            if (ToolMethods.isEquals((Object)vo.getUnidadeFatCliente().getPessoa(), (Object)vo.getEmpresa().getPessoa()) && vo.getItensNotaPropria().size() > 0) {
                ItemNotaFiscalPropria item = (ItemNotaFiscalPropria)vo.getItensNotaPropria().get(0);
                pc = item.getPlanoContaCred();
            }
            for (Titulo titulo : titulos) {
                titulo.setPagRec(Short.valueOf((short)0));
                if (pc != null) {
                    titulo.setPlanoConta(pc);
                }
                for (LancamentoCtbGerencial lanc : titulo.getLancCtbGerencial()) {
                    lanc.setDebCred(Short.valueOf(EnumLancamentoCTBGerencial.DEBITO.getValue()));
                }
            }
        }
    }

    private void gerarInfPagSemPagamento(NotaFiscalPropria vo, InfPagNF inf) {
        ServiceMeioPagamentoImpl service = (ServiceMeioPagamentoImpl)ConfApplicationContext.getBean(ServiceMeioPagamentoImpl.class);
        MeioPagamento meioPagamento = service.getPorTipoPagamento("90");
        if (meioPagamento != null) {
            if (inf.getValorTotal() == 0.0) {
                ArrayList<InfPagamentoNfPropria> removidos = new ArrayList<InfPagamentoNfPropria>();
                for (InfPagamentoNfPropria infPag : vo.getInfPagamentoNfPropria()) {
                    if (!ToolMethods.isEquals((Object)infPag.getTipoPagDifal(), (Object)0) || !ToolMethods.isEquals((Object)infPag.getTipoPagRetido(), (Object)0)) continue;
                    removidos.add(infPag);
                }
                vo.getInfPagamentoNfPropria().removeAll(removidos);
            }
            InfPagamentoNfPropria i = new InfPagamentoNfPropria();
            i.setCondicoesPagamento(vo.getCondicaoPagamento());
            i.setParcelas(vo.getParcelas());
            i.setMeioPagamento(meioPagamento);
            i.setTipoPagamentoNFe(meioPagamento.getTipoPagamentoNFe());
            i.setNotaFiscalPropria(vo);
            vo.getInfPagamentoNfPropria().add(i);
        }
    }

    private PlanoConta getPlanoContaClienteFornecedor(NotaFiscalPropria vo, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        ItemNotaFiscalPropria i;
        if (ToolMethods.isEquals((Object)vo.getNaturezaOperacao().getEntradaSaida(), (Object)2) && (i = (ItemNotaFiscalPropria)vo.getItensNotaPropria().get(0)).getPlanoContaDeb() != null) {
            return i.getPlanoContaCred();
        }
        return this.scPlanoConta.getPlanoConta(vo.getUnidadeFatCliente().getCliente(), opcoes);
    }

    private ItemParamCreditoLoja getParamCreditoLoja(Empresa empresa, ClassificacaoClientes classificacaoClientes, Date dataEmissao) {
        if (classificacaoClientes != null) {
            ServiceParamCreditoLoja service = (ServiceParamCreditoLoja)ConfApplicationContext.getBean(ServiceParamCreditoLoja.class);
            return service.get(classificacaoClientes, empresa, dataEmissao);
        }
        return null;
    }

    private class ItemPisCofins {
        private IncidenciaPisCofins incidenciaPisCofins;
        private Double valorBCPis = 0.0;
        private Double valorPis = 0.0;
        private Double aliquotaPis = 0.0;
        private Double percPis = 0.0;
        private Double valorBCCofins = 0.0;
        private Double valorCofins = 0.0;
        private Double aliquotaCofins = 0.0;
        private Double percCofins = 0.0;
        private Cfop cfop;
        private Ncm ncm;
        private ModeloDocFiscal modeloDocFiscal;
        private Double valorProduto = 0.0;
        private Double valorIpi = 0.0;
        private Double valorIcmsST = 0.0;
        private Double percProduto = 0.0;
        private Double percIpi = 0.0;
        private Double percIcmsST = 0.0;
        private Double valorIcms = 0.0;
        private Double percIcms = 0.0;

        public ItemPisCofins(AuxNotaFiscalPropria auxNotaFiscalPropria) {
        }

        public IncidenciaPisCofins getIncidenciaPisCofins() {
            return this.incidenciaPisCofins;
        }

        public void setIncidenciaPisCofins(IncidenciaPisCofins incidenciaPisCofins) {
            this.incidenciaPisCofins = incidenciaPisCofins;
        }

        public Double getValorBCPis() {
            return this.valorBCPis;
        }

        public void setValorBCPis(Double valorBCPis) {
            this.valorBCPis = valorBCPis;
        }

        public Double getValorPis() {
            return this.valorPis;
        }

        public void setValorPis(Double valorPis) {
            this.valorPis = valorPis;
        }

        public Double getAliquotaPis() {
            return this.aliquotaPis;
        }

        public void setAliquotaPis(Double aliquotaPis) {
            this.aliquotaPis = aliquotaPis;
        }

        public Double getPercPis() {
            return this.percPis;
        }

        public void setPercPis(Double percPis) {
            this.percPis = percPis;
        }

        public Double getValorBCCofins() {
            return this.valorBCCofins;
        }

        public void setValorBCCofins(Double valorBCCofins) {
            this.valorBCCofins = valorBCCofins;
        }

        public Double getValorCofins() {
            return this.valorCofins;
        }

        public void setValorCofins(Double valorCofins) {
            this.valorCofins = valorCofins;
        }

        public Double getAliquotaCofins() {
            return this.aliquotaCofins;
        }

        public void setAliquotaCofins(Double aliquotaCofins) {
            this.aliquotaCofins = aliquotaCofins;
        }

        public Double getPercCofins() {
            return this.percCofins;
        }

        public void setPercCofins(Double percCofins) {
            this.percCofins = percCofins;
        }

        public Cfop getCfop() {
            return this.cfop;
        }

        public void setCfop(Cfop cfop) {
            this.cfop = cfop;
        }

        public Ncm getNcm() {
            return this.ncm;
        }

        public void setNcm(Ncm ncm) {
            this.ncm = ncm;
        }

        public ModeloDocFiscal getModeloDocFiscal() {
            return this.modeloDocFiscal;
        }

        public void setModeloDocFiscal(ModeloDocFiscal modeloDocFiscal) {
            this.modeloDocFiscal = modeloDocFiscal;
        }

        public Double getValorProduto() {
            return this.valorProduto;
        }

        public void setValorProduto(Double valorProduto) {
            this.valorProduto = valorProduto;
        }

        public Double getValorIpi() {
            return this.valorIpi;
        }

        public void setValorIpi(Double valorIpi) {
            this.valorIpi = valorIpi;
        }

        public Double getValorIcmsST() {
            return this.valorIcmsST;
        }

        public void setValorIcmsST(Double valorIcmsST) {
            this.valorIcmsST = valorIcmsST;
        }

        public Double getPercProduto() {
            return this.percProduto;
        }

        public void setPercProduto(Double percProduto) {
            this.percProduto = percProduto;
        }

        public Double getPercIpi() {
            return this.percIpi;
        }

        public void setPercIpi(Double percIpi) {
            this.percIpi = percIpi;
        }

        public Double getPercIcmsST() {
            return this.percIcmsST;
        }

        public void setPercIcmsST(Double percIcmsST) {
            this.percIcmsST = percIcmsST;
        }

        public Double getValorIcms() {
            return this.valorIcms;
        }

        public void setValorIcms(Double valorIcms) {
            this.valorIcms = valorIcms;
        }

        public Double getPercIcms() {
            return this.percIcms;
        }

        public void setPercIcms(Double percIcms) {
            this.percIcms = percIcms;
        }
    }
}

