/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.titulos;

import com.touchcomp.basementor.constants.enums.geracaotitulosimpostosretidos.EnumConstGeracaoTitulosImpostosRetidos;
import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstGerarDocFinanceiro;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.InfPagamentoNfTerceiros;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.helpers.impl.lotecontabil.HelperLoteContabil;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoFormatUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mentorcore.exceptions.ExceptionValidation;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.titulos.AuxTitulos;
import mentorcore.utilities.impl.titulos.AuxTitulosRetidos;
import mentorcore.utilities.impl.titulos.model.InfPagNF;

class AuxNotaFiscalTerceiros {
    private final HelperLoteContabil helperLote = (HelperLoteContabil)Context.get(HelperLoteContabil.class);

    AuxNotaFiscalTerceiros() {
    }

    public void criarTitulos(NotaFiscalTerceiros vo, OpcoesFinanceiras op, EmpresaContabilidade cont, OpcoesContabeis opcoesContabeis) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        Object infPag2;
        MeioPagamento m;
        InfPagNF inf = this.getValorTotalItemNFTerceiros(vo.getItemNotaTerceiros());
        if (inf.getValorTotal() == 0.0) {
            return;
        }
        if (vo.getInfPagamentoNfTerceiros().isEmpty()) {
            vo.getInfPagamentoNfTerceiros().add(this.criarInfPagamentoPadrao(vo, op));
        }
        if (vo.getInfPagamentoNfTerceiros().size() == 1 && (m = this.getMeioPagamento(vo, op)) != null) {
            ((InfPagamentoNfTerceiros)vo.getInfPagamentoNfTerceiros().get(0)).setMeioPagamento(m);
            if (((InfPagamentoNfTerceiros)vo.getInfPagamentoNfTerceiros().get(0)).getTipoPagamentoNFe() == null) {
                ((InfPagamentoNfTerceiros)vo.getInfPagamentoNfTerceiros().get(0)).setTipoPagamentoNFe(m.getTipoPagamentoNFe());
            }
        }
        for (Object infPag2 : vo.getInfPagamentoNfTerceiros()) {
            if (infPag2.getMeioPagamento() != null) continue;
            throw new ExceptionGeracaoTitulos("Primeiro informe o Meio de Pagamento no cadastro de Condi\u00e7\u00f5es de Pagamento, ou na pr\u00f3pria Nota Fiscal ou em Op\u00e7\u00f5es Financeiras!");
        }
        this.determinarValorInfPagamento(vo, inf);
        ArrayList titulosAll = new ArrayList();
        for (InfPagamentoNfTerceiros infPagamento : vo.getInfPagamentoNfTerceiros()) {
            if (infPagamento.getMeioPagamento() != null && Objects.equals(infPagamento.getMeioPagamento().getGerarFinanceiro(), EnumConstGerarDocFinanceiro.GERAR_TITULOS.value)) {
                Double valorPagamento = infPagamento.getValor();
                List titulos = new ArrayList();
                Pessoa pessoa = vo.getUnidadeFatFornecedor().getFornecedor().getPessoa();
                SCompPlanoConta compPlanoConta = (SCompPlanoConta)ConfApplicationContext.getBean(SCompPlanoConta.class);
                PlanoConta pc = compPlanoConta.getPlanoConta(vo.getUnidadeFatFornecedor().getFornecedor(), opcoesContabeis);
                short tipoPessoa = EnumConstPessoa.FORNECEDOR.getEnumId();
                short tipoTitulo = 0;
                String obs = "NFT: " + vo.getUnidadeFatFornecedor().getFornecedor().getPessoa().getNome();
                if (infPagamento.getMeioPagamento() != null && infPagamento.getMeioPagamento().getAlterarPessoaTitulo().equals((short)1)) {
                    pessoa = vo.getMeioPagamento().getPessoa();
                    pc = vo.getMeioPagamento().getPlanoConta();
                }
                titulos = vo.getCondicoesPagamento() != null && vo.getCondicoesPagamento().getCondMutante() != null && vo.getCondicoesPagamento().getCondMutante() == 1 ? new AuxTitulos().getTitulosMutanteInternal(vo.getCondicoesPagamento(), pessoa, valorPagamento, pc, 0.0, vo.getParcelas(), tipoPessoa, tipoTitulo, (short)1, vo.getDataEmissao(), obs, vo.getDataEmissao(), vo.getDataCompetencia(), vo.getDataCadastro(), vo.getDataCompetencia(), vo.getEmpresa(), op, infPagamento.getMeioPagamento(), vo.getClassificacaoPessoas()) : new AuxTitulos().getTitulosNaoMutanteInternal(vo.getCondicoesPagamento(), pessoa, valorPagamento, pc, 0.0, tipoPessoa, tipoTitulo, (short)1, vo.getDataEmissao(), obs, vo.getDataEmissao(), vo.getDataCompetencia(), vo.getDataCadastro(), vo.getDataCompetencia(), vo.getEmpresa(), op, infPagamento.getMeioPagamento(), vo.getClassificacaoPessoas());
                for (Titulo t : titulos) {
                    t.setInfPagamentoNfTerceiros(infPagamento);
                }
                infPagamento.setTitulos(titulos);
                titulosAll.addAll(titulos);
                continue;
            }
            infPagamento.getTitulos().clear();
        }
        infPag2 = (InfPagamentoNfTerceiros)vo.getInfPagamentoNfTerceiros().get(0);
        new AuxTitulosRetidos().calcularTitulosRetidos((InfPagamentoNfTerceiros)infPag2, vo, inf.getValorTotal(), op, cont, opcoesContabeis);
        CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentosCTBGerencial(vo.getItemNotaTerceiros(), titulosAll, op.getEmpresa());
        this.atualizarTitulosPorMeioPagamento(vo, opcoesContabeis);
    }

    private InfPagNF getValorTotalItemNFTerceiros(List<ItemNotaTerceiros> itens) {
        Double valor = 0.0;
        Double valorDesconto = 0.0;
        Double valorIcmsSt = 0.0;
        Double valorIcmsStDev = 0.0;
        Double valorIcmsDisp = 0.0;
        for (ItemNotaTerceiros o : itens) {
            ItemNotaTerceiros i = o;
            if (i.getGerarFinanceiro() != 1) continue;
            valor = valor + i.getItemNotaLivroFiscal().getValorTotal();
            valorDesconto = valorDesconto + i.getValorDesconto();
            if (i.getItemNotaLivroFiscal().getVrDevICMSST() != null) {
                valorIcmsStDev = valorIcmsStDev + i.getItemNotaLivroFiscal().getVrDevICMSST();
            }
            if (i.getModeloFiscal().getModeloFiscalIcms().getIcmsDispensadoDesconto() != null && i.getModeloFiscal().getModeloFiscalIcms().getIcmsDispensadoDesconto().equals((short)1)) {
                valorIcmsDisp = valorIcmsDisp + i.getItemNotaLivroFiscal().getVrIcmsDesonerado();
            }
            if (valor == 0.0) {
                valor = i.getVrProduto() + i.getVrServico();
            }
            if (i.getModeloFiscal().getModeloFiscalIcms().getCalcularIcmsStCliente() == null || i.getModeloFiscal().getModeloFiscalIcms().getCalcularIcmsStCliente() == 1) continue;
            valorIcmsSt = valorIcmsSt + i.getItemNotaLivroFiscal().getVrIcmsSt();
        }
        InfPagNF i = new InfPagNF();
        i.setValorTotal(valor);
        i.setValorIcmsST(valorIcmsSt);
        i.setValorIcmsSTDev(valorIcmsStDev);
        i.setValorDesconto(valorDesconto);
        i.setValorIcmsDispensado(valorIcmsDisp);
        return i;
    }

    void validarValoresTitulos(NotaFiscalTerceiros vo, OpcoesCompraSuprimentos opcoesCompra, OpcoesContabeis opcoesContabeis) throws ExceptionValidation {
        InfPagNF inf = this.getValorTotalItemNFTerceiros(vo.getItemNotaTerceiros());
        Double valorTotalNota = inf.getValorTotal();
        Double valorTitulos = 0.0;
        if (vo.getInfPagamentoNfTerceiros() != null && !vo.getInfPagamentoNfTerceiros().isEmpty()) {
            for (InfPagamentoNfTerceiros i : vo.getInfPagamentoNfTerceiros()) {
                for (Titulo t : i.getTitulos()) {
                    valorTitulos = valorTitulos + (t.getValor() - t.getValorMultaEmbutida() - t.getValorJurosEmbutido() - t.getValorDespesaBancariaEmbutida());
                }
            }
            BigDecimal bd = new BigDecimal(valorTitulos);
            bd = bd.setScale(2, 5);
            valorTitulos = bd.doubleValue();
            bd = new BigDecimal(valorTotalNota);
            bd = bd.setScale(2, 5);
            valorTotalNota = bd.doubleValue();
            if (opcoesContabeis != null) {
                if (ToolMethods.isEquals((Object)opcoesContabeis.getTipoGeracaoTitulosImpostosRetidos(), (Object)EnumConstGeracaoTitulosImpostosRetidos.GERAR_TITULO_APURACAO_MANUAL.getValue())) {
                    valorTitulos = valorTitulos + CoreUtilityFactory.getUtilityTitulos().getTotalImpostosRetidosNFTerceiros(vo);
                } else if (ToolMethods.isEquals((Object)opcoesContabeis.getTipoGeracaoTitulosImpostosRetidos(), (Object)EnumConstGeracaoTitulosImpostosRetidos.GERAR_TITULO_APURACAO_REINF.getValue())) {
                    valorTitulos = valorTitulos + CoreUtilityFactory.getUtilityTitulos().getTotalImpostosRetidosNFTerceirosReinf(vo);
                }
            }
            Double diferenca = valorTitulos - valorTotalNota;
            if ((diferenca = ContatoFormatUtil.arrredondarNumero((Double)diferenca, (int)2)) > opcoesCompra.getValorMinBloqTit() || diferenca < -opcoesCompra.getValorMinBloqTit().doubleValue()) {
                throw new ExceptionValidation("Existe uma diferen\u00e7a entre o valor total da nota e dos t\u00edtulos. " + ContatoFormatUtil.formataNumero((Number)diferenca, (int)2));
            }
        }
    }

    private InfPagamentoNfTerceiros criarInfPagamentoPadrao(NotaFiscalTerceiros vo, OpcoesFinanceiras op) {
        InfPagamentoNfTerceiros i = new InfPagamentoNfTerceiros();
        i.setMeioPagamento(this.getMeioPagamento(vo, op));
        i.setNotaFiscalTerceiros(vo);
        return i;
    }

    private void determinarValorInfPagamento(NotaFiscalTerceiros vo, InfPagNF i) {
        Double valorTotal = i.getValorTotal();
        int cont = vo.getInfPagamentoNfTerceiros().size();
        int contValorMaiorZero = 0;
        double somaValorMaiorZero = 0.0;
        for (InfPagamentoNfTerceiros pag : vo.getInfPagamentoNfTerceiros()) {
            if (!(pag.getValor() > 0.0)) continue;
            somaValorMaiorZero += pag.getValor().doubleValue();
            ++contValorMaiorZero;
        }
        valorTotal = valorTotal - somaValorMaiorZero;
        cont -= contValorMaiorZero;
        for (InfPagamentoNfTerceiros pag : vo.getInfPagamentoNfTerceiros()) {
            if (pag.getValor() == 0.0 && cont > 0) {
                pag.setValor(Double.valueOf(valorTotal / (double)cont));
            }
            if (!(pag.getValor() > 0.0) || cont != 0) continue;
            pag.setValor(Double.valueOf(pag.getValor() + valorTotal));
        }
    }

    private void atualizarTitulosPorMeioPagamento(NotaFiscalTerceiros vo, OpcoesContabeis opcoesContabeis) throws ExceptionInvalidData {
        for (InfPagamentoNfTerceiros i : vo.getInfPagamentoNfTerceiros()) {
            if (i.getMeioPagamento() == null || !i.getMeioPagamento().getAlterarPessoaTitulo().equals((short)1)) continue;
            for (Titulo t : i.getTitulos()) {
                t.setLoteAdLancamentos(this.getLoteAdicionalContabil(vo, t, i.getMeioPagamento(), opcoesContabeis));
            }
        }
    }

    private LoteContabil getLoteAdicionalContabil(NotaFiscalTerceiros vo, Titulo t, MeioPagamento meioPagamento, OpcoesContabeis opcoesContabeis) throws ExceptionInvalidData {
        LoteContabil lote = this.helperLote.criaRecriaLoteContabil(t.getLoteAdLancamentos(), t.getDataCompetencia(), vo.getEmpresa(), ConstEnumOrigemLoteContabil.NOTA_TERCEIROS);
        Lancamento l = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)vo.getEmpresa());
        SCompPlanoConta compPlanoConta = (SCompPlanoConta)ConfApplicationContext.getBean(SCompPlanoConta.class);
        l.setPlanoContaDeb(compPlanoConta.getPlanoConta(vo.getUnidadeFatFornecedor().getFornecedor(), opcoesContabeis));
        l.setPlanoContaCred(t.getPlanoConta());
        l.setGerado(Short.valueOf((short)0));
        l.setHistorico("Lancamento gerado pela transferencia de titulos do fornecedor: " + String.valueOf(vo.getUnidadeFatFornecedor()) + " para a conta do Meio de Pagamento: " + meioPagamento.getDescricao());
        l.setValor(t.getValor());
        l.setLoteContabil(lote);
        l.setDataLancamento(l.getLoteContabil().getDataLote());
        lote.getLancamentos().add(l);
        return lote;
    }

    private MeioPagamento getMeioPagamento(NotaFiscalTerceiros vo, OpcoesFinanceiras op) {
        MeioPagamento m = vo.getMeioPagamento() != null ? vo.getMeioPagamento() : (vo.getCondicoesPagamento() != null && vo.getCondicoesPagamento().getMeioPagamento() != null ? vo.getCondicoesPagamento().getMeioPagamento() : op.getMeioPagamento());
        return m;
    }
}

