/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.titulos;

import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.constants.enums.pedido.EnumConstGeracaoTitulosPreVendaPedido;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GeracaoTituloPedido;
import com.touchcomp.basementor.model.vo.InfPagamentoPedido;
import com.touchcomp.basementor.model.vo.ItemParamCreditoLoja;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.helpers.impl.lotecontabil.HelperLoteContabil;
import com.touchcomp.basementorservice.helpers.impl.titulo.HelperTitulos;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorservice.service.interfaces.ServiceParamCreditoLoja;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoFormatUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mentorcore.exceptions.ExceptionValidation;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.titulos.AuxTitulos;
import mentorcore.utilities.impl.titulos.model.InfPagNF;

class AuxPedido {
    private final SCompPlanoConta scPlanoConta = (SCompPlanoConta)ConfApplicationContext.getBean(SCompPlanoConta.class);
    private final HelperLoteContabil helperLote = (HelperLoteContabil)Context.get(HelperLoteContabil.class);

    AuxPedido() {
    }

    public void criarTitulos(Pedido vo, OpcoesFinanceiras op, OpcoesFaturamento opFat, OpcoesContabeis opcoesCont) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        InfPagNF inf = this.getValorTotalPedido(vo);
        if (inf.getValorTotal() == 0.0) {
            return;
        }
        if (vo.getInfPagamentoPedido().isEmpty()) {
            vo.getInfPagamentoPedido().add(this.criarInfPagamentoPadrao(vo, op));
        }
        this.determinarValorInfPagamento(vo, inf, opFat);
        Short provisao = vo.getSituacaoPedido().getGerarFinanceiroNFCe();
        if (vo.getSituacaoPedido() != null && ToolMethods.isAffirmative((Number)vo.getSituacaoPedido().getNaoGerarTitulosPedido()) || ToolMethods.isEquals((Object)provisao, (Object)EnumConstGeracaoTitulosPreVendaPedido.NAO_GERAR_TITULOS.getValue())) {
            return;
        }
        Date dataBase = vo.getDataPrevisaoSaida();
        if (vo.getTipoDataTitulo() != null && vo.getTipoDataTitulo() == 0) {
            dataBase = vo.getDataEmissao();
        }
        ArrayList titulosAll = new ArrayList();
        boolean embutiIcmsSt = false;
        PlanoConta planoConta = this.scPlanoConta.getPlanoConta(vo.getUnidadeFatCliente().getCliente(), opcoesCont);
        for (InfPagamentoPedido infPagamentoPedido : vo.getInfPagamentoPedido()) {
            Double valorTotalNota = infPagamentoPedido.getValorLiquido();
            String obs = "Pedido: " + vo.getUnidadeFatCliente().getCliente().getPessoa().getNome();
            List titulos = null;
            CondicoesPagamento cond = infPagamentoPedido.getCondicoesPagamento();
            String parcelas = infPagamentoPedido.getParcelas();
            if (cond == null) {
                cond = vo.getCondicoesPagamento();
                parcelas = vo.getCondPagMut();
            }
            titulos = cond.getCondMutante() != null && cond.getCondMutante() == 1 ? new AuxTitulos().getTitulosMutanteInternal(cond, vo.getUnidadeFatCliente().getCliente().getPessoa(), valorTotalNota, planoConta, vo.getPercComissao(), parcelas, EnumConstPessoa.CLIENTE.getEnumId(), (short)1, provisao, dataBase, obs, vo.getDataEmissao(), vo.getDataEmissao(), vo.getDataCadastro(), vo.getDataEmissao(), vo.getEmpresa(), op, infPagamentoPedido.getMeioPagamento(), vo.getUnidadeFatCliente().getCliente().getClassificacaoClientes()) : new AuxTitulos().getTitulosNaoMutanteInternal(cond, vo.getUnidadeFatCliente().getCliente().getPessoa(), valorTotalNota, planoConta, vo.getPercComissao(), EnumConstPessoa.CLIENTE.getEnumId(), (short)1, provisao, dataBase, obs, vo.getDataEmissao(), vo.getDataEmissao(), vo.getDataCadastro(), vo.getDataEmissao(), vo.getEmpresa(), op, infPagamentoPedido.getMeioPagamento(), vo.getUnidadeFatCliente().getCliente().getClassificacaoClientes());
            if (inf.getValorIcmsST() > 0.0 && !embutiIcmsSt) {
                embutiIcmsSt = true;
                Iterator iterator = titulos.iterator();
                if (iterator.hasNext()) {
                    Titulo titulo = (Titulo)iterator.next();
                    titulo.setValor(ContatoFormatUtil.arrredondarNumero((Double)(titulo.getValor() + inf.getValorIcmsST()), (int)2));
                }
            }
            for (Titulo t : titulos) {
                t.setInfPagamentoPedido(infPagamentoPedido);
            }
            if (infPagamentoPedido.getTitulos() != null) {
                infPagamentoPedido.getTitulos().clear();
                infPagamentoPedido.getTitulos().addAll(titulos);
            } else {
                infPagamentoPedido.setTitulos(titulos);
            }
            if (infPagamentoPedido.getTipoPagamentoNFe() != null && infPagamentoPedido.getTipoPagamentoNFe().getCodigo().equals("05")) {
                ClassificacaoClientes classificacaoClientes = vo.getUnidadeFatCliente().getCliente().getClassificacaoClientes();
                ItemParamCreditoLoja param = this.getParamCreditoLoja(vo.getEmpresa(), classificacaoClientes, dataBase);
                if (param != null) {
                    int i = 0;
                    for (Titulo t : infPagamentoPedido.getTitulos()) {
                        if (i == 0) {
                            t.setDataVencimento(param.getDataVencimento());
                        } else {
                            t.setDataVencimento(ToolDate.addMonthToDate((Date)param.getDataVencimento(), (Integer)i));
                        }
                        ++i;
                    }
                }
            }
            titulosAll.addAll(titulos);
        }
        CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentosCTBGerencial(vo.getItemPedido(), titulosAll, op.getEmpresa());
        this.calculaBCComissaoRepresentante(vo, op);
        this.atualizarInfPagPedido(vo);
    }

    public void criarTitulosGeracaoTituloPedido(GeracaoTituloPedido geracaoTituloPedido, OpcoesFinanceiras op, OpcoesFaturamento opFat, OpcoesContabeis opcoesCont) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        Pedido vo = geracaoTituloPedido.getPedido();
        InfPagNF inf = this.getValorTotalGeracaoTituloPedido(vo);
        if (inf.getValorTotal() == 0.0) {
            return;
        }
        if (vo.getInfPagamentoPedido().isEmpty()) {
            vo.getInfPagamentoPedido().add(this.criarInfPagamentoPadrao(vo, op));
        }
        this.determinarValorInfPagamento(vo, inf, opFat);
        for (InfPagamentoPedido infPagamentoPedido : vo.getInfPagamentoPedido()) {
            Date dataBase = vo.getDataEmissao();
            if (vo.getTipoDataTitulo() != null && vo.getTipoDataTitulo() == 0) {
                dataBase = vo.getDataEmissao();
            }
            if ((ToolMethods.isEquals((Object)infPagamentoPedido.getTipoPagamentoNFe().getCodigo(), (Object)"03") || ToolMethods.isEquals((Object)infPagamentoPedido.getTipoPagamentoNFe().getCodigo(), (Object)"04")) && infPagamentoPedido.getDataFinanceiraCartao() != null) {
                dataBase = infPagamentoPedido.getDataFinanceiraCartao();
            }
            Double valorTotalNota = infPagamentoPedido.getValorLiquido();
            String obs = "Pedido: " + vo.getUnidadeFatCliente().getCliente().getPessoa().getNome();
            List titulos = null;
            Short provisao = 1;
            CondicoesPagamento cond = infPagamentoPedido.getCondicoesPagamento();
            String parcelas = infPagamentoPedido.getParcelas();
            if (cond == null) {
                cond = vo.getCondicoesPagamento();
                parcelas = vo.getCondPagMut();
            }
            Pessoa pessoa = vo.getUnidadeFatCliente().getCliente().getPessoa();
            PlanoConta pc = this.scPlanoConta.getPlanoConta(vo.getUnidadeFatCliente().getCliente(), opcoesCont);
            if (infPagamentoPedido.getMeioPagamento() != null && infPagamentoPedido.getMeioPagamento().getAlterarPessoaTitulo().equals((short)1)) {
                pessoa = infPagamentoPedido.getMeioPagamento().getPessoa();
                pc = infPagamentoPedido.getMeioPagamento().getPlanoConta();
            }
            titulos = cond.getCondMutante() != null && cond.getCondMutante() == 1 ? new AuxTitulos().getTitulosMutanteInternal(cond, pessoa, valorTotalNota, pc, vo.getPercComissao(), parcelas, EnumConstPessoa.CLIENTE.getEnumId(), (short)1, provisao, dataBase, obs, dataBase, dataBase, vo.getDataCadastro(), dataBase, vo.getEmpresa(), op, infPagamentoPedido.getMeioPagamento(), vo.getUnidadeFatCliente().getCliente().getClassificacaoClientes()) : new AuxTitulos().getTitulosNaoMutanteInternal(cond, pessoa, valorTotalNota, pc, vo.getPercComissao(), EnumConstPessoa.CLIENTE.getEnumId(), (short)1, provisao, dataBase, obs, dataBase, dataBase, vo.getDataCadastro(), dataBase, vo.getEmpresa(), op, infPagamentoPedido.getMeioPagamento(), vo.getUnidadeFatCliente().getCliente().getClassificacaoClientes());
            for (Titulo t : titulos) {
                t.setInfPagamentoPedido(infPagamentoPedido);
            }
            if (infPagamentoPedido.getTitulos() != null) {
                infPagamentoPedido.getTitulos().clear();
                infPagamentoPedido.getTitulos().addAll(titulos);
            } else {
                infPagamentoPedido.setTitulos(titulos);
            }
            if (infPagamentoPedido.getTipoPagamentoNFe() == null || !infPagamentoPedido.getTipoPagamentoNFe().getCodigo().equals("05")) continue;
            ClassificacaoClientes classificacaoClientes = vo.getUnidadeFatCliente().getCliente().getClassificacaoClientes();
            ItemParamCreditoLoja param = this.getParamCreditoLoja(vo.getEmpresa(), classificacaoClientes, dataBase);
            if (param == null) continue;
            int count = 0;
            for (Titulo t : infPagamentoPedido.getTitulos()) {
                Date dataVencimento = ToolDate.nextDays((Date)param.getDataVencimento(), (int)count);
                t.setDataVencimento(dataVencimento);
                count += 30;
            }
        }
        if (inf.getValorIcmsST() > 0.0) {
            this.gerarTituloSTGeracaoTituloPedido(geracaoTituloPedido, inf.getValorIcmsST(), op, opcoesCont);
        }
        ArrayList titulosAll = new ArrayList();
        for (InfPagamentoPedido infPag : vo.getInfPagamentoPedido()) {
            if (infPag.getMeioPagamento() != null && infPag.getMeioPagamento().getAlterarPessoaTitulo().equals((short)1)) {
                for (Titulo t : infPag.getTitulos()) {
                    t.setLoteAdLancamentos(this.getLoteAdicionalContabil(vo, t, infPag.getMeioPagamento(), opcoesCont));
                }
            }
            titulosAll.addAll(infPag.getTitulos());
        }
        CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentosCTBGerencial(vo.getItemPedido(), titulosAll, op.getEmpresa());
        this.calculaBCComissaoRepresentante(vo, op);
    }

    private LoteContabil getLoteAdicionalContabil(Pedido vo, Titulo t, MeioPagamento meioPagamento, OpcoesContabeis opcoesCont) throws ExceptionInvalidData {
        LoteContabil lote = this.helperLote.criaRecriaLoteContabil(t.getLoteAdLancamentos(), t.getDataCompetencia(), vo.getEmpresa(), ConstEnumOrigemLoteContabil.TITULO);
        Lancamento l = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)vo.getEmpresa());
        PlanoConta pc = null;
        pc = vo.getUnidadeFatCliente().getCliente().getPessoa().getContasPessoa() != null && vo.getUnidadeFatCliente().getCliente().getPessoa().getContasPessoa().getPlanoContaAntecAtivo() != null ? vo.getUnidadeFatCliente().getCliente().getPessoa().getContasPessoa().getPlanoContaAntecAtivo() : this.scPlanoConta.getPlanoConta(vo.getUnidadeFatCliente().getCliente(), opcoesCont);
        l.setPlanoContaCred(pc);
        l.setPlanoContaDeb(t.getPlanoConta());
        l.setGerado(Short.valueOf((short)0));
        l.setHistorico("Lancamento gerado pela transferencia de titulos do cliente: " + String.valueOf(vo.getUnidadeFatCliente()) + " para a conta do Meio de Pagamento: " + meioPagamento.getDescricao());
        l.setValor(t.getValor());
        l.setLoteContabil(lote);
        l.setDataLancamento(l.getLoteContabil().getDataLote());
        lote.getLancamentos().add(l);
        return lote;
    }

    private Double calculoDescontoSuframa(Pedido p) {
        Double descontoTotal = 0.0;
        Double percDescontoSuframa = this.getPercSuframaCliente(p.getUnidadeFatCliente());
        for (ItemPedido item : p.getItemPedido()) {
            if (!item.getProduto().getNaoAplicaSuframa().equals((short)0)) continue;
            descontoTotal = descontoTotal + item.getValorTotalBruto() * (percDescontoSuframa / 100.0);
            descontoTotal = ContatoFormatUtil.arrredondarNumero((Double)descontoTotal, (int)2);
        }
        descontoTotal = ContatoFormatUtil.arrredondarNumero((Double)descontoTotal, (int)2);
        return descontoTotal;
    }

    private double getPercSuframaCliente(UnidadeFatCliente vo) {
        double perc = 0.0;
        if (vo != null && vo.getCliente().getPessoa().getComplemento().getHabilitarSuframa() != null && vo.getCliente().getPessoa().getComplemento().getHabilitarSuframa() == 1) {
            perc = vo.getCliente().getFaturamento().getPercentualCofinsSufr() + vo.getCliente().getFaturamento().getPercentualIcmsSufr() + vo.getCliente().getFaturamento().getPercentualIpiSufr() + vo.getCliente().getFaturamento().getPercentualPisSufr();
        }
        return perc;
    }

    public void atualizarDatasEValoresPedidos(Pedido vo, OpcoesFinanceiras op, OpcoesFaturamento opFat, OpcoesContabeis opcoesCont) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        InfPagNF inf = this.getValorTotalPedido(vo);
        if (inf.getValorTotal() == 0.0) {
            return;
        }
        if (vo.getInfPagamentoPedido().isEmpty()) {
            vo.getInfPagamentoPedido().add(this.criarInfPagamentoPadrao(vo, op));
        }
        this.determinarValorInfPagamento(vo, inf, opFat);
        Date dataBase = vo.getDataPrevisaoSaida();
        if (vo.getTipoDataTitulo() != null && vo.getTipoDataTitulo() == 0) {
            dataBase = vo.getDataEmissao();
        }
        PlanoConta planoConta = this.scPlanoConta.getPlanoConta(vo.getUnidadeFatCliente().getCliente(), opcoesCont);
        for (InfPagamentoPedido infPagamentoPedido : vo.getInfPagamentoPedido()) {
            Double valorTotalNota = infPagamentoPedido.getValorLiquido();
            List titulosOld = infPagamentoPedido.getTitulos();
            String obs = "Pedido: " + vo.getUnidadeFatCliente().getCliente().getPessoa().getNome();
            List titulos = null;
            Short provisao = vo.getSituacaoPedido().getGerarFinanceiroNFCe();
            CondicoesPagamento cond = infPagamentoPedido.getCondicoesPagamento();
            String parcelas = infPagamentoPedido.getParcelas();
            if (cond == null) {
                cond = vo.getCondicoesPagamento();
                parcelas = vo.getCondPagMut();
            }
            titulos = cond.getCondMutante() != null && cond.getCondMutante() == 1 ? new AuxTitulos().getTitulosMutanteInternal(cond, vo.getUnidadeFatCliente().getCliente().getPessoa(), valorTotalNota, planoConta, vo.getPercComissao(), parcelas, EnumConstPessoa.CLIENTE.getEnumId(), (short)1, provisao, dataBase, obs, vo.getDataEmissao(), vo.getDataEmissao(), vo.getDataCadastro(), vo.getDataEmissao(), vo.getEmpresa(), op, infPagamentoPedido.getMeioPagamento(), vo.getUnidadeFatCliente().getCliente().getClassificacaoClientes()) : new AuxTitulos().getTitulosNaoMutanteInternal(cond, vo.getUnidadeFatCliente().getCliente().getPessoa(), valorTotalNota, planoConta, vo.getPercComissao(), EnumConstPessoa.CLIENTE.getEnumId(), (short)1, provisao, dataBase, obs, vo.getDataEmissao(), vo.getDataEmissao(), vo.getDataCadastro(), vo.getDataEmissao(), vo.getEmpresa(), op, infPagamentoPedido.getMeioPagamento(), vo.getUnidadeFatCliente().getCliente().getClassificacaoClientes());
            for (int i = 0; i < titulos.size(); ++i) {
                Titulo old = (Titulo)titulosOld.get(i);
                Titulo tNew = (Titulo)titulos.get(i);
                old.setValor(tNew.getValor());
                old.setValorMultaEmbutida(tNew.getValorMultaEmbutida());
                old.setValorJurosEmbutido(tNew.getValorJurosEmbutido());
                old.setPercMulta(tNew.getPercMulta());
                old.setPercJurosMes(tNew.getPercJurosMes());
                old.setDescontoFinanceiro(tNew.getDescontoFinanceiro());
                old.setValorAdicional(tNew.getValorAdicional());
                old.setDataEmissao(tNew.getDataEmissao());
                old.setDataVencimento(tNew.getDataVencimento());
                old.setDataVencimentoBase(tNew.getDataVencimentoBase());
                old.setDataCompetencia(tNew.getDataCompetencia());
                old.setDataEntradaSaida(tNew.getDataEntradaSaida());
                old.setDataCadastro(tNew.getDataCadastro());
                old.setValorDescontosEmbutido(tNew.getValorDescontosEmbutido());
                old.setValorTaxaCartao(tNew.getValorTaxaCartao());
            }
        }
    }

    public void atualizarDatasEValoresPedidosGeracaoTituloPedido(GeracaoTituloPedido geracao, OpcoesFinanceiras op, OpcoesFaturamento opFat, OpcoesContabeis opcoesCont) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        Pedido vo = geracao.getPedido();
        InfPagNF inf = this.getValorTotalGeracaoTituloPedido(vo);
        if (inf.getValorTotal() == 0.0) {
            return;
        }
        if (vo.getInfPagamentoPedido().isEmpty()) {
            vo.getInfPagamentoPedido().add(this.criarInfPagamentoPadrao(vo, op));
        }
        this.determinarValorInfPagamento(vo, inf, opFat);
        for (InfPagamentoPedido infPagamentoPedido : vo.getInfPagamentoPedido()) {
            Date dataBase = vo.getDataEmissao();
            if ((ToolMethods.isEquals((Object)infPagamentoPedido.getTipoPagamentoNFe().getCodigo(), (Object)"03") || ToolMethods.isEquals((Object)infPagamentoPedido.getTipoPagamentoNFe().getCodigo(), (Object)"04")) && infPagamentoPedido.getDataFinanceiraCartao() != null) {
                dataBase = infPagamentoPedido.getDataFinanceiraCartao();
            }
            Double valorTotalNota = infPagamentoPedido.getValorLiquido();
            List titulosOld = infPagamentoPedido.getTitulos();
            String obs = "Pedido: " + vo.getUnidadeFatCliente().getCliente().getPessoa().getNome();
            List titulos = null;
            Short provisao = 1;
            CondicoesPagamento cond = infPagamentoPedido.getCondicoesPagamento();
            String parcelas = infPagamentoPedido.getParcelas();
            if (cond == null) {
                cond = vo.getCondicoesPagamento();
                parcelas = vo.getCondPagMut();
            }
            PlanoConta planoConta = this.scPlanoConta.getPlanoConta(vo.getUnidadeFatCliente().getCliente(), opcoesCont);
            titulos = cond.getCondMutante() != null && cond.getCondMutante() == 1 ? new AuxTitulos().getTitulosMutanteInternal(cond, vo.getUnidadeFatCliente().getCliente().getPessoa(), valorTotalNota, planoConta, vo.getPercComissao(), parcelas, EnumConstPessoa.CLIENTE.getEnumId(), (short)1, provisao, dataBase, obs, dataBase, dataBase, vo.getDataCadastro(), dataBase, vo.getEmpresa(), op, infPagamentoPedido.getMeioPagamento(), vo.getUnidadeFatCliente().getCliente().getClassificacaoClientes()) : new AuxTitulos().getTitulosNaoMutanteInternal(cond, vo.getUnidadeFatCliente().getCliente().getPessoa(), valorTotalNota, planoConta, vo.getPercComissao(), EnumConstPessoa.CLIENTE.getEnumId(), (short)1, provisao, dataBase, obs, dataBase, dataBase, vo.getDataCadastro(), dataBase, vo.getEmpresa(), op, infPagamentoPedido.getMeioPagamento(), vo.getUnidadeFatCliente().getCliente().getClassificacaoClientes());
            for (int i = 0; i < titulos.size(); ++i) {
                Titulo old = (Titulo)titulosOld.get(i);
                Titulo tNew = (Titulo)titulos.get(i);
                old.setValor(tNew.getValor());
                old.setValorMultaEmbutida(tNew.getValorMultaEmbutida());
                old.setValorJurosEmbutido(tNew.getValorJurosEmbutido());
                old.setPercMulta(tNew.getPercMulta());
                old.setPercJurosMes(tNew.getPercJurosMes());
                old.setDescontoFinanceiro(tNew.getDescontoFinanceiro());
                old.setValorAdicional(tNew.getValorAdicional());
                old.setDataEmissao(tNew.getDataEmissao());
                old.setDataVencimento(tNew.getDataVencimento());
                old.setDataVencimentoBase(tNew.getDataVencimentoBase());
                old.setDataCompetencia(tNew.getDataCompetencia());
                old.setDataEntradaSaida(tNew.getDataEntradaSaida());
                old.setDataCadastro(tNew.getDataCadastro());
                old.setValorDescontosEmbutido(tNew.getValorDescontosEmbutido());
                old.setValorTaxaCartao(tNew.getValorTaxaCartao());
            }
        }
    }

    private ItemParamCreditoLoja getParamCreditoLoja(Empresa empresa, ClassificacaoClientes classificacaoClientes, Date dataEmissao) {
        if (classificacaoClientes != null) {
            ServiceParamCreditoLoja service = (ServiceParamCreditoLoja)ConfApplicationContext.getBean(ServiceParamCreditoLoja.class);
            return service.get(classificacaoClientes, empresa, dataEmissao);
        }
        return null;
    }

    public HashMap getValorTotalItemPedido(List itens, double percDescFinance) {
        HashMap<String, Double> h = new HashMap<String, Double>();
        Double valor = 0.0;
        Double valorIcmsSt = 0.0;
        Double valorParaBCComissaoTitulo = 0.0;
        for (Object o : itens) {
            ItemPedido i = (ItemPedido)o;
            if (i.getModeloFiscal().getGerarFinanceiro() != 1) continue;
            valor = valor + (i.getValorTotal() - i.getValorTotal() * (percDescFinance / 100.0));
            valorParaBCComissaoTitulo = valorParaBCComissaoTitulo + i.getValorTotal();
        }
        h.put("valorTotal", valor);
        h.put("valorICMSST", valorIcmsSt);
        h.put("valorParaBCComissaoTitulo", valorParaBCComissaoTitulo);
        return h;
    }

    public InfPagNF getValorTotalPedido(Pedido vo) {
        Double valorSemImposto = 0.0;
        Double valorComImposto = 0.0;
        Double valorIcmsSt = 0.0;
        Double valorIcmsDisp = 0.0;
        if (ToolMethods.isEquals((Object)vo.getSituacaoPedido().getGerarFinanceiroNFCe(), (Object)1)) {
            for (ItemPedido i : vo.getItemPedido()) {
                if (i.getModeloFiscal() == null || i.getModeloFiscal().getGerarFinanceiro() == 1) {
                    valorSemImposto = valorSemImposto + i.getValorTotal();
                }
                if (i.getModeloFiscal() == null) continue;
                if (ToolMethods.isEquals((Object)vo.getSituacaoPedido().getGerarFinanceiroNFCe(), (Object)1) && i.getModeloFiscal().getModeloFiscalIcms().getIcmsDispensadoDesconto() != null && i.getModeloFiscal().getModeloFiscalIcms().getIcmsDispensadoDesconto().equals((short)1) && i.getItemPedidoFiscal() != null) {
                    valorIcmsDisp = valorIcmsDisp + i.getItemPedidoFiscal().getVrICMSDispensado();
                }
                if (i.getModeloFiscal().getModeloFiscalIcms().getCalcularIcmsStCliente() == null || i.getModeloFiscal().getModeloFiscalIcms().getCalcularIcmsStCliente() == 1 || i.getItemPedidoFiscal() == null) continue;
                valorIcmsSt = valorIcmsSt + i.getItemPedidoFiscal().getVrIcmsSt();
            }
        } else {
            for (ItemPedido i : vo.getItemPedido()) {
                if (i.getModeloFiscal() != null && i.getModeloFiscal().getGerarFinanceiro() != 1) continue;
                if (i.getValorTotalComImpostos() == 0.0) {
                    valorSemImposto = valorSemImposto + i.getValorTotal();
                } else {
                    valorComImposto = valorComImposto + i.getValorTotalComImpostos();
                }
                if (i.getModeloFiscal() == null || i.getModeloFiscal().getModeloFiscalIcms().getCalcularIcmsStCliente() == null || i.getModeloFiscal().getModeloFiscalIcms().getCalcularIcmsStCliente() == 1 || i.getItemPedidoFiscal() == null) continue;
                valorIcmsSt = valorIcmsSt + i.getItemPedidoFiscal().getVrIcmsSt();
                valorComImposto = valorComImposto - i.getItemPedidoFiscal().getVrIcmsSt();
            }
        }
        if (valorSemImposto > 0.0 && vo.getPercDescFinanceiro() != null && vo.getPercDescFinanceiro() > 0.0) {
            valorSemImposto = valorSemImposto - valorSemImposto * (vo.getPercDescFinanceiro() / 100.0);
        }
        InfPagNF i = new InfPagNF();
        i.setValorTotal(valorSemImposto + valorComImposto);
        i.setValorIcmsST(valorIcmsSt);
        i.setValorIcmsDispensado(valorIcmsDisp);
        return i;
    }

    private InfPagNF getValorTotalGeracaoTituloPedido(Pedido vo) {
        Double valor = 0.0;
        Double valorIcmsSt = 0.0;
        for (ItemPedido i : vo.getItemPedido()) {
            if (i.getModeloFiscal() == null || i.getModeloFiscal().getGerarFinanceiro() == 1) {
                valor = valor + i.getValorTotalComImpostos();
            }
            if (i.getItemPedidoFiscal() == null || i.getModeloFiscal().getModeloFiscalIcms().getCalcularIcmsStCliente() == null || i.getModeloFiscal().getModeloFiscalIcms().getCalcularIcmsStCliente() == 1) continue;
            valorIcmsSt = valorIcmsSt + (i.getItemPedidoFiscal().getVrIcmsSt() + i.getItemPedidoFiscal().getValorFCPSt());
        }
        if (vo.getPercDescFinanceiro() != null && vo.getPercDescFinanceiro() > 0.0) {
            valor = valor - valor * (vo.getPercDescFinanceiro() / 100.0);
        }
        InfPagNF i = new InfPagNF();
        valor = valor - (0.0 + valorIcmsSt);
        i.setValorTotal(valor);
        i.setValorIcmsST(valorIcmsSt);
        return i;
    }

    void validarValoresTitulos(Pedido vo) throws ExceptionValidation {
        InfPagNF inf = this.getValorTotalPedido(vo);
        Double valorTotalNota = inf.getValorTotal() + inf.getValorIcmsST();
        Double valorTitulos = 0.0;
        for (InfPagamentoPedido infPag : vo.getInfPagamentoPedido()) {
            for (Titulo t : infPag.getTitulos()) {
                if (ToolMethods.isEquals((Object)t.getProvisao(), (Object)1)) {
                    return;
                }
                valorTitulos = valorTitulos + t.getValor();
            }
        }
        BigDecimal bd = new BigDecimal(valorTitulos);
        bd = bd.setScale(2, 5);
        valorTitulos = bd.doubleValue();
        bd = new BigDecimal(valorTotalNota);
        bd = bd.setScale(2, 5);
        valorTotalNota = bd.doubleValue();
        Double diferenca = valorTitulos - valorTotalNota;
        if ((diferenca = ContatoFormatUtil.arrredondarNumero((Double)diferenca, (int)2)) > 0.2 || diferenca < -0.2) {
            throw new ExceptionValidation("Existe uma diferen\u00e7a entre o valor total do pedido e dos t\u00edtulos. " + ContatoFormatUtil.formataNumero((Number)diferenca, (int)2));
        }
    }

    private InfPagamentoPedido criarInfPagamentoPadrao(Pedido vo, OpcoesFinanceiras op) {
        InfPagamentoPedido i = new InfPagamentoPedido();
        i.setCondicoesPagamento(vo.getCondicoesPagamento());
        i.setParcelas(vo.getCondPagMut());
        if (vo.getMeioPagamento() != null) {
            i.setMeioPagamento(vo.getMeioPagamento());
        } else if (vo.getCondicoesPagamento() != null && vo.getCondicoesPagamento().getMeioPagamento() != null) {
            i.setMeioPagamento(vo.getCondicoesPagamento().getMeioPagamento());
        } else if (op.getMeioPagamento() != null) {
            i.setMeioPagamento(op.getMeioPagamento());
        }
        if (i.getMeioPagamento() != null && i.getMeioPagamento().getTipoPagamentoNFe() != null) {
            i.setTipoPagamentoNFe(i.getMeioPagamento().getTipoPagamentoNFe());
        }
        i.setPedido(vo);
        return i;
    }

    private void determinarValorInfPagamento(Pedido vo, InfPagNF i, OpcoesFaturamento opFat) {
        Double valorTotal = i.getValorTotal() - i.getValorIcmsSTDev() - i.getValorImpostoRetido() - i.getValorIcmsDispensado();
        int cont = vo.getInfPagamentoPedido().size();
        int contValorMaiorZero = 0;
        double somaValorMaiorZero = 0.0;
        if (cont <= 1) {
            for (InfPagamentoPedido pag : vo.getInfPagamentoPedido()) {
                if (!(pag.getValor() > 0.0)) continue;
                somaValorMaiorZero += pag.getValor().doubleValue();
                ++contValorMaiorZero;
            }
            valorTotal = valorTotal - somaValorMaiorZero;
            cont -= contValorMaiorZero;
            for (InfPagamentoPedido pag : vo.getInfPagamentoPedido()) {
                if ((pag.getValor() == 0.0 || pag.getValor() < 0.0) && cont > 0) {
                    pag.setValor(Double.valueOf(valorTotal / (double)cont));
                }
                if (!(pag.getValor() > 0.0) || cont != 0) continue;
                pag.setValor(Double.valueOf(pag.getValor() + valorTotal));
            }
        }
        for (InfPagamentoPedido pag : vo.getInfPagamentoPedido()) {
            pag.setValorLiquido(pag.getValor());
        }
        if (opFat != null && ToolMethods.isEquals((Object)opFat.getAplicarMajoracaoPrecoFechamentoPedido(), (Object)1)) {
            for (InfPagamentoPedido inf : vo.getInfPagamentoPedido()) {
                Double valorLiquido = ToolFormatter.arrredondarNumero((Double)CoreUtilityFactory.getUtilityCondicoesPagamento().calcularValorTotalMajorado(inf.getValor(), inf.getCondicoesPagamento(), inf.getParcelas()), (int)2);
                Double valorBruto = ToolFormatter.arrredondarNumero((Double)inf.getValor(), (int)2);
                inf.setValorLiquido(valorLiquido);
                inf.setValor(valorBruto);
                inf.setValorAcrescimo(Double.valueOf(valorLiquido - valorBruto));
            }
        }
    }

    public void calculaBCComissaoRepresentante(Pedido vo, OpcoesFinanceiras op) {
        HelperTitulos helper = (HelperTitulos)Context.get(HelperTitulos.class);
        helper.atualizaTitulosRep(vo, op);
    }

    private void gerarTituloSTGeracaoTituloPedido(GeracaoTituloPedido geracao, Double valorST, OpcoesFinanceiras op, OpcoesContabeis opcoesCont) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        if (geracao.getDataTituloST() == null) {
            throw new ExceptionGeracaoTitulos("Informe a data para o t\u00edtulo de Icms ST!");
        }
        if (geracao.getCondicaoPagamentoST() == null) {
            throw new ExceptionGeracaoTitulos("Informe a condi\u00e7\u00e3o de pagamento para o t\u00edtulo de Icms ST!");
        }
        Pedido vo = geracao.getPedido();
        InfPagamentoPedido infPagST = this.getInfPagamentoST(geracao, vo, valorST);
        Pessoa pessoa = vo.getUnidadeFatCliente().getCliente().getPessoa();
        PlanoConta pc = this.scPlanoConta.getPlanoConta(vo.getUnidadeFatCliente().getCliente(), opcoesCont);
        if (infPagST.getMeioPagamento() != null && infPagST.getMeioPagamento().getAlterarPessoaTitulo().equals((short)1)) {
            pessoa = infPagST.getMeioPagamento().getPessoa();
            pc = infPagST.getMeioPagamento().getPlanoConta();
        }
        String obs = "Titulo relativo ao ICMS ST do pedido: " + vo.getIdentificador() + " de" + vo.getUnidadeFatCliente().getCliente().getPessoa().getNome();
        List titulos = null;
        Short provisao = 1;
        CondicoesPagamento cond = infPagST.getCondicoesPagamento();
        String parcelas = "1;";
        titulos = cond.getCondMutante() != null && cond.getCondMutante() == 1 ? new AuxTitulos().getTitulosMutanteInternal(cond, pessoa, valorST, pc, vo.getPercComissao(), parcelas, EnumConstPessoa.CLIENTE.getEnumId(), (short)1, provisao, geracao.getDataTituloST(), obs, geracao.getDataTituloST(), geracao.getDataTituloST(), new Date(), geracao.getDataTituloST(), vo.getEmpresa(), op, infPagST.getMeioPagamento(), vo.getUnidadeFatCliente().getCliente().getClassificacaoClientes()) : new AuxTitulos().getTitulosNaoMutanteInternal(cond, pessoa, valorST, pc, vo.getPercComissao(), EnumConstPessoa.CLIENTE.getEnumId(), (short)1, provisao, geracao.getDataTituloST(), obs, geracao.getDataTituloST(), geracao.getDataTituloST(), new Date(), geracao.getDataTituloST(), vo.getEmpresa(), op, infPagST.getMeioPagamento(), vo.getUnidadeFatCliente().getCliente().getClassificacaoClientes());
        for (Titulo t : titulos) {
            t.setInfPagamentoPedido(infPagST);
        }
        if (infPagST.getTitulos() != null) {
            infPagST.getTitulos().clear();
            infPagST.getTitulos().addAll(titulos);
        } else {
            infPagST.setTitulos(titulos);
        }
    }

    private InfPagamentoPedido getInfPagamentoST(GeracaoTituloPedido geracao, Pedido vo, Double valorST) {
        InfPagamentoPedido infPagST = null;
        Boolean achou = false;
        for (InfPagamentoPedido infPag : vo.getInfPagamentoPedido()) {
            if (!ToolMethods.isEquals((Object)infPag.getTipoPagST(), (Object)1)) continue;
            infPagST = infPag;
            achou = true;
            break;
        }
        if (!achou.booleanValue()) {
            infPagST = new InfPagamentoPedido();
            infPagST.setNaoGerarComissao(Short.valueOf((short)1));
            infPagST.setTipoPagST(Short.valueOf((short)1));
            vo.getInfPagamentoPedido().add(infPagST);
        }
        infPagST.setCondicoesPagamento(geracao.getCondicaoPagamentoST());
        if (infPagST.getCondicoesPagamento().getMeioPagamento() != null) {
            infPagST.setMeioPagamento(infPagST.getCondicoesPagamento().getMeioPagamento());
            infPagST.setTipoPagamentoNFe(infPagST.getCondicoesPagamento().getMeioPagamento().getTipoPagamentoNFe());
        }
        infPagST.setValor(valorST);
        infPagST.setValorLiquido(valorST);
        infPagST.setPedido(vo);
        return infPagST;
    }

    private void atualizarInfPagPedido(Pedido vo) {
        for (Object object : vo.getInfPagamentoPedido()) {
            Double valorTotal = 0.0;
            InfPagamentoPedido inf = (InfPagamentoPedido)object;
            for (Titulo titulo : inf.getTitulos()) {
                valorTotal = valorTotal + titulo.getValor();
                valorTotal = ContatoFormatUtil.arrredondarNumero((Double)valorTotal, (int)2);
            }
            inf.setValorLiquido(valorTotal);
        }
    }
}

