/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.titulos;

import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.PedComercioFormasPag;
import com.touchcomp.basementor.model.vo.PedidoComercio;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TituloRepresentante;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfinanceiras.HelperOpcoesFinanceiras;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import java.util.ArrayList;
import java.util.List;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.titulos.AuxTitulos;

class AuxPedidoComercio {
    private final SCompPlanoConta scPlanoConta = (SCompPlanoConta)ConfApplicationContext.getBean(SCompPlanoConta.class);

    AuxPedidoComercio() {
    }

    public List criarTitulosUnicaForma(PedidoComercio vo, PlanoContaGerencial pcAcrescimo, PlanoContaGerencial pcDesconto, OpcoesFinanceiras op, OpcoesContabeis opcoes) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        List<Titulo> titulos = new ArrayList();
        Pessoa pessoa = vo.getCliente();
        short tipoPessoa = EnumConstPessoa.CLIENTE.getEnumId();
        ClassificacaoClientes classificacaoPessoa = null;
        if (vo.getClientePedido() != null) {
            classificacaoPessoa = vo.getClientePedido().getClassificacaoClientes();
        }
        double valorTotalNota = vo.getValorTotal();
        String obs = "Pedido Comercio: " + vo.getIdentificador().toString();
        if (vo.getPessoaAutorizada() != null) {
            obs = obs + " Pessoa Autorizada: " + vo.getPessoaAutorizada().toString();
        }
        obs = obs + " Parcelas: ";
        CondicoesPagamento cond = ((PedComercioFormasPag)vo.getFechamentoPedidoComercio().getFormasPagCupomFiscal().get(0)).getFormasPagCupomFiscal().getCondicoesPagamento();
        PlanoConta planoConta = this.scPlanoConta.getPlanoConta(vo.getClientePedido(), opcoes);
        titulos = cond.getCondMutante() != null && cond.getCondMutante() == 1 ? new AuxTitulos().getTitulosMutanteInternal(cond, pessoa, valorTotalNota, planoConta, 0.0, cond.getParcelasMutante(), tipoPessoa, (short)1, (short)1, vo.getDataEmissao(), obs, vo.getDataEmissao(), vo.getDataEmissao(), vo.getDataCadastro(), vo.getDataEmissao(), vo.getEmpresa(), op, op.getMeioPagamento(), classificacaoPessoa) : new AuxTitulos().getTitulosNaoMutanteInternal(cond, pessoa, valorTotalNota, planoConta, 0.0, tipoPessoa, (short)1, (short)1, vo.getDataEmissao(), obs, vo.getDataEmissao(), vo.getDataEmissao(), vo.getDataCadastro(), vo.getDataEmissao(), vo.getEmpresa(), op, op.getMeioPagamento(), classificacaoPessoa);
        int i = 1;
        for (Titulo t : titulos) {
            t.setPedidoComercio(vo);
            t.setTipoDoc(op.getTipoDocFinanceiro());
            t.setCarteiraCobranca(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(op).getCarteiraCobranca(t.getPagRec().shortValue()));
            t.setNumParcTituloEstnota(Short.valueOf((short)i));
            TituloRepresentante tr = new TituloRepresentante();
            tr.setPercComissao(vo.getPercComissaoMedio());
            tr.setRepresentante(vo.getRepresentante());
            tr.setTitulo(t);
            tr.setVrBCComissao(t.getValor());
            ArrayList<TituloRepresentante> tit = new ArrayList<TituloRepresentante>();
            tit.add(tr);
            t.setRepresentantes(tit);
            ++i;
        }
        CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentosCTBGerencial(vo, titulos, pcAcrescimo, pcDesconto);
        return titulos;
    }

    public List criarTitulos(PedidoComercio vo, PlanoContaGerencial pcAcrescimo, PlanoContaGerencial pcDesconto, OpcoesFinanceiras op, OpcoesContabeis opcoes) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        ArrayList<Titulo> titulos = new ArrayList<Titulo>();
        Pessoa pessoa = vo.getCliente();
        short tipoPessoa = EnumConstPessoa.CLIENTE.getEnumId();
        ClassificacaoClientes classificacaoPessoa = null;
        if (vo.getClientePedido() != null) {
            classificacaoPessoa = vo.getClientePedido().getClassificacaoClientes();
        }
        String obs = "Pedido Comercio: " + vo.getIdentificador().toString();
        if (vo.getPessoaAutorizada() != null) {
            obs = obs + " Pessoa Autorizada: " + vo.getPessoaAutorizada().toString();
        }
        obs = obs + " Parcelas: ";
        PlanoConta planoConta = this.scPlanoConta.getPlanoConta(vo.getClientePedido(), opcoes);
        for (PedComercioFormasPag formas : vo.getFechamentoPedidoComercio().getFormasPagCupomFiscal()) {
            CondicoesPagamento cond = formas.getFormasPagCupomFiscal().getCondicoesPagamento();
            if (formas.getFormasPagCupomFiscal().getCondicoesPagamento().getCondMutante() != null && formas.getFormasPagCupomFiscal().getCondicoesPagamento().getCondMutante() == 1) {
                titulos.addAll(new AuxTitulos().getTitulosMutanteInternal(formas.getFormasPagCupomFiscal().getCondicoesPagamento(), pessoa, formas.getValor(), planoConta, 0.0, cond.getParcelasMutante(), tipoPessoa, (short)1, (short)1, vo.getDataEmissao(), obs, vo.getDataEmissao(), vo.getDataEmissao(), vo.getDataCadastro(), vo.getDataEmissao(), vo.getEmpresa(), op, op.getMeioPagamento(), classificacaoPessoa));
                continue;
            }
            titulos.addAll(new AuxTitulos().getTitulosNaoMutanteInternal(cond, pessoa, formas.getValor(), planoConta, 0.0, tipoPessoa, (short)1, (short)1, vo.getDataEmissao(), obs, vo.getDataEmissao(), vo.getDataEmissao(), vo.getDataCadastro(), vo.getDataEmissao(), vo.getEmpresa(), op, op.getMeioPagamento(), classificacaoPessoa));
        }
        int i = 1;
        for (Titulo t : titulos) {
            t.setPedidoComercio(vo);
            t.setTipoDoc(op.getTipoDocFinanceiro());
            t.setCarteiraCobranca(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(op).getCarteiraCobranca(t.getPagRec().shortValue()));
            t.setNumParcTituloEstnota(Short.valueOf((short)i));
            TituloRepresentante tr = new TituloRepresentante();
            tr.setPercComissao(vo.getPercComissaoMedio());
            tr.setRepresentante(vo.getRepresentante());
            tr.setTitulo(t);
            tr.setVrBCComissao(t.getValor());
            ArrayList<TituloRepresentante> tit = new ArrayList<TituloRepresentante>();
            tit.add(tr);
            t.setRepresentantes(tit);
            ++i;
        }
        CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentosCTBGerencial(vo, titulos, pcAcrescimo, pcDesconto);
        return titulos;
    }
}

