/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.titulos;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorEntSaida;
import com.touchcomp.basementor.constants.enums.opcoeslocacao.EnumGerTituloApuracao;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.vo.ApuracaoLocacaoContratoBem;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesLocacao;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfinanceiras.HelperOpcoesFinanceiras;
import com.touchcomp.basementorspringcontext.Context;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.tools.ContatoFormatUtil;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.titulos.AuxTitulos;

class AuxRPS {
    AuxRPS() {
    }

    public List criarTitulos(Rps vo, OpcoesFinanceiras op, Date dataVencimento, OpcoesLocacao opcoesLocacao) throws ExceptionGeracaoTitulos {
        List titulos;
        block11: {
            block10: {
                PlanoConta pc;
                short tipoTitulo;
                titulos = new ArrayList();
                if (vo.getGerarFinanceiro() != 1) {
                    return titulos;
                }
                Pessoa pessoa = vo.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPessoa();
                short tipoPessoa = EnumConstPessoa.PESSOA.getEnumId();
                if (vo.getEntradaSaida().shortValue() == EnumConstantsMentorEntSaida.ENTRADA.getValue()) {
                    tipoTitulo = 0;
                    pc = vo.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPlanoContaFornecedor();
                } else {
                    tipoTitulo = 1;
                    pc = vo.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPlanoContaCliente();
                }
                double valorTotalNota = vo.getValorLiquidoNfse();
                String obs = "RPS/NFSe: " + vo.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPessoa().getNome();
                MeioPagamento meio = vo.getMeioPagamento();
                if (meio == null && vo.getCondicoesPagamento() != null && vo.getCondicoesPagamento().getMeioPagamento() != null) {
                    meio = vo.getCondicoesPagamento().getMeioPagamento();
                }
                if (meio == null) {
                    meio = op.getMeioPagamento();
                }
                titulos = vo.getCondicoesPagamento().getCondMutante() != null && vo.getCondicoesPagamento().getCondMutante() == 1 ? new AuxTitulos().getTitulosMutanteInternal(vo.getCondicoesPagamento(), pessoa, valorTotalNota, pc, 0.0, vo.getParcelas(), tipoPessoa, tipoTitulo, (short)1, dataVencimento != null ? dataVencimento : vo.getDataEmissao(), obs, vo.getDataEmissao(), vo.getDataEmissao(), vo.getDataCadastro(), vo.getDataEmissao(), vo.getEmpresa(), op, meio, vo.getClassificacaoPessoas()) : new AuxTitulos().getTitulosNaoMutanteInternal(vo.getCondicoesPagamento(), pessoa, valorTotalNota, pc, 0.0, tipoPessoa, tipoTitulo, (short)1, dataVencimento != null ? dataVencimento : vo.getDataEmissao(), obs, vo.getDataEmissao(), vo.getDataEmissao(), vo.getDataCadastro(), vo.getDataEmissao(), vo.getEmpresa(), op, meio, vo.getClassificacaoPessoas());
                if (opcoesLocacao == null || opcoesLocacao.getTipoCentroCustoLancGerencial() == null || !opcoesLocacao.getTipoCentroCustoLancGerencial().equals(EnumGerTituloApuracao.CENTRO_CUSTO_ATIVO.getValue())) break block10;
                if (vo.getApuracaoContratoLocacao() == null || vo.getApuracaoContratoLocacao().getContratoLocacao() == null) break block11;
                Double valorApurContratos = 0.0;
                for (ApuracaoLocacaoContratoBem a : vo.getApuracaoContratoLocacao().getApuracaoLocacaoContratoBem()) {
                    valorApurContratos = valorApurContratos + a.getValorTotal();
                }
                Double perc = ContatoFormatUtil.arrredondarNumero(valorTotalNota * 100.0 / valorApurContratos, 4);
                for (Titulo t : titulos) {
                    Double valorAcumLanc = 0.0;
                    t.setRps(vo);
                    t.setTipoDoc(op.getTipoDocFinanceiro());
                    t.setCarteiraCobranca(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(op).getCarteiraCobranca(t.getPagRec().shortValue()));
                    int qtdeBens = vo.getApuracaoContratoLocacao().getApuracaoLocacaoContratoBem().size();
                    int qtdeAux = 0;
                    for (ApuracaoLocacaoContratoBem a : vo.getApuracaoContratoLocacao().getApuracaoLocacaoContratoBem()) {
                        Double valor = ContatoFormatUtil.arrredondarNumero(a.getValorTotal() * perc / 100.0 / (double)titulos.size(), 2);
                        if (++qtdeAux == qtdeBens) {
                            Double diferenca = valor + valorAcumLanc - t.getValor();
                            valor = valor - diferenca;
                        }
                        t.getLancCtbGerencial().addAll(CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentosCTBGerencial(vo, t, valor, a.getContratoLocacaoBem().getAtivo().getContaGerencial(), a.getContratoLocacaoBem().getAtivo().getCentroCusto()));
                        valorAcumLanc = valorAcumLanc + valor;
                    }
                }
                break block11;
            }
            for (Titulo t : titulos) {
                t.setRps(vo);
                t.setTipoDoc(op.getTipoDocFinanceiro());
                t.setCarteiraCobranca(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(op).getCarteiraCobranca(t.getPagRec().shortValue()));
                t.setLancCtbGerencial(CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentosCTBGerencial(vo, t, t.getValor(), vo.getServicoRPS().getPlanoContaGerencial(), vo.getServicoRPS().getCentroCusto()));
            }
        }
        return titulos;
    }
}

