/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.titulos;

import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesFinanceirasTaxas;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.RenegociacaoTitulos;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TituloRepresentante;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.helpers.impl.lotecontabil.HelperLoteContabil;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoDateUtil;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.titulos.AuxTitulos;

public class AuxRenegociacaoTitulos {
    private final HelperLoteContabil helperLote = (HelperLoteContabil)Context.get(HelperLoteContabil.class);
    private static final TLogger logger = TLogger.get(AuxRenegociacaoTitulos.class);

    public List criarTitulos(RenegociacaoTitulos vo, OpcoesFinanceiras op, List<Titulo> listTitulos, EmpresaContabilidade empresaContabilidade, Pessoa pessoaNovoTitulo, PlanoConta planoContaNovoTitulo) throws ExceptionGeracaoTitulos {
        ArrayList<Titulo> titulos = new ArrayList<Titulo>();
        Titulo titulo = listTitulos.get(0);
        Short nrParcela = 1;
        Double valorDesconto = 0.0;
        Double valorMultaEmbutida = 0.0;
        Double valorJurosEmbutido = 0.0;
        Double valorAdicional = 0.0;
        Double valorDescontoEmbutido = vo.getValorDescontosEmbutido();
        Double saldoTituloRateado = ContatoFormatUtil.arrredondarNumero((Double)((this.getSaldoTitulo(listTitulos) + vo.getJurosEmbutidos() + vo.getMultaEmbutida() + vo.getValorAdicional()) / (double)vo.getNrParcelas().intValue()), (int)2);
        PlanoContaGerencial planoContaGerencial = this.getPlanoContaGerencial(empresaContabilidade, vo);
        if (planoContaGerencial == null) {
            throw new ExceptionGeracaoTitulos("Primeiro, cadastre o Plano de Contas Gerencial para Renegocia\u00e7\u00e3o de Recebimento e Pagamento em Empresa Contabilidade!");
        }
        Date lastDate = vo.getDataEmissao();
        Double valorTitulo = 0.0;
        for (int i = 0; i < vo.getNrParcelas(); ++i) {
            Date dataVencimento;
            Date dataCompetencia;
            Date dataEmissao;
            if (vo.getVariarDtCompVenc().equals((short)0)) {
                dataEmissao = vo.getDataEmissao();
                dataCompetencia = vo.getDataCompetencia();
                if (i == 0) {
                    dataVencimento = vo.getDataVencInicial();
                    lastDate = vo.getDataVencInicial();
                } else if (vo.getGerarDataFixa().equals((short)1)) {
                    dataVencimento = dt = ContatoDateUtil.nextDateInNextMonth((Date)lastDate, (Date)vo.getDataVencInicial());
                    lastDate = dt;
                } else {
                    dataVencimento = ContatoDateUtil.nextPreviousDays((Date)vo.getDataVencInicial(), (int)(i * vo.getDiasEntreParcelas()));
                }
            } else {
                dataEmissao = ContatoDateUtil.nextDateInNextMonth((Date)lastDate, (Date)vo.getDataEmissao());
                dataCompetencia = ContatoDateUtil.nextDateInNextMonth((Date)lastDate, (Date)vo.getDataCompetencia());
                if (i == 0) {
                    dataVencimento = vo.getDataVencInicial();
                    dataCompetencia = vo.getDataCompetencia();
                    dataEmissao = vo.getDataEmissao();
                } else if (vo.getGerarDataFixa().equals((short)1)) {
                    dt = ContatoDateUtil.nextDateInNextMonth((Date)lastDate, (Date)vo.getDataEmissao());
                    dataVencimento = DateUtil.nextMonth(vo.getDataVencInicial(), i);
                    lastDate = dt;
                } else {
                    dataVencimento = ContatoDateUtil.nextPreviousDays((Date)vo.getDataVencInicial(), (int)(i * vo.getDiasEntreParcelas()));
                    dataCompetencia = ContatoDateUtil.nextPreviousDays((Date)vo.getDataCompetencia(), (int)(i * vo.getDiasEntreParcelas()));
                    dataEmissao = ContatoDateUtil.nextPreviousDays((Date)vo.getDataEmissao(), (int)(i * vo.getDiasEntreParcelas()));
                }
            }
            valorTitulo = nrParcela.equals(vo.getNrParcelas().shortValue()) && vo.getNrParcelas() > 1 ? this.getValorUltimaParcela(listTitulos, vo, saldoTituloRateado) : saldoTituloRateado;
            valorTitulo = valorTitulo - valorDescontoEmbutido;
            if (nrParcela.equals(vo.getNrParcelas().shortValue()) && vo.getNrParcelas() > 1) {
                valorAdicional = this.getValorAdicionalUltimaParcela(titulos, vo);
                valorDesconto = this.getValorDescontUltimaParcela(titulos, vo);
                valorMultaEmbutida = this.getValorMultaEmbutida(titulos, vo);
                valorJurosEmbutido = this.getValorJurosEmbutida(titulos, vo);
            } else {
                valorAdicional = ContatoFormatUtil.arrredondarNumero((Double)(vo.getValorAdicional() / (double)vo.getNrParcelas().intValue()), (int)2);
                valorDesconto = ContatoFormatUtil.arrredondarNumero((Double)(vo.getDesconto() / (double)vo.getNrParcelas().intValue()), (int)2);
                valorMultaEmbutida = ContatoFormatUtil.arrredondarNumero((Double)(vo.getMultaEmbutida() / (double)vo.getNrParcelas().intValue()), (int)2);
                valorJurosEmbutido = ContatoFormatUtil.arrredondarNumero((Double)(vo.getJurosEmbutidos() / (double)vo.getNrParcelas().intValue()), (int)2);
            }
            Titulo t = new AuxTitulos().newTitulo(pessoaNovoTitulo, planoContaNovoTitulo, EnumConstPessoa.PESSOA.getEnumId(), titulo.getPagRec(), titulo.getProvisao(), dataVencimento, vo.getObservacao(), dataEmissao, dataEmissao, new Date(), dataCompetencia, titulo.getEmpresa(), op, nrParcela, vo.getNrParcelas(), valorTitulo, vo.getMulta(), valorMultaEmbutida, vo.getJuros(), valorJurosEmbutido, valorAdicional, valorDesconto, vo.getMeioPagamento(), vo.getValorDescontosEmbutido(), null, titulo.getClassificacaoPessoa());
            t.setRepresentantes(this.getTitulosRepresentante(listTitulos, vo, nrParcela, t));
            t.setRenegociacaoTitulos(vo);
            t.setTipoDoc(vo.getTipoDoc());
            t.setCarteiraCobranca(vo.getCarteiraCobranca());
            Short s = nrParcela;
            nrParcela = (short)(nrParcela + 1);
            titulos.add(t);
        }
        this.aglutinarComissaoReprsentante(titulos);
        this.setarPercJuros(titulos, op);
        CoreUtilityFactory.getUtilityLancamentosGerenciais().criaLancamentoCtbGerencialRenegociacaoTitulos(listTitulos, titulos, vo, planoContaGerencial);
        this.atualizarTitulosPorMeioPagamento(titulos, vo, listTitulos.get(0).getPlanoConta());
        return titulos;
    }

    private void atualizarTitulosPorMeioPagamento(List<Titulo> titulos, RenegociacaoTitulos vo, PlanoConta planoContaCred) {
        for (Titulo t : titulos) {
            if (!ToolMethods.isEquals((Object)t.getMeioPagamento().getAlterarPessoaTitulo(), (Object)1)) continue;
            t.setLoteAdLancamentos(this.getLoteAdicionalContabil(vo, t, planoContaCred));
        }
    }

    private LoteContabil getLoteAdicionalContabil(RenegociacaoTitulos vo, Titulo t, PlanoConta planoContaCred) {
        LoteContabil lote = this.helperLote.criaRecriaLoteContabil(t.getLoteAdLancamentos(), t.getDataCompetencia(), vo.getEmpresa(), ConstEnumOrigemLoteContabil.RENEGOCIACAO_TITULOS);
        Lancamento l = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)vo.getEmpresa());
        l.setPlanoContaCred(planoContaCred);
        l.setPlanoContaDeb(t.getPlanoConta());
        l.setGerado(Short.valueOf((short)0));
        l.setHistorico("Lancamento gerado pela transferencia de titulos pela renegocia\u00e7\u00e3o: " + planoContaCred.getDescricao() + " para a conta " + String.valueOf(t.getMeioPagamento().getPessoa()) + ".");
        l.setValor(t.getValor());
        lote.getLancamentos().add(l);
        return lote;
    }

    private Double getVrBCComissao(TituloRepresentante t, Double vrBCComissao, RenegociacaoTitulos vo) {
        Double valor = 0.0;
        valor = t.getVrBCComissao() - vrBCComissao * (double)(vo.getNrParcelas() - 1);
        return ContatoFormatUtil.arrredondarNumero((Double)valor, (int)2);
    }

    private void setarPercJuros(List titulos, OpcoesFinanceiras op) {
        for (Object titulo : titulos) {
            Titulo t = (Titulo)titulo;
            this.setarPercJurosMultaDesconto(t, op);
        }
    }

    private Double getSaldoTitulo(List<Titulo> listTitulos) {
        Double valorSaldo = 0.0;
        for (Titulo t : listTitulos) {
            valorSaldo = valorSaldo + t.getValorSaldo();
        }
        return valorSaldo;
    }

    private Double getValorUltimaParcela(List<Titulo> listTitulos, RenegociacaoTitulos vo, Double valorRateado) {
        Double valor = 0.0;
        valor = this.getSaldoTitulo(listTitulos) + vo.getJurosEmbutidos() + vo.getMultaEmbutida() + vo.getValorAdicional() - valorRateado * (double)(vo.getNrParcelas() - 1);
        return ContatoFormatUtil.arrredondarNumero((Double)valor, (int)2);
    }

    private List<TituloRepresentante> getTitulosRepresentante(List<Titulo> listTitulos, RenegociacaoTitulos vo, Short nrParcela, Titulo titulo) {
        Double percComissao;
        Double vrBCComissao;
        ArrayList<TituloRepresentante> titulosRepresentante = new ArrayList<TituloRepresentante>();
        ArrayList<TituloRepresentante> newtitulosRepresentantes = new ArrayList<TituloRepresentante>();
        ArrayList<Representante> representantesOld = new ArrayList<Representante>();
        for (Titulo tit : listTitulos) {
            if (tit.getRepresentantes() == null || tit.getRepresentantes().isEmpty()) continue;
            for (TituloRepresentante r : tit.getRepresentantes()) {
                titulosRepresentante.add(r);
                if (representantesOld.contains(r.getRepresentante())) continue;
                representantesOld.add(r.getRepresentante());
            }
        }
        for (Representante rep : representantesOld) {
            vrBCComissao = 0.0;
            percComissao = 0.0;
            for (TituloRepresentante titRep : titulosRepresentante) {
                if (!rep.equals((Object)titRep.getRepresentante()) || this.existsApauracaoComissaoRepresentante(titRep)) continue;
                Double saldo = titRep.getTitulo().getValorSaldo();
                Double valorTitulo = titRep.getTitulo().getValor();
                Double percSaldo = saldo * 100.0 / valorTitulo;
                percComissao = titRep.getPercComissao() != null ? titRep.getPercComissao() : 0.0;
                vrBCComissao = titRep.getVrBCComissao() != null ? titRep.getVrBCComissao() * percSaldo / 100.0 : 0.0;
                TituloRepresentante newTitRep = new TituloRepresentante();
                newTitRep.setRepresentante(rep);
                newTitRep.setTitulo(titulo);
                newTitRep.setPercComissao(percComissao);
                newTitRep.setVrBCComissao(vrBCComissao);
                newtitulosRepresentantes.add(newTitRep);
            }
        }
        for (TituloRepresentante t : newtitulosRepresentantes) {
            vrBCComissao = t.getVrBCComissao();
            percComissao = t.getPercComissao();
            vrBCComissao = ContatoFormatUtil.arrredondarNumero((Double)(vrBCComissao / (double)vo.getNrParcelas().intValue()), (int)2);
            if (nrParcela.equals(vo.getNrParcelas().shortValue()) && vo.getNrParcelas() > 1) {
                t.setVrBCComissao(this.getVrBCComissao(t, vrBCComissao, vo));
                continue;
            }
            t.setVrBCComissao(vrBCComissao);
            t.setPercComissao(percComissao);
        }
        return newtitulosRepresentantes;
    }

    private void aglutinarComissaoReprsentante(List<Titulo> titulos) {
        for (Titulo t : titulos) {
            ArrayList<TituloRepresentante> novosTitulos = new ArrayList<TituloRepresentante>();
            for (TituloRepresentante repOld : t.getRepresentantes()) {
                Boolean achou = false;
                for (TituloRepresentante repNew : novosTitulos) {
                    if (!repNew.getRepresentante().equals((Object)repOld.getRepresentante()) || !repNew.getPercComissao().equals(repOld.getPercComissao())) continue;
                    repNew.setVrBCComissao(Double.valueOf(repNew.getVrBCComissao() + repOld.getVrBCComissao()));
                    achou = true;
                    break;
                }
                if (achou.booleanValue()) continue;
                novosTitulos.add(repOld);
            }
            t.setRepresentantes(novosTitulos);
        }
    }

    private Double getValorAdicionalUltimaParcela(List<Titulo> listTitulos, RenegociacaoTitulos vo) {
        Double valorAdicional = 0.0;
        for (Titulo t : listTitulos) {
            valorAdicional = valorAdicional + t.getValorAdicional();
        }
        return ContatoFormatUtil.arrredondarNumero((Double)(vo.getValorAdicional() - valorAdicional), (int)2);
    }

    private Double getValorDescontUltimaParcela(List<Titulo> listTitulos, RenegociacaoTitulos vo) {
        Double valorDesconto = 0.0;
        for (Titulo t : listTitulos) {
            valorDesconto = valorDesconto + t.getDescontoFinanceiro();
        }
        return ContatoFormatUtil.arrredondarNumero((Double)(vo.getDesconto() - valorDesconto), (int)2);
    }

    private Double getValorMultaEmbutida(List<Titulo> listTitulos, RenegociacaoTitulos vo) {
        Double valorMultaEmbutida = 0.0;
        for (Titulo t : listTitulos) {
            valorMultaEmbutida = valorMultaEmbutida + t.getValorMultaEmbutida();
        }
        return ContatoFormatUtil.arrredondarNumero((Double)(vo.getMultaEmbutida() - valorMultaEmbutida), (int)2);
    }

    private Double getValorJurosEmbutida(List<Titulo> listTitulos, RenegociacaoTitulos vo) {
        Double valorJurosEmbutido = 0.0;
        for (Titulo t : listTitulos) {
            valorJurosEmbutido = valorJurosEmbutido + t.getValorJurosEmbutido();
        }
        return ContatoFormatUtil.arrredondarNumero((Double)(vo.getJurosEmbutidos() - valorJurosEmbutido), (int)2);
    }

    private PlanoContaGerencial getPlanoContaGerencial(EmpresaContabilidade empresaContabilidade, RenegociacaoTitulos vo) {
        if (vo.getPagRec().equals((short)0)) {
            return empresaContabilidade.getPcGerRenegociacaoPag();
        }
        return empresaContabilidade.getPcGerRenegociacaoRec();
    }

    private void setarPercJurosMultaDesconto(Titulo t, OpcoesFinanceiras op) {
        if (t.getPagRec() == 1) {
            Double percJuros = op.getPercJurosMes();
            Double percDesc = op.getPercDescMes();
            Double percMulta = op.getPercMulta();
            OpcoesFinanceirasTaxas opTaxas = this.getOpcoesFinanceirasTaxas(t.getMeioPagamento(), op);
            if (opTaxas != null) {
                percJuros = opTaxas.getPercJurosMes();
                percDesc = opTaxas.getPercDescMes();
                percMulta = opTaxas.getPercMulta();
            }
            if (percJuros != null) {
                t.setPercJurosMes(percJuros);
                t.setVrJurosDia(Double.valueOf(t.getValor() * (percJuros / 100.0) / 30.0));
            } else {
                t.setPercJurosMes(Double.valueOf(0.0));
                t.setVrJurosDia(Double.valueOf(0.0));
            }
            if (percDesc != null) {
                t.setPercDescontoMes(percDesc);
            } else {
                t.setPercDescontoMes(Double.valueOf(0.0));
            }
            if (percMulta != null) {
                t.setPercMulta(percMulta);
            } else {
                t.setPercMulta(Double.valueOf(0.0));
            }
        } else {
            t.setPercMulta(Double.valueOf(0.0));
            t.setPercJurosMes(Double.valueOf(0.0));
            t.setVrJurosDia(Double.valueOf(0.0));
            t.setPercDescontoMes(Double.valueOf(0.0));
        }
    }

    private OpcoesFinanceirasTaxas getOpcoesFinanceirasTaxas(MeioPagamento meioPagamento, OpcoesFinanceiras op) {
        if (meioPagamento != null) {
            for (OpcoesFinanceirasTaxas taxa : op.getTaxas()) {
                if (!taxa.getMeioPagamento().equals((Object)meioPagamento)) continue;
                return taxa;
            }
        }
        return null;
    }

    private boolean existsApauracaoComissaoRepresentante(TituloRepresentante titRep) {
        try {
            CoreRequestContext r = new CoreRequestContext();
            r.setAttribute("tituloRepresentante", titRep);
            return (Boolean)CoreServiceFactory.getServiceApuracaoComissaoRep().execute(r, "existsApuracaoComissaoByTituloRepresentante");
        }
        catch (ExceptionService ex) {
            logger.error((Throwable)ex, ex.getCause());
            ex.printStackTrace();
            return false;
        }
    }
}

