/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.titulos;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import java.util.ArrayList;
import java.util.Date;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.finder.BaseCriteria;
import mentorcore.service.CoreService;
import mentorcore.service.impl.financeiro.cnabnovo.model.RetornoRecebimentoCnab;

class AuxRetornoCnabTituloAntecipado {
    private static final TLogger logger = TLogger.get(AuxRetornoCnabTituloAntecipado.class);
    private static final SCompPlanoConta scPlanoConta = (SCompPlanoConta)ConfApplicationContext.getBean(SCompPlanoConta.class);

    AuxRetornoCnabTituloAntecipado() {
    }

    public Titulo criarTitulos(RetornoRecebimentoCnab retornoRecebimentoCnab, EmpresaFinanceiro empresaFinanceiro, Titulo titulo, EmpresaContabilidade empresaContabilidade, OpcoesContabeis opcoesContabeis) throws ExceptionService, ExceptionInvalidData {
        Titulo t = new Titulo();
        t.setCarteiraCobranca(titulo.getCarteiraCobranca());
        t.setDataCadastro(new Date());
        t.setDataCompetencia(new Date());
        t.setDataEntradaSaida(t.getDataCompetencia());
        t.setDataEmissao(new Date());
        t.setDataVencimento(titulo.getDataVencimento());
        t.setDataVencimentoBase(titulo.getDataVencimento());
        t.setEmpresa(titulo.getEmpresa());
        t.setNumParcTituloEstnota(Short.valueOf(Short.parseShort("1")));
        t.setObservacao("Titulo antecipado por retorno de cnab: " + titulo.getObservacao());
        t.setPagRec(Short.valueOf((short)1));
        t.setPessoa(titulo.getPessoa());
        t.setClassificacaoPessoa(titulo.getClassificacaoPessoa());
        Cliente cliente = this.getClienteTitulo(t);
        if (cliente != null) {
            t.setPlanoConta(scPlanoConta.getPlanoConta(cliente, opcoesContabeis));
            t.setTipoPessoa(EnumConstPessoa.CLIENTE.getEnumId());
        } else {
            t.setPlanoConta(t.getPlanoConta());
            t.setTipoPessoa(EnumConstPessoa.PESSOA.getEnumId());
        }
        t.setProvisao(Short.valueOf((short)1));
        t.setTipoDoc(titulo.getTipoDoc());
        t.setValor(Double.valueOf(this.getValorBaixadoTitulo(retornoRecebimentoCnab) - retornoRecebimentoCnab.getSaldoAtualTitulo()));
        t.setAntecipado(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        ArrayList<LancamentoCtbGerencial> lista = new ArrayList<LancamentoCtbGerencial>();
        LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, t.getDataCadastro(), t.getDataVencimento(), Short.valueOf(EnumLancamentoCTBGerencial.CREDITO.getValue()), t.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Lanc. do Titulo referente a Retorno de CNAB Antecipado: " + t.getPessoa().getNome(), empresaFinanceiro.getPlanoGerencialTituloAntecipado(), t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), null, t.getValor(), null);
        lista.add(l);
        t.setLancCtbGerencial(lista);
        return t;
    }

    private Double getValorBaixadoTitulo(RetornoRecebimentoCnab retornoRecebimentoCnab) {
        return retornoRecebimentoCnab.getValorBaixa();
    }

    private Cliente getClienteTitulo(Titulo t) {
        try {
            BaseCriteria b = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOCliente().getVOClass());
            b.and().equal("pessoa", t.getPessoa());
            Cliente cliente = (Cliente)CoreService.executeSearchUniqueResult(b);
            return cliente;
        }
        catch (ExceptionService ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }
}

