/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.titulos;

import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesFinanceirasTaxas;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.RepresentanteContratoComissao;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TituloRepresentante;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfinanceiras.HelperOpcoesFinanceiras;
import com.touchcomp.basementorservice.service.impl.feriado.ServiceFeriadoImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import mentorcore.tools.DateUtil;

public class AuxTitulos {
    private final TLogger logger = TLogger.get(this.getClass());
    private final ServiceFeriadoImpl serviceFeriadoImpl = (ServiceFeriadoImpl)Context.get(ServiceFeriadoImpl.class);

    public List getTitulosMutanteInternal(CondicoesPagamento cd, Pessoa p, Double valorTotalNota, PlanoConta pc, Double percComissao, String parcelas, Short tipoPessoa, Short pagRec, Short provReal, Date dataBase, String observacao, Date dataEmissao, Date dataEntradaSaida, Date dataCadastro, Date dataCompetencia, Empresa empresa, OpcoesFinanceiras opcoes, MeioPagamento meioPagamento, ClassificacaoClientes classificacaoPessoa) throws ExceptionGeracaoTitulos {
        List<Integer> parc = this.getParcelas(parcelas);
        if (parc.isEmpty()) {
            throw new ExceptionGeracaoTitulos("N\u00e3o foi poss\u00edvel gerar os t\u00edtulos com as condi\u00e7\u00f5es informadas: " + String.valueOf(cd));
        }
        if (pc == null) {
            throw new ExceptionGeracaoTitulos("Plano de contas cont\u00e1bil n\u00e3o foi informado no Titulo. Verifique cadastro anterior, como Cliente, Fornecedores, etc.");
        }
        if (valorTotalNota <= 0.0) {
            return new ArrayList();
        }
        ArrayList<Titulo> ret = new ArrayList<Titulo>();
        Double valorTitulo = valorTotalNota / (double)parc.size();
        Double valorAux = 0.0;
        valorTitulo = ContatoFormatUtil.arrredondarNumero((Double)valorTitulo, (int)2);
        valorTotalNota = ContatoFormatUtil.arrredondarNumero((Double)valorTotalNota, (int)2);
        for (short i = 1; i <= parc.size(); i = (short)(i + 1)) {
            Date dataTitulo = DateUtil.nextDays(dataBase, parc.get(i - 1));
            if (i == parc.size()) {
                valorTitulo = valorTotalNota - valorAux;
            } else {
                valorAux = i == 1 ? Double.valueOf(valorAux + valorTitulo) : Double.valueOf(valorAux + valorTitulo);
            }
            if (cd.getExcluirDiasNaoUteis() != null && cd.getExcluirDiasNaoUteis() == 1) {
                dataTitulo = this.getDataVencimentoDiasNaoUteis(dataTitulo, empresa);
            }
            if (cd.getForcarData().equals((short)1)) {
                dataTitulo = DateUtil.nextDays(dataTitulo, cd.getDelayDias().intValue());
                Integer diaSemana1 = cd.getDiaSemana().getDia().intValue();
                Integer diaSemana2 = DateUtil.diaDaSemana(dataTitulo);
                if (diaSemana2 <= diaSemana1) {
                    dif = diaSemana1 - diaSemana2;
                    dataTitulo = DateUtil.nextDays(dataTitulo, dif);
                } else {
                    dif = 7 - diaSemana2;
                    dataTitulo = DateUtil.nextDays(dataTitulo, dif + diaSemana1);
                }
            }
            Titulo t = this.newTitulo(p, pc, tipoPessoa, pagRec, provReal, dataTitulo, observacao, dataEmissao, dataTitulo, dataCadastro, dataCompetencia, empresa, opcoes, i, parc.size(), valorTitulo, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, meioPagamento, 0.0, cd, classificacaoPessoa);
            ret.add(t);
        }
        this.setarPercJuros(ret, opcoes);
        return ret;
    }

    public List getTitulosNaoMutanteInternal(CondicoesPagamento cd, Pessoa p, Double valorTotalNota, PlanoConta pc, Double percComissao, Short tipoPessoa, Short pagRec, Short provReal, Date dataTitulo, String observacao, Date dataEmissao, Date dataEntradaSaida, Date dataCadastro, Date dataCompetencia, Empresa empresa, OpcoesFinanceiras opcoes, MeioPagamento meioPagamento, ClassificacaoClientes classificacaoPessoa) throws ExceptionGeracaoTitulos {
        ArrayList<Titulo> ret = new ArrayList<Titulo>();
        if (pc == null) {
            throw new ExceptionGeracaoTitulos("Plano de contas cont\u00e1bil n\u00e3o foi informado no Titulo. Verifique cadastro anterior, como Cliente, Fornecedores, etc.");
        }
        if (valorTotalNota != 0.0) {
            if (cd == null) {
                return new ArrayList();
            }
            short s = cd.getNumeroParcelas().intValue();
            Double valorTitulo = valorTotalNota / (double)s;
            Double valorAux = 0.0;
            valorTitulo = ContatoFormatUtil.arrredondarNumero((Double)valorTitulo, (int)2);
            valorTotalNota = ContatoFormatUtil.arrredondarNumero((Double)valorTotalNota, (int)2);
            for (short i = 1; i <= s; i = (short)(i + 1)) {
                if (cd.getEntrada() != 1 || i != 1) {
                    dataTitulo = DateUtil.nextDays(dataTitulo, cd.getNumeroDiasVencimento());
                }
                if (i == s) {
                    valorTitulo = valorTotalNota - valorAux;
                } else {
                    valorAux = i == 1 ? Double.valueOf(valorAux + valorTitulo) : Double.valueOf(valorAux + valorTitulo);
                }
                if (cd.getExcluirDiasNaoUteis() != null && cd.getExcluirDiasNaoUteis() == 1) {
                    dataTitulo = this.getDataVencimentoDiasNaoUteis(dataTitulo, empresa);
                }
                if (cd.getForcarData().equals((short)1)) {
                    dataTitulo = DateUtil.nextDays(dataTitulo, cd.getDelayDias().intValue());
                    Integer diaSemana1 = cd.getDiaSemana().getDia().intValue();
                    Integer diaSemana2 = DateUtil.diaDaSemana(dataTitulo);
                    if (diaSemana2 <= diaSemana1) {
                        dif = diaSemana1 - diaSemana2;
                        dataTitulo = DateUtil.nextDays(dataTitulo, dif);
                    } else {
                        dif = 7 - diaSemana2;
                        dataTitulo = DateUtil.nextDays(dataTitulo, dif + diaSemana1);
                    }
                }
                Titulo t = this.newTitulo(p, pc, tipoPessoa, pagRec, provReal, dataTitulo, observacao, dataEmissao, dataTitulo, dataCadastro, dataCompetencia, empresa, opcoes, i, s, valorTitulo, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, meioPagamento, 0.0, cd, classificacaoPessoa);
                ret.add(t);
            }
        }
        this.setarPercJuros(ret, opcoes);
        return ret;
    }

    public List<Integer> getParcelas(String text) {
        return Arrays.asList(ToolString.splitStringAsInteger((String)text, (char[])new char[0]));
    }

    private void setarPercJuros(List titulos, OpcoesFinanceiras op) {
        for (Object titulo : titulos) {
            Titulo t = (Titulo)titulo;
            this.setarPercJurosMultaDesconto(t, op);
        }
    }

    Double getValorTotalTitulos(List titulos) {
        if (titulos == null) {
            return 0.0;
        }
        Double valorTotal = 0.0;
        for (Object o : titulos) {
            valorTotal = valorTotal + ((Titulo)o).getValor();
        }
        return valorTotal;
    }

    String getNrTituloBaixadoFromBDError(String msg) {
        String aux;
        int end;
        int init = msg.indexOf("@");
        if (init > -1 && (end = (aux = msg.substring(init + 1)).indexOf("@")) > -1) {
            return aux.substring(0, end);
        }
        return "";
    }

    Titulo newTitulo(Pessoa p, PlanoConta pc, Short tipoPessoa, Short pagRec, Short provisionadoRealizado, Date dataTitulo, String observacao, Date dataEmissao, Date dataEntradaSaida, Date dataCadastro, Date dataCompetencia, Empresa empresa, OpcoesFinanceiras opcoes, short parcela, int numParc, double valorTitulo, double multa, double multaEmbutida, double juros, double jurosEmbutido, double valorAdicional, double desconto, MeioPagamento meioPagamento, double valorDescontoEmbutido, CondicoesPagamento cp, ClassificacaoClientes classificacaoPessoa) {
        Titulo t = new Titulo();
        t.setPagRec(pagRec);
        t.setProvisao(provisionadoRealizado);
        t.setCarteiraCobranca(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(opcoes).getCarteiraCobranca(t.getPagRec().shortValue()));
        t.setCartCobrancaDestino(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(opcoes).getCarteiraCobrancaDestino(p, cp));
        t.setTipoDoc(opcoes.getTipoDocFinanceiro());
        if (observacao == null || observacao.trim().isEmpty()) {
            t.setObservacao("T\u00edtulo " + parcela + "/" + numParc);
        } else {
            t.setObservacao(observacao + "(" + parcela + "/" + numParc + ")");
        }
        t.setNumeroParcelas(Short.valueOf((short)numParc));
        t.setValor(Double.valueOf(valorTitulo));
        t.setValorMultaEmbutida(Double.valueOf(multaEmbutida));
        t.setValorJurosEmbutido(Double.valueOf(jurosEmbutido));
        t.setPercMulta(Double.valueOf(multa));
        t.setPercJurosMes(Double.valueOf(juros));
        t.setDescontoFinanceiro(Double.valueOf(desconto));
        t.setValorAdicional(Double.valueOf(valorAdicional));
        t.setNumParcTituloEstnota(Short.valueOf(parcela));
        t.setPessoa(p);
        t.setClassificacaoPessoa(classificacaoPessoa);
        t.setTipoPessoa(tipoPessoa);
        t.setDataEmissao(dataEmissao);
        t.setDataVencimento(dataTitulo);
        t.setDataVencimentoBase(dataTitulo);
        t.setDataCompetencia(dataCompetencia);
        t.setDataEntradaSaida(t.getDataCompetencia());
        t.setEmpresa(empresa);
        t.setDataCadastro(dataCadastro);
        t.setPlanoConta(pc);
        t.setMeioPagamento(meioPagamento);
        t.setValorDescontosEmbutido(Double.valueOf(valorDescontoEmbutido));
        if (t.getMeioPagamento() == null) {
            t.setMeioPagamento(opcoes.getMeioPagamento());
        }
        if (cp != null && cp.getTaxaCartao() > 0.0) {
            t.setValorTaxaCartao(Double.valueOf(t.getValor() * cp.getTaxaCartao() / 100.0));
        }
        return t;
    }

    public static List<TituloRepresentante> gerarTitulosRepresentante(List<RepresentanteContratoComissao> representantesComissao, Titulo t, Double valorBaseCalculo, Double percBCComissaoRep) {
        ArrayList<TituloRepresentante> titulosRepresentantes = new ArrayList<TituloRepresentante>();
        for (RepresentanteContratoComissao reprComissao : representantesComissao) {
            TituloRepresentante tituloRepr = new TituloRepresentante();
            tituloRepr.setRepresentante(reprComissao.getRepresentante());
            tituloRepr.setPercComissao(reprComissao.getPercentualComissao());
            tituloRepr.setTitulo(t);
            tituloRepr.setVrBCComissao(Double.valueOf(valorBaseCalculo * percBCComissaoRep / 100.0));
            titulosRepresentantes.add(tituloRepr);
        }
        return titulosRepresentantes;
    }

    public static List<Titulo> buildTitulos(List<RepresentanteContratoComissao> representanteContratoComissaos, List<Titulo> titulos, Double percBCComissaoRep) {
        for (Titulo titulo : titulos) {
            titulo.getRepresentantes().addAll(AuxTitulos.gerarTitulosRepresentante(representanteContratoComissaos, titulo, titulo.getValor(), percBCComissaoRep));
        }
        return titulos;
    }

    private Date getDataVencimentoDiasNaoUteis(Date dataEmissao, Empresa empresa) {
        Date data = dataEmissao;
        Integer diaSemana = DateUtil.diaDaSemana(dataEmissao);
        if (diaSemana.equals(7)) {
            data = DateUtil.nextDays(data, 1);
            diaSemana = 1;
        }
        if (diaSemana.equals(1)) {
            data = DateUtil.nextDays(data, 1);
        }
        if (this.existeFeriado(data, empresa).booleanValue()) {
            diaSemana = DateUtil.diaDaSemana(data = DateUtil.nextDays(data, 1));
            if (diaSemana.equals(7)) {
                data = DateUtil.nextDays(data, 1);
                diaSemana = 1;
            }
            if (diaSemana.equals(1)) {
                data = DateUtil.nextDays(data, 1);
            }
        }
        return data;
    }

    private Boolean existeFeriado(Date data, Empresa empresa) {
        int dia = ToolDate.dayFromDate((Date)data);
        int mes = ToolDate.monthFromDate((Date)data);
        int ano = ToolDate.yearFromDate((Object)data);
        boolean existeFeriado = this.serviceFeriadoImpl.findFeriadoPorData(dia, mes, ano, empresa);
        return existeFeriado;
    }

    private void setarPercJurosMultaDesconto(Titulo t, OpcoesFinanceiras op) {
        if (t.getPagRec() == 1) {
            Double percJuros = op.getPercJurosMes();
            Double percDesc = op.getPercDescMes();
            Double percMulta = op.getPercMulta();
            OpcoesFinanceirasTaxas opTaxas = this.getOpcoesFinanceirasTaxas(t.getMeioPagamento(), op);
            if (opTaxas != null) {
                percJuros = opTaxas.getPercJurosMes();
                percDesc = opTaxas.getPercDescMes();
                percMulta = opTaxas.getPercMulta();
            }
            if (percJuros != null) {
                t.setPercJurosMes(percJuros);
                t.setVrJurosDia(Double.valueOf(t.getValor() * (percJuros / 100.0) / 30.0));
            } else {
                t.setPercJurosMes(Double.valueOf(0.0));
                t.setVrJurosDia(Double.valueOf(0.0));
            }
            if (percDesc != null) {
                t.setPercDescontoMes(percDesc);
            } else {
                t.setPercDescontoMes(Double.valueOf(0.0));
            }
            if (percMulta != null) {
                t.setPercMulta(percMulta);
            } else {
                t.setPercMulta(Double.valueOf(0.0));
            }
        } else {
            t.setPercMulta(Double.valueOf(0.0));
            t.setPercJurosMes(Double.valueOf(0.0));
            t.setVrJurosDia(Double.valueOf(0.0));
            t.setPercDescontoMes(Double.valueOf(0.0));
        }
    }

    private OpcoesFinanceirasTaxas getOpcoesFinanceirasTaxas(MeioPagamento meioPagamento, OpcoesFinanceiras op) {
        if (meioPagamento != null) {
            for (OpcoesFinanceirasTaxas taxa : op.getTaxas()) {
                if (!taxa.getMeioPagamento().equals((Object)meioPagamento)) continue;
                return taxa;
            }
        }
        return null;
    }
}

