/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.titulos;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.formaspagcupomfiscal.EnumFormasPagCupomFiscalDeducaoTaxa;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.FormasPagCupomFiscal;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesFinanceirasTaxas;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TituloBaixaCartao;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorspringcontext.Context;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.DateUtil;

public class AuxTitulosBaixa {
    public List<TituloBaixaCartao> getTituloBaixaCartao(GrupoDeBaixaFormas grupoBaixaFormas, OpcoesFinanceiras opcoesFinanceira, EmpresaFinanceiro emp) throws ExceptionService {
        if (grupoBaixaFormas.getFormaPagamento().equals((short)9)) {
            return this.createTituloBaixaCartaoDebito(grupoBaixaFormas, opcoesFinanceira, emp);
        }
        return this.createTituloBaixaCartaoCredito(grupoBaixaFormas, opcoesFinanceira, emp);
    }

    private List<TituloBaixaCartao> createTituloBaixaCartaoDebito(GrupoDeBaixaFormas grupoBaixaFormas, OpcoesFinanceiras opcoesFinanceira, EmpresaFinanceiro empFinanceira) throws ExceptionService {
        if (opcoesFinanceira.getTipoDocFinanceiroTituloCartao() == null) {
            throw new ExceptionService("Informe o Tipo de Documento para Titulo do Cartao em Opcoes Financeiras");
        }
        ArrayList<TituloBaixaCartao> titulos = new ArrayList<TituloBaixaCartao>();
        if (grupoBaixaFormas.getGrupoDeBaixa().getPagRec() == 1) {
            FormasPagCupomFiscal formaPagamento = grupoBaixaFormas.getFormaPagamentoCartao();
            Double valorTitulo = this.getValor(grupoBaixaFormas.getBaixaTitulo());
            Titulo t = new Titulo();
            t.setPagRec(Short.valueOf((short)1));
            t.setProvisao(Short.valueOf((short)1));
            t.setTipoDoc(opcoesFinanceira.getTipoDocFinanceiroTituloCartao());
            t.setObservacao("Recebimento referente ao(s) Titulo(s): " + this.getIdTitulo(grupoBaixaFormas.getBaixaTitulo()));
            t.setValor(valorTitulo);
            t.setValorTaxaCartao(ContatoFormatUtil.arrredondarNumero((Double)(t.getValor() * (formaPagamento.getTaxaCartao() / 100.0)), (int)2));
            t.setNumParcTituloEstnota(Short.valueOf((short)1));
            t.setPessoa(formaPagamento.getPessoa());
            t.setClassificacaoPessoa(opcoesFinanceira.getClassificacaoClientes());
            if (formaPagamento.getPessoa().getPessoaDadosFinanceiros() != null) {
                t.setCartCobrancaDestino(formaPagamento.getPessoa().getPessoaDadosFinanceiros().getCarteiraCobranca());
            }
            t.setTipoPessoa(EnumConstPessoa.PESSOA.getEnumId());
            t.setDataEmissao(grupoBaixaFormas.getGrupoDeBaixa().getDataLiquidacao());
            t.setDataVencimento(this.getDataVencimentoTituloDebito(t.getDataEmissao(), formaPagamento.getDiasDeslocamento(), formaPagamento.getExcluiSabado(), formaPagamento.getExcluiDomingo(), formaPagamento.getExcluiFeriado(), grupoBaixaFormas.getGrupoDeBaixa().getEmpresa()));
            t.setDataVencimentoBase(t.getDataVencimento());
            t.setDataCompetencia(grupoBaixaFormas.getGrupoDeBaixa().getDataLiquidacao());
            t.setDataEntradaSaida(t.getDataCompetencia());
            t.setEmpresa(grupoBaixaFormas.getGrupoDeBaixa().getEmpresa());
            t.setDataCadastro(grupoBaixaFormas.getGrupoDeBaixa().getDataLiquidacao());
            t.setPlanoConta(formaPagamento.getPlanoConta());
            t.setCarteiraCobranca(formaPagamento.getCarteiraCobranca());
            this.setarPercJurosMultaDesconto(t, opcoesFinanceira);
            LancamentoCtbGerencial lancGerencial = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, DateUtil.getDateLastMonthDay(grupoBaixaFormas.getGrupoDeBaixa().getDataLiquidacao()), t.getDataVencimento(), Short.valueOf(EnumLancamentoCTBGerencial.CREDITO.getValue()), grupoBaixaFormas.getGrupoDeBaixa().getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Titulo referente : " + formaPagamento.getPessoa().getNome(), formaPagamento.getPlanoContaGerencial(), t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), formaPagamento.getCentroCusto(), t.getValor(), null);
            ArrayList<LancamentoCtbGerencial> lanc = new ArrayList<LancamentoCtbGerencial>();
            lanc.add(lancGerencial);
            t.setLancCtbGerencial(lanc);
            TituloBaixaCartao tituloBaixa = new TituloBaixaCartao(t);
            tituloBaixa.setGrupoBaixaFormas(grupoBaixaFormas);
            titulos.add(tituloBaixa);
        } else {
            FormasPagCupomFiscal formaPagamento = grupoBaixaFormas.getFormaPagamentoCartao();
            Double valorTitulo = this.getValor(grupoBaixaFormas.getBaixaTitulo());
            Titulo t = new Titulo();
            t.setPagRec(Short.valueOf((short)0));
            t.setProvisao(Short.valueOf((short)1));
            t.setTipoDoc(opcoesFinanceira.getTipoDocFinanceiroTituloCartao());
            t.setObservacao("Pagamento referente ao(s) Titulo(s): " + this.getIdTitulo(grupoBaixaFormas.getBaixaTitulo()));
            t.setValor(valorTitulo);
            t.setValorTaxaCartao(ContatoFormatUtil.arrredondarNumero((Double)(t.getValor() * (formaPagamento.getTaxaCartao() / 100.0)), (int)2));
            t.setNumParcTituloEstnota(Short.valueOf((short)1));
            t.setPessoa(formaPagamento.getPessoa());
            t.setClassificacaoPessoa(opcoesFinanceira.getClassificacaoClientes());
            if (formaPagamento.getPessoa().getPessoaDadosFinanceiros() != null) {
                t.setCartCobrancaDestino(formaPagamento.getPessoa().getPessoaDadosFinanceiros().getCarteiraCobranca());
            }
            t.setTipoPessoa(EnumConstPessoa.PESSOA.getEnumId());
            t.setDataEmissao(grupoBaixaFormas.getGrupoDeBaixa().getDataLiquidacao());
            t.setDataVencimento(this.getDataVencimentoTituloDebito(t.getDataEmissao(), formaPagamento.getDiasDeslocamento(), formaPagamento.getExcluiSabado(), formaPagamento.getExcluiDomingo(), formaPagamento.getExcluiFeriado(), grupoBaixaFormas.getGrupoDeBaixa().getEmpresa()));
            t.setDataVencimentoBase(t.getDataVencimento());
            t.setDataCompetencia(grupoBaixaFormas.getGrupoDeBaixa().getDataLiquidacao());
            t.setDataEntradaSaida(t.getDataCompetencia());
            t.setEmpresa(grupoBaixaFormas.getGrupoDeBaixa().getEmpresa());
            t.setDataCadastro(grupoBaixaFormas.getGrupoDeBaixa().getDataLiquidacao());
            t.setPlanoConta(formaPagamento.getPlanoConta());
            t.setCarteiraCobranca(formaPagamento.getCarteiraCobranca());
            this.setarPercJurosMultaDesconto(t, opcoesFinanceira);
            LancamentoCtbGerencial lancGerencial = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, DateUtil.getDateLastMonthDay(grupoBaixaFormas.getGrupoDeBaixa().getDataLiquidacao()), t.getDataVencimento(), Short.valueOf(EnumLancamentoCTBGerencial.DEBITO.getValue()), grupoBaixaFormas.getGrupoDeBaixa().getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Titulo referente : " + formaPagamento.getPessoa().getNome(), formaPagamento.getPlanoContaGerencial(), t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), formaPagamento.getCentroCusto(), t.getValor(), null);
            ArrayList<LancamentoCtbGerencial> lanc = new ArrayList<LancamentoCtbGerencial>();
            lanc.add(lancGerencial);
            t.setLancCtbGerencial(lanc);
            TituloBaixaCartao tituloBaixa = new TituloBaixaCartao(t);
            tituloBaixa.setGrupoBaixaFormas(grupoBaixaFormas);
            titulos.add(tituloBaixa);
        }
        return titulos;
    }

    private Double getValor(List<BaixaTitulo> baixaTitulo) {
        Double valor = 0.0;
        for (BaixaTitulo baixaTitulo1 : baixaTitulo) {
            valor = valor + baixaTitulo1.getTotalOperacao();
        }
        return valor;
    }

    private Date getDataVencimentoTituloDebito(Date dataEmissao, Integer diasDeslocamento, Short excluiSabado, Short excluiDomingo, Short excluiFeriado, Empresa empresa) throws ExceptionService {
        Date data = DateUtil.nextDays(dataEmissao, diasDeslocamento);
        Integer diaSemana = DateUtil.diaDaSemana(dataEmissao);
        if (diaSemana.equals(7) && excluiSabado != null && excluiSabado.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            data = DateUtil.nextDays(data, 1);
            diaSemana = 1;
        }
        if (diaSemana.equals(1) && excluiDomingo != null && excluiDomingo.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            data = DateUtil.nextDays(data, 1);
        }
        if (excluiFeriado != null && excluiFeriado.equals(EnumConstantsMentorSimNao.SIM.getValue()) && this.existeFeriado(data, empresa)) {
            diaSemana = DateUtil.diaDaSemana(data = DateUtil.nextDays(data, 1));
            if (diaSemana.equals(7) && excluiSabado != null && excluiSabado.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
                data = DateUtil.nextDays(data, 1);
                diaSemana = 1;
            }
            if (diaSemana.equals(1) && excluiDomingo != null && excluiDomingo.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
                data = DateUtil.nextDays(data, 1);
            }
        }
        return data;
    }

    private Date getDataVencimentoTituloCredito(Date dataEmissao, Short dataFixa, Integer diaFixo, Integer diaVariavel, Short excluiSabado, Short excluiDomingo, Short excluiFeriado, Empresa empresa, int parcela) throws ExceptionService {
        Date data = null;
        if (dataFixa.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            Integer diaFixoVencimento = diaFixo;
            Integer diaEmissao = DateUtil.dayFromDate(dataEmissao);
            Integer mesEmissao = DateUtil.monthFromDate(dataEmissao);
            Integer anoEmissao = DateUtil.yearFromDate(dataEmissao);
            if (diaEmissao < diaFixoVencimento) {
                data = this.getFormateDate(diaFixoVencimento, mesEmissao, anoEmissao);
            } else {
                if ((mesEmissao = Integer.valueOf(mesEmissao + parcela)) > 12) {
                    mesEmissao = mesEmissao - 12;
                    anoEmissao = anoEmissao + 1;
                }
                data = this.getFormateDate(diaFixoVencimento, mesEmissao, anoEmissao);
            }
        } else {
            data = DateUtil.nextDays(dataEmissao, diaVariavel * parcela);
        }
        Integer diaSemana = DateUtil.diaDaSemana(data);
        if (diaSemana.equals(7) && excluiSabado != null && excluiSabado.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            data = DateUtil.nextDays(data, 1);
            diaSemana = 1;
        }
        if (diaSemana.equals(1) && excluiDomingo != null && excluiDomingo.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            data = DateUtil.nextDays(data, 1);
        }
        if (excluiFeriado != null && excluiFeriado.equals(EnumConstantsMentorSimNao.SIM.getValue()) && this.existeFeriado(data, empresa)) {
            diaSemana = DateUtil.diaDaSemana(data = DateUtil.nextDays(data, 1));
            if (diaSemana.equals(7) && excluiSabado != null && excluiSabado.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
                data = DateUtil.nextDays(data, 1);
                diaSemana = 1;
            }
            if (diaSemana.equals(1) && excluiDomingo != null && excluiDomingo.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
                data = DateUtil.nextDays(data, 1);
            }
        }
        return data;
    }

    private Date getFormateDate(Integer diaFixoVencimento, Integer mesEmissao, Integer anoEmissao) {
        return DateUtil.intToDate(anoEmissao, mesEmissao, diaFixoVencimento);
    }

    private boolean existeFeriado(Date data, Empresa empresa) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("periodoFinal", data);
        request.setAttribute("periodoInicial", data);
        request.setAttribute("idEmpresa", empresa.getIdentificador());
        List feriadoNacional = (List)CoreServiceFactory.getServiceFeriado().execute(request, "findFeriadoPorPeriodo");
        return feriadoNacional != null && !feriadoNacional.isEmpty();
    }

    private String getIdTitulo(List<BaixaTitulo> b) {
        Object ret = "";
        Iterator<BaixaTitulo> iterator = b.iterator();
        while (iterator.hasNext()) {
            BaixaTitulo bx;
            BaixaTitulo baixa = bx = iterator.next();
            ret = (String)ret + baixa.getTitulo().getIdentificador() + " ";
        }
        return ret;
    }

    private List<TituloBaixaCartao> createTituloBaixaCartaoCredito(GrupoDeBaixaFormas grupoBaixa, OpcoesFinanceiras opcoesFinanceira, EmpresaFinanceiro emp) throws ExceptionService {
        if (opcoesFinanceira.getTipoDocFinanceiroTituloCartao() == null) {
            throw new ExceptionService("Informe o Tipo de Documento para Titulo do Cartao em Opcoes Financeiras");
        }
        ArrayList<TituloBaixaCartao> titulosCartao = new ArrayList<TituloBaixaCartao>();
        if (grupoBaixa.getGrupoDeBaixa().getPagRec() == 1) {
            FormasPagCupomFiscal formaPagamento = grupoBaixa.getFormaPagamentoCartao();
            Double valorTotalBaixa = this.getValor(grupoBaixa.getBaixaTitulo());
            Integer parcelas = new Integer(formaPagamento.getNrParcelas().shortValue());
            Integer contParcelas = 1;
            Double valorTituloAcumulativo = 0.0;
            Double taxaCartaoAcumulativo = 0.0;
            Double totalTaxaCartao = ContatoFormatUtil.arrredondarNumero((Double)(valorTotalBaixa * (formaPagamento.getTaxaCartao() / 100.0)), (int)2);
            Double valorPorTitulo = ContatoFormatUtil.arrredondarNumero((Double)(valorTotalBaixa / (double)parcelas.intValue()), (int)2);
            Short deducaoTaxa = formaPagamento.getDeducaoTaxa();
            Short count = 1;
            do {
                Titulo t = new Titulo();
                t.setPagRec(Short.valueOf((short)1));
                t.setProvisao(Short.valueOf((short)1));
                t.setTipoDoc(opcoesFinanceira.getTipoDocFinanceiroTituloCartao());
                t.setObservacao("Recebimento referente ao(s) Titulo(s): " + this.getIdTitulo(grupoBaixa.getBaixaTitulo()));
                if (contParcelas.equals(parcelas)) {
                    t.setValor(Double.valueOf(valorTotalBaixa - valorTituloAcumulativo));
                } else {
                    t.setValor(valorPorTitulo);
                    valorTituloAcumulativo = valorTituloAcumulativo + valorPorTitulo;
                }
                if (deducaoTaxa.equals(EnumFormasPagCupomFiscalDeducaoTaxa.DEDUCAO_TODAS_PARCELAS.getValue())) {
                    if (contParcelas.equals(parcelas)) {
                        t.setValorTaxaCartao(Double.valueOf(totalTaxaCartao - taxaCartaoAcumulativo));
                    } else {
                        t.setValorTaxaCartao(ContatoFormatUtil.arrredondarNumero((Double)(t.getValor() * (formaPagamento.getTaxaCartao() / 100.0)), (int)2));
                        taxaCartaoAcumulativo = taxaCartaoAcumulativo + t.getValorTaxaCartao();
                    }
                } else if (contParcelas == 1) {
                    t.setValorTaxaCartao(Double.valueOf(valorTotalBaixa * (formaPagamento.getTaxaCartao() / 100.0)));
                }
                t.setNumeroParcelas(Short.valueOf(parcelas.shortValue()));
                t.setNumParcTituloEstnota(count);
                Short s = count;
                count = (short)(count + 1);
                t.setPessoa(formaPagamento.getPessoa());
                t.setClassificacaoPessoa(opcoesFinanceira.getClassificacaoClientes());
                if (formaPagamento.getPessoa().getPessoaDadosFinanceiros() != null) {
                    t.setCartCobrancaDestino(formaPagamento.getPessoa().getPessoaDadosFinanceiros().getCarteiraCobranca());
                }
                t.setTipoPessoa(EnumConstPessoa.PESSOA.getEnumId());
                t.setDataEmissao(grupoBaixa.getGrupoDeBaixa().getDataLiquidacao());
                t.setDataVencimento(this.getDataVencimentoTituloCredito(t.getDataEmissao(), formaPagamento.getDataFixa(), formaPagamento.getDiaFixo(), formaPagamento.getDiaVariavel(), formaPagamento.getExcluiSabado(), formaPagamento.getExcluiDomingo(), formaPagamento.getExcluiFeriado(), formaPagamento.getEmpresa(), contParcelas));
                t.setDataVencimentoBase(t.getDataVencimento());
                t.setDataCompetencia(grupoBaixa.getGrupoDeBaixa().getDataLiquidacao());
                t.setDataEntradaSaida(t.getDataCompetencia());
                t.setEmpresa(grupoBaixa.getGrupoDeBaixa().getEmpresa());
                t.setDataCadastro(grupoBaixa.getGrupoDeBaixa().getDataLiquidacao());
                t.setPlanoConta(formaPagamento.getPlanoConta());
                t.setCarteiraCobranca(formaPagamento.getCarteiraCobranca());
                this.setarPercJurosMultaDesconto(t, opcoesFinanceira);
                LancamentoCtbGerencial lancGerencial = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, DateUtil.getDateLastMonthDay(grupoBaixa.getGrupoDeBaixa().getDataLiquidacao()), t.getDataVencimento(), Short.valueOf(EnumLancamentoCTBGerencial.CREDITO.getValue()), grupoBaixa.getGrupoDeBaixa().getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Titulo referente : " + formaPagamento.getPessoa().getNome(), formaPagamento.getPlanoContaGerencial(), t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), formaPagamento.getCentroCusto(), t.getValor(), null);
                ArrayList<LancamentoCtbGerencial> lanc = new ArrayList<LancamentoCtbGerencial>();
                lanc.add(lancGerencial);
                t.setLancCtbGerencial(lanc);
                TituloBaixaCartao tituloBaixa = new TituloBaixaCartao(t);
                tituloBaixa.setGrupoBaixaFormas(grupoBaixa);
                titulosCartao.add(tituloBaixa);
            } while ((contParcelas = Integer.valueOf(contParcelas + 1)) <= parcelas);
        } else {
            FormasPagCupomFiscal formaPagamento = grupoBaixa.getFormaPagamentoCartao();
            Double valorTotalBaixa = this.getValor(grupoBaixa.getBaixaTitulo());
            Integer parcelas = new Integer(formaPagamento.getNrParcelas().shortValue());
            Integer contParcelas = 1;
            Double valorTituloAcumulativo = 0.0;
            Double taxaCartaoAcumulativo = 0.0;
            Double totalTaxaCartao = ContatoFormatUtil.arrredondarNumero((Double)(valorTotalBaixa * (formaPagamento.getTaxaCartao() / 100.0)), (int)2);
            Double valorPorTitulo = ContatoFormatUtil.arrredondarNumero((Double)(valorTotalBaixa / (double)parcelas.intValue()), (int)2);
            Short deducaoTaxa = formaPagamento.getDeducaoTaxa();
            Short count = 1;
            do {
                Titulo t = new Titulo();
                t.setPagRec(Short.valueOf((short)0));
                t.setProvisao(Short.valueOf((short)1));
                t.setTipoDoc(opcoesFinanceira.getTipoDocFinanceiroTituloCartao());
                t.setObservacao("Pagamento referente ao(s) Titulo(s): " + this.getIdTitulo(grupoBaixa.getBaixaTitulo()));
                if (contParcelas.equals(parcelas)) {
                    t.setValor(Double.valueOf(valorTotalBaixa - valorTituloAcumulativo));
                } else {
                    t.setValor(valorPorTitulo);
                    valorTituloAcumulativo = valorTituloAcumulativo + valorPorTitulo;
                }
                if (deducaoTaxa.equals(EnumFormasPagCupomFiscalDeducaoTaxa.DEDUCAO_TODAS_PARCELAS.getValue())) {
                    if (contParcelas.equals(parcelas)) {
                        t.setValorTaxaCartao(Double.valueOf(totalTaxaCartao - taxaCartaoAcumulativo));
                    } else {
                        t.setValorTaxaCartao(ContatoFormatUtil.arrredondarNumero((Double)(t.getValor() * (formaPagamento.getTaxaCartao() / 100.0)), (int)2));
                        taxaCartaoAcumulativo = taxaCartaoAcumulativo + t.getValorTaxaCartao();
                    }
                } else if (contParcelas == 1) {
                    t.setValorTaxaCartao(Double.valueOf(valorTotalBaixa * (formaPagamento.getTaxaCartao() / 100.0)));
                }
                t.setNumeroParcelas(Short.valueOf(parcelas.shortValue()));
                t.setNumParcTituloEstnota(count);
                Short lancGerencial = count;
                count = (short)(count + 1);
                t.setPessoa(formaPagamento.getPessoa());
                t.setClassificacaoPessoa(opcoesFinanceira.getClassificacaoClientes());
                if (formaPagamento.getPessoa().getPessoaDadosFinanceiros() != null) {
                    t.setCartCobrancaDestino(formaPagamento.getPessoa().getPessoaDadosFinanceiros().getCarteiraCobranca());
                }
                t.setTipoPessoa(EnumConstPessoa.PESSOA.getEnumId());
                t.setDataEmissao(grupoBaixa.getGrupoDeBaixa().getDataLiquidacao());
                t.setDataVencimento(this.getDataVencimentoTituloCredito(t.getDataEmissao(), formaPagamento.getDataFixa(), formaPagamento.getDiaFixo(), formaPagamento.getDiaVariavel(), formaPagamento.getExcluiSabado(), formaPagamento.getExcluiDomingo(), formaPagamento.getExcluiFeriado(), formaPagamento.getEmpresa(), contParcelas));
                t.setDataVencimentoBase(t.getDataVencimento());
                t.setDataCompetencia(grupoBaixa.getGrupoDeBaixa().getDataLiquidacao());
                t.setDataEntradaSaida(t.getDataCompetencia());
                t.setEmpresa(grupoBaixa.getGrupoDeBaixa().getEmpresa());
                t.setDataCadastro(grupoBaixa.getGrupoDeBaixa().getDataLiquidacao());
                t.setPlanoConta(formaPagamento.getPlanoConta());
                t.setCarteiraCobranca(formaPagamento.getCarteiraCobranca());
                this.setarPercJurosMultaDesconto(t, opcoesFinanceira);
                lancGerencial = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, DateUtil.getDateLastMonthDay(grupoBaixa.getGrupoDeBaixa().getDataLiquidacao()), t.getDataVencimento(), Short.valueOf(EnumLancamentoCTBGerencial.DEBITO.getValue()), grupoBaixa.getGrupoDeBaixa().getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Titulo referente : " + formaPagamento.getPessoa().getNome(), formaPagamento.getPlanoContaGerencial(), t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), formaPagamento.getCentroCusto(), t.getValor(), null);
                ArrayList<Short> lanc = new ArrayList<Short>();
                lanc.add(lancGerencial);
                t.setLancCtbGerencial(lanc);
                TituloBaixaCartao tituloBaixa = new TituloBaixaCartao(t);
                tituloBaixa.setGrupoBaixaFormas(grupoBaixa);
                titulosCartao.add(tituloBaixa);
            } while ((contParcelas = Integer.valueOf(contParcelas + 1)) <= parcelas);
        }
        return titulosCartao;
    }

    private void setarPercJurosMultaDesconto(Titulo t, OpcoesFinanceiras op) {
        if (t.getPagRec() == 1) {
            Double percJuros = op.getPercJurosMes();
            Double percDesc = op.getPercDescMes();
            Double percMulta = op.getPercMulta();
            OpcoesFinanceirasTaxas opTaxas = this.getOpcoesFinanceirasTaxas(t.getMeioPagamento(), op);
            if (opTaxas != null) {
                percJuros = opTaxas.getPercJurosMes();
                percDesc = opTaxas.getPercDescMes();
                percMulta = opTaxas.getPercMulta();
            }
            if (percJuros != null) {
                t.setPercJurosMes(percJuros);
                t.setVrJurosDia(Double.valueOf(t.getValor() * (percJuros / 100.0) / 30.0));
            } else {
                t.setPercJurosMes(Double.valueOf(0.0));
                t.setVrJurosDia(Double.valueOf(0.0));
            }
            if (percDesc != null) {
                t.setPercDescontoMes(percDesc);
            } else {
                t.setPercDescontoMes(Double.valueOf(0.0));
            }
            if (percMulta != null) {
                t.setPercMulta(percMulta);
            } else {
                t.setPercMulta(Double.valueOf(0.0));
            }
        } else {
            t.setPercMulta(Double.valueOf(0.0));
            t.setPercJurosMes(Double.valueOf(0.0));
            t.setVrJurosDia(Double.valueOf(0.0));
            t.setPercDescontoMes(Double.valueOf(0.0));
        }
    }

    private OpcoesFinanceirasTaxas getOpcoesFinanceirasTaxas(MeioPagamento meioPagamento, OpcoesFinanceiras op) {
        if (meioPagamento != null) {
            for (OpcoesFinanceirasTaxas taxa : op.getTaxas()) {
                if (!taxa.getMeioPagamento().equals((Object)meioPagamento)) continue;
                return taxa;
            }
        }
        return null;
    }
}

