/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.titulos;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.opcoescontabeis.EnumConstImpostosRetidos;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.vo.InfPagamentoNfPropria;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesContabeisImpostosRetidos;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorservice.components.opcoes.CompOpcoesContabeis;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfinanceiras.HelperOpcoesFinanceiras;
import com.touchcomp.basementorspringcontext.Context;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class AuxTitulosCooperados {
    public void calcularTitulosImpostosCooperados(List<InfPagamentoNfPropria> infPagamento, NotaFiscalPropria vo, Double valorTotalNota, OpcoesFinanceiras op, OpcoesContabeis cont) throws ExceptionGeracaoTitulos {
        ArrayList<Titulo> ret = new ArrayList<Titulo>();
        String serie = vo.getSerie();
        Integer nrNota = vo.getNumeroNota();
        double vrInssNaoRetido = 0.0;
        double vrRAT = 0.0;
        double vrSenar = 0.0;
        double vrTaxaSanidadeAnimal = 0.0;
        Date date = null;
        vrInssNaoRetido = vo.getValoresNfPropria().getValorInssNaoRetido();
        vrRAT = vo.getValoresNfPropria().getValorRAT();
        vrSenar = vo.getValoresNfPropria().getValorSenar();
        vrTaxaSanidadeAnimal = vo.getValoresNfPropria().getValorTaxaSanidadeAnimal();
        date = vo.getDataEmissaoNota();
        String meio = "";
        String end = "Para isto informe os dados necessarios no recurso Empresa Contabilidade.";
        String start = "O mentor pode criar t\u00edtulos a pagar para os impostos retidos. ";
        Date dataTitulo = null;
        Pessoa pessoaTitulo = null;
        Short numTitulo = 1;
        for (InfPagamentoNfPropria i : infPagamento) {
            Short s;
            for (Object o : i.getTitulos()) {
                Titulo t = (Titulo)o;
                if (t.getNumParcTituloEstnota() <= numTitulo) continue;
                numTitulo = t.getNumParcTituloEstnota();
            }
            if (vrInssNaoRetido > 0.0) {
                OpcoesContabeisImpostosRetidos inss = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)cont, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.INSS);
                if (inss.getPlanoContaImpostoRetido() != null && inss.getPlanoContaGerencialImpostoRetido() != null) {
                    s = numTitulo;
                    numTitulo = (short)(numTitulo + 1);
                    dataTitulo = inss.getDiaVencimentoImpostoRetido() != null && inss.getDiaVencimentoImpostoRetido() > 0 ? AuxTitulosCooperados.getDataTitulo(inss.getDiaVencimentoImpostoRetido(), date) : vo.getDataEmissaoNota();
                    pessoaTitulo = inss.getPessoaImpostoRetido() != null ? inss.getPessoaImpostoRetido() : vo.getUnidadeFatCliente().getCliente().getPessoa();
                    ret.add(AuxTitulosCooperados.getTituloCooperado(pessoaTitulo, inss.getPlanoContaImpostoRetido(), inss.getPlanoContaGerencialImpostoRetido(), vo, "INSS de cooperado para a nota propria " + serie + " - " + nrNota + ", pessoa: " + pessoaTitulo.getNome(), vrInssNaoRetido, dataTitulo, numTitulo, op));
                } else {
                    meio = "Imposto INSS. ";
                    throw new ExceptionGeracaoTitulos(start + meio + end);
                }
            }
            if (vrRAT > 0.0) {
                OpcoesContabeisImpostosRetidos rat = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)cont, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.RAT);
                if (rat.getPlanoContaImpostoRetido() != null && rat.getPlanoContaGerencialImpostoRetido() != null) {
                    s = numTitulo;
                    numTitulo = (short)(numTitulo + 1);
                    dataTitulo = rat.getDiaVencimentoImpostoRetido() != null && rat.getDiaVencimentoImpostoRetido() > 0 ? AuxTitulosCooperados.getDataTitulo(rat.getDiaVencimentoImpostoRetido(), date) : vo.getDataEmissaoNota();
                    pessoaTitulo = rat.getPessoaImpostoRetido() != null ? rat.getPessoaImpostoRetido() : vo.getUnidadeFatCliente().getCliente().getPessoa();
                    ret.add(AuxTitulosCooperados.getTituloCooperado(pessoaTitulo, rat.getPlanoContaImpostoRetido(), rat.getPlanoContaGerencialImpostoRetido(), vo, "RAT de cooperado para a nota propria " + serie + " - " + nrNota + ", pessoa: " + pessoaTitulo.getNome(), vrRAT, dataTitulo, numTitulo, op));
                } else {
                    meio = "Imposto RAT. ";
                    throw new ExceptionGeracaoTitulos(start + meio + end);
                }
            }
            if (vrSenar > 0.0) {
                OpcoesContabeisImpostosRetidos senar = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)cont, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.SENAR);
                if (senar.getPlanoContaImpostoRetido() != null && senar.getPlanoContaGerencialImpostoRetido() != null) {
                    s = numTitulo;
                    numTitulo = (short)(numTitulo + 1);
                    dataTitulo = senar.getDiaVencimentoImpostoRetido() != null && senar.getDiaVencimentoImpostoRetido() > 0 ? AuxTitulosCooperados.getDataTitulo(senar.getDiaVencimentoImpostoRetido(), date) : vo.getDataEmissaoNota();
                    pessoaTitulo = senar.getPessoaImpostoRetido() != null ? senar.getPessoaImpostoRetido() : vo.getUnidadeFatCliente().getCliente().getPessoa();
                    ret.add(AuxTitulosCooperados.getTituloCooperado(pessoaTitulo, senar.getPlanoContaImpostoRetido(), senar.getPlanoContaGerencialImpostoRetido(), vo, "Senar de cooperado para a nota propria " + serie + " - " + nrNota + ", pessoa: " + pessoaTitulo.getNome(), vrSenar, dataTitulo, numTitulo, op));
                } else {
                    meio = "Imposto Senar. ";
                    throw new ExceptionGeracaoTitulos(start + meio + end);
                }
            }
            if (vrTaxaSanidadeAnimal > 0.0) {
                OpcoesContabeisImpostosRetidos taxaSanAnimal = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)cont, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.TAXA_SANIDADE_ANIMAL);
                if (taxaSanAnimal.getPlanoContaImpostoRetido() != null && taxaSanAnimal.getPlanoContaGerencialImpostoRetido() != null) {
                    s = numTitulo;
                    numTitulo = (short)(numTitulo + 1);
                    dataTitulo = taxaSanAnimal.getDiaVencimentoImpostoRetido() != null && taxaSanAnimal.getDiaVencimentoImpostoRetido() > 0 ? AuxTitulosCooperados.getDataTitulo(taxaSanAnimal.getDiaVencimentoImpostoRetido(), date) : vo.getDataEmissaoNota();
                    pessoaTitulo = taxaSanAnimal.getPessoaImpostoRetido() != null ? taxaSanAnimal.getPessoaImpostoRetido() : vo.getUnidadeFatCliente().getCliente().getPessoa();
                    ret.add(AuxTitulosCooperados.getTituloCooperado(pessoaTitulo, taxaSanAnimal.getPlanoContaImpostoRetido(), taxaSanAnimal.getPlanoContaGerencialImpostoRetido(), vo, "Taxa de Sanidade Animal (IMA) de cooperado para a nota propria " + serie + " - " + nrNota + ", pessoa: " + pessoaTitulo.getNome(), vrTaxaSanidadeAnimal, dataTitulo, numTitulo, op));
                } else {
                    meio = "Imposto Taxa Sanidade Animal. ";
                    throw new ExceptionGeracaoTitulos(start + meio + end);
                }
            }
            i.getTitulos().addAll(ret);
        }
    }

    private static Titulo getTituloCooperado(Pessoa p, PlanoConta pc, PlanoContaGerencial pcGer, NotaFiscalPropria nota, String obs, Double valor, Date dataTitulo, Short num, OpcoesFinanceiras op) {
        dataTitulo = dataTitulo != null ? dataTitulo : new Date();
        Titulo t = new Titulo();
        t.setDataCadastro(new Date());
        NotaFiscalPropria vo = nota;
        t.setDataEmissao(vo.getDataEmissaoNota());
        t.setDataCompetencia(vo.getDataEntradaSaida());
        t.setDataEntradaSaida(t.getDataCompetencia());
        t.setEmpresa(vo.getEmpresa());
        t.setDataVencimento(dataTitulo);
        t.setDataVencimentoBase(dataTitulo);
        t.setNaoCompoeFluxo(Short.valueOf((short)0));
        t.setObservacao(obs);
        t.setPagRec(AuxTitulosCooperados.getPagRec(nota));
        t.setPercJurosMes(Double.valueOf(0.0));
        t.setPessoa(p);
        if (nota.getClassificacaoCliente() != null) {
            t.setClassificacaoPessoa(nota.getClassificacaoCliente());
        } else {
            t.setClassificacaoPessoa(op.getClassificacaoClientes());
        }
        t.setNumParcTituloEstnota(num);
        t.setPlanoConta(pc);
        t.setProvisao(Short.valueOf((short)1));
        t.setTipoDoc(op.getTipoDocFinanceiro());
        t.setTipoPessoa(EnumConstPessoa.PESSOA.getEnumId());
        t.setValor(valor);
        t.setVrAbatimento(Double.valueOf(0.0));
        t.setVrDescontoCondicional(Double.valueOf(0.0));
        t.setVrIofPago(Double.valueOf(0.0));
        if (AuxTitulosCooperados.getPagRec(nota) == 1) {
            if (op.getPercJurosMes() != null && op.getPercJurosMes() > 0.0) {
                t.setPercJurosMes(op.getPercJurosMes());
                t.setVrJurosDia(Double.valueOf(t.getValor() * (t.getPercJurosMes() / 100.0) / 30.0));
            } else {
                t.setPercJurosMes(Double.valueOf(0.0));
                t.setVrJurosDia(Double.valueOf(0.0));
            }
        }
        t.setCarteiraCobranca(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(op).getCarteiraCobranca(t.getPagRec().shortValue()));
        LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, dataTitulo, dataTitulo, Short.valueOf(EnumLancamentoCTBGerencial.DEBITO.getValue()), t.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()), obs, pcGer, t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), null, valor, null);
        ArrayList<LancamentoCtbGerencial> aux = new ArrayList<LancamentoCtbGerencial>();
        aux.add(l);
        t.setLancCtbGerencial(aux);
        InfPagamentoNfPropria i = new InfPagamentoNfPropria();
        i.setMeioPagamento(op.getMeioPagamento());
        i.setValor(valor);
        i.setNotaFiscalPropria(nota);
        if (i.getMeioPagamento() != null) {
            i.setTipoPagamentoNFe(i.getMeioPagamento().getTipoPagamentoNFe());
        }
        t.setInfPagamentoNfPropria(i);
        t.setMeioPagamento(op.getMeioPagamento());
        return t;
    }

    private static Date getDataTitulo(Short dia, Date data) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        if (dia != null && dia > 0) {
            g.add(2, 1);
            g.set(5, dia.shortValue());
        }
        return g.getTime();
    }

    private static Short getPagRec(NotaFiscalPropria nota) {
        if (nota.getNaturezaOperacao().getEntradaSaida() == 1) {
            return (short)0;
        }
        return (short)1;
    }
}

