/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.titulos;

import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.DevolucaoPedComercio;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesFinanceirasTaxas;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.helpers.impl.lotecontabil.HelperLoteContabil;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import java.util.ArrayList;
import java.util.Date;
import mentorcore.utilities.CoreUtilityFactory;

public class AuxTitulosDevolucaoPedComercio {
    private final SCompPlanoConta scPlanoConta = (SCompPlanoConta)ConfApplicationContext.getBean(SCompPlanoConta.class);
    private final HelperLoteContabil helperLote = (HelperLoteContabil)Context.get(HelperLoteContabil.class);

    public Titulo criarTituloCreditoAntecipadoDevolucaoPedComercio(DevolucaoPedComercio vo, OpcoesFinanceiras op, EmpresaContabilidade empresaContabilidade, Short pagRec, OpcoesContabeis opcoesCont) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        Pessoa pessoa = null;
        PlanoConta pc = null;
        PlanoConta pcAntecipacao = null;
        PlanoContaGerencial planoContaGerencial = null;
        ClassificacaoClientes classificacaoClientes = null;
        if (vo.getNotaPropriaGerada() != null) {
            pessoa = vo.getNotaPropriaGerada().getUnidadeFatCliente().getCliente().getPessoa();
            pc = this.scPlanoConta.getPlanoConta(vo.getNotaPropriaGerada().getUnidadeFatCliente().getCliente(), opcoesCont);
            pcAntecipacao = this.scPlanoConta.getPlanoContaAntecip(vo.getNotaPropriaGerada().getUnidadeFatCliente().getCliente(), opcoesCont);
            classificacaoClientes = vo.getNotaPropriaGerada().getUnidadeFatCliente().getCliente().getClassificacaoClientes();
            if (pcAntecipacao == null) {
                throw new ExceptionGeracaoTitulos("Primeiro, cadastre o Plano de Contas de Antecipa\u00e7\u00e3o no cadastro de Cliente!");
            }
        }
        if (classificacaoClientes == null) {
            classificacaoClientes = op.getClassificacaoClientes();
        }
        short tipoPessoa = EnumConstPessoa.PESSOA.getEnumId();
        Object obs = "";
        if (pagRec.equals((short)1)) {
            planoContaGerencial = empresaContabilidade.getPlanoDevGerenRecebimento();
            obs = "Titulo antecipado (credito) para a pessoa: " + pessoa.getNome() + " referente a uma devolucao de pedido comercio";
        } else {
            planoContaGerencial = empresaContabilidade.getPlanoDevGerenPagamento();
            obs = "Titulo antecipado (debito) para a pessoa: " + pessoa.getNome() + " referente a uma devolucao de pedido comercio";
        }
        Titulo t = new Titulo();
        t.setAntecipado(Short.valueOf((short)1));
        t.setPagRec(pagRec);
        t.setProvisao(Short.valueOf((short)1));
        t.setCarteiraCobranca(op.getCarteiraCobranca());
        t.setTipoDoc(op.getTipoDocFinanceiro());
        t.setObservacao((String)obs);
        t.setNumeroParcelas(Short.valueOf((short)1));
        t.setValor(vo.getValorCredito());
        t.setValorMultaEmbutida(Double.valueOf(0.0));
        t.setValorJurosEmbutido(Double.valueOf(0.0));
        t.setDescontoFinanceiro(Double.valueOf(0.0));
        t.setValorAdicional(Double.valueOf(0.0));
        t.setNumParcTituloEstnota(Short.valueOf((short)1));
        t.setPessoa(pessoa);
        t.setClassificacaoPessoa(classificacaoClientes);
        t.setTipoPessoa(Short.valueOf(tipoPessoa));
        t.setDataEmissao(new Date());
        t.setDataVencimento(new Date());
        t.setDataVencimentoBase(new Date());
        t.setDataCompetencia(new Date());
        t.setDataEntradaSaida(t.getDataCompetencia());
        t.setEmpresa(vo.getEmpresa());
        t.setDataCadastro(new Date());
        t.setPlanoConta(pc);
        if (planoContaGerencial == null) {
            throw new ExceptionGeracaoTitulos("Primeiro, cadastre o Plano de Contas Gerencial para Devolu\u00e7\u00e3o de Recebimento e Pagamento em Empresa Contabilidade!");
        }
        t.getLancCtbGerencial().add(CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentoGerencialDevolucaoPedComercio(t.getValor(), planoContaGerencial, null, vo, vo.getEmpresa(), t.getDataVencimento(), pessoa));
        t.setLoteAdLancamentos(this.gerarLancamentosTitulos(t, vo, pc, pcAntecipacao, pessoa));
        t.setMeioPagamento(op.getMeioPagamento());
        this.setarPercJurosMultaDesconto(t, op);
        return t;
    }

    public LoteContabil gerarLancamentosTitulos(Titulo vo, DevolucaoPedComercio devolucaoPedComercio, PlanoConta pcClienteFornecedor, PlanoConta pcAntecipacao, Pessoa pessoa) {
        LoteContabil lote = this.helperLote.criaRecriaLoteContabil(vo.getLoteAdLancamentos(), vo.getDataCompetencia(), vo.getEmpresa(), ConstEnumOrigemLoteContabil.TITULO);
        Lancamento l = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)vo.getEmpresa());
        if (vo.getPagRec().equals((short)1)) {
            l.setPlanoContaCred(pcClienteFornecedor);
            l.setPlanoContaDeb(pcAntecipacao);
            l.setHistorico("Lancamento Adicional de Credito gerado pela devolucao da pessoa: " + pessoa.getNome());
        } else {
            l.setPlanoContaCred(pcAntecipacao);
            l.setPlanoContaDeb(pcClienteFornecedor);
            l.setHistorico("Lancamento Adicional de Debito gerado pela devolucao da pessoa: " + pessoa.getNome());
        }
        l.setGerado(Short.valueOf((short)0));
        l.setValor(vo.getValor());
        ArrayList<Lancamento> lanc = new ArrayList<Lancamento>();
        lanc.add(l);
        lote.setLancamentos(lanc);
        return lote;
    }

    private void setarPercJurosMultaDesconto(Titulo t, OpcoesFinanceiras op) {
        if (t.getPagRec() == 1) {
            Double percJuros = op.getPercJurosMes();
            Double percDesc = op.getPercDescMes();
            Double percMulta = op.getPercMulta();
            OpcoesFinanceirasTaxas opTaxas = this.getOpcoesFinanceirasTaxas(t.getMeioPagamento(), op);
            if (opTaxas != null) {
                percJuros = opTaxas.getPercJurosMes();
                percDesc = opTaxas.getPercDescMes();
                percMulta = opTaxas.getPercMulta();
            }
            if (percJuros != null) {
                t.setPercJurosMes(percJuros);
                t.setVrJurosDia(Double.valueOf(t.getValor() * (percJuros / 100.0) / 30.0));
            } else {
                t.setPercJurosMes(Double.valueOf(0.0));
                t.setVrJurosDia(Double.valueOf(0.0));
            }
            if (percDesc != null) {
                t.setPercDescontoMes(percDesc);
            } else {
                t.setPercDescontoMes(Double.valueOf(0.0));
            }
            if (percMulta != null) {
                t.setPercMulta(percMulta);
            } else {
                t.setPercMulta(Double.valueOf(0.0));
            }
        } else {
            t.setPercMulta(Double.valueOf(0.0));
            t.setPercJurosMes(Double.valueOf(0.0));
            t.setVrJurosDia(Double.valueOf(0.0));
            t.setPercDescontoMes(Double.valueOf(0.0));
        }
    }

    private OpcoesFinanceirasTaxas getOpcoesFinanceirasTaxas(MeioPagamento meioPagamento, OpcoesFinanceiras op) {
        if (meioPagamento != null) {
            for (OpcoesFinanceirasTaxas taxa : op.getTaxas()) {
                if (!taxa.getMeioPagamento().equals((Object)meioPagamento)) continue;
                return taxa;
            }
        }
        return null;
    }
}

