/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.titulos;

import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.DevolucaoVendas;
import com.touchcomp.basementor.model.vo.DevolucaoVendasNFPropria;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesFinanceirasTaxas;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.interfaces.VODocumento;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.model.VODevolucaoComprasVendas;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.model.nfce.VONFCe;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.model.nfp.VONFPropria;
import com.touchcomp.basementorservice.components.devolucaocomprasvendas.model.nft.VONFTerceiros;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.helpers.impl.lotecontabil.HelperLoteContabil;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfinanceiras.HelperOpcoesFinanceiras;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import java.util.ArrayList;
import java.util.Date;
import mentorcore.utilities.CoreUtilityFactory;

public class AuxTitulosDevolucaoVendas {
    private final SCompPlanoConta scPlanoConta = (SCompPlanoConta)ConfApplicationContext.getBean(SCompPlanoConta.class);
    private final HelperLoteContabil helperLote = (HelperLoteContabil)Context.get(HelperLoteContabil.class);

    public Titulo criarTituloDevolvido(VODevolucaoComprasVendas vo, OpcoesFinanceiras op, Date dataVencimento, EmpresaContabilidade empresaContabilidade, Short pagRec, MeioPagamento meioPagamento, OpcoesContabeis opcoesCont) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        PlanoConta pc;
        Pessoa pessoa = null;
        PlanoContaGerencial planoContaGerencial = null;
        ClassificacaoClientes classificacaoPessoa = null;
        if (vo.getOut().getNotaPropriaGerada() != null) {
            pessoa = vo.getOut().getNotaPropriaGerada().getUnidadeFatCliente().getCliente().getPessoa();
            if (vo.getParams().getRespeitarPlanoContaClienteFornecedor() == null || vo.getParams().getRespeitarPlanoContaClienteFornecedor().equals((short)0)) {
                pc = this.scPlanoConta.getPlanoConta(vo.getOut().getNotaPropriaGerada().getUnidadeFatCliente().getCliente(), opcoesCont);
            } else if (vo.getOut().getPlanoConta() != null) {
                pc = vo.getOut().getPlanoConta();
            } else {
                it = (ItemNotaFiscalPropria)vo.getOut().getNotaPropriaGerada().getItensNotaPropria().get(0);
                pc = it.getPlanoContaCred();
            }
            classificacaoPessoa = vo.getOut().getNotaPropriaGerada().getClassificacaoCliente();
        } else {
            pessoa = vo.getOut().getNotaTerceirosGerada().getUnidadeFatFornecedor().getFornecedor().getPessoa();
            if (vo.getParams().getRespeitarPlanoContaClienteFornecedor() == null || vo.getParams().getRespeitarPlanoContaClienteFornecedor().equals((short)0)) {
                pc = this.scPlanoConta.getPlanoConta(vo.getOut().getNotaTerceirosGerada().getUnidadeFatFornecedor().getFornecedor(), opcoesCont);
            } else if (vo.getOut().getPlanoConta() != null) {
                pc = vo.getOut().getPlanoConta();
            } else {
                it = (ItemNotaTerceiros)vo.getOut().getNotaTerceirosGerada().getItemNotaTerceiros().get(0);
                pc = it.getPlanoContaDeb();
            }
            classificacaoPessoa = vo.getOut().getNotaTerceirosGerada().getClassificacaoPessoas();
        }
        if (classificacaoPessoa == null) {
            classificacaoPessoa = op.getClassificacaoClientes();
        }
        short tipoPessoa = EnumConstPessoa.PESSOA.getEnumId();
        Object obs = "";
        if (pagRec.equals((short)0)) {
            obs = "Titulo a ser pago (devolucao de venda) para a pessoa: " + pessoa.getNome();
            planoContaGerencial = empresaContabilidade.getPlanoDevGerenPagamento();
        } else {
            obs = "Titulo a ser recebido (devolucao de compra) para a pessoa: " + pessoa.getNome();
            planoContaGerencial = empresaContabilidade.getPlanoDevGerenRecebimento();
        }
        Titulo t = new Titulo();
        t.setPagRec(pagRec);
        t.setProvisao(Short.valueOf((short)1));
        t.setCarteiraCobranca(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(op).getCarteiraCobranca(t.getPagRec().shortValue()));
        t.setTipoDoc(op.getTipoDocFinanceiro());
        t.setObservacao((String)obs);
        t.setNumeroParcelas(Short.valueOf((short)1));
        t.setValor(vo.getOut().getValorDevolver());
        t.setValorMultaEmbutida(Double.valueOf(0.0));
        t.setValorJurosEmbutido(Double.valueOf(0.0));
        t.setDescontoFinanceiro(Double.valueOf(0.0));
        t.setValorAdicional(Double.valueOf(0.0));
        t.setNumParcTituloEstnota(Short.valueOf((short)1));
        t.setPessoa(pessoa);
        t.setClassificacaoPessoa(classificacaoPessoa);
        t.setTipoPessoa(Short.valueOf(tipoPessoa));
        t.setDataEmissao(new Date());
        t.setDataVencimento(dataVencimento);
        t.setDataVencimentoBase(dataVencimento);
        t.setDataCompetencia(new Date());
        t.setDataEntradaSaida(t.getDataCompetencia());
        t.setEmpresa(vo.getOut().getEmpresa());
        t.setDataCadastro(new Date());
        t.setPlanoConta(pc);
        if (planoContaGerencial == null) {
            throw new ExceptionGeracaoTitulos("Primeiro, cadastre o Plano de Contas Gerencial para Devolu\u00e7\u00e3o de Recebimento e Pagamento em Empresa Contabilidade!");
        }
        t.getLancCtbGerencial().add(CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentoGerencialDevolucaoVendas(t.getValor(), planoContaGerencial, null, vo.getOut().getEmpresa(), dataVencimento, pessoa));
        t.setMeioPagamento(meioPagamento);
        if (t.getMeioPagamento() == null) {
            t.setMeioPagamento(op.getMeioPagamento());
        }
        this.setarPercJurosMultaDesconto(t, op);
        return t;
    }

    public Titulo criarTituloCreditoAntecipadoDevolucaoVendas(VODevolucaoComprasVendas vo, OpcoesFinanceiras op, EmpresaContabilidade empresaContabilidade, Short pagRec, Pessoa pessoa, PlanoConta pc, PlanoConta pcAntecipacao) throws ExceptionGeracaoTitulos {
        short tipoPessoa = EnumConstPessoa.PESSOA.getEnumId();
        String obs = "";
        PlanoContaGerencial planoContaGerencial = null;
        if (pagRec.equals((short)1)) {
            obs = this.getObservacaoTituloAntecipado(vo, pessoa, (Short)1);
            planoContaGerencial = empresaContabilidade.getPlanoDevGerenRecebimento();
        } else {
            obs = this.getObservacaoTituloAntecipado(vo, pessoa, (Short)0);
            planoContaGerencial = empresaContabilidade.getPlanoDevGerenPagamento();
        }
        Titulo t = new Titulo();
        t.setAntecipado(Short.valueOf((short)1));
        t.setPagRec(pagRec);
        t.setProvisao(Short.valueOf((short)1));
        t.setCarteiraCobranca(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(op).getCarteiraCobranca(t.getPagRec().shortValue()));
        t.setTipoDoc(op.getTipoDocFinanceiro());
        t.setObservacao(obs);
        t.setNumeroParcelas(Short.valueOf((short)1));
        t.setValor(vo.getOut().getValorCredito());
        t.setValorMultaEmbutida(Double.valueOf(0.0));
        t.setValorJurosEmbutido(Double.valueOf(0.0));
        t.setDescontoFinanceiro(Double.valueOf(0.0));
        t.setValorAdicional(Double.valueOf(0.0));
        t.setNumParcTituloEstnota(Short.valueOf((short)1));
        t.setPessoa(pessoa);
        t.setClassificacaoPessoa(op.getClassificacaoClientes());
        t.setTipoPessoa(Short.valueOf(tipoPessoa));
        t.setDataEmissao(new Date());
        t.setDataVencimento(new Date());
        t.setDataVencimentoBase(new Date());
        t.setDataCompetencia(new Date());
        t.setDataEntradaSaida(t.getDataCompetencia());
        t.setEmpresa(vo.getOut().getEmpresa());
        t.setDataCadastro(new Date());
        t.setPlanoConta(pcAntecipacao);
        if (planoContaGerencial == null) {
            throw new ExceptionGeracaoTitulos("Primeiro, cadastre o Plano de Contas Gerencial para Devolu\u00e7\u00e3o de Recebimento e Pagamento em Empresa Contabilidade!");
        }
        t.getLancCtbGerencial().add(CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentoGerencialDevolucaoVendas(t.getValor(), planoContaGerencial, null, vo.getOut().getEmpresa(), t.getDataVencimento(), pessoa));
        if (vo.getParams().getNaoGerarLancAdicional() == null || vo.getParams().getNaoGerarLancAdicional().equals((short)0)) {
            t.setLoteAdLancamentos(this.gerarLancamentosTitulos(t, pc, pcAntecipacao, pessoa));
        }
        this.setarPercJurosMultaDesconto(t, op);
        return t;
    }

    public LoteContabil gerarLancamentosTitulos(Titulo vo, PlanoConta pcClienteFornecedor, PlanoConta pcAntecipacao, Pessoa pessoa) {
        LoteContabil lote = this.helperLote.criaRecriaLoteContabil(vo.getLoteAdLancamentos(), vo.getDataCompetencia(), vo.getEmpresa(), ConstEnumOrigemLoteContabil.DEVOL_VENDAS);
        Lancamento l = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)vo.getEmpresa());
        if (vo.getPagRec().equals((short)0)) {
            l.setPlanoContaCred(pcClienteFornecedor);
            l.setPlanoContaDeb(pcAntecipacao);
            l.setHistorico("Lancamento Adicional de Debito gerado pela devolucao da pessoa: " + pessoa.getNome());
        } else {
            l.setPlanoContaCred(pcAntecipacao);
            l.setPlanoContaDeb(pcClienteFornecedor);
            l.setHistorico("Lancamento Adicional de Credito gerado pela devolucao da pessoa: " + pessoa.getNome());
        }
        l.setValor(vo.getValor());
        ArrayList<Lancamento> lanc = new ArrayList<Lancamento>();
        lanc.add(l);
        lote.setLancamentos(lanc);
        return lote;
    }

    private String getObservacaoTituloAntecipado(VODevolucaoComprasVendas vo, Pessoa pessoa, Short pagRec) {
        VONFPropria v;
        int count;
        StringBuilder sbb;
        StringBuilder sb = new StringBuilder();
        if (pagRec.equals((short)1)) {
            sb.append("Titulo antecipado (credito) para a pessoa: ");
        } else {
            sb.append("Titulo antecipado (debito) para a pessoa: ");
        }
        sb.append(pessoa.getNome());
        if (vo.getOut().getNotaTerceirosGerada() != null && vo.getOut().getNotaTerceirosGerada().getNumeroNota() != null) {
            sb.append(". NF Terceiros gerada: ");
            sb.append(vo.getOut().getNotaTerceirosGerada().getNumeroNota().toString());
        }
        for (VODocumento voDoc : vo.getNotasOrigem()) {
            sbb = new StringBuilder();
            sbb.append(". Notas Proprias Devolvidas: ");
            count = 1;
            if (voDoc instanceof VONFPropria) {
                v = (VONFPropria)voDoc;
                sb.append(v.getSource().getNumeroNota().toString());
                if (count == vo.getNotasOrigem().size()) {
                    sb.append(".");
                } else {
                    sb.append(", ");
                }
                ++count;
            }
            if (count <= true) continue;
            sb.append(sbb.toString());
        }
        for (VODocumento voDoc : vo.getNotasOrigem()) {
            sbb = new StringBuilder();
            sbb.append(". Notas Terceiros Devolvidas: ");
            count = 1;
            if (voDoc instanceof VONFTerceiros) {
                v = (VONFTerceiros)voDoc;
                sb.append(v.getSource().getNumeroNota().toString());
                if (count == vo.getNotasOrigem().size()) {
                    sb.append(".");
                } else {
                    sb.append(", ");
                }
                ++count;
            }
            if (count <= true) continue;
            sb.append(sbb.toString());
        }
        for (VODocumento voDoc : vo.getNotasOrigem()) {
            sbb = new StringBuilder();
            sbb.append(". NFCe\u00b4s Devolvidas: ");
            count = 1;
            if (voDoc instanceof VONFCe) {
                v = (VONFCe)voDoc;
                sb.append(v.getSource().getNumero().toString());
                if (count == vo.getNotasOrigem().size()) {
                    sb.append(".");
                } else {
                    sb.append(", ");
                }
                ++count;
            }
            if (count <= 1) continue;
            sb.append(sbb.toString());
        }
        return sb.toString();
    }

    private void setarPercJurosMultaDesconto(Titulo t, OpcoesFinanceiras op) {
        if (t.getPagRec() == 1) {
            Double percJuros = op.getPercJurosMes();
            Double percDesc = op.getPercDescMes();
            Double percMulta = op.getPercMulta();
            OpcoesFinanceirasTaxas opTaxas = this.getOpcoesFinanceirasTaxas(t.getMeioPagamento(), op);
            if (opTaxas != null) {
                percJuros = opTaxas.getPercJurosMes();
                percDesc = opTaxas.getPercDescMes();
                percMulta = opTaxas.getPercMulta();
            }
            if (percJuros != null) {
                t.setPercJurosMes(percJuros);
                t.setVrJurosDia(Double.valueOf(t.getValor() * (percJuros / 100.0) / 30.0));
            } else {
                t.setPercJurosMes(Double.valueOf(0.0));
                t.setVrJurosDia(Double.valueOf(0.0));
            }
            if (percDesc != null) {
                t.setPercDescontoMes(percDesc);
            } else {
                t.setPercDescontoMes(Double.valueOf(0.0));
            }
            if (percMulta != null) {
                t.setPercMulta(percMulta);
            } else {
                t.setPercMulta(Double.valueOf(0.0));
            }
        } else {
            t.setPercMulta(Double.valueOf(0.0));
            t.setPercJurosMes(Double.valueOf(0.0));
            t.setVrJurosDia(Double.valueOf(0.0));
            t.setPercDescontoMes(Double.valueOf(0.0));
        }
    }

    private OpcoesFinanceirasTaxas getOpcoesFinanceirasTaxas(MeioPagamento meioPagamento, OpcoesFinanceiras op) {
        if (meioPagamento != null) {
            for (OpcoesFinanceirasTaxas taxa : op.getTaxas()) {
                if (!taxa.getMeioPagamento().equals((Object)meioPagamento)) continue;
                return taxa;
            }
        }
        return null;
    }

    public Titulo criarTituloDevolvido(DevolucaoVendas vo, OpcoesFinanceiras op, Date dataVencimento, EmpresaContabilidade empresaContabilidade, Short pagRec, MeioPagamento meioPagamento, OpcoesContabeis opcoesCont) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        PlanoConta pc;
        Pessoa pessoa = null;
        PlanoContaGerencial planoContaGerencial = null;
        ClassificacaoClientes classificacaoPessoa = null;
        if (vo.getNotaPropriaGerada() != null) {
            pessoa = vo.getNotaPropriaGerada().getUnidadeFatCliente().getCliente().getPessoa();
            if (vo.getRespeitarPlanoContaClienteFornecedor() == null || vo.getRespeitarPlanoContaClienteFornecedor().equals((short)0)) {
                pc = this.scPlanoConta.getPlanoConta(vo.getNotaPropriaGerada().getUnidadeFatCliente().getCliente(), opcoesCont);
            } else if (vo.getPlanoConta() != null) {
                pc = vo.getPlanoConta();
            } else {
                it = (ItemNotaFiscalPropria)vo.getNotaPropriaGerada().getItensNotaPropria().get(0);
                pc = it.getPlanoContaCred();
            }
            classificacaoPessoa = vo.getNotaPropriaGerada().getClassificacaoCliente();
        } else {
            pessoa = vo.getNotaTerceirosGerada().getUnidadeFatFornecedor().getFornecedor().getPessoa();
            if (vo.getRespeitarPlanoContaClienteFornecedor() == null || vo.getRespeitarPlanoContaClienteFornecedor().equals((short)0)) {
                pc = this.scPlanoConta.getPlanoConta(vo.getNotaTerceirosGerada().getUnidadeFatFornecedor().getFornecedor(), opcoesCont);
            } else if (vo.getPlanoConta() != null) {
                pc = vo.getPlanoConta();
            } else {
                it = (ItemNotaTerceiros)vo.getNotaTerceirosGerada().getItemNotaTerceiros().get(0);
                pc = it.getPlanoContaDeb();
            }
            classificacaoPessoa = vo.getNotaTerceirosGerada().getClassificacaoPessoas();
        }
        if (classificacaoPessoa == null) {
            classificacaoPessoa = op.getClassificacaoClientes();
        }
        short tipoPessoa = EnumConstPessoa.PESSOA.getEnumId();
        Object obs = "";
        if (pagRec.equals((short)0)) {
            obs = "Titulo a ser pago (devolucao de venda) para a pessoa: " + pessoa.getNome();
            planoContaGerencial = empresaContabilidade.getPlanoDevGerenPagamento();
        } else {
            obs = "Titulo a ser recebido (devolucao de compra) para a pessoa: " + pessoa.getNome();
            planoContaGerencial = empresaContabilidade.getPlanoDevGerenRecebimento();
        }
        Titulo t = new Titulo();
        t.setPagRec(pagRec);
        t.setProvisao(Short.valueOf((short)1));
        t.setCarteiraCobranca(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(op).getCarteiraCobranca(t.getPagRec().shortValue()));
        t.setTipoDoc(op.getTipoDocFinanceiro());
        t.setObservacao((String)obs);
        t.setNumeroParcelas(Short.valueOf((short)1));
        t.setValor(vo.getValorDevolver());
        t.setValorMultaEmbutida(Double.valueOf(0.0));
        t.setValorJurosEmbutido(Double.valueOf(0.0));
        t.setDescontoFinanceiro(Double.valueOf(0.0));
        t.setValorAdicional(Double.valueOf(0.0));
        t.setNumParcTituloEstnota(Short.valueOf((short)1));
        t.setPessoa(pessoa);
        t.setClassificacaoPessoa(classificacaoPessoa);
        t.setTipoPessoa(Short.valueOf(tipoPessoa));
        t.setDataEmissao(new Date());
        t.setDataVencimento(dataVencimento);
        t.setDataVencimentoBase(dataVencimento);
        t.setDataCompetencia(new Date());
        t.setDataEntradaSaida(t.getDataCompetencia());
        t.setEmpresa(vo.getEmpresa());
        t.setDataCadastro(new Date());
        t.setPlanoConta(pc);
        if (planoContaGerencial == null) {
            throw new ExceptionGeracaoTitulos("Primeiro, cadastre o Plano de Contas Gerencial para Devolu\u00e7\u00e3o de Recebimento e Pagamento em Empresa Contabilidade!");
        }
        t.getLancCtbGerencial().add(CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentoGerencialDevolucaoVendas(t.getValor(), planoContaGerencial, null, vo.getEmpresa(), dataVencimento, pessoa));
        t.setMeioPagamento(meioPagamento);
        if (t.getMeioPagamento() == null) {
            t.setMeioPagamento(op.getMeioPagamento());
        }
        this.setarPercJurosMultaDesconto(t, op);
        return t;
    }

    public Titulo criarTituloCreditoAntecipadoDevolucaoVendas(DevolucaoVendas vo, OpcoesFinanceiras op, EmpresaContabilidade empresaContabilidade, Short pagRec, Pessoa pessoa, PlanoConta pc, PlanoConta pcAntecipacao) throws ExceptionGeracaoTitulos {
        short tipoPessoa = EnumConstPessoa.PESSOA.getEnumId();
        String obs = "";
        PlanoContaGerencial planoContaGerencial = null;
        if (pagRec.equals((short)1)) {
            obs = this.getObservacaoTituloAntecipado(vo, pessoa, (Short)1);
            planoContaGerencial = empresaContabilidade.getPlanoDevGerenRecebimento();
        } else {
            obs = this.getObservacaoTituloAntecipado(vo, pessoa, (Short)0);
            planoContaGerencial = empresaContabilidade.getPlanoDevGerenPagamento();
        }
        Titulo t = new Titulo();
        t.setAntecipado(Short.valueOf((short)1));
        t.setPagRec(pagRec);
        t.setProvisao(Short.valueOf((short)1));
        t.setCarteiraCobranca(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(op).getCarteiraCobranca(t.getPagRec().shortValue()));
        t.setTipoDoc(op.getTipoDocFinanceiro());
        t.setObservacao(obs);
        t.setNumeroParcelas(Short.valueOf((short)1));
        t.setValor(vo.getValorCredito());
        t.setValorMultaEmbutida(Double.valueOf(0.0));
        t.setValorJurosEmbutido(Double.valueOf(0.0));
        t.setDescontoFinanceiro(Double.valueOf(0.0));
        t.setValorAdicional(Double.valueOf(0.0));
        t.setNumParcTituloEstnota(Short.valueOf((short)1));
        t.setPessoa(pessoa);
        t.setClassificacaoPessoa(op.getClassificacaoClientes());
        t.setTipoPessoa(Short.valueOf(tipoPessoa));
        t.setDataEmissao(new Date());
        t.setDataVencimento(new Date());
        t.setDataVencimentoBase(new Date());
        t.setDataCompetencia(new Date());
        t.setDataEntradaSaida(t.getDataCompetencia());
        t.setEmpresa(vo.getEmpresa());
        t.setDataCadastro(new Date());
        t.setPlanoConta(pcAntecipacao);
        if (planoContaGerencial == null) {
            throw new ExceptionGeracaoTitulos("Primeiro, cadastre o Plano de Contas Gerencial para Devolu\u00e7\u00e3o de Recebimento e Pagamento em Empresa Contabilidade!");
        }
        t.getLancCtbGerencial().add(CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentoGerencialDevolucaoVendas(t.getValor(), planoContaGerencial, null, vo.getEmpresa(), t.getDataVencimento(), pessoa));
        if (vo.getNaoGerarLancAdicional() == null || vo.getNaoGerarLancAdicional().equals((short)0)) {
            t.setLoteAdLancamentos(this.gerarLancamentosTitulos(t, vo, pc, pcAntecipacao, pessoa));
        }
        this.setarPercJurosMultaDesconto(t, op);
        return t;
    }

    public LoteContabil gerarLancamentosTitulos(Titulo vo, DevolucaoVendas devolucaoVendas, PlanoConta pcClienteFornecedor, PlanoConta pcAntecipacao, Pessoa pessoa) {
        LoteContabil lote = this.helperLote.criaRecriaLoteContabil(vo.getLoteAdLancamentos(), vo.getDataCompetencia(), vo.getEmpresa(), ConstEnumOrigemLoteContabil.DEVOL_VENDAS);
        Lancamento l = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)vo.getEmpresa());
        if (vo.getPagRec().equals((short)0)) {
            l.setPlanoContaCred(pcClienteFornecedor);
            l.setPlanoContaDeb(pcAntecipacao);
            l.setHistorico("Lancamento Adicional de Debito gerado pela devolucao da pessoa: " + pessoa.getNome());
        } else {
            l.setPlanoContaCred(pcAntecipacao);
            l.setPlanoContaDeb(pcClienteFornecedor);
            l.setHistorico("Lancamento Adicional de Credito gerado pela devolucao da pessoa: " + pessoa.getNome());
        }
        l.setValor(vo.getValor());
        ArrayList<Lancamento> lanc = new ArrayList<Lancamento>();
        lanc.add(l);
        lote.setLancamentos(lanc);
        return lote;
    }

    private String getObservacaoTituloAntecipado(DevolucaoVendas vo, Pessoa pessoa, Short pagRec) {
        int count;
        StringBuilder sb = new StringBuilder();
        if (pagRec.equals((short)1)) {
            sb.append("Titulo antecipado (credito) para a pessoa: ");
        } else {
            sb.append("Titulo antecipado (debito) para a pessoa: ");
        }
        sb.append(pessoa.getNome());
        if (vo.getNotaTerceirosGerada() != null && vo.getNotaTerceirosGerada().getNumeroNota() != null) {
            sb.append(". NF Terceiros gerada: ");
            sb.append(vo.getNotaTerceirosGerada().getNumeroNota().toString());
        }
        if (vo.getNotasPropriaDevolvida() != null && !vo.getNotasPropriaDevolvida().isEmpty()) {
            sb.append(". Notas Proprias Devolvidas: ");
            count = 1;
            for (DevolucaoVendasNFPropria n : vo.getNotasPropriaDevolvida()) {
                sb.append(n.getNotaFiscalPropria().getNumeroNota().toString());
                if (count == vo.getNotasPropriaDevolvida().size()) {
                    sb.append(".");
                } else {
                    sb.append(", ");
                }
                ++count;
            }
        }
        if (vo.getNotasTerceirosDevolvida() != null && !vo.getNotasTerceirosDevolvida().isEmpty()) {
            sb.append(". Notas Terceiros Devolvidas: ");
            count = 1;
            for (DevolucaoVendasNFPropria n : vo.getNotasTerceirosDevolvida()) {
                sb.append(n.getNotaFiscalTerceiros().getNumeroNota().toString());
                if (count == vo.getNotasTerceirosDevolvida().size()) {
                    sb.append(".");
                } else {
                    sb.append(", ");
                }
                ++count;
            }
        }
        return sb.toString();
    }
}

