/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.titulos;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.vo.InfPagamentoNfPropria;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesContabeisDifal;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;

class AuxTitulosDifal {
    AuxTitulosDifal() {
    }

    void calcularTitulosDifal(InfPagamentoNfPropria infPagamento, NotaFiscalPropria vo, Double valorTotalNota, OpcoesFinanceiras op, OpcoesContabeis cont, OpcoesContabeisDifal difalUF) throws ExceptionGeracaoTitulos {
        ArrayList<Titulo> retidos = new ArrayList<Titulo>();
        String serie = vo.getSerie();
        Integer nrNota = vo.getNumeroNota();
        double vrIcmsDifal = 0.0;
        for (ItemNotaFiscalPropria in : vo.getItensNotaPropria()) {
            vrIcmsDifal += in.getItemNotaLivroFiscal().getValorIcmsPartilhaDest().doubleValue();
        }
        Date date = AuxTitulosDifal.getDataTitulo(difalUF.getDiaDifal(), vo.getDataEmissaoNota());
        Short numeroTitulo = 1;
        if (vrIcmsDifal > 0.0) {
            retidos.add(AuxTitulosDifal.getTituloDifal(difalUF.getPessoa(), difalUF.getPlanoConta(), difalUF.getPlanoGerencial(), vo, "Guia referente ao Difal, pessoa: " + difalUF.getPessoa().getNome() + "data venc.: " + ToolDate.dateToStr((Date)date), vrIcmsDifal, date, numeroTitulo, op, (short)0));
        }
        for (Titulo t : retidos) {
            t.setInfPagamentoNfPropria(infPagamento);
        }
        infPagamento.getTitulos().addAll(retidos);
    }

    private static Titulo getTituloDifal(Pessoa p, PlanoConta pc, PlanoContaGerencial pcGer, NotaFiscalPropria vo, String obs, Double valor, Date dataTitulo, Short num, OpcoesFinanceiras op, Short tipoTitulo) {
        dataTitulo = dataTitulo != null ? dataTitulo : new Date();
        Titulo t = new Titulo();
        t.setCarteiraCobranca(op.getCarteiraCobranca());
        t.setDataCadastro(new Date());
        t.setDataEmissao(vo.getDataEmissaoNota());
        t.setDataCompetencia(vo.getDataEmissaoNota());
        t.setDataEntradaSaida(t.getDataCompetencia());
        t.setEmpresa(vo.getEmpresa());
        t.setDataVencimento(dataTitulo);
        t.setDataVencimentoBase(dataTitulo);
        t.setNaoCompoeFluxo(Short.valueOf((short)0));
        t.setNumParcTituloEstnota(Short.valueOf((short)1));
        t.setObservacao(obs);
        t.setPagRec(tipoTitulo);
        t.setPercJurosMes(Double.valueOf(0.0));
        t.setPessoa(p);
        if (vo.getClassificacaoCliente() != null) {
            t.setClassificacaoPessoa(vo.getClassificacaoCliente());
        } else {
            t.setClassificacaoPessoa(op.getClassificacaoClientes());
        }
        t.setNumParcTituloEstnota(num);
        t.setPlanoConta(pc);
        t.setProvisao(Short.valueOf((short)1));
        t.setTipoDoc(op.getTipoDocFinanceiro());
        t.setTipoPessoa(EnumConstPessoa.PESSOA.getEnumId());
        t.setValor(valor);
        t.setVrAbatimento(Double.valueOf(0.0));
        t.setVrDescontoCondicional(Double.valueOf(0.0));
        t.setVrIofPago(Double.valueOf(0.0));
        t.setVrJurosDia(Double.valueOf(0.0));
        LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, dataTitulo, dataTitulo, Short.valueOf(EnumLancamentoCTBGerencial.DEBITO.getValue()), t.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()), obs, pcGer, Short.valueOf(EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue()), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), null, valor, null);
        ArrayList<LancamentoCtbGerencial> aux = new ArrayList<LancamentoCtbGerencial>();
        aux.add(l);
        t.setLancCtbGerencial(aux);
        return t;
    }

    private static Date getDataTitulo(Short dia, Date data) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        if (dia != null && dia > 0) {
            g.add(2, 1);
            g.set(5, dia.shortValue());
        }
        return g.getTime();
    }
}

