/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.titulos;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.eventocooperado.EnumConstEventoCooperado;
import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.vo.ApuracaoValoresCooperados;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.CentroResultadoContFin;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Cooperado;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoCooperado;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.LancamentoEventoCooperado;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.LoteLancamentoEventoCooperado;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesFinanceirasTaxas;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.TipoDoc;
import com.touchcomp.basementor.model.vo.TipoValoresTitulosEventoCooperado;
import com.touchcomp.basementor.model.vo.TipoValoresTitulosTitulos;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorservice.helpers.impl.lotecontabil.HelperLoteContabil;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfinanceiras.HelperOpcoesFinanceiras;
import com.touchcomp.basementorservice.service.impl.geracaocontapessoa.ServiceGeracaoContaPessoaImpl;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.titulos.AuxTitulos;

public class AuxTitulosFolhaLeite {
    private final SCompPlanoConta scPlanoConta = (SCompPlanoConta)ConfApplicationContext.getBean(SCompPlanoConta.class);
    private final HelperLoteContabil helperLote = (HelperLoteContabil)Context.get(HelperLoteContabil.class);

    public LancamentoEventoCooperado createTitulo(LancamentoEventoCooperado vo, OpcoesFinanceiras opcoes, OpcoesContabeis opContabeis, CentroResultadoContFin centroResultadoContFin) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        vo.setTitulos(new ArrayList());
        Short tipoTitulo = this.getTipoTitulo(vo);
        Object obs = "";
        if (vo.getCooperado() != null) {
            obs = "Movimentacao do Cooperado: " + vo.getCooperado().getCliente().getPessoa().getNome();
        } else if (vo.getCliente() != null) {
            obs = "Movimentacao do Cliente: " + vo.getCliente().getPessoa().getNome();
        }
        obs = (String)obs + ". Evento: " + vo.getEventoCooperado().getDescricao();
        short tipoPessoa = EnumConstPessoa.PESSOA.getEnumId();
        ArrayList<Titulo> titulos = new ArrayList<Titulo>();
        PlanoConta pc = vo.getEventoCooperado().getPlanoContaContabil();
        if (pc == null) {
            pc = vo.getCooperado() != null ? this.getPCCooperado(vo.getCooperado(), opContabeis) : this.scPlanoConta.getPlanoConta(vo.getCliente(), opContabeis);
        }
        vo.setPlanoContaContabil(pc);
        Pessoa pessoa = vo.getCooperado() != null ? vo.getCooperado().getCliente().getPessoa() : vo.getCliente().getPessoa();
        ClassificacaoClientes classificacaoPessoa = this.getClassificacaoCliente(vo);
        if (vo.getCondicoesPagamento() == null || vo.getDataVencimento() != null) {
            Titulo titulo = this.createTitulo(tipoTitulo, opcoes, (String)obs, pessoa, vo.getDataMovimento(), vo.getEmpresa(), pc, vo.getEventoCooperado().getPlanoContaGerencial(), vo.getValorOperacao(), vo.getEventoCooperado().getMeioPagamento(), vo.getDataVencimento(), classificacaoPessoa, vo.getEventoCooperado());
            titulos.add(titulo);
        } else if (vo.getCondicoesPagamento().getCondMutante() != null && vo.getCondicoesPagamento().getCondMutante().shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
            titulos.addAll(new AuxTitulos().getTitulosMutanteInternal(vo.getCondicoesPagamento(), pessoa, vo.getValorOperacao(), pc, 0.0, vo.getParcelas(), tipoPessoa, tipoTitulo, (short)1, vo.getDataMovimento(), (String)obs, vo.getDataMovimento(), vo.getDataMovimento(), vo.getDataCadastro(), vo.getDataMovimento(), vo.getEmpresa(), opcoes, vo.getEventoCooperado().getMeioPagamento(), classificacaoPessoa));
        } else {
            titulos.addAll(new AuxTitulos().getTitulosNaoMutanteInternal(vo.getCondicoesPagamento(), pessoa, vo.getValorOperacao(), pc, 0.0, tipoPessoa, tipoTitulo, (short)1, vo.getDataMovimento(), (String)obs, vo.getDataMovimento(), vo.getDataMovimento(), vo.getDataCadastro(), vo.getDataMovimento(), vo.getEmpresa(), opcoes, vo.getEventoCooperado().getMeioPagamento(), classificacaoPessoa));
        }
        if (vo.getEventoCooperado().getPercJuros() > 0.0) {
            for (Titulo t : titulos) {
                Double valorJuros = ToolFormatter.arrredondarNumero((Double)(t.getValor() * (vo.getEventoCooperado().getPercJuros() / 100.0)), (int)2);
                t.setValor(Double.valueOf(t.getValor() + valorJuros));
                t.setValorJurosEmbutido(valorJuros);
            }
        }
        if (vo.getEventoCooperado().getPercDesconto() > 0.0) {
            for (Titulo t : titulos) {
                Double valorDesconto = ToolFormatter.arrredondarNumero((Double)(t.getValor() * (vo.getEventoCooperado().getPercDesconto() / 100.0)), (int)2);
                t.setValor(Double.valueOf(t.getValor() + valorDesconto));
                t.setValorDescontosEmbutido(valorDesconto);
            }
        }
        if (ToolMethods.isNotNull((Object)vo.getEventoCooperado()).booleanValue()) {
            for (TipoValoresTitulosEventoCooperado tt : vo.getEventoCooperado().getTipoValoresTitulosEventoCooperado()) {
                if (!(tt.getValor() > 0.0)) continue;
                Double percentual = tt.getValor();
                for (Titulo titulo : titulos) {
                    TipoValoresTitulosTitulos tv = new TipoValoresTitulosTitulos();
                    tv.setTipoValoresTitulos(tt.getTipoValoresTitulos());
                    tv.setTitulo(titulo);
                    Double valor = ToolFormatter.arrredondarNumero((Double)(titulo.getValor() * percentual / 100.0), (int)2);
                    tv.setValor(valor);
                    titulo.setValor(Double.valueOf(titulo.getValor() + valor));
                    titulo.getTipoValoresTitulosTitulos().add(tv);
                }
            }
        }
        CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentosCTBGerencial(vo, titulos, (Boolean)false);
        this.gerarLancContabilAdicionalDocFinanceiro(vo, opContabeis, centroResultadoContFin);
        if (vo.getEventoCooperado().getRepasse().equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            ArrayList<Titulo> titulosRepasse = new ArrayList<Titulo>();
            Short tipoTituloRepasse = this.getTipoTituloRepasse(vo.getEventoCooperado());
            obs = "Titulo Repasse para: " + vo.getPessoaTerceiros().getNome();
            obs = (String)obs + ". Evento: " + vo.getEventoCooperado().getDescricao();
            if (vo.getCondicoesPagamento() == null) {
                MeioPagamento meioPagamento = vo.getEventoCooperado().getMeioPagamento();
                if (vo.getMeioPagamentoRepasse() != null) {
                    meioPagamento = vo.getMeioPagamentoRepasse();
                }
                Titulo tituloRepasse = this.createTitulo(tipoTituloRepasse, opcoes, (String)obs, vo.getPessoaTerceiros(), vo.getDataMovimento(), vo.getEmpresa(), vo.getEventoCooperado().getPlanoContaContabilRepasse(), vo.getEventoCooperado().getPlanoContaGerencial(), vo.getValorOperacao(), meioPagamento, vo.getDataVencimentoRepasse(), vo.getEventoCooperado().getClassificacaoPessoaRepasse(), vo.getEventoCooperado());
                tituloRepasse.setLancamentoCooperado(vo);
                titulosRepasse.add(tituloRepasse);
            } else if (vo.getCondicoesPagamento().getCondMutante() != null && vo.getCondicoesPagamento().getCondMutante().shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
                titulosRepasse.addAll(new AuxTitulos().getTitulosMutanteInternal(vo.getCondicoesPagamento(), vo.getPessoaTerceiros(), vo.getValorOperacao(), pc, 0.0, vo.getParcelas(), tipoPessoa, tipoTituloRepasse, (short)1, vo.getDataMovimento(), (String)obs, vo.getDataMovimento(), vo.getDataMovimento(), vo.getDataCadastro(), vo.getDataMovimento(), vo.getEmpresa(), opcoes, vo.getEventoCooperado().getMeioPagamento(), vo.getEventoCooperado().getClassificacaoPessoaRepasse()));
            } else {
                titulosRepasse.addAll(new AuxTitulos().getTitulosNaoMutanteInternal(vo.getCondicoesPagamento(), vo.getPessoaTerceiros(), vo.getValorOperacao(), pc, 0.0, tipoPessoa, tipoTituloRepasse, (short)1, vo.getDataMovimento(), (String)obs, vo.getDataMovimento(), vo.getDataMovimento(), vo.getDataCadastro(), vo.getDataMovimento(), vo.getEmpresa(), opcoes, vo.getEventoCooperado().getMeioPagamento(), vo.getEventoCooperado().getClassificacaoPessoaRepasse()));
            }
            if (vo.getDataVencimentoRepasse() != null) {
                for (Titulo t : titulosRepasse) {
                    t.setDataVencimento(vo.getDataVencimentoRepasse());
                    t.setDataVencimentoBase(vo.getDataVencimentoRepasse());
                }
            }
            if (vo.getEventoCooperado().getPercJurosRepasse() > 0.0) {
                for (Titulo t : titulosRepasse) {
                    Double valorJuros = ToolFormatter.arrredondarNumero((Double)(t.getValor() * (vo.getEventoCooperado().getPercJurosRepasse() / 100.0)), (int)2);
                    t.setValor(Double.valueOf(t.getValor() + valorJuros));
                    t.setValorJurosEmbutido(valorJuros);
                }
            }
            if (vo.getEventoCooperado().getPercDescontoRepasse() > 0.0) {
                for (Titulo t : titulosRepasse) {
                    Double valorDesconto = ToolFormatter.arrredondarNumero((Double)(t.getValor() * (vo.getEventoCooperado().getPercDescontoRepasse() / 100.0)), (int)2);
                    t.setValor(Double.valueOf(t.getValor() - valorDesconto));
                }
            }
            CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentosCTBGerencial(vo, titulosRepasse, (Boolean)true);
            titulos.addAll(titulosRepasse);
        }
        for (Titulo t : titulos) {
            t.setLancamentoCooperado(vo);
        }
        vo.setTitulos(titulos);
        return vo;
    }

    public Titulo createTitulo(Short tipoTitulo, OpcoesFinanceiras opcoesFinanceira, String obs, Pessoa pessoa, Date dataMovimento, Empresa empresa, PlanoConta planoConta, PlanoContaGerencial planoContaGerencial, Double valorTitulo, MeioPagamento meioPagamento, Date dataVencimento, ClassificacaoClientes classificacao, EventoCooperado eventoCooperado) {
        Titulo t = new Titulo();
        t.setPagRec(tipoTitulo);
        t.setProvisao(Short.valueOf((short)1));
        t.setTipoDoc(opcoesFinanceira.getTipoDocFinanceiro());
        t.setObservacao(obs);
        t.setValorDespBancPaga(Double.valueOf(0.0));
        t.setNumParcTituloEstnota(Short.valueOf((short)1));
        t.setPessoa(pessoa);
        t.setValor(valorTitulo);
        t.setCarteiraCobranca(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(opcoesFinanceira).getCarteiraCobranca(t.getPagRec().shortValue()));
        t.setCartCobrancaDestino(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(opcoesFinanceira).getCarteiraCobrancaDestino(pessoa, null));
        t.setTipoPessoa(EnumConstPessoa.PESSOA.getEnumId());
        t.setDataEmissao(dataMovimento);
        if (dataVencimento != null) {
            t.setDataVencimento(dataVencimento);
            t.setDataVencimentoBase(dataVencimento);
        } else {
            t.setDataVencimento(dataMovimento);
            t.setDataVencimentoBase(dataMovimento);
        }
        t.setDataCompetencia(dataMovimento);
        t.setDataEntradaSaida(t.getDataCompetencia());
        t.setEmpresa(empresa);
        t.setDataCadastro(new Date());
        t.setPlanoConta(planoConta);
        t.setMeioPagamento(meioPagamento);
        if (classificacao != null) {
            t.setClassificacaoPessoa(classificacao);
        } else {
            opcoesFinanceira.getClassificacaoClientes();
        }
        this.setarPercJurosMultaDesconto(t, opcoesFinanceira);
        return t;
    }

    private Short getTipoTitulo(LancamentoEventoCooperado lancCooperado) {
        if (lancCooperado.getEventoCooperado().getDebCred().equals(EnumConstEventoCooperado.EVENTO_COOPERADO_CREDITO.getValue())) {
            return (short)0;
        }
        return (short)1;
    }

    private Short getTipoTituloRepasse(EventoCooperado evento) {
        if (evento.getDebCred().equals(EnumConstEventoCooperado.EVENTO_COOPERADO_CREDITO.getValue())) {
            return (short)1;
        }
        return (short)0;
    }

    public void gerarLancContabilAdicionalDocFinanceiro(LancamentoEventoCooperado evt, OpcoesContabeis opContabeis, CentroResultadoContFin centroResultadoContFin) throws ExceptionInvalidData {
        if (!Objects.equals(evt.getEventoCooperado().getContabilizarEvento(), EnumConstantsMentorSimNao.SIM.getValue())) {
            return;
        }
        LoteContabil lote = this.helperLote.criaRecriaLoteContabil(evt.getLoteContabil(), evt.getDataMovimento(), evt.getEmpresa(), ConstEnumOrigemLoteContabil.LANCAMENTO_EVENTO_COOPERADO);
        Lancamento l = CompLancamentoBase.newLancamento((LoteContabil)lote, (Empresa)evt.getEmpresa());
        l.setEmpresa(centroResultadoContFin.getEmpresa());
        l.setCentroResultadoContFin(centroResultadoContFin);
        l.setGrupoEmpresa(centroResultadoContFin.getEmpresa().getEmpresaDados().getGrupoEmpresa());
        PlanoConta pcCredito = evt.getEventoCooperado().getPlanoContaContabilCredito();
        PlanoConta pcDebito = evt.getEventoCooperado().getPlanoContaContabilDebito();
        if (pcCredito == null) {
            pcCredito = evt.getCooperado() != null ? this.getPCCooperado(evt.getCooperado(), opContabeis) : this.scPlanoConta.getPlanoConta(evt.getCliente(), opContabeis);
        }
        if (pcDebito == null) {
            if (evt.getCooperado() != null) {
                pcDebito = this.getPCCooperado(evt.getCooperado(), opContabeis);
            } else {
                pcCredito = this.scPlanoConta.getPlanoConta(evt.getCliente(), opContabeis);
            }
        }
        l.setPlanoContaCred(pcCredito);
        l.setPlanoContaDeb(pcDebito);
        l.setHistorico(evt.getHistorico());
        l.setValor(evt.getValorOperacao());
        ArrayList<Lancamento> lanc = new ArrayList<Lancamento>();
        lanc.add(l);
        lote.setLancamentos(lanc);
        evt.setLoteContabil(lote);
        evt.setPlanoContaContabilCredito(l.getPlanoContaCred());
        evt.setPlanoContaContabilDebito(l.getPlanoContaDeb());
    }

    private PlanoConta getPCCooperado(Cooperado cooperado, OpcoesContabeis opContabeis) {
        ServiceGeracaoContaPessoaImpl service = (ServiceGeracaoContaPessoaImpl)ConfApplicationContext.getBean(ServiceGeracaoContaPessoaImpl.class);
        return service.getPlanoContaCooperado(cooperado, opContabeis);
    }

    public Titulo createTituloDevedorApuracao(Double valor, Date dataVencimento, TipoDoc tipoDoc, MeioPagamento meioPagamento, CarteiraCobranca carteiraCobranca, OpcoesFinanceiras opcoesFinanceiras, OpcoesContabeis opcoesContabeis, ApuracaoValoresCooperados vo, Cliente cliente, PlanoContaGerencial planoGerencial, String observacao, Date dataEmissaoNovoTit, PlanoConta pc) {
        Titulo t = new Titulo();
        t.setPagRec(Short.valueOf((short)1));
        t.setProvisao(Short.valueOf((short)1));
        t.setTipoDoc(tipoDoc);
        t.setValorDespBancPaga(Double.valueOf(0.0));
        t.setNumParcTituloEstnota(Short.valueOf((short)1));
        if (cliente.getClassificacaoClientes() != null) {
            t.setPessoa(cliente.getPessoa());
        } else {
            opcoesFinanceiras.getClassificacaoClientes();
        }
        t.setClassificacaoPessoa(cliente.getClassificacaoClientes());
        t.setValor(valor);
        t.setCarteiraCobranca(carteiraCobranca);
        t.setCartCobrancaDestino(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(opcoesFinanceiras).getCarteiraCobrancaDestino(cliente.getPessoa(), null));
        t.setTipoPessoa(EnumConstPessoa.PESSOA.getEnumId());
        t.setDataEmissao(dataEmissaoNovoTit);
        t.setDataVencimento(dataVencimento);
        t.setDataVencimentoBase(dataVencimento);
        t.setDataCompetencia(dataEmissaoNovoTit);
        t.setDataEntradaSaida(t.getDataCompetencia());
        t.setEmpresa(vo.getEmpresa());
        t.setDataCadastro(new Date());
        t.setPlanoConta(pc);
        t.setPercJurosMes(opcoesFinanceiras.getPercJurosMes());
        t.setPercMulta(opcoesFinanceiras.getPercMulta());
        t.setObservacao(observacao);
        if (t.getPagRec() == 1) {
            if (t.getPercJurosMes() != null && t.getPercJurosMes() > 0.0) {
                t.setPercJurosMes(t.getPercJurosMes());
                t.setVrJurosDia(Double.valueOf(t.getValor() * (t.getPercJurosMes() / 100.0) / 30.0));
            } else {
                t.setPercJurosMes(Double.valueOf(0.0));
                t.setVrJurosDia(Double.valueOf(0.0));
            }
        }
        t.setMeioPagamento(meioPagamento);
        if (ToolMethods.isStrWithData((String)vo.getDescricao())) {
            StringBuilder sb = new StringBuilder();
            if (ToolMethods.isStrWithData((String)cliente.getCodigoCliente())) {
                sb.append("Cod Cliente: ");
                sb.append(cliente.getCodigoCliente());
            }
            sb.append(" - ");
            sb.append(vo.getDescricao());
        } else {
            t.setObservacao("Titulo devedor referente a diferenca na apuracao de cooperado/cliente.");
        }
        LancamentoCtbGerencial lancGerencial = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, new Date(), t.getDataVencimento(), Short.valueOf(EnumLancamentoCTBGerencial.CREDITO.getValue()), vo.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Lancamento referente ao titulo devedor referente a diferenca na apuracao de cooperado/cliente.", planoGerencial, t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), null, t.getValor(), null);
        ArrayList<LancamentoCtbGerencial> lanc = new ArrayList<LancamentoCtbGerencial>();
        lanc.add(lancGerencial);
        t.setLancCtbGerencial(lanc);
        return t;
    }

    private void setarPercJurosMultaDesconto(Titulo t, OpcoesFinanceiras op) {
        if (t.getPagRec() == 1) {
            Double percJuros = op.getPercJurosMes();
            Double percDesc = op.getPercDescMes();
            Double percMulta = op.getPercMulta();
            OpcoesFinanceirasTaxas opTaxas = this.getOpcoesFinanceirasTaxas(t.getMeioPagamento(), op);
            if (opTaxas != null) {
                percJuros = opTaxas.getPercJurosMes();
                percDesc = opTaxas.getPercDescMes();
                percMulta = opTaxas.getPercMulta();
            }
            if (percJuros != null) {
                t.setPercJurosMes(percJuros);
                t.setVrJurosDia(Double.valueOf(t.getValor() * (percJuros / 100.0) / 30.0));
            } else {
                t.setPercJurosMes(Double.valueOf(0.0));
                t.setVrJurosDia(Double.valueOf(0.0));
            }
            if (percDesc != null) {
                t.setPercDescontoMes(percDesc);
            } else {
                t.setPercDescontoMes(Double.valueOf(0.0));
            }
            if (percMulta != null) {
                t.setPercMulta(percMulta);
            } else {
                t.setPercMulta(Double.valueOf(0.0));
            }
        } else {
            t.setPercMulta(Double.valueOf(0.0));
            t.setPercJurosMes(Double.valueOf(0.0));
            t.setVrJurosDia(Double.valueOf(0.0));
            t.setPercDescontoMes(Double.valueOf(0.0));
        }
    }

    private OpcoesFinanceirasTaxas getOpcoesFinanceirasTaxas(MeioPagamento meioPagamento, OpcoesFinanceiras op) {
        if (meioPagamento != null) {
            for (OpcoesFinanceirasTaxas taxa : op.getTaxas()) {
                if (!taxa.getMeioPagamento().equals((Object)meioPagamento)) continue;
                return taxa;
            }
        }
        return null;
    }

    public Titulo createTituloCredorApuracao(Double valor, Date dataVencimento, TipoDoc tipoDoc, MeioPagamento meioPagamento, CarteiraCobranca carteiraCobranca, OpcoesFinanceiras opcoesFinanceiras, OpcoesContabeis opcoesContabeis, ApuracaoValoresCooperados vo, Cliente cliente, PlanoContaGerencial planoGerencial, Date dataEmissao, PlanoConta planoConta) {
        Titulo t = new Titulo();
        t.setPagRec(Short.valueOf((short)0));
        t.setProvisao(Short.valueOf((short)1));
        t.setTipoDoc(tipoDoc);
        t.setValorDespBancPaga(Double.valueOf(0.0));
        t.setNumParcTituloEstnota(Short.valueOf((short)1));
        t.setPessoa(cliente.getPessoa());
        if (cliente.getClassificacaoClientes() != null) {
            t.setClassificacaoPessoa(cliente.getClassificacaoClientes());
        } else {
            t.setClassificacaoPessoa(opcoesFinanceiras.getClassificacaoClientes());
        }
        t.setValor(valor);
        t.setCarteiraCobranca(carteiraCobranca);
        t.setCartCobrancaDestino(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(opcoesFinanceiras).getCarteiraCobrancaDestino(cliente.getPessoa(), null));
        t.setTipoPessoa(EnumConstPessoa.PESSOA.getEnumId());
        t.setDataEmissao(dataEmissao);
        t.setDataVencimento(dataVencimento);
        t.setDataVencimentoBase(dataVencimento);
        t.setDataCompetencia(dataEmissao);
        t.setDataEntradaSaida(t.getDataCompetencia());
        t.setEmpresa(vo.getEmpresa());
        t.setDataCadastro(new Date());
        t.setPlanoConta(planoConta);
        t.setMeioPagamento(meioPagamento);
        t.setObservacao(vo.getDescricao());
        if (ToolMethods.isStrWithData((String)vo.getDescricao())) {
            StringBuilder sb = new StringBuilder();
            if (ToolMethods.isStrWithData((String)cliente.getCodigoCliente())) {
                sb.append("Cod Cliente: ");
                sb.append(cliente.getCodigoCliente());
            }
            sb.append(" - ");
            sb.append(vo.getDescricao());
        } else {
            t.setObservacao("Titulo credor referente a diferenca na apuracao de cooperado/cliente.");
        }
        LancamentoCtbGerencial lancGerencial = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, new Date(), t.getDataVencimento(), Short.valueOf(EnumLancamentoCTBGerencial.DEBITO.getValue()), vo.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Lancamento referente ao titulo credor referente a diferenca na apuracao de cooperado/cliente.", planoGerencial, t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), null, t.getValor(), null);
        ArrayList<LancamentoCtbGerencial> lanc = new ArrayList<LancamentoCtbGerencial>();
        lanc.add(lancGerencial);
        t.setLancCtbGerencial(lanc);
        return t;
    }

    public LoteLancamentoEventoCooperado createTituloLote(LoteLancamentoEventoCooperado lote, OpcoesFinanceiras opcoes, OpcoesContabeis opContabeis) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        for (LancamentoEventoCooperado vo : lote.getLancamentosCooperado()) {
            Pessoa pessoa;
            vo.setCentroResultadoContFin(lote.getCentroResultadoContFin());
            vo.setTitulos(new ArrayList());
            Short tipoTitulo = this.getTipoTitulo(vo);
            Object obs = vo.getObservacao();
            obs = (String)obs + " . ";
            ClassificacaoClientes classificacaoPessoa = this.getClassificacaoPessoaLote(lote);
            if (vo.getCooperado() != null) {
                obs = (String)obs + "Movimentacao do Cooperado: " + vo.getCooperado().getCliente().getPessoa().getNome();
            } else if (vo.getCliente() != null) {
                obs = (String)obs + "Movimentacao do Cliente: " + vo.getCliente().getPessoa().getNome();
            }
            obs = (String)obs + ". Evento: " + vo.getEventoCooperado().getDescricao();
            short tipoPessoa = EnumConstPessoa.PESSOA.getEnumId();
            ArrayList<Titulo> titulos = new ArrayList<Titulo>();
            PlanoConta pc = vo.getEventoCooperado().getPlanoContaContabil();
            if (pc == null) {
                pc = vo.getCooperado() != null ? this.getPCCooperado(vo.getCooperado(), opContabeis) : this.scPlanoConta.getPlanoConta(vo.getCliente(), opContabeis);
            }
            vo.setPlanoContaContabil(pc);
            Pessoa pessoa2 = pessoa = vo.getCooperado() != null ? vo.getCooperado().getCliente().getPessoa() : vo.getCliente().getPessoa();
            if (vo.getCondicoesPagamento() == null || vo.getDataVencimento() != null) {
                Titulo titulo = this.createTitulo(tipoTitulo, opcoes, (String)obs, pessoa, vo.getDataMovimento(), vo.getEmpresa(), pc, vo.getEventoCooperado().getPlanoContaGerencial(), vo.getValorOperacao(), vo.getEventoCooperado().getMeioPagamento(), vo.getDataVencimento(), classificacaoPessoa, vo.getEventoCooperado());
                titulos.add(titulo);
            } else if (vo.getCondicoesPagamento().getCondMutante() != null && vo.getCondicoesPagamento().getCondMutante().shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
                titulos.addAll(new AuxTitulos().getTitulosMutanteInternal(vo.getCondicoesPagamento(), pessoa, vo.getValorOperacao(), pc, 0.0, vo.getParcelas(), tipoPessoa, tipoTitulo, (short)1, vo.getDataMovimento(), (String)obs, vo.getDataMovimento(), vo.getDataMovimento(), vo.getDataCadastro(), vo.getDataMovimento(), vo.getEmpresa(), opcoes, vo.getEventoCooperado().getMeioPagamento(), classificacaoPessoa));
            } else {
                titulos.addAll(new AuxTitulos().getTitulosNaoMutanteInternal(vo.getCondicoesPagamento(), pessoa, vo.getValorOperacao(), pc, 0.0, tipoPessoa, tipoTitulo, (short)1, vo.getDataMovimento(), (String)obs, vo.getDataMovimento(), vo.getDataMovimento(), vo.getDataCadastro(), vo.getDataMovimento(), vo.getEmpresa(), opcoes, vo.getEventoCooperado().getMeioPagamento(), classificacaoPessoa));
            }
            if (vo.getEventoCooperado().getPercJuros() > 0.0) {
                for (Titulo t : titulos) {
                    Double valorJuros = ToolFormatter.arrredondarNumero((Double)(t.getValor() * (vo.getEventoCooperado().getPercJuros() / 100.0)), (int)2);
                    t.setValor(Double.valueOf(t.getValor() + valorJuros));
                    t.setValorJurosEmbutido(valorJuros);
                }
            }
            if (vo.getEventoCooperado().getPercDesconto() > 0.0) {
                for (Titulo t : titulos) {
                    Double valorDesconto = ToolFormatter.arrredondarNumero((Double)(t.getValor() * (vo.getEventoCooperado().getPercDesconto() / 100.0)), (int)2);
                    t.setValor(Double.valueOf(t.getValor() + valorDesconto));
                    t.setValorDescontosEmbutido(valorDesconto);
                }
            }
            this.gerarLancContabilAdicionalDocFinanceiro(vo, opContabeis, vo.getCentroResultadoContFin());
            for (Titulo t : titulos) {
                t.setLancamentoCooperado(vo);
            }
            CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentosCTBGerencial(vo, titulos, (Boolean)false);
            vo.setTitulos(titulos);
        }
        if (lote.getEventoCooperado().getRepasse().equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            ArrayList<Titulo> titulosRepasse = new ArrayList<Titulo>();
            Short tipoTituloRepasse = this.getTipoTituloRepasse(lote.getEventoCooperado());
            String obs = "Titulo Repasse para: " + lote.getPessoaTerceiros().getNome();
            obs = obs + ". Evento: " + lote.getEventoCooperado().getDescricao();
            if (lote.getCondicoesPagamento() == null) {
                MeioPagamento meioPagamento = lote.getEventoCooperado().getMeioPagamento();
                if (lote.getMeioPagamentoRepasse() != null) {
                    meioPagamento = lote.getMeioPagamentoRepasse();
                }
                Titulo tituloRepasse = this.createTitulo(tipoTituloRepasse, opcoes, obs, lote.getPessoaTerceiros(), lote.getDataEmissaoRepasse(), lote.getEmpresa(), lote.getEventoCooperado().getPlanoContaContabilRepasse(), lote.getEventoCooperado().getPlanoContaGerencialRepasse(), lote.getValorTotal(), meioPagamento, lote.getDataVencimentoRepasse(), lote.getEventoCooperado().getClassificacaoPessoaRepasse(), lote.getEventoCooperado());
                tituloRepasse.setLoteLancamentoCooperado(lote);
                titulosRepasse.add(tituloRepasse);
            } else {
                short tipoPessoa = EnumConstPessoa.PESSOA.getEnumId();
                if (lote.getCondicoesPagamento().getCondMutante() != null && lote.getCondicoesPagamento().getCondMutante().shortValue() == EnumConstantsMentorSimNao.SIM.getValue()) {
                    titulosRepasse.addAll(new AuxTitulos().getTitulosMutanteInternal(lote.getCondicoesPagamento(), lote.getPessoaTerceiros(), lote.getValorTotal(), lote.getEventoCooperado().getPlanoContaContabil(), 0.0, lote.getParcelas(), tipoPessoa, tipoTituloRepasse, (short)1, lote.getDataEmissaoRepasse(), obs, lote.getDataEmissaoRepasse(), lote.getDataEmissaoRepasse(), lote.getDataCadastro(), lote.getDataEmissaoRepasse(), lote.getEmpresa(), opcoes, lote.getEventoCooperado().getMeioPagamento(), lote.getEventoCooperado().getClassificacaoPessoaRepasse()));
                } else {
                    titulosRepasse.addAll(new AuxTitulos().getTitulosNaoMutanteInternal(lote.getCondicoesPagamento(), lote.getPessoaTerceiros(), lote.getValorTotal(), lote.getEventoCooperado().getPlanoContaContabil(), 0.0, tipoPessoa, tipoTituloRepasse, (short)1, lote.getDataEmissaoRepasse(), obs, lote.getDataEmissaoRepasse(), lote.getDataEmissaoRepasse(), lote.getDataCadastro(), lote.getDataEmissaoRepasse(), lote.getEmpresa(), opcoes, lote.getEventoCooperado().getMeioPagamento(), lote.getEventoCooperado().getClassificacaoPessoaRepasse()));
                }
            }
            if (lote.getDataVencimentoRepasse() != null) {
                for (Titulo t : titulosRepasse) {
                    t.setDataVencimento(lote.getDataVencimentoRepasse());
                    t.setDataVencimentoBase(lote.getDataVencimentoRepasse());
                }
            }
            if (lote.getEventoCooperado().getPercJurosRepasse() > 0.0) {
                for (Titulo t : titulosRepasse) {
                    Double valorJuros = ToolFormatter.arrredondarNumero((Double)(t.getValor() * (lote.getEventoCooperado().getPercJurosRepasse() / 100.0)), (int)2);
                    t.setValor(Double.valueOf(t.getValor() + valorJuros));
                    t.setValorJurosEmbutido(valorJuros);
                }
            }
            if (lote.getEventoCooperado().getPercDescontoRepasse() > 0.0) {
                for (Titulo t : titulosRepasse) {
                    Double valorDesconto = ToolFormatter.arrredondarNumero((Double)(t.getValor() * (lote.getEventoCooperado().getPercDescontoRepasse() / 100.0)), (int)2);
                    t.setValor(Double.valueOf(t.getValor() - valorDesconto));
                }
            }
            for (Titulo t : titulosRepasse) {
                t.setLoteLancamentoCooperado(lote);
            }
            CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentosCTBGerencial(lote, titulosRepasse, (Boolean)true);
            lote.setTitulosRepasse(titulosRepasse);
        }
        return lote;
    }

    private ClassificacaoClientes getClassificacaoCliente(LancamentoEventoCooperado vo) {
        if (vo.getEventoCooperado().getClassificacaoPessoa() != null) {
            return vo.getEventoCooperado().getClassificacaoPessoa();
        }
        if (vo.getCooperado() != null) {
            return vo.getCooperado().getCliente().getClassificacaoClientes();
        }
        return vo.getCliente().getClassificacaoClientes();
    }

    private ClassificacaoClientes getClassificacaoPessoaLote(LoteLancamentoEventoCooperado lote) {
        if (lote.getEventoCooperado().getClassificacaoPessoa() != null) {
            return lote.getEventoCooperado().getClassificacaoPessoa();
        }
        if (lote.getCooperado() != null) {
            return lote.getCooperado().getCliente().getClassificacaoClientes();
        }
        return lote.getCliente().getClassificacaoClientes();
    }
}

