/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.titulos;

import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.deprecated.PreFaturamentoPed;
import com.touchcomp.basementor.model.deprecated.PreFaturamentoPedItem;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.exceptions.ExceptionValidation;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.titulos.AuxTitulos;

class AuxTitulosPreFaturamentoPed {
    private final SCompPlanoConta scPlanoConta = (SCompPlanoConta)ConfApplicationContext.getBean(SCompPlanoConta.class);

    AuxTitulosPreFaturamentoPed() {
    }

    public List criarTitulos(PreFaturamentoPed vo, OpcoesFinanceiras op, OpcoesContabeis opcoes) throws ExceptionGeracaoTitulos, ExceptionInvalidData {
        Double valorTotalNota = (Double)this.getValorTotalItemPreFaturamento(vo.getPreFaturamentoPedItem()).get("valorTotal");
        Pedido pedido = vo.getExpedicao().getPedido();
        if (valorTotalNota == 0.0 || pedido == null) {
            return new ArrayList();
        }
        if (pedido.getPercDescFinanceiro() != null && pedido.getPercDescFinanceiro() > 0.0) {
            valorTotalNota = valorTotalNota - valorTotalNota * (pedido.getPercDescFinanceiro() / 100.0);
        }
        Date dataBase = pedido.getDataPrevisaoSaida();
        if (pedido.getTipoDataTitulo() != null && pedido.getTipoDataTitulo() == 0) {
            dataBase = pedido.getDataEmissao();
        }
        String obs = "Pedido: " + pedido.getUnidadeFatCliente().getCliente().getPessoa().getNome();
        PlanoConta pc = this.scPlanoConta.getPlanoConta(pedido.getUnidadeFatCliente().getCliente(), opcoes);
        List ret = null;
        ret = pedido.getCondicoesPagamento().getCondMutante() != null && pedido.getCondicoesPagamento().getCondMutante() == 1 ? new AuxTitulos().getTitulosMutanteInternal(pedido.getCondicoesPagamento(), pedido.getUnidadeFatCliente().getCliente().getPessoa(), valorTotalNota, pc, pedido.getPercComissao(), pedido.getCondPagMut(), EnumConstPessoa.CLIENTE.getEnumId(), (short)1, (short)0, dataBase, obs, pedido.getDataEmissao(), pedido.getDataEmissao(), pedido.getDataCadastro(), pedido.getDataEmissao(), pedido.getEmpresa(), op, op.getMeioPagamento(), null) : new AuxTitulos().getTitulosNaoMutanteInternal(pedido.getCondicoesPagamento(), pedido.getUnidadeFatCliente().getCliente().getPessoa(), valorTotalNota, pc, pedido.getPercComissao(), EnumConstPessoa.CLIENTE.getEnumId(), (short)1, (short)0, dataBase, obs, pedido.getDataEmissao(), pedido.getDataEmissao(), pedido.getDataCadastro(), pedido.getDataEmissao(), pedido.getEmpresa(), op, op.getMeioPagamento(), null);
        ArrayList itensPedido = new ArrayList();
        CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentosCTBGerencial(itensPedido, ret, op.getEmpresa());
        return ret;
    }

    public HashMap getValorTotalItemPedido(List<PreFaturamentoPedItem> itens, double percDescFinance) {
        HashMap<String, Double> h = new HashMap<String, Double>();
        Double valor = 0.0;
        Double valorIcmsSt = 0.0;
        Double valorParaBCComissaoTitulo = 0.0;
        for (PreFaturamentoPedItem preItem : itens) {
            if (preItem.getGerarFinanceiro() != 1) continue;
            valor = valor + (preItem.getValorTotal() - preItem.getValorTotal() * (percDescFinance / 100.0));
            valorParaBCComissaoTitulo = valorParaBCComissaoTitulo + preItem.getValorTotal();
        }
        h.put("valorTotal", valor);
        h.put("valorICMSST", valorIcmsSt);
        h.put("valorParaBCComissaoTitulo", valorParaBCComissaoTitulo);
        return h;
    }

    public HashMap getValorTotalItemPreFaturamento(List<PreFaturamentoPedItem> itens) {
        HashMap<String, Double> h = new HashMap<String, Double>();
        Double valor = 0.0;
        Double valorIcmsSt = 0.0;
        for (PreFaturamentoPedItem o : itens) {
            PreFaturamentoPedItem preItem = o;
            if (preItem.getGerarFinanceiro() != 1) continue;
            valor = valor + preItem.getValorTotal();
        }
        h.put("valorTotal", valor);
        h.put("valorICMSST", valorIcmsSt);
        return h;
    }

    void validarValoresTitulos(PreFaturamentoPed vo) throws ExceptionValidation {
    }
}

