/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.utilities.impl.titulos;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.geracaotitulosimpostosretidos.EnumConstGeracaoTitulosImpostosRetidos;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.opcoescontabeis.EnumConstImpostosRetidos;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoaComplementar;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.InfPagamentoNfPropria;
import com.touchcomp.basementor.model.vo.InfPagamentoNfTerceiros;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesContabeisImpostosRetidos;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TituloPisCofins;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorservice.components.opcoes.CompOpcoesContabeis;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

class AuxTitulosRetidos {
    AuxTitulosRetidos() {
    }

    void calcularTitulosRetidos(InfPagamentoNfTerceiros infPagamento, NotaFiscalTerceiros vo, Double valorTotalNota, OpcoesFinanceiras op, EmpresaContabilidade cont, OpcoesContabeis opcoesContabeis) throws ExceptionGeracaoTitulos {
        ArrayList<Titulo> retidos = new ArrayList<Titulo>();
        double vrIss = 0.0;
        double vrInss = 0.0;
        double vrIrrf = 0.0;
        double vrLei10833 = 0.0;
        double vrFunrural = 0.0;
        double vrOutros = 0.0;
        double vrPis = 0.0;
        double vrCofins = 0.0;
        double vrContSocial = 0.0;
        double vrSestSenat = 0.0;
        double vrRat = 0.0;
        double vrSenar = 0.0;
        double vrTaxaSanidadeAnimal = 0.0;
        for (ItemNotaTerceiros in : vo.getItemNotaTerceiros()) {
            if (ToolMethods.isEquals((Object)in.getIssRetido(), (Object)1)) {
                vrIss += in.getItemNotaLivroFiscal().getVrIss().doubleValue();
            }
            vrInss += in.getItemNotaLivroFiscal().getVrInss().doubleValue();
            vrIrrf += in.getItemNotaLivroFiscal().getVrIrrf().doubleValue();
            vrLei10833 += in.getItemNotaLivroFiscal().getVrLei10833().doubleValue();
            vrFunrural += in.getItemNotaLivroFiscal().getVrFunrural().doubleValue();
            vrOutros += in.getItemNotaLivroFiscal().getVrOutros().doubleValue();
            vrPis += in.getItemNotaLivroFiscal().getVrPisSt().doubleValue();
            vrCofins += in.getItemNotaLivroFiscal().getVrCofinsSt().doubleValue();
            vrContSocial += in.getItemNotaLivroFiscal().getVrContSoc().doubleValue();
            vrSestSenat += in.getItemNotaLivroFiscal().getValorSestSenat().doubleValue();
            vrRat += in.getItemNotaLivroFiscal().getValorRat().doubleValue();
            vrSenar += in.getItemNotaLivroFiscal().getValorSenar().doubleValue();
            vrTaxaSanidadeAnimal += in.getItemNotaLivroFiscal().getValorTaxaSanidadeAnimal().doubleValue();
        }
        Double valorTotal = vrCofins + vrContSocial + vrFunrural + vrInss + vrSestSenat + vrIrrf + vrIss + vrLei10833 + vrOutros + vrPis + vrRat + vrSenar + vrTaxaSanidadeAnimal;
        if (valorTotal > 0.0) {
            Double perc = valorTotal / valorTotalNota;
            for (Titulo t : infPagamento.getTitulos()) {
                t.setValor(Double.valueOf(t.getValor() - t.getValor() * perc));
            }
        }
        if (ToolMethods.isEquals((Object)opcoesContabeis.getTipoGeracaoTitulosImpostosRetidos(), (Object)EnumConstGeracaoTitulosImpostosRetidos.GERAR_TITULO_DOCUMENTOS_FISCAIS.getValue()) || ToolMethods.isEquals((Object)opcoesContabeis.getTipoGeracaoTitulosImpostosRetidos(), (Object)EnumConstGeracaoTitulosImpostosRetidos.GERAR_TITULO_APURACAO_REINF.getValue())) {
            this.gerarTitulosRetidos(infPagamento, vo, valorTotalNota, op, cont, opcoesContabeis, retidos, vrIss, vrInss, vrIrrf, vrLei10833, vrFunrural, vrOutros, vrPis, vrCofins, vrContSocial, vrSestSenat, vrRat, vrSenar, vrTaxaSanidadeAnimal);
        }
        for (Titulo t : retidos) {
            t.setInfPagamentoNfTerceiros(infPagamento);
        }
        infPagamento.getTitulos().addAll(retidos);
        if (ToolMethods.isEquals((Object)opcoesContabeis.getTipoGeracaoTitulosImpostosRetidos(), (Object)EnumConstGeracaoTitulosImpostosRetidos.GERAR_TITULO_APURACAO_REINF.getValue())) {
            this.gerarImpostosTituloPisCofins(vo, infPagamento);
        }
    }

    void gerarTitulosRetidos(InfPagamentoNfTerceiros infPagamento, NotaFiscalTerceiros vo, Double valorTotalNota, OpcoesFinanceiras op, EmpresaContabilidade cont, OpcoesContabeis opcoesContabeis, List<Titulo> retidos, double vrIss, double vrInss, double vrIrrf, double vrLei10833, double vrFunrural, double vrOutros, double vrPis, double vrCofins, double vrContSocial, double vrSestSenat, double vrRat, double vrSenar, double vrTaxaSanidadeAnimal) throws ExceptionGeracaoTitulos {
        Short s;
        Date date = null;
        date = cont.getOpcaoGerarTitulos().equals((short)0) ? vo.getDataEntrada() : vo.getDataEmissao();
        String serie = vo.getSerie();
        Integer nrNota = vo.getNumeroNota();
        String meio = "";
        String end = "Para isto configure esta op\u00e7\u00e3o em Opcoes Contabeis.";
        String start = "O mentor pode criar t\u00edtulos a pagar para os impostos retidos. ";
        Date dataTitulo = null;
        Short numTitulo = 1;
        for (Titulo t : infPagamento.getTitulos()) {
            if (t.getNumParcTituloEstnota() <= numTitulo) continue;
            numTitulo = t.getNumParcTituloEstnota();
        }
        if (vrIss > 0.0) {
            OpcoesContabeisImpostosRetidos iss = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.ISS);
            if (iss.getPessoaImpostoRetido() != null && iss.getPlanoContaImpostoRetido() != null && iss.getPlanoContaGerencialImpostoRetido() != null) {
                s = numTitulo;
                numTitulo = (short)(numTitulo + 1);
                dataTitulo = AuxTitulosRetidos.getDataTitulo(iss.getDiaVencimentoImpostoRetido(), date);
                retidos.add(AuxTitulosRetidos.getTituloRetido(iss.getPessoaImpostoRetido(), iss.getPlanoContaImpostoRetido(), iss.getPlanoContaGerencialImpostoRetido(), vo, "ISS retido para a nota de Terceiros " + serie + " - " + nrNota + ", pessoa: " + iss.getPessoaImpostoRetido().getNome(), vrIss, dataTitulo, numTitulo, op));
            } else {
                meio = "Imposto ISS. ";
                throw new ExceptionGeracaoTitulos(start + meio + end);
            }
        }
        if (vrInss > 0.0) {
            OpcoesContabeisImpostosRetidos inss = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.INSS);
            if (inss.getPessoaImpostoRetido() != null && inss.getPlanoContaImpostoRetido() != null && inss.getPlanoContaGerencialImpostoRetido() != null) {
                s = numTitulo;
                numTitulo = (short)(numTitulo + 1);
                dataTitulo = AuxTitulosRetidos.getDataTitulo(inss.getDiaVencimentoImpostoRetido(), date);
                retidos.add(AuxTitulosRetidos.getTituloRetido(inss.getPessoaImpostoRetido(), inss.getPlanoContaImpostoRetido(), inss.getPlanoContaGerencialImpostoRetido(), vo, "INSS retido para a nota de Terceiros " + serie + " - " + nrNota + ", pessoa: " + inss.getPessoaImpostoRetido().getNome(), vrInss + vrSestSenat, dataTitulo, numTitulo, op));
            } else {
                meio = "Imposto INSS. ";
                throw new ExceptionGeracaoTitulos(start + meio + end);
            }
        }
        if (vrIrrf > 0.0) {
            OpcoesContabeisImpostosRetidos irrf = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.IRRF);
            if (irrf.getPessoaImpostoRetido() != null && irrf.getPlanoContaImpostoRetido() != null && irrf.getPlanoContaGerencialImpostoRetido() != null) {
                s = numTitulo;
                numTitulo = (short)(numTitulo + 1);
                dataTitulo = AuxTitulosRetidos.getDataTitulo(irrf.getDiaVencimentoImpostoRetido(), date);
                retidos.add(AuxTitulosRetidos.getTituloRetido(irrf.getPessoaImpostoRetido(), irrf.getPlanoContaImpostoRetido(), irrf.getPlanoContaGerencialImpostoRetido(), vo, "IRRF retido para a nota de Terceiros " + serie + " - " + nrNota + ", pessoa: " + irrf.getPessoaImpostoRetido().getNome(), vrIrrf, dataTitulo, numTitulo, op));
            } else {
                meio = "Imposto IRRF. ";
                throw new ExceptionGeracaoTitulos(start + meio + end);
            }
        }
        if (vrLei10833 > 0.0 && !ToolMethods.isEquals((Object)opcoesContabeis.getTipoGeracaoTitulosImpostosRetidos(), (Object)EnumConstGeracaoTitulosImpostosRetidos.GERAR_TITULO_APURACAO_REINF.getValue())) {
            OpcoesContabeisImpostosRetidos lei10833 = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.LEI_10833);
            if (lei10833.getPessoaImpostoRetido() != null && lei10833.getPlanoContaImpostoRetido() != null && lei10833.getPlanoContaGerencialImpostoRetido() != null) {
                s = numTitulo;
                numTitulo = (short)(numTitulo + 1);
                dataTitulo = AuxTitulosRetidos.getDataTitulo(lei10833.getDiaVencimentoImpostoRetido(), date);
                retidos.add(AuxTitulosRetidos.getTituloRetido(lei10833.getPessoaImpostoRetido(), lei10833.getPlanoContaImpostoRetido(), lei10833.getPlanoContaGerencialImpostoRetido(), vo, "Lei 10833 retido para a nota de Terceiros " + serie + " - " + nrNota + ", pessoa: " + lei10833.getPessoaImpostoRetido().getNome(), vrLei10833, dataTitulo, numTitulo, op));
            } else {
                meio = "Imposto LEI 10833. ";
                throw new ExceptionGeracaoTitulos(start + meio + end);
            }
        }
        if (vrOutros > 0.0) {
            OpcoesContabeisImpostosRetidos outros = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.OUTROS);
            if (outros.getPessoaImpostoRetido() != null && outros.getPlanoContaImpostoRetido() != null && outros.getPlanoContaGerencialImpostoRetido() != null) {
                s = numTitulo;
                numTitulo = (short)(numTitulo + 1);
                dataTitulo = AuxTitulosRetidos.getDataTitulo(outros.getDiaVencimentoImpostoRetido(), date);
                retidos.add(AuxTitulosRetidos.getTituloRetido(outros.getPessoaImpostoRetido(), outros.getPlanoContaImpostoRetido(), outros.getPlanoContaGerencialImpostoRetido(), vo, "Outros impostos retidos para a nota de Terceiros " + serie + " - " + nrNota + ", pessoa: " + outros.getPessoaImpostoRetido().getNome(), vrOutros, dataTitulo, numTitulo, op));
            } else {
                meio = "Imposto Outros. ";
                throw new ExceptionGeracaoTitulos(start + meio + end);
            }
        }
        if (vrPis > 0.0 && !ToolMethods.isEquals((Object)opcoesContabeis.getTipoGeracaoTitulosImpostosRetidos(), (Object)EnumConstGeracaoTitulosImpostosRetidos.GERAR_TITULO_APURACAO_REINF.getValue())) {
            OpcoesContabeisImpostosRetidos pis = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.PIS);
            if (pis.getPessoaImpostoRetido() != null && pis.getPlanoContaImpostoRetido() != null && pis.getPlanoContaGerencialImpostoRetido() != null) {
                s = numTitulo;
                numTitulo = (short)(numTitulo + 1);
                dataTitulo = AuxTitulosRetidos.getDataTitulo(pis.getDiaVencimentoImpostoRetido(), date);
                retidos.add(AuxTitulosRetidos.getTituloRetido(pis.getPessoaImpostoRetido(), pis.getPlanoContaImpostoRetido(), pis.getPlanoContaGerencialImpostoRetido(), vo, "Pis retido para a nota de Terceiros " + serie + " - " + nrNota + ", pessoa: " + pis.getPessoaImpostoRetido().getNome(), vrPis, dataTitulo, numTitulo, op));
            } else {
                meio = "Imposto Pis. ";
                throw new ExceptionGeracaoTitulos(start + meio + end);
            }
        }
        if (vrCofins > 0.0 && !ToolMethods.isEquals((Object)opcoesContabeis.getTipoGeracaoTitulosImpostosRetidos(), (Object)EnumConstGeracaoTitulosImpostosRetidos.GERAR_TITULO_APURACAO_REINF.getValue())) {
            OpcoesContabeisImpostosRetidos cofins = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.COFINS);
            if (cofins.getPessoaImpostoRetido() != null && cofins.getPlanoContaImpostoRetido() != null && cofins.getPlanoContaGerencialImpostoRetido() != null) {
                s = numTitulo;
                numTitulo = (short)(numTitulo + 1);
                dataTitulo = AuxTitulosRetidos.getDataTitulo(cofins.getDiaVencimentoImpostoRetido(), date);
                retidos.add(AuxTitulosRetidos.getTituloRetido(cofins.getPessoaImpostoRetido(), cofins.getPlanoContaImpostoRetido(), cofins.getPlanoContaGerencialImpostoRetido(), vo, "Cofins retido para a nota de Terceiros " + serie + " - " + nrNota + ", pessoa: " + cofins.getPessoaImpostoRetido().getNome(), vrCofins, dataTitulo, numTitulo, op));
            } else {
                meio = "Imposto Cofins. ";
                throw new ExceptionGeracaoTitulos(start + meio + end);
            }
        }
        if (vrContSocial > 0.0 && !ToolMethods.isEquals((Object)opcoesContabeis.getTipoGeracaoTitulosImpostosRetidos(), (Object)EnumConstGeracaoTitulosImpostosRetidos.GERAR_TITULO_APURACAO_REINF.getValue())) {
            OpcoesContabeisImpostosRetidos csll = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.CSLL);
            if (csll.getPessoaImpostoRetido() != null && csll.getPlanoContaImpostoRetido() != null && csll.getPlanoContaGerencialImpostoRetido() != null) {
                s = numTitulo;
                numTitulo = (short)(numTitulo + 1);
                dataTitulo = AuxTitulosRetidos.getDataTitulo(csll.getDiaVencimentoImpostoRetido(), date);
                retidos.add(AuxTitulosRetidos.getTituloRetido(csll.getPessoaImpostoRetido(), csll.getPlanoContaImpostoRetido(), csll.getPlanoContaGerencialImpostoRetido(), vo, "Cont. Social retido NF Terc. " + serie + " - " + nrNota + ", pessoa: " + csll.getPessoaImpostoRetido().getNome(), vrContSocial, dataTitulo, numTitulo, op));
            } else {
                meio = "Imposto Contrib. Social. ";
                throw new ExceptionGeracaoTitulos(start + meio + end);
            }
        }
        if (vrFunrural > 0.0) {
            OpcoesContabeisImpostosRetidos funrural = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.FUNRURAL);
            if (funrural.getPessoaImpostoRetido() != null && funrural.getPlanoContaImpostoRetido() != null && funrural.getPlanoContaGerencialImpostoRetido() != null) {
                s = numTitulo;
                numTitulo = (short)(numTitulo + 1);
                dataTitulo = AuxTitulosRetidos.getDataTitulo(funrural.getDiaVencimentoImpostoRetido(), date);
                retidos.add(AuxTitulosRetidos.getTituloRetido(funrural.getPessoaImpostoRetido(), funrural.getPlanoContaImpostoRetido(), funrural.getPlanoContaGerencialImpostoRetido(), vo, "Funrural retido para a nota de Terceiros " + serie + " - " + nrNota + ", pessoa: " + funrural.getPessoaImpostoRetido().getNome(), vrFunrural, dataTitulo, numTitulo, op));
            } else {
                meio = "Imposto Funrural. ";
                throw new ExceptionGeracaoTitulos(start + meio + end);
            }
        }
        if (vrSestSenat > 0.0) {
            OpcoesContabeisImpostosRetidos sestSenat = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.SEST_SENAT);
            if (sestSenat.getPessoaImpostoRetido() != null && sestSenat.getPlanoContaImpostoRetido() != null && sestSenat.getPlanoContaGerencialImpostoRetido() != null) {
                s = numTitulo;
                numTitulo = (short)(numTitulo + 1);
                dataTitulo = AuxTitulosRetidos.getDataTitulo(sestSenat.getDiaVencimentoImpostoRetido(), date);
                retidos.add(AuxTitulosRetidos.getTituloRetido(sestSenat.getPessoaImpostoRetido(), sestSenat.getPlanoContaImpostoRetido(), sestSenat.getPlanoContaGerencialImpostoRetido(), vo, "Sest/Senat retido para a nota de Terceiros " + serie + " - " + nrNota + ", pessoa: " + sestSenat.getPessoaImpostoRetido().getNome(), vrSestSenat, dataTitulo, numTitulo, op));
            } else {
                meio = "Imposto Sest/Senat. ";
                throw new ExceptionGeracaoTitulos(start + meio + end);
            }
        }
        if (vrSenar > 0.0) {
            OpcoesContabeisImpostosRetidos senar = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.SENAR);
            if (senar.getPessoaImpostoRetido() != null && senar.getPlanoContaImpostoRetido() != null && senar.getPlanoContaGerencialImpostoRetido() != null) {
                s = numTitulo;
                numTitulo = (short)(numTitulo + 1);
                dataTitulo = AuxTitulosRetidos.getDataTitulo(senar.getDiaVencimentoImpostoRetido(), date);
                retidos.add(AuxTitulosRetidos.getTituloRetido(senar.getPessoaImpostoRetido(), senar.getPlanoContaImpostoRetido(), senar.getPlanoContaGerencialImpostoRetido(), vo, "Senar retido para a nota de Terceiros " + serie + " - " + nrNota + ", pessoa: " + senar.getPessoaImpostoRetido().getNome(), vrSenar, dataTitulo, numTitulo, op));
            } else {
                meio = "Imposto Senar. ";
                throw new ExceptionGeracaoTitulos(start + meio + end);
            }
        }
        if (vrRat > 0.0) {
            OpcoesContabeisImpostosRetidos rat = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.RAT);
            if (rat.getPessoaImpostoRetido() != null && rat.getPlanoContaImpostoRetido() != null && rat.getPlanoContaGerencialImpostoRetido() != null) {
                s = numTitulo;
                numTitulo = (short)(numTitulo + 1);
                dataTitulo = AuxTitulosRetidos.getDataTitulo(rat.getDiaVencimentoImpostoRetido(), date);
                retidos.add(AuxTitulosRetidos.getTituloRetido(rat.getPessoaImpostoRetido(), rat.getPlanoContaImpostoRetido(), rat.getPlanoContaGerencialImpostoRetido(), vo, "Rat retido para a nota de Terceiros " + serie + " - " + nrNota + ", pessoa: " + rat.getPessoaImpostoRetido().getNome(), vrRat, dataTitulo, numTitulo, op));
            } else {
                meio = "Imposto RAT. ";
                throw new ExceptionGeracaoTitulos(start + meio + end);
            }
        }
        if (vrTaxaSanidadeAnimal > 0.0) {
            OpcoesContabeisImpostosRetidos taxaSanAnimal = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.TAXA_SANIDADE_ANIMAL);
            if (taxaSanAnimal.getPessoaImpostoRetido() != null && taxaSanAnimal.getPlanoContaImpostoRetido() != null && taxaSanAnimal.getPlanoContaGerencialImpostoRetido() != null) {
                s = numTitulo;
                numTitulo = (short)(numTitulo + 1);
                dataTitulo = AuxTitulosRetidos.getDataTitulo(taxaSanAnimal.getDiaVencimentoImpostoRetido(), date);
                retidos.add(AuxTitulosRetidos.getTituloRetido(taxaSanAnimal.getPessoaImpostoRetido(), taxaSanAnimal.getPlanoContaImpostoRetido(), taxaSanAnimal.getPlanoContaGerencialImpostoRetido(), vo, "Taxa Sanidade Animal para a nota de Terceiros " + serie + " - " + nrNota + ", pessoa: " + taxaSanAnimal.getPessoaImpostoRetido().getNome(), vrTaxaSanidadeAnimal, dataTitulo, numTitulo, op));
            } else {
                meio = "Taxa Sanidade Animal. ";
                throw new ExceptionGeracaoTitulos(start + meio + end);
            }
        }
    }

    void calcularTitulosRetidos(InfPagamentoNfPropria infPagamento, NotaFiscalPropria vo, Double valorTotalNota, OpcoesFinanceiras op, EmpresaContabilidade cont, OpcoesContabeis opcoesContabeis) throws ExceptionGeracaoTitulos {
        double vrIss = 0.0;
        double vrInss = 0.0;
        double vrIrrf = 0.0;
        double vrLei10833 = 0.0;
        double vrFunrural = 0.0;
        double vrOutros = 0.0;
        double vrPis = 0.0;
        double vrCofins = 0.0;
        double vrContSocial = 0.0;
        double vrSestSenat = 0.0;
        double vrRat = 0.0;
        double vrSenar = 0.0;
        double vrTaxaSanidadeAnimal = 0.0;
        for (ItemNotaFiscalPropria in : vo.getItensNotaPropria()) {
            if (ToolMethods.isEquals((Object)in.getIssRetido(), (Object)1)) {
                vrIss += in.getItemNotaLivroFiscal().getVrIss().doubleValue();
            }
            vrInss += in.getItemNotaLivroFiscal().getVrInss().doubleValue();
            vrIrrf += in.getItemNotaLivroFiscal().getVrIrrf().doubleValue();
            vrLei10833 += in.getItemNotaLivroFiscal().getVrLei10833().doubleValue();
            vrFunrural += in.getItemNotaLivroFiscal().getVrFunrural().doubleValue();
            vrOutros += in.getItemNotaLivroFiscal().getVrOutros().doubleValue();
            vrPis += in.getItemNotaLivroFiscal().getVrPisSt().doubleValue();
            vrCofins += in.getItemNotaLivroFiscal().getVrCofinsSt().doubleValue();
            vrContSocial += in.getItemNotaLivroFiscal().getVrContSoc().doubleValue();
            vrSestSenat += in.getItemNotaLivroFiscal().getValorSestSenat().doubleValue();
            vrRat += in.getItemNotaLivroFiscal().getValorRat().doubleValue();
            vrSenar += in.getItemNotaLivroFiscal().getValorSenar().doubleValue();
            vrTaxaSanidadeAnimal += in.getItemNotaLivroFiscal().getValorTaxaSanidadeAnimal().doubleValue();
        }
        Double valorTotal = vrCofins + vrContSocial + vrFunrural + vrInss + vrSestSenat + vrIrrf + vrIss + vrLei10833 + vrOutros + vrPis + vrRat + vrSenar + vrTaxaSanidadeAnimal;
        if (valorTotal > 0.0) {
            Double perc = valorTotal / valorTotalNota;
            for (Titulo t : infPagamento.getTitulos()) {
                t.setValor(Double.valueOf(t.getValor() - t.getValor() * perc));
            }
        }
        if (ToolMethods.isEquals((Object)opcoesContabeis.getTipoGeracaoTitulosImpostosRetidos(), (Object)EnumConstGeracaoTitulosImpostosRetidos.GERAR_TITULO_DOCUMENTOS_FISCAIS.getValue())) {
            this.gerarTitulosRetidosNFPropria(vo, infPagamento, vrIss, vrInss, vrIrrf, vrLei10833, vrFunrural, vrOutros, vrPis, vrCofins, vrContSocial, vrSestSenat, vrRat, vrSenar, vrTaxaSanidadeAnimal, op, cont, opcoesContabeis);
        }
    }

    private void gerarTitulosRetidosNFPropria(NotaFiscalPropria vo, InfPagamentoNfPropria infPagamento, double vrIss, double vrInss, double vrIrrf, double vrLei10833, double vrFunrural, double vrOutros, double vrPis, double vrCofins, double vrContSocial, double vrSestSenat, double vrRat, double vrSenar, double vrTaxaSanidadeAnimal, OpcoesFinanceiras op, EmpresaContabilidade cont, OpcoesContabeis opcoesContabeis) throws ExceptionGeracaoTitulos {
        Object t2;
        ArrayList<Titulo> retidos = new ArrayList<Titulo>();
        Date date = vo.getDataEmissaoNota();
        String serie = vo.getSerie();
        Integer nrNota = vo.getNumeroNota();
        String meio = "";
        String end = "Para isto configure esta op\u00e7\u00e3o no cadastro da Empresa, em Empresa Contabilidade.";
        String start = "O mentor pode criar t\u00edtulos a pagar para os impostos retidos. ";
        Date dataTitulo = null;
        Short numTitulo = 1;
        Pessoa pessoaTitulo = vo.getUnidadeFatCliente().getCliente().getPessoa();
        Short tipoTitulo = 0;
        for (Object t2 : infPagamento.getTitulos()) {
            if (t2.getNumParcTituloEstnota() <= numTitulo) continue;
            numTitulo = t2.getNumParcTituloEstnota();
        }
        if (vrIss > 0.0) {
            OpcoesContabeisImpostosRetidos iss = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.ISS);
            if (iss.getPlanoContaImpostoRetido() != null && iss.getPlanoContaGerencialImpostoRetido() != null) {
                t2 = numTitulo;
                numTitulo = (short)(numTitulo + 1);
                dataTitulo = AuxTitulosRetidos.getDataTitulo(iss.getDiaVencimentoImpostoRetido(), date);
                if (iss.getPessoaImpostoRetido() != null) {
                    pessoaTitulo = iss.getPessoaImpostoRetido();
                    tipoTitulo = 0;
                } else {
                    pessoaTitulo = vo.getUnidadeFatCliente().getCliente().getPessoa();
                    tipoTitulo = 1;
                }
                retidos.add(AuxTitulosRetidos.getTituloRetido(pessoaTitulo, iss.getPlanoContaImpostoRetido(), iss.getPlanoContaGerencialImpostoRetido(), vo, "ISS retido para a nota de Terceiros " + serie + " - " + nrNota + ", pessoa: " + iss.getPessoaImpostoRetido().getNome(), vrIss, dataTitulo, numTitulo, op, tipoTitulo));
            } else {
                meio = "Imposto ISS. ";
                throw new ExceptionGeracaoTitulos(start + meio + end);
            }
        }
        if (vrInss > 0.0) {
            OpcoesContabeisImpostosRetidos inss = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.INSS);
            if (inss.getPlanoContaImpostoRetido() != null && inss.getPlanoContaGerencialImpostoRetido() != null) {
                t2 = numTitulo;
                numTitulo = (short)(numTitulo + 1);
                dataTitulo = AuxTitulosRetidos.getDataTitulo(inss.getDiaVencimentoImpostoRetido(), date);
                if (inss.getPessoaImpostoRetido() != null) {
                    pessoaTitulo = inss.getPessoaImpostoRetido();
                    tipoTitulo = 0;
                } else {
                    pessoaTitulo = vo.getUnidadeFatCliente().getCliente().getPessoa();
                    tipoTitulo = 1;
                }
                retidos.add(AuxTitulosRetidos.getTituloRetido(pessoaTitulo, inss.getPlanoContaImpostoRetido(), inss.getPlanoContaGerencialImpostoRetido(), vo, "INSS retido para a nota de Terceiros " + serie + " - " + nrNota + ", pessoa: " + pessoaTitulo.getNome(), vrInss + vrSestSenat, dataTitulo, numTitulo, op, tipoTitulo));
            } else {
                meio = "Imposto INSS. ";
                throw new ExceptionGeracaoTitulos(start + meio + end);
            }
        }
        if (vrIrrf > 0.0) {
            OpcoesContabeisImpostosRetidos irrf = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.IRRF);
            if (irrf.getPlanoContaImpostoRetido() != null && irrf.getPlanoContaGerencialImpostoRetido() != null) {
                t2 = numTitulo;
                numTitulo = (short)(numTitulo + 1);
                dataTitulo = AuxTitulosRetidos.getDataTitulo(irrf.getDiaVencimentoImpostoRetido(), date);
                if (irrf.getPessoaImpostoRetido() != null) {
                    pessoaTitulo = irrf.getPessoaImpostoRetido();
                    tipoTitulo = 0;
                } else {
                    pessoaTitulo = vo.getUnidadeFatCliente().getCliente().getPessoa();
                    tipoTitulo = 1;
                }
                retidos.add(AuxTitulosRetidos.getTituloRetido(pessoaTitulo, irrf.getPlanoContaImpostoRetido(), irrf.getPlanoContaGerencialImpostoRetido(), vo, "IRRF retido para a nota de Terceiros " + serie + " - " + nrNota + ", pessoa: " + pessoaTitulo.getNome(), vrIrrf, dataTitulo, numTitulo, op, tipoTitulo));
            } else {
                meio = "Imposto IRRF. ";
                throw new ExceptionGeracaoTitulos(start + meio + end);
            }
        }
        if (vrLei10833 > 0.0) {
            OpcoesContabeisImpostosRetidos lei10833 = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.LEI_10833);
            if (lei10833.getPlanoContaImpostoRetido() != null && lei10833.getPlanoContaGerencialImpostoRetido() != null) {
                t2 = numTitulo;
                numTitulo = (short)(numTitulo + 1);
                dataTitulo = AuxTitulosRetidos.getDataTitulo(lei10833.getDiaVencimentoImpostoRetido(), date);
                if (lei10833.getPessoaImpostoRetido() != null) {
                    pessoaTitulo = lei10833.getPessoaImpostoRetido();
                    tipoTitulo = 0;
                } else {
                    pessoaTitulo = vo.getUnidadeFatCliente().getCliente().getPessoa();
                    tipoTitulo = 1;
                }
                retidos.add(AuxTitulosRetidos.getTituloRetido(pessoaTitulo, lei10833.getPlanoContaImpostoRetido(), lei10833.getPlanoContaGerencialImpostoRetido(), vo, "Lei 10833 retido para a nota de Terceiros " + serie + " - " + nrNota + ", pessoa: " + pessoaTitulo.getNome(), vrLei10833, dataTitulo, numTitulo, op, tipoTitulo));
            } else {
                meio = "Imposto LEI 10833. ";
                throw new ExceptionGeracaoTitulos(start + meio + end);
            }
        }
        if (vrOutros > 0.0) {
            OpcoesContabeisImpostosRetidos outros = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.OUTROS);
            if (outros.getPlanoContaImpostoRetido() != null && outros.getPlanoContaGerencialImpostoRetido() != null) {
                t2 = numTitulo;
                numTitulo = (short)(numTitulo + 1);
                dataTitulo = AuxTitulosRetidos.getDataTitulo(outros.getDiaVencimentoImpostoRetido(), date);
                if (outros.getPessoaImpostoRetido() != null) {
                    pessoaTitulo = outros.getPessoaImpostoRetido();
                    tipoTitulo = 0;
                } else {
                    pessoaTitulo = vo.getUnidadeFatCliente().getCliente().getPessoa();
                    tipoTitulo = 1;
                }
                retidos.add(AuxTitulosRetidos.getTituloRetido(pessoaTitulo, outros.getPlanoContaImpostoRetido(), outros.getPlanoContaGerencialImpostoRetido(), vo, "Outros impostos retidos para a nota de Terceiros " + serie + " - " + nrNota + ", pessoa: " + pessoaTitulo.getNome(), vrOutros, dataTitulo, numTitulo, op, tipoTitulo));
            } else {
                meio = "Imposto Outros. ";
                throw new ExceptionGeracaoTitulos(start + meio + end);
            }
        }
        if (vrPis > 0.0) {
            OpcoesContabeisImpostosRetidos pis = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.PIS);
            if (pis.getPlanoContaImpostoRetido() != null && pis.getPlanoContaGerencialImpostoRetido() != null) {
                t2 = numTitulo;
                numTitulo = (short)(numTitulo + 1);
                dataTitulo = AuxTitulosRetidos.getDataTitulo(pis.getDiaVencimentoImpostoRetido(), date);
                if (pis.getPessoaImpostoRetido() != null) {
                    pessoaTitulo = pis.getPessoaImpostoRetido();
                    tipoTitulo = 0;
                } else {
                    pessoaTitulo = vo.getUnidadeFatCliente().getCliente().getPessoa();
                    tipoTitulo = 1;
                }
                retidos.add(AuxTitulosRetidos.getTituloRetido(pessoaTitulo, pis.getPlanoContaImpostoRetido(), pis.getPlanoContaGerencialImpostoRetido(), vo, "Pis retido para a nota de Terceiros " + serie + " - " + nrNota + ", pessoa: " + pessoaTitulo.getNome(), vrPis, dataTitulo, numTitulo, op, tipoTitulo));
            } else {
                meio = "Imposto Pis. ";
                throw new ExceptionGeracaoTitulos(start + meio + end);
            }
        }
        if (vrCofins > 0.0) {
            OpcoesContabeisImpostosRetidos cofins = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.COFINS);
            if (cofins.getPlanoContaImpostoRetido() != null && cofins.getPlanoContaGerencialImpostoRetido() != null) {
                t2 = numTitulo;
                numTitulo = (short)(numTitulo + 1);
                dataTitulo = AuxTitulosRetidos.getDataTitulo(cofins.getDiaVencimentoImpostoRetido(), date);
                if (cofins.getPessoaImpostoRetido() != null) {
                    pessoaTitulo = cofins.getPessoaImpostoRetido();
                    tipoTitulo = 0;
                } else {
                    pessoaTitulo = vo.getUnidadeFatCliente().getCliente().getPessoa();
                    tipoTitulo = 1;
                }
                retidos.add(AuxTitulosRetidos.getTituloRetido(pessoaTitulo, cofins.getPlanoContaImpostoRetido(), cofins.getPlanoContaGerencialImpostoRetido(), vo, "Cofins retido para a nota de Terceiros " + serie + " - " + nrNota + ", pessoa: " + pessoaTitulo.getNome(), vrCofins, dataTitulo, numTitulo, op, tipoTitulo));
            } else {
                meio = "Imposto Cofins. ";
                throw new ExceptionGeracaoTitulos(start + meio + end);
            }
        }
        if (vrContSocial > 0.0) {
            OpcoesContabeisImpostosRetidos csll = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.CSLL);
            if (csll.getPlanoContaImpostoRetido() != null && csll.getPlanoContaGerencialImpostoRetido() != null) {
                t2 = numTitulo;
                numTitulo = (short)(numTitulo + 1);
                dataTitulo = AuxTitulosRetidos.getDataTitulo(csll.getDiaVencimentoImpostoRetido(), date);
                if (csll.getPessoaImpostoRetido() != null) {
                    pessoaTitulo = csll.getPessoaImpostoRetido();
                    tipoTitulo = 0;
                } else {
                    pessoaTitulo = vo.getUnidadeFatCliente().getCliente().getPessoa();
                    tipoTitulo = 1;
                }
                retidos.add(AuxTitulosRetidos.getTituloRetido(pessoaTitulo, csll.getPlanoContaImpostoRetido(), csll.getPlanoContaGerencialImpostoRetido(), vo, "Cont. Social retido NF Terc. " + serie + " - " + nrNota + ", pessoa: " + pessoaTitulo.getNome(), vrContSocial, dataTitulo, numTitulo, op, tipoTitulo));
            } else {
                meio = "Imposto Contrib. Social. ";
                throw new ExceptionGeracaoTitulos(start + meio + end);
            }
        }
        if (vrFunrural > 0.0) {
            OpcoesContabeisImpostosRetidos funrural = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.FUNRURAL);
            if (funrural.getPlanoContaImpostoRetido() != null && funrural.getPlanoContaGerencialImpostoRetido() != null) {
                t2 = numTitulo;
                numTitulo = (short)(numTitulo + 1);
                dataTitulo = AuxTitulosRetidos.getDataTitulo(funrural.getDiaVencimentoImpostoRetido(), date);
                if (funrural.getPessoaImpostoRetido() != null) {
                    pessoaTitulo = funrural.getPessoaImpostoRetido();
                    tipoTitulo = 0;
                } else {
                    pessoaTitulo = vo.getUnidadeFatCliente().getCliente().getPessoa();
                    tipoTitulo = 1;
                }
                retidos.add(AuxTitulosRetidos.getTituloRetido(pessoaTitulo, funrural.getPlanoContaImpostoRetido(), funrural.getPlanoContaGerencialImpostoRetido(), vo, "Funrural retido para a nota de Terceiros " + serie + " - " + nrNota + ", pessoa: " + pessoaTitulo.getNome(), vrFunrural, dataTitulo, numTitulo, op, tipoTitulo));
            } else {
                meio = "Imposto Funrural. ";
                throw new ExceptionGeracaoTitulos(start + meio + end);
            }
        }
        if (vrSestSenat > 0.0) {
            OpcoesContabeisImpostosRetidos sestSenat = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.SEST_SENAT);
            if (sestSenat.getPlanoContaImpostoRetido() != null && sestSenat.getPlanoContaGerencialImpostoRetido() != null) {
                t2 = numTitulo;
                numTitulo = (short)(numTitulo + 1);
                dataTitulo = AuxTitulosRetidos.getDataTitulo(sestSenat.getDiaVencimentoImpostoRetido(), date);
                if (sestSenat.getPessoaImpostoRetido() != null) {
                    pessoaTitulo = sestSenat.getPessoaImpostoRetido();
                    tipoTitulo = 0;
                } else {
                    pessoaTitulo = vo.getUnidadeFatCliente().getCliente().getPessoa();
                    tipoTitulo = 1;
                }
                retidos.add(AuxTitulosRetidos.getTituloRetido(pessoaTitulo, sestSenat.getPlanoContaImpostoRetido(), sestSenat.getPlanoContaGerencialImpostoRetido(), vo, "Sest/Senat retido para a nota de Terceiros " + serie + " - " + nrNota + ", pessoa: " + pessoaTitulo.getNome(), vrSestSenat, dataTitulo, numTitulo, op, tipoTitulo));
            } else {
                meio = "Imposto Sest/Senat. ";
                throw new ExceptionGeracaoTitulos(start + meio + end);
            }
        }
        if (vrSenar > 0.0) {
            OpcoesContabeisImpostosRetidos senar = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.SENAR);
            if (senar.getPlanoContaImpostoRetido() != null && senar.getPlanoContaGerencialImpostoRetido() != null) {
                t2 = numTitulo;
                numTitulo = (short)(numTitulo + 1);
                dataTitulo = AuxTitulosRetidos.getDataTitulo(senar.getDiaVencimentoImpostoRetido(), date);
                if (senar.getPessoaImpostoRetido() != null) {
                    pessoaTitulo = senar.getPessoaImpostoRetido();
                    tipoTitulo = 0;
                } else {
                    pessoaTitulo = vo.getUnidadeFatCliente().getCliente().getPessoa();
                    tipoTitulo = 1;
                }
                retidos.add(AuxTitulosRetidos.getTituloRetido(pessoaTitulo, senar.getPlanoContaImpostoRetido(), senar.getPlanoContaGerencialImpostoRetido(), vo, "Senar retido para a nota de Terceiros " + serie + " - " + nrNota + ", pessoa: " + pessoaTitulo.getNome(), vrSenar, dataTitulo, numTitulo, op, tipoTitulo));
            } else {
                meio = "Imposto Senar. ";
                throw new ExceptionGeracaoTitulos(start + meio + end);
            }
        }
        if (vrRat > 0.0) {
            OpcoesContabeisImpostosRetidos rat = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.RAT);
            if (rat.getPlanoContaImpostoRetido() != null && rat.getPlanoContaGerencialImpostoRetido() != null) {
                t2 = numTitulo;
                numTitulo = (short)(numTitulo + 1);
                dataTitulo = AuxTitulosRetidos.getDataTitulo(rat.getDiaVencimentoImpostoRetido(), date);
                if (rat.getPessoaImpostoRetido() != null) {
                    pessoaTitulo = rat.getPessoaImpostoRetido();
                    tipoTitulo = 0;
                } else {
                    pessoaTitulo = vo.getUnidadeFatCliente().getCliente().getPessoa();
                    tipoTitulo = 1;
                }
                retidos.add(AuxTitulosRetidos.getTituloRetido(pessoaTitulo, rat.getPlanoContaImpostoRetido(), rat.getPlanoContaGerencialImpostoRetido(), vo, "Rat retido para a nota de Terceiros " + serie + " - " + nrNota + ", pessoa: " + pessoaTitulo.getNome(), vrRat, dataTitulo, numTitulo, op, tipoTitulo));
            } else {
                meio = "Imposto RAT. ";
                throw new ExceptionGeracaoTitulos(start + meio + end);
            }
        }
        if (vrTaxaSanidadeAnimal > 0.0) {
            OpcoesContabeisImpostosRetidos taxaSanAnimal = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)opcoesContabeis, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.TAXA_SANIDADE_ANIMAL);
            if (taxaSanAnimal.getPlanoContaImpostoRetido() != null && taxaSanAnimal.getPlanoContaGerencialImpostoRetido() != null) {
                t2 = numTitulo;
                numTitulo = (short)(numTitulo + 1);
                dataTitulo = AuxTitulosRetidos.getDataTitulo(taxaSanAnimal.getDiaVencimentoImpostoRetido(), date);
                if (taxaSanAnimal.getPessoaImpostoRetido() != null) {
                    pessoaTitulo = taxaSanAnimal.getPessoaImpostoRetido();
                    tipoTitulo = 0;
                } else {
                    pessoaTitulo = vo.getUnidadeFatCliente().getCliente().getPessoa();
                    tipoTitulo = 1;
                }
                retidos.add(AuxTitulosRetidos.getTituloRetido(pessoaTitulo, taxaSanAnimal.getPlanoContaImpostoRetido(), taxaSanAnimal.getPlanoContaGerencialImpostoRetido(), vo, "Taxa Sanidade Animal para a nota de Terceiros " + serie + " - " + nrNota + ", pessoa: " + pessoaTitulo.getNome(), vrTaxaSanidadeAnimal, dataTitulo, numTitulo, op, tipoTitulo));
            } else {
                meio = "Taxa Sanidade Animal. ";
                throw new ExceptionGeracaoTitulos(start + meio + end);
            }
        }
        for (Object t2 : retidos) {
            t2.setInfPagamentoNfPropria(infPagamento);
        }
        infPagamento.getTitulos().addAll(retidos);
    }

    private static Titulo getTituloRetido(Pessoa p, PlanoConta pc, PlanoContaGerencial pcGer, NotaFiscalTerceiros vo, String obs, Double valor, Date dataTitulo, Short num, OpcoesFinanceiras op) {
        dataTitulo = dataTitulo != null ? dataTitulo : new Date();
        Titulo t = new Titulo();
        t.setCarteiraCobranca(op.getCarteiraCobranca());
        t.setDataCadastro(new Date());
        t.setDataEmissao(vo.getDataEmissao());
        t.setDataCompetencia(vo.getDataEntrada());
        t.setDataEntradaSaida(t.getDataCompetencia());
        t.setEmpresa(vo.getEmpresa());
        t.setDataVencimento(dataTitulo);
        t.setDataVencimentoBase(dataTitulo);
        t.setNaoCompoeFluxo(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        t.setNumParcTituloEstnota(Short.valueOf((short)1));
        t.setObservacao(obs);
        t.setPagRec(Short.valueOf((short)0));
        t.setPercJurosMes(Double.valueOf(0.0));
        t.setPessoa(p);
        t.setClassificacaoPessoa(op.getClassificacaoClientes());
        t.setNumParcTituloEstnota(num);
        t.setPlanoConta(pc);
        t.setProvisao(Short.valueOf((short)1));
        t.setTipoDoc(op.getTipoDocFinanceiro());
        t.setTipoPessoa(EnumConstPessoa.PESSOA.getEnumId());
        t.setValor(valor);
        t.setVrAbatimento(Double.valueOf(0.0));
        t.setVrDescontoCondicional(Double.valueOf(0.0));
        t.setVrIofPago(Double.valueOf(0.0));
        t.setVrJurosDia(Double.valueOf(0.0));
        LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, dataTitulo, dataTitulo, Short.valueOf(EnumLancamentoCTBGerencial.DEBITO.getValue()), t.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()), obs, pcGer, t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), null, valor, null);
        ArrayList<LancamentoCtbGerencial> aux = new ArrayList<LancamentoCtbGerencial>();
        aux.add(l);
        t.setLancCtbGerencial(aux);
        return t;
    }

    private static Titulo getTituloRetido(Pessoa p, PlanoConta pc, PlanoContaGerencial pcGer, NotaFiscalPropria vo, String obs, Double valor, Date dataTitulo, Short num, OpcoesFinanceiras op, Short tipoTitulo) {
        dataTitulo = dataTitulo != null ? dataTitulo : new Date();
        Titulo t = new Titulo();
        t.setCarteiraCobranca(op.getCarteiraCobranca());
        t.setDataCadastro(new Date());
        t.setDataEmissao(vo.getDataEmissaoNota());
        t.setDataCompetencia(vo.getDataEmissaoNota());
        t.setDataEntradaSaida(t.getDataCompetencia());
        t.setEmpresa(vo.getEmpresa());
        t.setDataVencimento(dataTitulo);
        t.setDataVencimentoBase(dataTitulo);
        t.setNaoCompoeFluxo(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        t.setNumParcTituloEstnota(Short.valueOf((short)1));
        t.setObservacao(obs);
        t.setPagRec(tipoTitulo);
        t.setPercJurosMes(Double.valueOf(0.0));
        t.setPessoa(p);
        t.setClassificacaoPessoa(op.getClassificacaoClientes());
        t.setNumParcTituloEstnota(num);
        t.setPlanoConta(pc);
        t.setProvisao(Short.valueOf((short)1));
        t.setTipoDoc(op.getTipoDocFinanceiro());
        t.setTipoPessoa(EnumConstPessoa.PESSOA.getEnumId());
        t.setValor(valor);
        t.setVrAbatimento(Double.valueOf(0.0));
        t.setVrDescontoCondicional(Double.valueOf(0.0));
        t.setVrIofPago(Double.valueOf(0.0));
        t.setVrJurosDia(Double.valueOf(0.0));
        LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, dataTitulo, dataTitulo, Short.valueOf(EnumLancamentoCTBGerencial.DEBITO.getValue()), t.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()), obs, pcGer, t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), null, valor, null);
        ArrayList<LancamentoCtbGerencial> aux = new ArrayList<LancamentoCtbGerencial>();
        aux.add(l);
        t.setLancCtbGerencial(aux);
        return t;
    }

    private static Date getDataTitulo(Short dia, Date data) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        if (dia != null && dia > 0) {
            g.add(2, 1);
            g.set(5, dia.shortValue());
        }
        return g.getTime();
    }

    private void gerarImpostosTituloPisCofins(NotaFiscalTerceiros vo, InfPagamentoNfTerceiros infPagamento) {
        double vrBCPis = 0.0;
        double vrPis = 0.0;
        double vrBCCofins = 0.0;
        double vrCofins = 0.0;
        double vrLei10833 = 0.0;
        double vrContSocial = 0.0;
        double vrTotal = 0.0;
        double vrIpiComercio = 0.0;
        double vrIpiIndustria = 0.0;
        double vrIcmsSt = 0.0;
        double vrBCLei10833 = 0.0;
        double vrBCContSoc = 0.0;
        for (ItemNotaTerceiros in : vo.getItemNotaTerceiros()) {
            vrLei10833 += in.getItemNotaLivroFiscal().getVrLei10833().doubleValue();
            vrBCLei10833 += in.getItemNotaLivroFiscal().getValorTotal().doubleValue();
            vrBCPis += in.getItemNotaLivroFiscal().getVrBCPisSt().doubleValue();
            vrPis += in.getItemNotaLivroFiscal().getVrPisSt().doubleValue();
            vrBCCofins += in.getItemNotaLivroFiscal().getVrBCCofinsSt().doubleValue();
            vrCofins += in.getItemNotaLivroFiscal().getVrCofinsSt().doubleValue();
            vrContSocial += in.getItemNotaLivroFiscal().getVrContSoc().doubleValue();
            vrBCContSoc += in.getItemNotaLivroFiscal().getValorTotal().doubleValue();
            vrTotal += in.getItemNotaLivroFiscal().getValorTotal().doubleValue();
            vrIpiComercio += in.getItemNotaLivroFiscal().getVrIpiComercio().doubleValue();
            vrIpiIndustria += in.getItemNotaLivroFiscal().getVrIpiIndustria().doubleValue();
            vrIcmsSt += in.getItemNotaLivroFiscal().getVrIcmsSt().doubleValue();
        }
        if (ToolMethods.isEquals((Object)vo.getModeloDocFiscal().getModeloServico(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) && ToolMethods.isEquals((Object)vo.getUnidadeFatFornecedor().getFornecedor().getPessoa().getComplemento().getTipoPessoa(), (Object)EnumConstTipoPessoaComplementar.JURIDICA.getEnumId()) && (ToolMethods.isWithData((Number)vrPis) || ToolMethods.isWithData((Number)vrCofins) || ToolMethods.isWithData((Number)vrLei10833) || ToolMethods.isWithData((Number)vrContSocial))) {
            int totalTitulosFornecedor = this.totalTitulosFornecedor(vo, infPagamento);
            for (Titulo titulo : infPagamento.getTitulos()) {
                if (!ToolMethods.isEquals((Object)titulo.getPessoa(), (Object)vo.getUnidadeFatFornecedor().getFornecedor().getPessoa())) continue;
                this.criarTituloPisCofins(titulo, vo, totalTitulosFornecedor, vrBCPis, vrPis, vrBCCofins, vrCofins, vrLei10833, vrContSocial, vrTotal, vrIpiComercio, vrIpiIndustria, vrIcmsSt, vrBCLei10833, vrBCContSoc);
            }
        }
    }

    private int totalTitulosFornecedor(NotaFiscalTerceiros vo, InfPagamentoNfTerceiros infPagamento) {
        int totalTitulosFornecedor = 0;
        for (Titulo titulo : infPagamento.getTitulos()) {
            if (!ToolMethods.isEquals((Object)titulo.getPessoa(), (Object)vo.getUnidadeFatFornecedor().getFornecedor().getPessoa())) continue;
            ++totalTitulosFornecedor;
        }
        return totalTitulosFornecedor;
    }

    private void criarTituloPisCofins(Titulo titulo, NotaFiscalTerceiros vo, int totalTitulosFornecedor, double vrBCPis, double vrPis, double vrBCCofins, double vrCofins, double vrLei10833, double vrContSocial, double vrTotal, double vrIpiComercio, double vrIpiIndustria, double vrIcmsSt, double vrBCLei10833, double vrBCContSoc) {
        TituloPisCofins tituloPisCofins = new TituloPisCofins();
        tituloPisCofins.setTitulo(titulo);
        tituloPisCofins.setIncidenciaPisCofins(((ItemNotaTerceiros)vo.getItemNotaTerceiros().get(0)).getIncidenciaPisCofins());
        tituloPisCofins.setValorBCPis(Double.valueOf(vrBCPis / (double)totalTitulosFornecedor));
        tituloPisCofins.setValorPis(Double.valueOf(vrPis / (double)totalTitulosFornecedor));
        tituloPisCofins.setAliquotaPis(((ItemNotaTerceiros)vo.getItemNotaTerceiros().get(0)).getItemNotaLivroFiscal().getAliquotaPisSt());
        tituloPisCofins.setSaldoPis(Double.valueOf(vrPis / (double)totalTitulosFornecedor));
        tituloPisCofins.setValorBCCofins(Double.valueOf(vrBCCofins / (double)totalTitulosFornecedor));
        tituloPisCofins.setValorCofins(Double.valueOf(vrCofins / (double)totalTitulosFornecedor));
        tituloPisCofins.setAliquotaCofins(((ItemNotaTerceiros)vo.getItemNotaTerceiros().get(0)).getItemNotaLivroFiscal().getAliquotaCofinsSt());
        tituloPisCofins.setSaldoCofins(Double.valueOf(vrCofins / (double)totalTitulosFornecedor));
        tituloPisCofins.setValorBCCsll(Double.valueOf(vrBCContSoc / (double)totalTitulosFornecedor));
        tituloPisCofins.setValorCsll(Double.valueOf(vrContSocial / (double)totalTitulosFornecedor));
        tituloPisCofins.setAliquotaCsll(((ItemNotaTerceiros)vo.getItemNotaTerceiros().get(0)).getItemNotaLivroFiscal().getAliquotaContSoc());
        tituloPisCofins.setSaldoCsll(Double.valueOf(vrContSocial / (double)totalTitulosFornecedor));
        tituloPisCofins.setValorBCLei10833(Double.valueOf(vrBCLei10833 / (double)totalTitulosFornecedor));
        tituloPisCofins.setValorLei10833(Double.valueOf(vrLei10833 / (double)totalTitulosFornecedor));
        tituloPisCofins.setAliquotaLei10833(((ItemNotaTerceiros)vo.getItemNotaTerceiros().get(0)).getItemNotaLivroFiscal().getAliquotaLei10833());
        tituloPisCofins.setSaldoLei10833(Double.valueOf(vrLei10833 / (double)totalTitulosFornecedor));
        tituloPisCofins.setNcm(((ItemNotaTerceiros)vo.getItemNotaTerceiros().get(0)).getProduto().getNcm());
        tituloPisCofins.setCfop(((ItemNotaTerceiros)vo.getItemNotaTerceiros().get(0)).getItemNotaLivroFiscal().getCfop());
        tituloPisCofins.setModeloDocFiscal(vo.getModeloDocFiscal());
        tituloPisCofins.setValorProduto(Double.valueOf(vrTotal - (vrIpiComercio + vrIpiIndustria + vrIcmsSt)));
        tituloPisCofins.setNatRendReinf(((ItemNotaTerceiros)vo.getItemNotaTerceiros().get(0)).getNaturezaRendimento());
        titulo.getTituloPisCofins().add(tituloPisCofins);
    }
}

